/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata transfer job's progress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataTransferJobProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataTransferJobProgress.Builder, MetadataTransferJobProgress> {
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalCount").getter(getter(MetadataTransferJobProgress::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()).build();

    private static final SdkField<Integer> SUCCEEDED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("succeededCount").getter(getter(MetadataTransferJobProgress::succeededCount))
            .setter(setter(Builder::succeededCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededCount").build()).build();

    private static final SdkField<Integer> SKIPPED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("skippedCount").getter(getter(MetadataTransferJobProgress::skippedCount))
            .setter(setter(Builder::skippedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedCount").build()).build();

    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedCount").getter(getter(MetadataTransferJobProgress::failedCount))
            .setter(setter(Builder::failedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COUNT_FIELD,
            SUCCEEDED_COUNT_FIELD, SKIPPED_COUNT_FIELD, FAILED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalCount;

    private final Integer succeededCount;

    private final Integer skippedCount;

    private final Integer failedCount;

    private MetadataTransferJobProgress(BuilderImpl builder) {
        this.totalCount = builder.totalCount;
        this.succeededCount = builder.succeededCount;
        this.skippedCount = builder.skippedCount;
        this.failedCount = builder.failedCount;
    }

    /**
     * <p>
     * The total count. [of what]
     * </p>
     * 
     * @return The total count. [of what]
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The succeeded count.
     * </p>
     * 
     * @return The succeeded count.
     */
    public final Integer succeededCount() {
        return succeededCount;
    }

    /**
     * <p>
     * The skipped count.
     * </p>
     * 
     * @return The skipped count.
     */
    public final Integer skippedCount() {
        return skippedCount;
    }

    /**
     * <p>
     * The failed count.
     * </p>
     * 
     * @return The failed count.
     */
    public final Integer failedCount() {
        return failedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(succeededCount());
        hashCode = 31 * hashCode + Objects.hashCode(skippedCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataTransferJobProgress)) {
            return false;
        }
        MetadataTransferJobProgress other = (MetadataTransferJobProgress) obj;
        return Objects.equals(totalCount(), other.totalCount()) && Objects.equals(succeededCount(), other.succeededCount())
                && Objects.equals(skippedCount(), other.skippedCount()) && Objects.equals(failedCount(), other.failedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataTransferJobProgress").add("TotalCount", totalCount())
                .add("SucceededCount", succeededCount()).add("SkippedCount", skippedCount()).add("FailedCount", failedCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "succeededCount":
            return Optional.ofNullable(clazz.cast(succeededCount()));
        case "skippedCount":
            return Optional.ofNullable(clazz.cast(skippedCount()));
        case "failedCount":
            return Optional.ofNullable(clazz.cast(failedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalCount", TOTAL_COUNT_FIELD);
        map.put("succeededCount", SUCCEEDED_COUNT_FIELD);
        map.put("skippedCount", SKIPPED_COUNT_FIELD);
        map.put("failedCount", FAILED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataTransferJobProgress, T> g) {
        return obj -> g.apply((MetadataTransferJobProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataTransferJobProgress> {
        /**
         * <p>
         * The total count. [of what]
         * </p>
         * 
         * @param totalCount
         *        The total count. [of what]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * The succeeded count.
         * </p>
         * 
         * @param succeededCount
         *        The succeeded count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededCount(Integer succeededCount);

        /**
         * <p>
         * The skipped count.
         * </p>
         * 
         * @param skippedCount
         *        The skipped count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedCount(Integer skippedCount);

        /**
         * <p>
         * The failed count.
         * </p>
         * 
         * @param failedCount
         *        The failed count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Integer failedCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalCount;

        private Integer succeededCount;

        private Integer skippedCount;

        private Integer failedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataTransferJobProgress model) {
            totalCount(model.totalCount);
            succeededCount(model.succeededCount);
            skippedCount(model.skippedCount);
            failedCount(model.failedCount);
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Integer getSucceededCount() {
            return succeededCount;
        }

        public final void setSucceededCount(Integer succeededCount) {
            this.succeededCount = succeededCount;
        }

        @Override
        public final Builder succeededCount(Integer succeededCount) {
            this.succeededCount = succeededCount;
            return this;
        }

        public final Integer getSkippedCount() {
            return skippedCount;
        }

        public final void setSkippedCount(Integer skippedCount) {
            this.skippedCount = skippedCount;
        }

        @Override
        public final Builder skippedCount(Integer skippedCount) {
            this.skippedCount = skippedCount;
            return this;
        }

        public final Integer getFailedCount() {
            return failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        @Override
        public MetadataTransferJobProgress build() {
            return new MetadataTransferJobProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
