/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pricing plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PricingPlan implements SdkPojo, Serializable, ToCopyableBuilder<PricingPlan.Builder, PricingPlan> {
    private static final SdkField<Long> BILLABLE_ENTITY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("billableEntityCount").getter(getter(PricingPlan::billableEntityCount))
            .setter(setter(Builder::billableEntityCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billableEntityCount").build())
            .build();

    private static final SdkField<BundleInformation> BUNDLE_INFORMATION_FIELD = SdkField
            .<BundleInformation> builder(MarshallingType.SDK_POJO).memberName("bundleInformation")
            .getter(getter(PricingPlan::bundleInformation)).setter(setter(Builder::bundleInformation))
            .constructor(BundleInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleInformation").build()).build();

    private static final SdkField<Instant> EFFECTIVE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveDateTime").getter(getter(PricingPlan::effectiveDateTime))
            .setter(setter(Builder::effectiveDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDateTime").build()).build();

    private static final SdkField<String> PRICING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pricingMode").getter(getter(PricingPlan::pricingModeAsString)).setter(setter(Builder::pricingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingMode").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(PricingPlan::updateDateTime)).setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateReason").getter(getter(PricingPlan::updateReasonAsString)).setter(setter(Builder::updateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BILLABLE_ENTITY_COUNT_FIELD, BUNDLE_INFORMATION_FIELD, EFFECTIVE_DATE_TIME_FIELD,
                    PRICING_MODE_FIELD, UPDATE_DATE_TIME_FIELD, UPDATE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long billableEntityCount;

    private final BundleInformation bundleInformation;

    private final Instant effectiveDateTime;

    private final String pricingMode;

    private final Instant updateDateTime;

    private final String updateReason;

    private PricingPlan(BuilderImpl builder) {
        this.billableEntityCount = builder.billableEntityCount;
        this.bundleInformation = builder.bundleInformation;
        this.effectiveDateTime = builder.effectiveDateTime;
        this.pricingMode = builder.pricingMode;
        this.updateDateTime = builder.updateDateTime;
        this.updateReason = builder.updateReason;
    }

    /**
     * <p>
     * The billable entity count.
     * </p>
     * 
     * @return The billable entity count.
     */
    public final Long billableEntityCount() {
        return billableEntityCount;
    }

    /**
     * <p>
     * The pricing plan's bundle information.
     * </p>
     * 
     * @return The pricing plan's bundle information.
     */
    public final BundleInformation bundleInformation() {
        return bundleInformation;
    }

    /**
     * <p>
     * The effective date and time of the pricing plan.
     * </p>
     * 
     * @return The effective date and time of the pricing plan.
     */
    public final Instant effectiveDateTime() {
        return effectiveDateTime;
    }

    /**
     * <p>
     * The pricing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingMode} will
     * return {@link PricingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingModeAsString}.
     * </p>
     * 
     * @return The pricing mode.
     * @see PricingMode
     */
    public final PricingMode pricingMode() {
        return PricingMode.fromValue(pricingMode);
    }

    /**
     * <p>
     * The pricing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingMode} will
     * return {@link PricingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingModeAsString}.
     * </p>
     * 
     * @return The pricing mode.
     * @see PricingMode
     */
    public final String pricingModeAsString() {
        return pricingMode;
    }

    /**
     * <p>
     * The set date and time for updating a pricing plan.
     * </p>
     * 
     * @return The set date and time for updating a pricing plan.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The update reason for changing a pricing plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReason} will
     * return {@link UpdateReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateReasonAsString}.
     * </p>
     * 
     * @return The update reason for changing a pricing plan.
     * @see UpdateReason
     */
    public final UpdateReason updateReason() {
        return UpdateReason.fromValue(updateReason);
    }

    /**
     * <p>
     * The update reason for changing a pricing plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReason} will
     * return {@link UpdateReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateReasonAsString}.
     * </p>
     * 
     * @return The update reason for changing a pricing plan.
     * @see UpdateReason
     */
    public final String updateReasonAsString() {
        return updateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billableEntityCount());
        hashCode = 31 * hashCode + Objects.hashCode(bundleInformation());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(pricingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingPlan)) {
            return false;
        }
        PricingPlan other = (PricingPlan) obj;
        return Objects.equals(billableEntityCount(), other.billableEntityCount())
                && Objects.equals(bundleInformation(), other.bundleInformation())
                && Objects.equals(effectiveDateTime(), other.effectiveDateTime())
                && Objects.equals(pricingModeAsString(), other.pricingModeAsString())
                && Objects.equals(updateDateTime(), other.updateDateTime())
                && Objects.equals(updateReasonAsString(), other.updateReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PricingPlan").add("BillableEntityCount", billableEntityCount())
                .add("BundleInformation", bundleInformation()).add("EffectiveDateTime", effectiveDateTime())
                .add("PricingMode", pricingModeAsString()).add("UpdateDateTime", updateDateTime())
                .add("UpdateReason", updateReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billableEntityCount":
            return Optional.ofNullable(clazz.cast(billableEntityCount()));
        case "bundleInformation":
            return Optional.ofNullable(clazz.cast(bundleInformation()));
        case "effectiveDateTime":
            return Optional.ofNullable(clazz.cast(effectiveDateTime()));
        case "pricingMode":
            return Optional.ofNullable(clazz.cast(pricingModeAsString()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "updateReason":
            return Optional.ofNullable(clazz.cast(updateReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("billableEntityCount", BILLABLE_ENTITY_COUNT_FIELD);
        map.put("bundleInformation", BUNDLE_INFORMATION_FIELD);
        map.put("effectiveDateTime", EFFECTIVE_DATE_TIME_FIELD);
        map.put("pricingMode", PRICING_MODE_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("updateReason", UPDATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PricingPlan, T> g) {
        return obj -> g.apply((PricingPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PricingPlan> {
        /**
         * <p>
         * The billable entity count.
         * </p>
         * 
         * @param billableEntityCount
         *        The billable entity count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billableEntityCount(Long billableEntityCount);

        /**
         * <p>
         * The pricing plan's bundle information.
         * </p>
         * 
         * @param bundleInformation
         *        The pricing plan's bundle information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleInformation(BundleInformation bundleInformation);

        /**
         * <p>
         * The pricing plan's bundle information.
         * </p>
         * This is a convenience method that creates an instance of the {@link BundleInformation.Builder} avoiding the
         * need to create one manually via {@link BundleInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BundleInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #bundleInformation(BundleInformation)}.
         * 
         * @param bundleInformation
         *        a consumer that will call methods on {@link BundleInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleInformation(BundleInformation)
         */
        default Builder bundleInformation(Consumer<BundleInformation.Builder> bundleInformation) {
            return bundleInformation(BundleInformation.builder().applyMutation(bundleInformation).build());
        }

        /**
         * <p>
         * The effective date and time of the pricing plan.
         * </p>
         * 
         * @param effectiveDateTime
         *        The effective date and time of the pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDateTime(Instant effectiveDateTime);

        /**
         * <p>
         * The pricing mode.
         * </p>
         * 
         * @param pricingMode
         *        The pricing mode.
         * @see PricingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingMode
         */
        Builder pricingMode(String pricingMode);

        /**
         * <p>
         * The pricing mode.
         * </p>
         * 
         * @param pricingMode
         *        The pricing mode.
         * @see PricingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingMode
         */
        Builder pricingMode(PricingMode pricingMode);

        /**
         * <p>
         * The set date and time for updating a pricing plan.
         * </p>
         * 
         * @param updateDateTime
         *        The set date and time for updating a pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The update reason for changing a pricing plan.
         * </p>
         * 
         * @param updateReason
         *        The update reason for changing a pricing plan.
         * @see UpdateReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateReason
         */
        Builder updateReason(String updateReason);

        /**
         * <p>
         * The update reason for changing a pricing plan.
         * </p>
         * 
         * @param updateReason
         *        The update reason for changing a pricing plan.
         * @see UpdateReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateReason
         */
        Builder updateReason(UpdateReason updateReason);
    }

    static final class BuilderImpl implements Builder {
        private Long billableEntityCount;

        private BundleInformation bundleInformation;

        private Instant effectiveDateTime;

        private String pricingMode;

        private Instant updateDateTime;

        private String updateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingPlan model) {
            billableEntityCount(model.billableEntityCount);
            bundleInformation(model.bundleInformation);
            effectiveDateTime(model.effectiveDateTime);
            pricingMode(model.pricingMode);
            updateDateTime(model.updateDateTime);
            updateReason(model.updateReason);
        }

        public final Long getBillableEntityCount() {
            return billableEntityCount;
        }

        public final void setBillableEntityCount(Long billableEntityCount) {
            this.billableEntityCount = billableEntityCount;
        }

        @Override
        public final Builder billableEntityCount(Long billableEntityCount) {
            this.billableEntityCount = billableEntityCount;
            return this;
        }

        public final BundleInformation.Builder getBundleInformation() {
            return bundleInformation != null ? bundleInformation.toBuilder() : null;
        }

        public final void setBundleInformation(BundleInformation.BuilderImpl bundleInformation) {
            this.bundleInformation = bundleInformation != null ? bundleInformation.build() : null;
        }

        @Override
        public final Builder bundleInformation(BundleInformation bundleInformation) {
            this.bundleInformation = bundleInformation;
            return this;
        }

        public final Instant getEffectiveDateTime() {
            return effectiveDateTime;
        }

        public final void setEffectiveDateTime(Instant effectiveDateTime) {
            this.effectiveDateTime = effectiveDateTime;
        }

        @Override
        public final Builder effectiveDateTime(Instant effectiveDateTime) {
            this.effectiveDateTime = effectiveDateTime;
            return this;
        }

        public final String getPricingMode() {
            return pricingMode;
        }

        public final void setPricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
        }

        @Override
        public final Builder pricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
            return this;
        }

        @Override
        public final Builder pricingMode(PricingMode pricingMode) {
            this.pricingMode(pricingMode == null ? null : pricingMode.toString());
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getUpdateReason() {
            return updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        @Override
        public final Builder updateReason(UpdateReason updateReason) {
            this.updateReason(updateReason == null ? null : updateReason.toString());
            return this;
        }

        @Override
        public PricingPlan build() {
            return new PricingPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
