/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a scene.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SceneSummary implements SdkPojo, Serializable, ToCopyableBuilder<SceneSummary.Builder, SceneSummary> {
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(SceneSummary::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()).build();

    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentLocation").getter(getter(SceneSummary::contentLocation)).setter(setter(Builder::contentLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SceneSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(SceneSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(SceneSummary::updateDateTime)).setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SceneSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCENE_ID_FIELD,
            CONTENT_LOCATION_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sceneId;

    private final String contentLocation;

    private final String arn;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private final String description;

    private SceneSummary(BuilderImpl builder) {
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the scene.
     * </p>
     * 
     * @return The ID of the scene.
     */
    public final String sceneId() {
        return sceneId;
    }

    /**
     * <p>
     * The relative path that specifies the location of the content definition file.
     * </p>
     * 
     * @return The relative path that specifies the location of the content definition file.
     */
    public final String contentLocation() {
        return contentLocation;
    }

    /**
     * <p>
     * The ARN of the scene.
     * </p>
     * 
     * @return The ARN of the scene.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the scene was created.
     * </p>
     * 
     * @return The date and time when the scene was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time when the scene was last updated.
     * </p>
     * 
     * @return The date and time when the scene was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The scene description.
     * </p>
     * 
     * @return The scene description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SceneSummary)) {
            return false;
        }
        SceneSummary other = (SceneSummary) obj;
        return Objects.equals(sceneId(), other.sceneId()) && Objects.equals(contentLocation(), other.contentLocation())
                && Objects.equals(arn(), other.arn()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SceneSummary").add("SceneId", sceneId()).add("ContentLocation", contentLocation())
                .add("Arn", arn()).add("CreationDateTime", creationDateTime()).add("UpdateDateTime", updateDateTime())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        case "contentLocation":
            return Optional.ofNullable(clazz.cast(contentLocation()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sceneId", SCENE_ID_FIELD);
        map.put("contentLocation", CONTENT_LOCATION_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SceneSummary, T> g) {
        return obj -> g.apply((SceneSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SceneSummary> {
        /**
         * <p>
         * The ID of the scene.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        /**
         * <p>
         * The relative path that specifies the location of the content definition file.
         * </p>
         * 
         * @param contentLocation
         *        The relative path that specifies the location of the content definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLocation(String contentLocation);

        /**
         * <p>
         * The ARN of the scene.
         * </p>
         * 
         * @param arn
         *        The ARN of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the scene was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the scene was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time when the scene was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the scene was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The scene description.
         * </p>
         * 
         * @param description
         *        The scene description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String sceneId;

        private String contentLocation;

        private String arn;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SceneSummary model) {
            sceneId(model.sceneId);
            contentLocation(model.contentLocation);
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
            description(model.description);
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SceneSummary build() {
            return new SceneSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
