/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tabular conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TabularConditions implements SdkPojo, Serializable,
        ToCopyableBuilder<TabularConditions.Builder, TabularConditions> {
    private static final SdkField<List<OrderBy>> ORDER_BY_FIELD = SdkField
            .<List<OrderBy>> builder(MarshallingType.LIST)
            .memberName("orderBy")
            .getter(getter(TabularConditions::orderBy))
            .setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderBy> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderBy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PropertyFilter>> PROPERTY_FILTERS_FIELD = SdkField
            .<List<PropertyFilter>> builder(MarshallingType.LIST)
            .memberName("propertyFilters")
            .getter(getter(TabularConditions::propertyFilters))
            .setter(setter(Builder::propertyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_BY_FIELD,
            PROPERTY_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<OrderBy> orderBy;

    private final List<PropertyFilter> propertyFilters;

    private TabularConditions(BuilderImpl builder) {
        this.orderBy = builder.orderBy;
        this.propertyFilters = builder.propertyFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrderBy() {
        return orderBy != null && !(orderBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria that orders the output. It can be sorted in ascending or descending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderBy} method.
     * </p>
     * 
     * @return Filter criteria that orders the output. It can be sorted in ascending or descending order.
     */
    public final List<OrderBy> orderBy() {
        return orderBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyFilters() {
        return propertyFilters != null && !(propertyFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can filter the request using various logical operators and a key-value format. For example:
     * </p>
     * <p>
     * <code>{"key": "serverType", "value": "webServer"}</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyFilters} method.
     * </p>
     * 
     * @return You can filter the request using various logical operators and a key-value format. For example:</p>
     *         <p>
     *         <code>{"key": "serverType", "value": "webServer"}</code>
     */
    public final List<PropertyFilter> propertyFilters() {
        return propertyFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderBy() ? orderBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyFilters() ? propertyFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabularConditions)) {
            return false;
        }
        TabularConditions other = (TabularConditions) obj;
        return hasOrderBy() == other.hasOrderBy() && Objects.equals(orderBy(), other.orderBy())
                && hasPropertyFilters() == other.hasPropertyFilters()
                && Objects.equals(propertyFilters(), other.propertyFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TabularConditions").add("OrderBy", hasOrderBy() ? orderBy() : null)
                .add("PropertyFilters", hasPropertyFilters() ? propertyFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        case "propertyFilters":
            return Optional.ofNullable(clazz.cast(propertyFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("propertyFilters", PROPERTY_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TabularConditions, T> g) {
        return obj -> g.apply((TabularConditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TabularConditions> {
        /**
         * <p>
         * Filter criteria that orders the output. It can be sorted in ascending or descending order.
         * </p>
         * 
         * @param orderBy
         *        Filter criteria that orders the output. It can be sorted in ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(Collection<OrderBy> orderBy);

        /**
         * <p>
         * Filter criteria that orders the output. It can be sorted in ascending or descending order.
         * </p>
         * 
         * @param orderBy
         *        Filter criteria that orders the output. It can be sorted in ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(OrderBy... orderBy);

        /**
         * <p>
         * Filter criteria that orders the output. It can be sorted in ascending or descending order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.OrderBy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iottwinmaker.model.OrderBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.OrderBy.Builder#build()} is called immediately and
         * its result is passed to {@link #orderBy(List<OrderBy>)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.OrderBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(java.util.Collection<OrderBy>)
         */
        Builder orderBy(Consumer<OrderBy.Builder>... orderBy);

        /**
         * <p>
         * You can filter the request using various logical operators and a key-value format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * 
         * @param propertyFilters
         *        You can filter the request using various logical operators and a key-value format. For example:</p>
         *        <p>
         *        <code>{"key": "serverType", "value": "webServer"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(Collection<PropertyFilter> propertyFilters);

        /**
         * <p>
         * You can filter the request using various logical operators and a key-value format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * 
         * @param propertyFilters
         *        You can filter the request using various logical operators and a key-value format. For example:</p>
         *        <p>
         *        <code>{"key": "serverType", "value": "webServer"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(PropertyFilter... propertyFilters);

        /**
         * <p>
         * You can filter the request using various logical operators and a key-value format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyFilters(List<PropertyFilter>)}.
         * 
         * @param propertyFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyFilters(java.util.Collection<PropertyFilter>)
         */
        Builder propertyFilters(Consumer<PropertyFilter.Builder>... propertyFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<OrderBy> orderBy = DefaultSdkAutoConstructList.getInstance();

        private List<PropertyFilter> propertyFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TabularConditions model) {
            orderBy(model.orderBy);
            propertyFilters(model.propertyFilters);
        }

        public final List<OrderBy.Builder> getOrderBy() {
            List<OrderBy.Builder> result = OrderByListCopier.copyToBuilder(this.orderBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderBy(Collection<OrderBy.BuilderImpl> orderBy) {
            this.orderBy = OrderByListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public final Builder orderBy(Collection<OrderBy> orderBy) {
            this.orderBy = OrderByListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(OrderBy... orderBy) {
            orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<OrderBy.Builder>... orderBy) {
            orderBy(Stream.of(orderBy).map(c -> OrderBy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PropertyFilter.Builder> getPropertyFilters() {
            List<PropertyFilter.Builder> result = PropertyFiltersCopier.copyToBuilder(this.propertyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyFilters(Collection<PropertyFilter.BuilderImpl> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copyFromBuilder(propertyFilters);
        }

        @Override
        public final Builder propertyFilters(Collection<PropertyFilter> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copy(propertyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(PropertyFilter... propertyFilters) {
            propertyFilters(Arrays.asList(propertyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(Consumer<PropertyFilter.Builder>... propertyFilters) {
            propertyFilters(Stream.of(propertyFilters).map(c -> PropertyFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TabularConditions build() {
            return new TabularConditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
