/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePricingPlanResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<UpdatePricingPlanResponse.Builder, UpdatePricingPlanResponse> {
    private static final SdkField<PricingPlan> CURRENT_PRICING_PLAN_FIELD = SdkField
            .<PricingPlan> builder(MarshallingType.SDK_POJO).memberName("currentPricingPlan")
            .getter(getter(UpdatePricingPlanResponse::currentPricingPlan)).setter(setter(Builder::currentPricingPlan))
            .constructor(PricingPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPricingPlan").build())
            .build();

    private static final SdkField<PricingPlan> PENDING_PRICING_PLAN_FIELD = SdkField
            .<PricingPlan> builder(MarshallingType.SDK_POJO).memberName("pendingPricingPlan")
            .getter(getter(UpdatePricingPlanResponse::pendingPricingPlan)).setter(setter(Builder::pendingPricingPlan))
            .constructor(PricingPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPricingPlan").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PRICING_PLAN_FIELD,
            PENDING_PRICING_PLAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PricingPlan currentPricingPlan;

    private final PricingPlan pendingPricingPlan;

    private UpdatePricingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.currentPricingPlan = builder.currentPricingPlan;
        this.pendingPricingPlan = builder.pendingPricingPlan;
    }

    /**
     * <p>
     * Update the current pricing plan.
     * </p>
     * 
     * @return Update the current pricing plan.
     */
    public final PricingPlan currentPricingPlan() {
        return currentPricingPlan;
    }

    /**
     * <p>
     * Update the pending pricing plan.
     * </p>
     * 
     * @return Update the pending pricing plan.
     */
    public final PricingPlan pendingPricingPlan() {
        return pendingPricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(currentPricingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(pendingPricingPlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePricingPlanResponse)) {
            return false;
        }
        UpdatePricingPlanResponse other = (UpdatePricingPlanResponse) obj;
        return Objects.equals(currentPricingPlan(), other.currentPricingPlan())
                && Objects.equals(pendingPricingPlan(), other.pendingPricingPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePricingPlanResponse").add("CurrentPricingPlan", currentPricingPlan())
                .add("PendingPricingPlan", pendingPricingPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currentPricingPlan":
            return Optional.ofNullable(clazz.cast(currentPricingPlan()));
        case "pendingPricingPlan":
            return Optional.ofNullable(clazz.cast(pendingPricingPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currentPricingPlan", CURRENT_PRICING_PLAN_FIELD);
        map.put("pendingPricingPlan", PENDING_PRICING_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePricingPlanResponse, T> g) {
        return obj -> g.apply((UpdatePricingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePricingPlanResponse> {
        /**
         * <p>
         * Update the current pricing plan.
         * </p>
         * 
         * @param currentPricingPlan
         *        Update the current pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPricingPlan(PricingPlan currentPricingPlan);

        /**
         * <p>
         * Update the current pricing plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link PricingPlan.Builder} avoiding the need to
         * create one manually via {@link PricingPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PricingPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #currentPricingPlan(PricingPlan)}.
         * 
         * @param currentPricingPlan
         *        a consumer that will call methods on {@link PricingPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentPricingPlan(PricingPlan)
         */
        default Builder currentPricingPlan(Consumer<PricingPlan.Builder> currentPricingPlan) {
            return currentPricingPlan(PricingPlan.builder().applyMutation(currentPricingPlan).build());
        }

        /**
         * <p>
         * Update the pending pricing plan.
         * </p>
         * 
         * @param pendingPricingPlan
         *        Update the pending pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingPricingPlan(PricingPlan pendingPricingPlan);

        /**
         * <p>
         * Update the pending pricing plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link PricingPlan.Builder} avoiding the need to
         * create one manually via {@link PricingPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PricingPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #pendingPricingPlan(PricingPlan)}.
         * 
         * @param pendingPricingPlan
         *        a consumer that will call methods on {@link PricingPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingPricingPlan(PricingPlan)
         */
        default Builder pendingPricingPlan(Consumer<PricingPlan.Builder> pendingPricingPlan) {
            return pendingPricingPlan(PricingPlan.builder().applyMutation(pendingPricingPlan).build());
        }
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private PricingPlan currentPricingPlan;

        private PricingPlan pendingPricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePricingPlanResponse model) {
            super(model);
            currentPricingPlan(model.currentPricingPlan);
            pendingPricingPlan(model.pendingPricingPlan);
        }

        public final PricingPlan.Builder getCurrentPricingPlan() {
            return currentPricingPlan != null ? currentPricingPlan.toBuilder() : null;
        }

        public final void setCurrentPricingPlan(PricingPlan.BuilderImpl currentPricingPlan) {
            this.currentPricingPlan = currentPricingPlan != null ? currentPricingPlan.build() : null;
        }

        @Override
        public final Builder currentPricingPlan(PricingPlan currentPricingPlan) {
            this.currentPricingPlan = currentPricingPlan;
            return this;
        }

        public final PricingPlan.Builder getPendingPricingPlan() {
            return pendingPricingPlan != null ? pendingPricingPlan.toBuilder() : null;
        }

        public final void setPendingPricingPlan(PricingPlan.BuilderImpl pendingPricingPlan) {
            this.pendingPricingPlan = pendingPricingPlan != null ? pendingPricingPlan.build() : null;
        }

        @Override
        public final Builder pendingPricingPlan(PricingPlan pendingPricingPlan) {
            this.pendingPricingPlan = pendingPricingPlan;
            return this;
        }

        @Override
        public UpdatePricingPlanResponse build() {
            return new UpdatePricingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
