/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotwireless.model.AccessDeniedException;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.ConflictException;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.InternalServerException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.ThrottlingException;
import software.amazon.awssdk.services.iotwireless.model.TooManyTagsException;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.ValidationException;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable;
import software.amazon.awssdk.services.iotwireless.transform.AssociateAwsAccountWithPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessDeviceWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateAwsAccountFromPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessDeviceFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceEndpointRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayFirmwareInformationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDeviceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListPartnerAccountsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListServiceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessDevicesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewayTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewaysRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.SendDataToWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TestWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdatePartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IotWirelessClient}.
 *
 * @see IotWirelessClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotWirelessClient implements IotWirelessClient {
    private static final Logger log = Logger.loggerFor(DefaultIotWirelessClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotWirelessClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return Result of the AssociateAwsAccountWithPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateAwsAccountWithPartnerAccountResponse associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateAwsAccountWithPartnerAccountResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateAwsAccountWithPartnerAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateAwsAccountWithPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAwsAccountWithPartnerAccount");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse>()
                            .withOperationName("AssociateAwsAccountWithPartnerAccount").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateAwsAccountWithPartnerAccountRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateAwsAccountWithPartnerAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return Result of the AssociateWirelessDeviceWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateWirelessDeviceWithThingResponse associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWirelessDeviceWithThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateWirelessDeviceWithThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessDeviceWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessDeviceWithThing");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse>()
                            .withOperationName("AssociateWirelessDeviceWithThing").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateWirelessDeviceWithThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateWirelessDeviceWithThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return Result of the AssociateWirelessGatewayWithCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateWirelessGatewayWithCertificateResponse associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWirelessGatewayWithCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateWirelessGatewayWithCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse>()
                            .withOperationName("AssociateWirelessGatewayWithCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateWirelessGatewayWithCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateWirelessGatewayWithCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return Result of the AssociateWirelessGatewayWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateWirelessGatewayWithThingResponse associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWirelessGatewayWithThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateWirelessGatewayWithThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithThing");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse>()
                            .withOperationName("AssociateWirelessGatewayWithThing").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateWirelessGatewayWithThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateWirelessGatewayWithThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return Result of the CreateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDestinationResponse createDestination(CreateDestinationRequest createDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDestination");

            return clientHandler.execute(new ClientExecutionParams<CreateDestinationRequest, CreateDestinationResponse>()
                    .withOperationName("CreateDestination").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return Result of the CreateDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeviceProfileResponse createDeviceProfile(CreateDeviceProfileRequest createDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDeviceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateDeviceProfileRequest, CreateDeviceProfileResponse>()
                    .withOperationName("CreateDeviceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeviceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeviceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return Result of the CreateServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateServiceProfileResponse createServiceProfile(CreateServiceProfileRequest createServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateServiceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateServiceProfileRequest, CreateServiceProfileResponse>()
                    .withOperationName("CreateServiceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createServiceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateServiceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return Result of the CreateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWirelessDeviceResponse createWirelessDevice(CreateWirelessDeviceRequest createWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessDevice");

            return clientHandler.execute(new ClientExecutionParams<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse>()
                    .withOperationName("CreateWirelessDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWirelessDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return Result of the CreateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWirelessGatewayResponse createWirelessGateway(CreateWirelessGatewayRequest createWirelessGatewayRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWirelessGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse>()
                    .withOperationName("CreateWirelessGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWirelessGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWirelessGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return Result of the CreateWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWirelessGatewayTaskResponse createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWirelessGatewayTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse>()
                            .withOperationName("CreateWirelessGatewayTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createWirelessGatewayTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateWirelessGatewayTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return Result of the CreateWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWirelessGatewayTaskDefinitionResponse createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWirelessGatewayTaskDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTaskDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("CreateWirelessGatewayTaskDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createWirelessGatewayTaskDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDestination");

            return clientHandler.execute(new ClientExecutionParams<DeleteDestinationRequest, DeleteDestinationResponse>()
                    .withOperationName("DeleteDestination").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return Result of the DeleteDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeviceProfileResponse deleteDeviceProfile(DeleteDeviceProfileRequest deleteDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeviceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse>()
                    .withOperationName("DeleteDeviceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeviceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeviceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return Result of the DeleteServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteServiceProfileResponse deleteServiceProfile(DeleteServiceProfileRequest deleteServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteServiceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteServiceProfileRequest, DeleteServiceProfileResponse>()
                    .withOperationName("DeleteServiceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteServiceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteServiceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return Result of the DeleteWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWirelessDeviceResponse deleteWirelessDevice(DeleteWirelessDeviceRequest deleteWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessDevice");

            return clientHandler.execute(new ClientExecutionParams<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse>()
                    .withOperationName("DeleteWirelessDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWirelessDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return Result of the DeleteWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWirelessGatewayResponse deleteWirelessGateway(DeleteWirelessGatewayRequest deleteWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWirelessGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse>()
                    .withOperationName("DeleteWirelessGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWirelessGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWirelessGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return Result of the DeleteWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWirelessGatewayTaskResponse deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWirelessGatewayTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTask");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse>()
                            .withOperationName("DeleteWirelessGatewayTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteWirelessGatewayTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteWirelessGatewayTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return Result of the DeleteWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWirelessGatewayTaskDefinitionResponse deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWirelessGatewayTaskDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTaskDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("DeleteWirelessGatewayTaskDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteWirelessGatewayTaskDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return Result of the DisassociateAwsAccountFromPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateAwsAccountFromPartnerAccountResponse disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateAwsAccountFromPartnerAccountResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateAwsAccountFromPartnerAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAwsAccountFromPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAwsAccountFromPartnerAccount");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse>()
                            .withOperationName("DisassociateAwsAccountFromPartnerAccount").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateAwsAccountFromPartnerAccountRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateAwsAccountFromPartnerAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return Result of the DisassociateWirelessDeviceFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateWirelessDeviceFromThingResponse disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateWirelessDeviceFromThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateWirelessDeviceFromThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessDeviceFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessDeviceFromThing");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse>()
                            .withOperationName("DisassociateWirelessDeviceFromThing").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateWirelessDeviceFromThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateWirelessDeviceFromThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return Result of the DisassociateWirelessGatewayFromCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateWirelessGatewayFromCertificateResponse disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateWirelessGatewayFromCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateWirelessGatewayFromCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateWirelessGatewayFromCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return Result of the DisassociateWirelessGatewayFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateWirelessGatewayFromThingResponse disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateWirelessGatewayFromThingResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromThing");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromThing").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateWirelessGatewayFromThingRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateWirelessGatewayFromThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return Result of the GetDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDestinationResponse getDestination(GetDestinationRequest getDestinationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDestination");

            return clientHandler.execute(new ClientExecutionParams<GetDestinationRequest, GetDestinationResponse>()
                    .withOperationName("GetDestination").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return Result of the GetDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeviceProfileResponse getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeviceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceProfile");

            return clientHandler.execute(new ClientExecutionParams<GetDeviceProfileRequest, GetDeviceProfileResponse>()
                    .withOperationName("GetDeviceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeviceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return Result of the GetPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPartnerAccountResponse getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPartnerAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPartnerAccount");

            return clientHandler.execute(new ClientExecutionParams<GetPartnerAccountRequest, GetPartnerAccountResponse>()
                    .withOperationName("GetPartnerAccount").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPartnerAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPartnerAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return Result of the GetServiceEndpoint operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetServiceEndpointResponse getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetServiceEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetServiceEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceEndpoint");

            return clientHandler.execute(new ClientExecutionParams<GetServiceEndpointRequest, GetServiceEndpointResponse>()
                    .withOperationName("GetServiceEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getServiceEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetServiceEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return Result of the GetServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetServiceProfileResponse getServiceProfile(GetServiceProfileRequest getServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetServiceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceProfile");

            return clientHandler.execute(new ClientExecutionParams<GetServiceProfileRequest, GetServiceProfileResponse>()
                    .withOperationName("GetServiceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getServiceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetServiceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return Result of the GetWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetWirelessDeviceResponse getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDevice");

            return clientHandler.execute(new ClientExecutionParams<GetWirelessDeviceRequest, GetWirelessDeviceResponse>()
                    .withOperationName("GetWirelessDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return Result of the GetWirelessDeviceStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessDeviceStatisticsResponse getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessDeviceStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessDeviceStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDeviceStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse>()
                            .withOperationName("GetWirelessDeviceStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessDeviceStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessDeviceStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return Result of the GetWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayResponse getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGateway");

            return clientHandler.execute(new ClientExecutionParams<GetWirelessGatewayRequest, GetWirelessGatewayResponse>()
                    .withOperationName("GetWirelessGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWirelessGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return Result of the GetWirelessGatewayCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayCertificateResponse getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessGatewayCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse>()
                            .withOperationName("GetWirelessGatewayCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessGatewayCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessGatewayCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return Result of the GetWirelessGatewayFirmwareInformation operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayFirmwareInformationResponse getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayFirmwareInformationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetWirelessGatewayFirmwareInformationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayFirmwareInformationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayFirmwareInformation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse>()
                            .withOperationName("GetWirelessGatewayFirmwareInformation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getWirelessGatewayFirmwareInformationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessGatewayFirmwareInformationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return Result of the GetWirelessGatewayStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayStatisticsResponse getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessGatewayStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse>()
                            .withOperationName("GetWirelessGatewayStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessGatewayStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessGatewayStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return Result of the GetWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayTaskResponse getWirelessGatewayTask(GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessGatewayTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTask");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse>()
                            .withOperationName("GetWirelessGatewayTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessGatewayTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessGatewayTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return Result of the GetWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWirelessGatewayTaskDefinitionResponse getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWirelessGatewayTaskDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTaskDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("GetWirelessGatewayTaskDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getWirelessGatewayTaskDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return Result of the ListDestinations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDestinationsResponse listDestinations(ListDestinationsRequest listDestinationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDestinationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDestinations");

            return clientHandler.execute(new ClientExecutionParams<ListDestinationsRequest, ListDestinationsResponse>()
                    .withOperationName("ListDestinations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDestinationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDestinationsIterable listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return new ListDestinationsIterable(this, applyPaginatorUserAgent(listDestinationsRequest));
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return Result of the ListDeviceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceProfilesResponse listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeviceProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListDeviceProfilesRequest, ListDeviceProfilesResponse>()
                    .withOperationName("ListDeviceProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDeviceProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDeviceProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client
     *             .listDeviceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceProfilesIterable listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return new ListDeviceProfilesIterable(this, applyPaginatorUserAgent(listDeviceProfilesRequest));
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return Result of the ListPartnerAccounts operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPartnerAccountsResponse listPartnerAccounts(ListPartnerAccountsRequest listPartnerAccountsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPartnerAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPartnerAccountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPartnerAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPartnerAccounts");

            return clientHandler.execute(new ClientExecutionParams<ListPartnerAccountsRequest, ListPartnerAccountsResponse>()
                    .withOperationName("ListPartnerAccounts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPartnerAccountsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPartnerAccountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return Result of the ListServiceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceProfilesResponse listServiceProfiles(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListServiceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListServiceProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServiceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListServiceProfilesRequest, ListServiceProfilesResponse>()
                    .withOperationName("ListServiceProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listServiceProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListServiceProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client
     *             .listServiceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceProfilesIterable listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return new ListServiceProfilesIterable(this, applyPaginatorUserAgent(listServiceProfilesRequest));
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return Result of the ListWirelessDevices operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWirelessDevicesResponse listWirelessDevices(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWirelessDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWirelessDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessDevices");

            return clientHandler.execute(new ClientExecutionParams<ListWirelessDevicesRequest, ListWirelessDevicesResponse>()
                    .withOperationName("ListWirelessDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listWirelessDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWirelessDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client
     *             .listWirelessDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWirelessDevicesIterable listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return new ListWirelessDevicesIterable(this, applyPaginatorUserAgent(listWirelessDevicesRequest));
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return Result of the ListWirelessGatewayTaskDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWirelessGatewayTaskDefinitionsResponse listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWirelessGatewayTaskDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWirelessGatewayTaskDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listWirelessGatewayTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGatewayTaskDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse>()
                            .withOperationName("ListWirelessGatewayTaskDefinitions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listWirelessGatewayTaskDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWirelessGatewayTaskDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return Result of the ListWirelessGateways operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWirelessGatewaysResponse listWirelessGateways(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWirelessGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWirelessGatewaysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGateways");

            return clientHandler.execute(new ClientExecutionParams<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse>()
                    .withOperationName("ListWirelessGateways").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listWirelessGatewaysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWirelessGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client
     *             .listWirelessGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWirelessGatewaysIterable listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return new ListWirelessGatewaysIterable(this, applyPaginatorUserAgent(listWirelessGatewaysRequest));
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return Result of the SendDataToWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendDataToWirelessDeviceResponse sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendDataToWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SendDataToWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendDataToWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendDataToWirelessDevice");

            return clientHandler
                    .execute(new ClientExecutionParams<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse>()
                            .withOperationName("SendDataToWirelessDevice").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(sendDataToWirelessDeviceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SendDataToWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws TooManyTagsException
     *         The request was denied because the resource can't have any more tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, TooManyTagsException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return Result of the TestWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TestWirelessDeviceResponse testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TestWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestWirelessDevice");

            return clientHandler.execute(new ClientExecutionParams<TestWirelessDeviceRequest, TestWirelessDeviceResponse>()
                    .withOperationName("TestWirelessDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(testWirelessDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDestination");

            return clientHandler.execute(new ClientExecutionParams<UpdateDestinationRequest, UpdateDestinationResponse>()
                    .withOperationName("UpdateDestination").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return Result of the UpdatePartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePartnerAccountResponse updatePartnerAccount(UpdatePartnerAccountRequest updatePartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePartnerAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePartnerAccount");

            return clientHandler.execute(new ClientExecutionParams<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse>()
                    .withOperationName("UpdatePartnerAccount").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePartnerAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePartnerAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return Result of the UpdateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWirelessDeviceResponse updateWirelessDevice(UpdateWirelessDeviceRequest updateWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWirelessDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessDevice");

            return clientHandler.execute(new ClientExecutionParams<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse>()
                    .withOperationName("UpdateWirelessDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateWirelessDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWirelessDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return Result of the UpdateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWirelessGatewayResponse updateWirelessGateway(UpdateWirelessGatewayRequest updateWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWirelessGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessGateway");

            return clientHandler.execute(new ClientExecutionParams<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse>()
                    .withOperationName("UpdateWirelessGateway").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateWirelessGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWirelessGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IotWirelessException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends IotWirelessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
