/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Sidewalk router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkSendDataToDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkSendDataToDevice.Builder, SidewalkSendDataToDevice> {
    private static final SdkField<Integer> SEQ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Seq")
            .getter(getter(SidewalkSendDataToDevice::seq)).setter(setter(Builder::seq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seq").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(SidewalkSendDataToDevice::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SEQ_FIELD, MESSAGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer seq;

    private final String messageType;

    private SidewalkSendDataToDevice(BuilderImpl builder) {
        this.seq = builder.seq;
        this.messageType = builder.messageType;
    }

    /**
     * <p>
     * The sequence number.
     * </p>
     * 
     * @return The sequence number.
     */
    public final Integer seq() {
        return seq;
    }

    /**
     * Returns the value of the MessageType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The value of the MessageType property for this object.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * Returns the value of the MessageType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The value of the MessageType property for this object.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(seq());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkSendDataToDevice)) {
            return false;
        }
        SidewalkSendDataToDevice other = (SidewalkSendDataToDevice) obj;
        return Objects.equals(seq(), other.seq()) && Objects.equals(messageTypeAsString(), other.messageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkSendDataToDevice").add("Seq", seq()).add("MessageType", messageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Seq":
            return Optional.ofNullable(clazz.cast(seq()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkSendDataToDevice, T> g) {
        return obj -> g.apply((SidewalkSendDataToDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkSendDataToDevice> {
        /**
         * <p>
         * The sequence number.
         * </p>
         * 
         * @param seq
         *        The sequence number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seq(Integer seq);

        /**
         * Sets the value of the MessageType property for this object.
         *
         * @param messageType
         *        The new value for the MessageType property for this object.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * Sets the value of the MessageType property for this object.
         *
         * @param messageType
         *        The new value for the MessageType property for this object.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);
    }

    static final class BuilderImpl implements Builder {
        private Integer seq;

        private String messageType;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkSendDataToDevice model) {
            seq(model.seq);
            messageType(model.messageType);
        }

        public final Integer getSeq() {
            return seq;
        }

        @Override
        public final Builder seq(Integer seq) {
            this.seq = seq;
            return this;
        }

        public final void setSeq(Integer seq) {
            this.seq = seq;
        }

        public final String getMessageType() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public SidewalkSendDataToDevice build() {
            return new SidewalkSendDataToDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
