/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWirelessGatewaysResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListWirelessGatewaysResponse.Builder, ListWirelessGatewaysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWirelessGatewaysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<WirelessGatewayStatistics>> WIRELESS_GATEWAY_LIST_FIELD = SdkField
            .<List<WirelessGatewayStatistics>> builder(MarshallingType.LIST)
            .memberName("WirelessGatewayList")
            .getter(getter(ListWirelessGatewaysResponse::wirelessGatewayList))
            .setter(setter(Builder::wirelessGatewayList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WirelessGatewayStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(WirelessGatewayStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WIRELESS_GATEWAY_LIST_FIELD));

    private final String nextToken;

    private final List<WirelessGatewayStatistics> wirelessGatewayList;

    private ListWirelessGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.wirelessGatewayList = builder.wirelessGatewayList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the WirelessGatewayList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasWirelessGatewayList() {
        return wirelessGatewayList != null && !(wirelessGatewayList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the wireless gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWirelessGatewayList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of the wireless gateway.
     */
    public final List<WirelessGatewayStatistics> wirelessGatewayList() {
        return wirelessGatewayList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGatewayList() ? wirelessGatewayList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessGatewaysResponse)) {
            return false;
        }
        ListWirelessGatewaysResponse other = (ListWirelessGatewaysResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWirelessGatewayList() == other.hasWirelessGatewayList()
                && Objects.equals(wirelessGatewayList(), other.wirelessGatewayList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWirelessGatewaysResponse").add("NextToken", nextToken())
                .add("WirelessGatewayList", hasWirelessGatewayList() ? wirelessGatewayList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WirelessGatewayList":
            return Optional.ofNullable(clazz.cast(wirelessGatewayList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessGatewaysResponse, T> g) {
        return obj -> g.apply((ListWirelessGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWirelessGatewaysResponse> {
        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * 
         * @param wirelessGatewayList
         *        The ID of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayList(Collection<WirelessGatewayStatistics> wirelessGatewayList);

        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * 
         * @param wirelessGatewayList
         *        The ID of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayList(WirelessGatewayStatistics... wirelessGatewayList);

        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WirelessGatewayStatistics>.Builder}
         * avoiding the need to create one manually via {@link List<WirelessGatewayStatistics>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WirelessGatewayStatistics>.Builder#build()} is called
         * immediately and its result is passed to {@link #wirelessGatewayList(List<WirelessGatewayStatistics>)}.
         * 
         * @param wirelessGatewayList
         *        a consumer that will call methods on {@link List<WirelessGatewayStatistics>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessGatewayList(List<WirelessGatewayStatistics>)
         */
        Builder wirelessGatewayList(Consumer<WirelessGatewayStatistics.Builder>... wirelessGatewayList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WirelessGatewayStatistics> wirelessGatewayList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessGatewaysResponse model) {
            super(model);
            nextToken(model.nextToken);
            wirelessGatewayList(model.wirelessGatewayList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<WirelessGatewayStatistics.Builder> getWirelessGatewayList() {
            List<WirelessGatewayStatistics.Builder> result = WirelessGatewayStatisticsListCopier
                    .copyToBuilder(this.wirelessGatewayList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder wirelessGatewayList(Collection<WirelessGatewayStatistics> wirelessGatewayList) {
            this.wirelessGatewayList = WirelessGatewayStatisticsListCopier.copy(wirelessGatewayList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayList(WirelessGatewayStatistics... wirelessGatewayList) {
            wirelessGatewayList(Arrays.asList(wirelessGatewayList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayList(Consumer<WirelessGatewayStatistics.Builder>... wirelessGatewayList) {
            wirelessGatewayList(Stream.of(wirelessGatewayList)
                    .map(c -> WirelessGatewayStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWirelessGatewayList(Collection<WirelessGatewayStatistics.BuilderImpl> wirelessGatewayList) {
            this.wirelessGatewayList = WirelessGatewayStatisticsListCopier.copyFromBuilder(wirelessGatewayList);
        }

        @Override
        public ListWirelessGatewaysResponse build() {
            return new ListWirelessGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
