/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of FPort assigned for different LoRaWAN application packages to use
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FPorts implements SdkPojo, Serializable, ToCopyableBuilder<FPorts.Builder, FPorts> {
    private static final SdkField<Integer> FUOTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Fuota")
            .getter(getter(FPorts::fuota)).setter(setter(Builder::fuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fuota").build()).build();

    private static final SdkField<Integer> MULTICAST_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Multicast").getter(getter(FPorts::multicast)).setter(setter(Builder::multicast))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Multicast").build()).build();

    private static final SdkField<Integer> CLOCK_SYNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClockSync").getter(getter(FPorts::clockSync)).setter(setter(Builder::clockSync))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClockSync").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUOTA_FIELD, MULTICAST_FIELD,
            CLOCK_SYNC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fuota;

    private final Integer multicast;

    private final Integer clockSync;

    private FPorts(BuilderImpl builder) {
        this.fuota = builder.fuota;
        this.multicast = builder.multicast;
        this.clockSync = builder.clockSync;
    }

    /**
     * Returns the value of the Fuota property for this object.
     * 
     * @return The value of the Fuota property for this object.
     */
    public final Integer fuota() {
        return fuota;
    }

    /**
     * Returns the value of the Multicast property for this object.
     * 
     * @return The value of the Multicast property for this object.
     */
    public final Integer multicast() {
        return multicast;
    }

    /**
     * Returns the value of the ClockSync property for this object.
     * 
     * @return The value of the ClockSync property for this object.
     */
    public final Integer clockSync() {
        return clockSync;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fuota());
        hashCode = 31 * hashCode + Objects.hashCode(multicast());
        hashCode = 31 * hashCode + Objects.hashCode(clockSync());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FPorts)) {
            return false;
        }
        FPorts other = (FPorts) obj;
        return Objects.equals(fuota(), other.fuota()) && Objects.equals(multicast(), other.multicast())
                && Objects.equals(clockSync(), other.clockSync());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FPorts").add("Fuota", fuota()).add("Multicast", multicast()).add("ClockSync", clockSync())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fuota":
            return Optional.ofNullable(clazz.cast(fuota()));
        case "Multicast":
            return Optional.ofNullable(clazz.cast(multicast()));
        case "ClockSync":
            return Optional.ofNullable(clazz.cast(clockSync()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FPorts, T> g) {
        return obj -> g.apply((FPorts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FPorts> {
        /**
         * Sets the value of the Fuota property for this object.
         *
         * @param fuota
         *        The new value for the Fuota property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fuota(Integer fuota);

        /**
         * Sets the value of the Multicast property for this object.
         *
         * @param multicast
         *        The new value for the Multicast property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicast(Integer multicast);

        /**
         * Sets the value of the ClockSync property for this object.
         *
         * @param clockSync
         *        The new value for the ClockSync property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clockSync(Integer clockSync);
    }

    static final class BuilderImpl implements Builder {
        private Integer fuota;

        private Integer multicast;

        private Integer clockSync;

        private BuilderImpl() {
        }

        private BuilderImpl(FPorts model) {
            fuota(model.fuota);
            multicast(model.multicast);
            clockSync(model.clockSync);
        }

        public final Integer getFuota() {
            return fuota;
        }

        public final void setFuota(Integer fuota) {
            this.fuota = fuota;
        }

        @Override
        @Transient
        public final Builder fuota(Integer fuota) {
            this.fuota = fuota;
            return this;
        }

        public final Integer getMulticast() {
            return multicast;
        }

        public final void setMulticast(Integer multicast) {
            this.multicast = multicast;
        }

        @Override
        @Transient
        public final Builder multicast(Integer multicast) {
            this.multicast = multicast;
            return this;
        }

        public final Integer getClockSync() {
            return clockSync;
        }

        public final void setClockSync(Integer clockSync) {
            this.clockSync = clockSync;
        }

        @Override
        @Transient
        public final Builder clockSync(Integer clockSync) {
            this.clockSync = clockSync;
            return this;
        }

        @Override
        public FPorts build() {
            return new FPorts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
