/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceEventConfigurationRequest extends IotWirelessRequest implements
        ToCopyableBuilder<GetResourceEventConfigurationRequest.Builder, GetResourceEventConfigurationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetResourceEventConfigurationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentifierType").getter(getter(GetResourceEventConfigurationRequest::identifierTypeAsString))
            .setter(setter(Builder::identifierType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifierType").build())
            .build();

    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerType").getter(getter(GetResourceEventConfigurationRequest::partnerTypeAsString))
            .setter(setter(Builder::partnerType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            IDENTIFIER_TYPE_FIELD, PARTNER_TYPE_FIELD));

    private final String identifier;

    private final String identifierType;

    private final String partnerType;

    private GetResourceEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
        this.partnerType = builder.partnerType;
    }

    /**
     * <p>
     * Resource identifier to opt in for event messaging.
     * </p>
     * 
     * @return Resource identifier to opt in for event messaging.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Identifier type of the particular resource identifier for event configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link IdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return Identifier type of the particular resource identifier for event configuration.
     * @see IdentifierType
     */
    public final IdentifierType identifierType() {
        return IdentifierType.fromValue(identifierType);
    }

    /**
     * <p>
     * Identifier type of the particular resource identifier for event configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link IdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return Identifier type of the particular resource identifier for event configuration.
     * @see IdentifierType
     */
    public final String identifierTypeAsString() {
        return identifierType;
    }

    /**
     * <p>
     * Partner type of the resource if the identifier type is PartnerAccountId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link EventNotificationPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return Partner type of the resource if the identifier type is PartnerAccountId.
     * @see EventNotificationPartnerType
     */
    public final EventNotificationPartnerType partnerType() {
        return EventNotificationPartnerType.fromValue(partnerType);
    }

    /**
     * <p>
     * Partner type of the resource if the identifier type is PartnerAccountId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link EventNotificationPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return Partner type of the resource if the identifier type is PartnerAccountId.
     * @see EventNotificationPartnerType
     */
    public final String partnerTypeAsString() {
        return partnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifierTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partnerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEventConfigurationRequest)) {
            return false;
        }
        GetResourceEventConfigurationRequest other = (GetResourceEventConfigurationRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(identifierTypeAsString(), other.identifierTypeAsString())
                && Objects.equals(partnerTypeAsString(), other.partnerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceEventConfigurationRequest").add("Identifier", identifier())
                .add("IdentifierType", identifierTypeAsString()).add("PartnerType", partnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "IdentifierType":
            return Optional.ofNullable(clazz.cast(identifierTypeAsString()));
        case "PartnerType":
            return Optional.ofNullable(clazz.cast(partnerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEventConfigurationRequest, T> g) {
        return obj -> g.apply((GetResourceEventConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceEventConfigurationRequest> {
        /**
         * <p>
         * Resource identifier to opt in for event messaging.
         * </p>
         * 
         * @param identifier
         *        Resource identifier to opt in for event messaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Identifier type of the particular resource identifier for event configuration.
         * </p>
         * 
         * @param identifierType
         *        Identifier type of the particular resource identifier for event configuration.
         * @see IdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentifierType
         */
        Builder identifierType(String identifierType);

        /**
         * <p>
         * Identifier type of the particular resource identifier for event configuration.
         * </p>
         * 
         * @param identifierType
         *        Identifier type of the particular resource identifier for event configuration.
         * @see IdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentifierType
         */
        Builder identifierType(IdentifierType identifierType);

        /**
         * <p>
         * Partner type of the resource if the identifier type is PartnerAccountId.
         * </p>
         * 
         * @param partnerType
         *        Partner type of the resource if the identifier type is PartnerAccountId.
         * @see EventNotificationPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationPartnerType
         */
        Builder partnerType(String partnerType);

        /**
         * <p>
         * Partner type of the resource if the identifier type is PartnerAccountId.
         * </p>
         * 
         * @param partnerType
         *        Partner type of the resource if the identifier type is PartnerAccountId.
         * @see EventNotificationPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationPartnerType
         */
        Builder partnerType(EventNotificationPartnerType partnerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String identifier;

        private String identifierType;

        private String partnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEventConfigurationRequest model) {
            super(model);
            identifier(model.identifier);
            identifierType(model.identifierType);
            partnerType(model.partnerType);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        @Transient
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        @Transient
        public final Builder identifierType(IdentifierType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        public final String getPartnerType() {
            return partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        @Transient
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        @Transient
        public final Builder partnerType(EventNotificationPartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceEventConfigurationRequest build() {
            return new GetResourceEventConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
