/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceEndpointResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetServiceEndpointResponse.Builder, GetServiceEndpointResponse> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(GetServiceEndpointResponse::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> SERVICE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceEndpoint").getter(getter(GetServiceEndpointResponse::serviceEndpoint))
            .setter(setter(Builder::serviceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceEndpoint").build()).build();

    private static final SdkField<String> SERVER_TRUST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerTrust").getter(getter(GetServiceEndpointResponse::serverTrust))
            .setter(setter(Builder::serverTrust))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTrust").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            SERVICE_ENDPOINT_FIELD, SERVER_TRUST_FIELD));

    private final String serviceType;

    private final String serviceEndpoint;

    private final String serverTrust;

    private GetServiceEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.serviceEndpoint = builder.serviceEndpoint;
        this.serverTrust = builder.serverTrust;
    }

    /**
     * <p>
     * The endpoint's service type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link WirelessGatewayServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The endpoint's service type.
     * @see WirelessGatewayServiceType
     */
    public final WirelessGatewayServiceType serviceType() {
        return WirelessGatewayServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The endpoint's service type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link WirelessGatewayServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The endpoint's service type.
     * @see WirelessGatewayServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * The service endpoint value.
     * </p>
     * 
     * @return The service endpoint value.
     */
    public final String serviceEndpoint() {
        return serviceEndpoint;
    }

    /**
     * <p>
     * The Root CA of the server trust certificate.
     * </p>
     * 
     * @return The Root CA of the server trust certificate.
     */
    public final String serverTrust() {
        return serverTrust;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(serverTrust());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceEndpointResponse)) {
            return false;
        }
        GetServiceEndpointResponse other = (GetServiceEndpointResponse) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(serviceEndpoint(), other.serviceEndpoint())
                && Objects.equals(serverTrust(), other.serverTrust());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceEndpointResponse").add("ServiceType", serviceTypeAsString())
                .add("ServiceEndpoint", serviceEndpoint()).add("ServerTrust", serverTrust()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "ServiceEndpoint":
            return Optional.ofNullable(clazz.cast(serviceEndpoint()));
        case "ServerTrust":
            return Optional.ofNullable(clazz.cast(serverTrust()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceEndpointResponse, T> g) {
        return obj -> g.apply((GetServiceEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceEndpointResponse> {
        /**
         * <p>
         * The endpoint's service type.
         * </p>
         * 
         * @param serviceType
         *        The endpoint's service type.
         * @see WirelessGatewayServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The endpoint's service type.
         * </p>
         * 
         * @param serviceType
         *        The endpoint's service type.
         * @see WirelessGatewayServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayServiceType
         */
        Builder serviceType(WirelessGatewayServiceType serviceType);

        /**
         * <p>
         * The service endpoint value.
         * </p>
         * 
         * @param serviceEndpoint
         *        The service endpoint value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEndpoint(String serviceEndpoint);

        /**
         * <p>
         * The Root CA of the server trust certificate.
         * </p>
         * 
         * @param serverTrust
         *        The Root CA of the server trust certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverTrust(String serverTrust);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String serviceType;

        private String serviceEndpoint;

        private String serverTrust;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceEndpointResponse model) {
            super(model);
            serviceType(model.serviceType);
            serviceEndpoint(model.serviceEndpoint);
            serverTrust(model.serverTrust);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        @Transient
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceType(WirelessGatewayServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getServiceEndpoint() {
            return serviceEndpoint;
        }

        public final void setServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        @Override
        @Transient
        public final Builder serviceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public final String getServerTrust() {
            return serverTrust;
        }

        public final void setServerTrust(String serverTrust) {
            this.serverTrust = serverTrust;
        }

        @Override
        @Transient
        public final Builder serverTrust(String serverTrust) {
            this.serverTrust = serverTrust;
            return this;
        }

        @Override
        public GetServiceEndpointResponse build() {
            return new GetServiceEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
