/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessGatewayTaskResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessGatewayTaskResponse.Builder, GetWirelessGatewayTaskResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessGatewayId").getter(getter(GetWirelessGatewayTaskResponse::wirelessGatewayId))
            .setter(setter(Builder::wirelessGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayId").build()).build();

    private static final SdkField<String> WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WirelessGatewayTaskDefinitionId")
            .getter(getter(GetWirelessGatewayTaskResponse::wirelessGatewayTaskDefinitionId))
            .setter(setter(Builder::wirelessGatewayTaskDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayTaskDefinitionId")
                    .build()).build();

    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUplinkReceivedAt").getter(getter(GetWirelessGatewayTaskResponse::lastUplinkReceivedAt))
            .setter(setter(Builder::lastUplinkReceivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build())
            .build();

    private static final SdkField<String> TASK_CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskCreatedAt").getter(getter(GetWirelessGatewayTaskResponse::taskCreatedAt))
            .setter(setter(Builder::taskCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCreatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetWirelessGatewayTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_GATEWAY_ID_FIELD,
            WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD, TASK_CREATED_AT_FIELD, STATUS_FIELD));

    private final String wirelessGatewayId;

    private final String wirelessGatewayTaskDefinitionId;

    private final String lastUplinkReceivedAt;

    private final String taskCreatedAt;

    private final String status;

    private GetWirelessGatewayTaskResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayId = builder.wirelessGatewayId;
        this.wirelessGatewayTaskDefinitionId = builder.wirelessGatewayTaskDefinitionId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.taskCreatedAt = builder.taskCreatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the wireless gateway.
     * </p>
     * 
     * @return The ID of the wireless gateway.
     */
    public final String wirelessGatewayId() {
        return wirelessGatewayId;
    }

    /**
     * <p>
     * The ID of the WirelessGatewayTask.
     * </p>
     * 
     * @return The ID of the WirelessGatewayTask.
     */
    public final String wirelessGatewayTaskDefinitionId() {
        return wirelessGatewayTaskDefinitionId;
    }

    /**
     * <p>
     * The date and time when the most recent uplink was received.
     * </p>
     * 
     * @return The date and time when the most recent uplink was received.
     */
    public final String lastUplinkReceivedAt() {
        return lastUplinkReceivedAt;
    }

    /**
     * <p>
     * The date and time when the task was created.
     * </p>
     * 
     * @return The date and time when the task was created.
     */
    public final String taskCreatedAt() {
        return taskCreatedAt;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessGatewayTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see WirelessGatewayTaskStatus
     */
    public final WirelessGatewayTaskStatus status() {
        return WirelessGatewayTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessGatewayTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see WirelessGatewayTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(wirelessGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessGatewayTaskDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(taskCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayTaskResponse)) {
            return false;
        }
        GetWirelessGatewayTaskResponse other = (GetWirelessGatewayTaskResponse) obj;
        return Objects.equals(wirelessGatewayId(), other.wirelessGatewayId())
                && Objects.equals(wirelessGatewayTaskDefinitionId(), other.wirelessGatewayTaskDefinitionId())
                && Objects.equals(lastUplinkReceivedAt(), other.lastUplinkReceivedAt())
                && Objects.equals(taskCreatedAt(), other.taskCreatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessGatewayTaskResponse").add("WirelessGatewayId", wirelessGatewayId())
                .add("WirelessGatewayTaskDefinitionId", wirelessGatewayTaskDefinitionId())
                .add("LastUplinkReceivedAt", lastUplinkReceivedAt()).add("TaskCreatedAt", taskCreatedAt())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessGatewayId":
            return Optional.ofNullable(clazz.cast(wirelessGatewayId()));
        case "WirelessGatewayTaskDefinitionId":
            return Optional.ofNullable(clazz.cast(wirelessGatewayTaskDefinitionId()));
        case "LastUplinkReceivedAt":
            return Optional.ofNullable(clazz.cast(lastUplinkReceivedAt()));
        case "TaskCreatedAt":
            return Optional.ofNullable(clazz.cast(taskCreatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayTaskResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWirelessGatewayTaskResponse> {
        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * 
         * @param wirelessGatewayId
         *        The ID of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayId(String wirelessGatewayId);

        /**
         * <p>
         * The ID of the WirelessGatewayTask.
         * </p>
         * 
         * @param wirelessGatewayTaskDefinitionId
         *        The ID of the WirelessGatewayTask.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId);

        /**
         * <p>
         * The date and time when the most recent uplink was received.
         * </p>
         * 
         * @param lastUplinkReceivedAt
         *        The date and time when the most recent uplink was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUplinkReceivedAt(String lastUplinkReceivedAt);

        /**
         * <p>
         * The date and time when the task was created.
         * </p>
         * 
         * @param taskCreatedAt
         *        The date and time when the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskCreatedAt(String taskCreatedAt);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see WirelessGatewayTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see WirelessGatewayTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskStatus
         */
        Builder status(WirelessGatewayTaskStatus status);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String wirelessGatewayId;

        private String wirelessGatewayTaskDefinitionId;

        private String lastUplinkReceivedAt;

        private String taskCreatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayTaskResponse model) {
            super(model);
            wirelessGatewayId(model.wirelessGatewayId);
            wirelessGatewayTaskDefinitionId(model.wirelessGatewayTaskDefinitionId);
            lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            taskCreatedAt(model.taskCreatedAt);
            status(model.status);
        }

        public final String getWirelessGatewayId() {
            return wirelessGatewayId;
        }

        public final void setWirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
        }

        @Override
        @Transient
        public final Builder wirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
            return this;
        }

        public final String getWirelessGatewayTaskDefinitionId() {
            return wirelessGatewayTaskDefinitionId;
        }

        public final void setWirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
        }

        @Override
        @Transient
        public final Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        @Transient
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final String getTaskCreatedAt() {
            return taskCreatedAt;
        }

        public final void setTaskCreatedAt(String taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
        }

        @Override
        @Transient
        public final Builder taskCreatedAt(String taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(WirelessGatewayTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetWirelessGatewayTaskResponse build() {
            return new GetWirelessGatewayTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
