/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFuotaTaskRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateFuotaTaskRequest.Builder, UpdateFuotaTaskRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateFuotaTaskRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateFuotaTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFuotaTaskRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoRaWANFuotaTask> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANFuotaTask> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(UpdateFuotaTaskRequest::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANFuotaTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> FIRMWARE_UPDATE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateImage").getter(getter(UpdateFuotaTaskRequest::firmwareUpdateImage))
            .setter(setter(Builder::firmwareUpdateImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateImage").build())
            .build();

    private static final SdkField<String> FIRMWARE_UPDATE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateRole").getter(getter(UpdateFuotaTaskRequest::firmwareUpdateRole))
            .setter(setter(Builder::firmwareUpdateRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, LO_RA_WAN_FIELD, FIRMWARE_UPDATE_IMAGE_FIELD, FIRMWARE_UPDATE_ROLE_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final LoRaWANFuotaTask loRaWAN;

    private final String firmwareUpdateImage;

    private final String firmwareUpdateRole;

    private UpdateFuotaTaskRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.firmwareUpdateImage = builder.firmwareUpdateImage;
        this.firmwareUpdateRole = builder.firmwareUpdateRole;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the LoRaWAN property for this object.
     * 
     * @return The value of the LoRaWAN property for this object.
     */
    public final LoRaWANFuotaTask loRaWAN() {
        return loRaWAN;
    }

    /**
     * Returns the value of the FirmwareUpdateImage property for this object.
     * 
     * @return The value of the FirmwareUpdateImage property for this object.
     */
    public final String firmwareUpdateImage() {
        return firmwareUpdateImage;
    }

    /**
     * Returns the value of the FirmwareUpdateRole property for this object.
     * 
     * @return The value of the FirmwareUpdateRole property for this object.
     */
    public final String firmwareUpdateRole() {
        return firmwareUpdateRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateImage());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFuotaTaskRequest)) {
            return false;
        }
        UpdateFuotaTaskRequest other = (UpdateFuotaTaskRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(firmwareUpdateImage(), other.firmwareUpdateImage())
                && Objects.equals(firmwareUpdateRole(), other.firmwareUpdateRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFuotaTaskRequest").add("Id", id()).add("Name", name()).add("Description", description())
                .add("LoRaWAN", loRaWAN()).add("FirmwareUpdateImage", firmwareUpdateImage())
                .add("FirmwareUpdateRole", firmwareUpdateRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "FirmwareUpdateImage":
            return Optional.ofNullable(clazz.cast(firmwareUpdateImage()));
        case "FirmwareUpdateRole":
            return Optional.ofNullable(clazz.cast(firmwareUpdateRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFuotaTaskRequest, T> g) {
        return obj -> g.apply((UpdateFuotaTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFuotaTaskRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * @param loRaWAN
         *        The new value for the LoRaWAN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANFuotaTask loRaWAN);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * This is a convenience that creates an instance of the {@link LoRaWANFuotaTask.Builder} avoiding the need to
         * create one manually via {@link LoRaWANFuotaTask#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANFuotaTask.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANFuotaTask)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANFuotaTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANFuotaTask)
         */
        default Builder loRaWAN(Consumer<LoRaWANFuotaTask.Builder> loRaWAN) {
            return loRaWAN(LoRaWANFuotaTask.builder().applyMutation(loRaWAN).build());
        }

        /**
         * Sets the value of the FirmwareUpdateImage property for this object.
         *
         * @param firmwareUpdateImage
         *        The new value for the FirmwareUpdateImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateImage(String firmwareUpdateImage);

        /**
         * Sets the value of the FirmwareUpdateRole property for this object.
         *
         * @param firmwareUpdateRole
         *        The new value for the FirmwareUpdateRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateRole(String firmwareUpdateRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private LoRaWANFuotaTask loRaWAN;

        private String firmwareUpdateImage;

        private String firmwareUpdateRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFuotaTaskRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            loRaWAN(model.loRaWAN);
            firmwareUpdateImage(model.firmwareUpdateImage);
            firmwareUpdateRole(model.firmwareUpdateRole);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANFuotaTask.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANFuotaTask.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANFuotaTask loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getFirmwareUpdateImage() {
            return firmwareUpdateImage;
        }

        public final void setFirmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
        }

        @Override
        @Transient
        public final Builder firmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        public final String getFirmwareUpdateRole() {
            return firmwareUpdateRole;
        }

        public final void setFirmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
        }

        @Override
        @Transient
        public final Builder firmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFuotaTaskRequest build() {
            return new UpdateFuotaTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
