/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN object for update functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANUpdateDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANUpdateDevice.Builder, LoRaWANUpdateDevice> {
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(LoRaWANUpdateDevice::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()).build();

    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProfileId").getter(getter(LoRaWANUpdateDevice::serviceProfileId))
            .setter(setter(Builder::serviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_PROFILE_ID_FIELD,
            SERVICE_PROFILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceProfileId;

    private final String serviceProfileId;

    private LoRaWANUpdateDevice(BuilderImpl builder) {
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
    }

    /**
     * <p>
     * The ID of the device profile for the wireless device.
     * </p>
     * 
     * @return The ID of the device profile for the wireless device.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * The ID of the service profile.
     * </p>
     * 
     * @return The ID of the service profile.
     */
    public final String serviceProfileId() {
        return serviceProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANUpdateDevice)) {
            return false;
        }
        LoRaWANUpdateDevice other = (LoRaWANUpdateDevice) obj;
        return Objects.equals(deviceProfileId(), other.deviceProfileId())
                && Objects.equals(serviceProfileId(), other.serviceProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANUpdateDevice").add("DeviceProfileId", deviceProfileId())
                .add("ServiceProfileId", serviceProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "ServiceProfileId":
            return Optional.ofNullable(clazz.cast(serviceProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANUpdateDevice, T> g) {
        return obj -> g.apply((LoRaWANUpdateDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANUpdateDevice> {
        /**
         * <p>
         * The ID of the device profile for the wireless device.
         * </p>
         * 
         * @param deviceProfileId
         *        The ID of the device profile for the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * The ID of the service profile.
         * </p>
         * 
         * @param serviceProfileId
         *        The ID of the service profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProfileId(String serviceProfileId);
    }

    static final class BuilderImpl implements Builder {
        private String deviceProfileId;

        private String serviceProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANUpdateDevice model) {
            deviceProfileId(model.deviceProfileId);
            serviceProfileId(model.serviceProfileId);
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        @Override
        public LoRaWANUpdateDevice build() {
            return new LoRaWANUpdateDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
