/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNetworkAnalyzerConfigurationRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateNetworkAnalyzerConfigurationRequest.Builder, UpdateNetworkAnalyzerConfigurationRequest> {
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(UpdateNetworkAnalyzerConfigurationRequest::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationName").build()).build();

    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.<TraceContent> builder(MarshallingType.SDK_POJO)
            .memberName("TraceContent").getter(getter(UpdateNetworkAnalyzerConfigurationRequest::traceContent))
            .setter(setter(Builder::traceContent)).constructor(TraceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()).build();

    private static final SdkField<List<String>> WIRELESS_DEVICES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessDevicesToAdd")
            .getter(getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessDevicesToAdd))
            .setter(setter(Builder::wirelessDevicesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevicesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WIRELESS_DEVICES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessDevicesToRemove")
            .getter(getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessDevicesToRemove))
            .setter(setter(Builder::wirelessDevicesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevicesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WIRELESS_GATEWAYS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessGatewaysToAdd")
            .getter(getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessGatewaysToAdd))
            .setter(setter(Builder::wirelessGatewaysToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewaysToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WIRELESS_GATEWAYS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessGatewaysToRemove")
            .getter(getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessGatewaysToRemove))
            .setter(setter(Builder::wirelessGatewaysToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewaysToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_NAME_FIELD,
            TRACE_CONTENT_FIELD, WIRELESS_DEVICES_TO_ADD_FIELD, WIRELESS_DEVICES_TO_REMOVE_FIELD, WIRELESS_GATEWAYS_TO_ADD_FIELD,
            WIRELESS_GATEWAYS_TO_REMOVE_FIELD));

    private final String configurationName;

    private final TraceContent traceContent;

    private final List<String> wirelessDevicesToAdd;

    private final List<String> wirelessDevicesToRemove;

    private final List<String> wirelessGatewaysToAdd;

    private final List<String> wirelessGatewaysToRemove;

    private UpdateNetworkAnalyzerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationName = builder.configurationName;
        this.traceContent = builder.traceContent;
        this.wirelessDevicesToAdd = builder.wirelessDevicesToAdd;
        this.wirelessDevicesToRemove = builder.wirelessDevicesToRemove;
        this.wirelessGatewaysToAdd = builder.wirelessGatewaysToAdd;
        this.wirelessGatewaysToRemove = builder.wirelessGatewaysToRemove;
    }

    /**
     * Returns the value of the ConfigurationName property for this object.
     * 
     * @return The value of the ConfigurationName property for this object.
     */
    public final String configurationName() {
        return configurationName;
    }

    /**
     * Returns the value of the TraceContent property for this object.
     * 
     * @return The value of the TraceContent property for this object.
     */
    public final TraceContent traceContent() {
        return traceContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDevicesToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessDevicesToAdd() {
        return wirelessDevicesToAdd != null && !(wirelessDevicesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WirelessDevices to add into NetworkAnalyzerConfiguration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDevicesToAdd} method.
     * </p>
     * 
     * @return WirelessDevices to add into NetworkAnalyzerConfiguration.
     */
    public final List<String> wirelessDevicesToAdd() {
        return wirelessDevicesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDevicesToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessDevicesToRemove() {
        return wirelessDevicesToRemove != null && !(wirelessDevicesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WirelessDevices to remove from NetworkAnalyzerConfiguration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDevicesToRemove} method.
     * </p>
     * 
     * @return WirelessDevices to remove from NetworkAnalyzerConfiguration.
     */
    public final List<String> wirelessDevicesToRemove() {
        return wirelessDevicesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessGatewaysToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessGatewaysToAdd() {
        return wirelessGatewaysToAdd != null && !(wirelessGatewaysToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WirelessGateways to add into NetworkAnalyzerConfiguration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessGatewaysToAdd} method.
     * </p>
     * 
     * @return WirelessGateways to add into NetworkAnalyzerConfiguration.
     */
    public final List<String> wirelessGatewaysToAdd() {
        return wirelessGatewaysToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessGatewaysToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessGatewaysToRemove() {
        return wirelessGatewaysToRemove != null && !(wirelessGatewaysToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WirelessGateways to remove from NetworkAnalyzerConfiguration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessGatewaysToRemove} method.
     * </p>
     * 
     * @return WirelessGateways to remove from NetworkAnalyzerConfiguration.
     */
    public final List<String> wirelessGatewaysToRemove() {
        return wirelessGatewaysToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDevicesToAdd() ? wirelessDevicesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDevicesToRemove() ? wirelessDevicesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGatewaysToAdd() ? wirelessGatewaysToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGatewaysToRemove() ? wirelessGatewaysToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkAnalyzerConfigurationRequest)) {
            return false;
        }
        UpdateNetworkAnalyzerConfigurationRequest other = (UpdateNetworkAnalyzerConfigurationRequest) obj;
        return Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(traceContent(), other.traceContent())
                && hasWirelessDevicesToAdd() == other.hasWirelessDevicesToAdd()
                && Objects.equals(wirelessDevicesToAdd(), other.wirelessDevicesToAdd())
                && hasWirelessDevicesToRemove() == other.hasWirelessDevicesToRemove()
                && Objects.equals(wirelessDevicesToRemove(), other.wirelessDevicesToRemove())
                && hasWirelessGatewaysToAdd() == other.hasWirelessGatewaysToAdd()
                && Objects.equals(wirelessGatewaysToAdd(), other.wirelessGatewaysToAdd())
                && hasWirelessGatewaysToRemove() == other.hasWirelessGatewaysToRemove()
                && Objects.equals(wirelessGatewaysToRemove(), other.wirelessGatewaysToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNetworkAnalyzerConfigurationRequest").add("ConfigurationName", configurationName())
                .add("TraceContent", traceContent())
                .add("WirelessDevicesToAdd", hasWirelessDevicesToAdd() ? wirelessDevicesToAdd() : null)
                .add("WirelessDevicesToRemove", hasWirelessDevicesToRemove() ? wirelessDevicesToRemove() : null)
                .add("WirelessGatewaysToAdd", hasWirelessGatewaysToAdd() ? wirelessGatewaysToAdd() : null)
                .add("WirelessGatewaysToRemove", hasWirelessGatewaysToRemove() ? wirelessGatewaysToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "TraceContent":
            return Optional.ofNullable(clazz.cast(traceContent()));
        case "WirelessDevicesToAdd":
            return Optional.ofNullable(clazz.cast(wirelessDevicesToAdd()));
        case "WirelessDevicesToRemove":
            return Optional.ofNullable(clazz.cast(wirelessDevicesToRemove()));
        case "WirelessGatewaysToAdd":
            return Optional.ofNullable(clazz.cast(wirelessGatewaysToAdd()));
        case "WirelessGatewaysToRemove":
            return Optional.ofNullable(clazz.cast(wirelessGatewaysToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkAnalyzerConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateNetworkAnalyzerConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateNetworkAnalyzerConfigurationRequest> {
        /**
         * Sets the value of the ConfigurationName property for this object.
         *
         * @param configurationName
         *        The new value for the ConfigurationName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * Sets the value of the TraceContent property for this object.
         *
         * @param traceContent
         *        The new value for the TraceContent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceContent(TraceContent traceContent);

        /**
         * Sets the value of the TraceContent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TraceContent.Builder} avoiding the need
         * to create one manually via {@link TraceContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link TraceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #traceContent(TraceContent)}.
         * 
         * @param traceContent
         *        a consumer that will call methods on {@link TraceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceContent(TraceContent)
         */
        default Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return traceContent(TraceContent.builder().applyMutation(traceContent).build());
        }

        /**
         * <p>
         * WirelessDevices to add into NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessDevicesToAdd
         *        WirelessDevices to add into NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevicesToAdd(Collection<String> wirelessDevicesToAdd);

        /**
         * <p>
         * WirelessDevices to add into NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessDevicesToAdd
         *        WirelessDevices to add into NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevicesToAdd(String... wirelessDevicesToAdd);

        /**
         * <p>
         * WirelessDevices to remove from NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessDevicesToRemove
         *        WirelessDevices to remove from NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevicesToRemove(Collection<String> wirelessDevicesToRemove);

        /**
         * <p>
         * WirelessDevices to remove from NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessDevicesToRemove
         *        WirelessDevices to remove from NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevicesToRemove(String... wirelessDevicesToRemove);

        /**
         * <p>
         * WirelessGateways to add into NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessGatewaysToAdd
         *        WirelessGateways to add into NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewaysToAdd(Collection<String> wirelessGatewaysToAdd);

        /**
         * <p>
         * WirelessGateways to add into NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessGatewaysToAdd
         *        WirelessGateways to add into NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewaysToAdd(String... wirelessGatewaysToAdd);

        /**
         * <p>
         * WirelessGateways to remove from NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessGatewaysToRemove
         *        WirelessGateways to remove from NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewaysToRemove(Collection<String> wirelessGatewaysToRemove);

        /**
         * <p>
         * WirelessGateways to remove from NetworkAnalyzerConfiguration.
         * </p>
         * 
         * @param wirelessGatewaysToRemove
         *        WirelessGateways to remove from NetworkAnalyzerConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewaysToRemove(String... wirelessGatewaysToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String configurationName;

        private TraceContent traceContent;

        private List<String> wirelessDevicesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> wirelessDevicesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> wirelessGatewaysToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> wirelessGatewaysToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkAnalyzerConfigurationRequest model) {
            super(model);
            configurationName(model.configurationName);
            traceContent(model.traceContent);
            wirelessDevicesToAdd(model.wirelessDevicesToAdd);
            wirelessDevicesToRemove(model.wirelessDevicesToRemove);
            wirelessGatewaysToAdd(model.wirelessGatewaysToAdd);
            wirelessGatewaysToRemove(model.wirelessGatewaysToRemove);
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final TraceContent.Builder getTraceContent() {
            return traceContent != null ? traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevicesToAdd() {
            if (wirelessDevicesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessDevicesToAdd;
        }

        public final void setWirelessDevicesToAdd(Collection<String> wirelessDevicesToAdd) {
            this.wirelessDevicesToAdd = WirelessDeviceListCopier.copy(wirelessDevicesToAdd);
        }

        @Override
        public final Builder wirelessDevicesToAdd(Collection<String> wirelessDevicesToAdd) {
            this.wirelessDevicesToAdd = WirelessDeviceListCopier.copy(wirelessDevicesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevicesToAdd(String... wirelessDevicesToAdd) {
            wirelessDevicesToAdd(Arrays.asList(wirelessDevicesToAdd));
            return this;
        }

        public final Collection<String> getWirelessDevicesToRemove() {
            if (wirelessDevicesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessDevicesToRemove;
        }

        public final void setWirelessDevicesToRemove(Collection<String> wirelessDevicesToRemove) {
            this.wirelessDevicesToRemove = WirelessDeviceListCopier.copy(wirelessDevicesToRemove);
        }

        @Override
        public final Builder wirelessDevicesToRemove(Collection<String> wirelessDevicesToRemove) {
            this.wirelessDevicesToRemove = WirelessDeviceListCopier.copy(wirelessDevicesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevicesToRemove(String... wirelessDevicesToRemove) {
            wirelessDevicesToRemove(Arrays.asList(wirelessDevicesToRemove));
            return this;
        }

        public final Collection<String> getWirelessGatewaysToAdd() {
            if (wirelessGatewaysToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessGatewaysToAdd;
        }

        public final void setWirelessGatewaysToAdd(Collection<String> wirelessGatewaysToAdd) {
            this.wirelessGatewaysToAdd = WirelessGatewayListCopier.copy(wirelessGatewaysToAdd);
        }

        @Override
        public final Builder wirelessGatewaysToAdd(Collection<String> wirelessGatewaysToAdd) {
            this.wirelessGatewaysToAdd = WirelessGatewayListCopier.copy(wirelessGatewaysToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewaysToAdd(String... wirelessGatewaysToAdd) {
            wirelessGatewaysToAdd(Arrays.asList(wirelessGatewaysToAdd));
            return this;
        }

        public final Collection<String> getWirelessGatewaysToRemove() {
            if (wirelessGatewaysToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessGatewaysToRemove;
        }

        public final void setWirelessGatewaysToRemove(Collection<String> wirelessGatewaysToRemove) {
            this.wirelessGatewaysToRemove = WirelessGatewayListCopier.copy(wirelessGatewaysToRemove);
        }

        @Override
        public final Builder wirelessGatewaysToRemove(Collection<String> wirelessGatewaysToRemove) {
            this.wirelessGatewaysToRemove = WirelessGatewayListCopier.copy(wirelessGatewaysToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewaysToRemove(String... wirelessGatewaysToRemove) {
            wirelessGatewaysToRemove(Arrays.asList(wirelessGatewaysToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkAnalyzerConfigurationRequest build() {
            return new UpdateNetworkAnalyzerConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
