/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Join event configuration object for enabling or disabling topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinEventConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JoinEventConfiguration.Builder, JoinEventConfiguration> {
    private static final SdkField<LoRaWANJoinEventNotificationConfigurations> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANJoinEventNotificationConfigurations> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(JoinEventConfiguration::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANJoinEventNotificationConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceIdEventTopic")
            .getter(getter(JoinEventConfiguration::wirelessDeviceIdEventTopicAsString))
            .setter(setter(Builder::wirelessDeviceIdEventTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceIdEventTopic").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD,
            WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final LoRaWANJoinEventNotificationConfigurations loRaWAN;

    private final String wirelessDeviceIdEventTopic;

    private JoinEventConfiguration(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
        this.wirelessDeviceIdEventTopic = builder.wirelessDeviceIdEventTopic;
    }

    /**
     * <p>
     * Join event configuration object for enabling or disabling LoRaWAN related event topics.
     * </p>
     * 
     * @return Join event configuration object for enabling or disabling LoRaWAN related event topics.
     */
    public final LoRaWANJoinEventNotificationConfigurations loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * Enum to denote whether the wireless device id join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessDeviceIdEventTopicAsString}.
     * </p>
     * 
     * @return Enum to denote whether the wireless device id join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final EventNotificationTopicStatus wirelessDeviceIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(wirelessDeviceIdEventTopic);
    }

    /**
     * <p>
     * Enum to denote whether the wireless device id join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessDeviceIdEventTopicAsString}.
     * </p>
     * 
     * @return Enum to denote whether the wireless device id join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final String wirelessDeviceIdEventTopicAsString() {
        return wirelessDeviceIdEventTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceIdEventTopicAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinEventConfiguration)) {
            return false;
        }
        JoinEventConfiguration other = (JoinEventConfiguration) obj;
        return Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(wirelessDeviceIdEventTopicAsString(), other.wirelessDeviceIdEventTopicAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinEventConfiguration").add("LoRaWAN", loRaWAN())
                .add("WirelessDeviceIdEventTopic", wirelessDeviceIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "WirelessDeviceIdEventTopic":
            return Optional.ofNullable(clazz.cast(wirelessDeviceIdEventTopicAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinEventConfiguration, T> g) {
        return obj -> g.apply((JoinEventConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JoinEventConfiguration> {
        /**
         * <p>
         * Join event configuration object for enabling or disabling LoRaWAN related event topics.
         * </p>
         * 
         * @param loRaWAN
         *        Join event configuration object for enabling or disabling LoRaWAN related event topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANJoinEventNotificationConfigurations loRaWAN);

        /**
         * <p>
         * Join event configuration object for enabling or disabling LoRaWAN related event topics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LoRaWANJoinEventNotificationConfigurations.Builder} avoiding the need to create one manually via
         * {@link LoRaWANJoinEventNotificationConfigurations#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANJoinEventNotificationConfigurations.Builder#build()} is
         * called immediately and its result is passed to {@link #loRaWAN(LoRaWANJoinEventNotificationConfigurations)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANJoinEventNotificationConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANJoinEventNotificationConfigurations)
         */
        default Builder loRaWAN(Consumer<LoRaWANJoinEventNotificationConfigurations.Builder> loRaWAN) {
            return loRaWAN(LoRaWANJoinEventNotificationConfigurations.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * Enum to denote whether the wireless device id join event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessDeviceIdEventTopic
         *        Enum to denote whether the wireless device id join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic);

        /**
         * <p>
         * Enum to denote whether the wireless device id join event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessDeviceIdEventTopic
         *        Enum to denote whether the wireless device id join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus wirelessDeviceIdEventTopic);
    }

    static final class BuilderImpl implements Builder {
        private LoRaWANJoinEventNotificationConfigurations loRaWAN;

        private String wirelessDeviceIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinEventConfiguration model) {
            loRaWAN(model.loRaWAN);
            wirelessDeviceIdEventTopic(model.wirelessDeviceIdEventTopic);
        }

        public final LoRaWANJoinEventNotificationConfigurations.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANJoinEventNotificationConfigurations.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANJoinEventNotificationConfigurations loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getWirelessDeviceIdEventTopic() {
            return wirelessDeviceIdEventTopic;
        }

        public final void setWirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic(wirelessDeviceIdEventTopic == null ? null : wirelessDeviceIdEventTopic.toString());
            return this;
        }

        @Override
        public JoinEventConfiguration build() {
            return new JoinEventConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
