/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Wireless metadata that is to be sent to multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MulticastWirelessMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<MulticastWirelessMetadata.Builder, MulticastWirelessMetadata> {
    private static final SdkField<LoRaWANMulticastMetadata> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANMulticastMetadata> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(MulticastWirelessMetadata::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANMulticastMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final LoRaWANMulticastMetadata loRaWAN;

    private MulticastWirelessMetadata(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * Returns the value of the LoRaWAN property for this object.
     * 
     * @return The value of the LoRaWAN property for this object.
     */
    public final LoRaWANMulticastMetadata loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastWirelessMetadata)) {
            return false;
        }
        MulticastWirelessMetadata other = (MulticastWirelessMetadata) obj;
        return Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MulticastWirelessMetadata").add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MulticastWirelessMetadata, T> g) {
        return obj -> g.apply((MulticastWirelessMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MulticastWirelessMetadata> {
        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * @param loRaWAN
         *        The new value for the LoRaWAN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANMulticastMetadata loRaWAN);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoRaWANMulticastMetadata.Builder}
         * avoiding the need to create one manually via {@link LoRaWANMulticastMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANMulticastMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #loRaWAN(LoRaWANMulticastMetadata)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANMulticastMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANMulticastMetadata)
         */
        default Builder loRaWAN(Consumer<LoRaWANMulticastMetadata.Builder> loRaWAN) {
            return loRaWAN(LoRaWANMulticastMetadata.builder().applyMutation(loRaWAN).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LoRaWANMulticastMetadata loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastWirelessMetadata model) {
            loRaWAN(model.loRaWAN);
        }

        public final LoRaWANMulticastMetadata.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANMulticastMetadata.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANMulticastMetadata loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        @Override
        public MulticastWirelessMetadata build() {
            return new MulticastWirelessMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
