/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.JoinEuiFiltersCopier;
import software.amazon.awssdk.services.iotwireless.model.NetIdFiltersCopier;
import software.amazon.awssdk.services.iotwireless.model.SubBandsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANGateway> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayEui").getter(LoRaWANGateway.getter(LoRaWANGateway::gatewayEui)).setter(LoRaWANGateway.setter(Builder::gatewayEui)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()}).build();
    private static final SdkField<String> RF_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RfRegion").getter(LoRaWANGateway.getter(LoRaWANGateway::rfRegion)).setter(LoRaWANGateway.setter(Builder::rfRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()}).build();
    private static final SdkField<List<List<String>>> JOIN_EUI_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JoinEuiFilters").getter(LoRaWANGateway.getter(LoRaWANGateway::joinEuiFilters)).setter(LoRaWANGateway.setter(Builder::joinEuiFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEuiFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> NET_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetIdFilters").getter(LoRaWANGateway.getter(LoRaWANGateway::netIdFilters)).setter(LoRaWANGateway.setter(Builder::netIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> SUB_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubBands").getter(LoRaWANGateway.getter(LoRaWANGateway::subBands)).setter(LoRaWANGateway.setter(Builder::subBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD, RF_REGION_FIELD, JOIN_EUI_FILTERS_FIELD, NET_ID_FILTERS_FIELD, SUB_BANDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayEui;
    private final String rfRegion;
    private final List<List<String>> joinEuiFilters;
    private final List<String> netIdFilters;
    private final List<Integer> subBands;

    private LoRaWANGateway(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.rfRegion = builder.rfRegion;
        this.joinEuiFilters = builder.joinEuiFilters;
        this.netIdFilters = builder.netIdFilters;
        this.subBands = builder.subBands;
    }

    public final String gatewayEui() {
        return this.gatewayEui;
    }

    public final String rfRegion() {
        return this.rfRegion;
    }

    public final boolean hasJoinEuiFilters() {
        return this.joinEuiFilters != null && !(this.joinEuiFilters instanceof SdkAutoConstructList);
    }

    public final List<List<String>> joinEuiFilters() {
        return this.joinEuiFilters;
    }

    public final boolean hasNetIdFilters() {
        return this.netIdFilters != null && !(this.netIdFilters instanceof SdkAutoConstructList);
    }

    public final List<String> netIdFilters() {
        return this.netIdFilters;
    }

    public final boolean hasSubBands() {
        return this.subBands != null && !(this.subBands instanceof SdkAutoConstructList);
    }

    public final List<Integer> subBands() {
        return this.subBands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(this.rfRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinEuiFilters() ? this.joinEuiFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetIdFilters() ? this.netIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubBands() ? this.subBands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGateway)) {
            return false;
        }
        LoRaWANGateway other = (LoRaWANGateway)obj;
        return Objects.equals(this.gatewayEui(), other.gatewayEui()) && Objects.equals(this.rfRegion(), other.rfRegion()) && this.hasJoinEuiFilters() == other.hasJoinEuiFilters() && Objects.equals(this.joinEuiFilters(), other.joinEuiFilters()) && this.hasNetIdFilters() == other.hasNetIdFilters() && Objects.equals(this.netIdFilters(), other.netIdFilters()) && this.hasSubBands() == other.hasSubBands() && Objects.equals(this.subBands(), other.subBands());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANGateway").add("GatewayEui", (Object)this.gatewayEui()).add("RfRegion", (Object)this.rfRegion()).add("JoinEuiFilters", this.hasJoinEuiFilters() ? this.joinEuiFilters() : null).add("NetIdFilters", this.hasNetIdFilters() ? this.netIdFilters() : null).add("SubBands", this.hasSubBands() ? this.subBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayEui": {
                return Optional.ofNullable(clazz.cast(this.gatewayEui()));
            }
            case "RfRegion": {
                return Optional.ofNullable(clazz.cast(this.rfRegion()));
            }
            case "JoinEuiFilters": {
                return Optional.ofNullable(clazz.cast(this.joinEuiFilters()));
            }
            case "NetIdFilters": {
                return Optional.ofNullable(clazz.cast(this.netIdFilters()));
            }
            case "SubBands": {
                return Optional.ofNullable(clazz.cast(this.subBands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGateway, T> g) {
        return obj -> g.apply((LoRaWANGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayEui;
        private String rfRegion;
        private List<List<String>> joinEuiFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> netIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> subBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGateway model) {
            this.gatewayEui(model.gatewayEui);
            this.rfRegion(model.rfRegion);
            this.joinEuiFilters(model.joinEuiFilters);
            this.netIdFilters(model.netIdFilters);
            this.subBands(model.subBands);
        }

        public final String getGatewayEui() {
            return this.gatewayEui;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final String getRfRegion() {
            return this.rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final Collection<? extends Collection<String>> getJoinEuiFilters() {
            if (this.joinEuiFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinEuiFilters;
        }

        public final void setJoinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
        }

        @Override
        public final Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinEuiFilters(Collection<String> ... joinEuiFilters) {
            this.joinEuiFilters((Collection<? extends Collection<String>>)Arrays.asList(joinEuiFilters));
            return this;
        }

        public final Collection<String> getNetIdFilters() {
            if (this.netIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.netIdFilters;
        }

        public final void setNetIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
        }

        @Override
        public final Builder netIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netIdFilters(String ... netIdFilters) {
            this.netIdFilters(Arrays.asList(netIdFilters));
            return this;
        }

        public final Collection<Integer> getSubBands() {
            if (this.subBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subBands;
        }

        public final void setSubBands(Collection<Integer> subBands) {
            this.subBands = SubBandsCopier.copy(subBands);
        }

        @Override
        public final Builder subBands(Collection<Integer> subBands) {
            this.subBands = SubBandsCopier.copy(subBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBands(Integer ... subBands) {
            this.subBands(Arrays.asList(subBands));
            return this;
        }

        public LoRaWANGateway build() {
            return new LoRaWANGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANGateway> {
        public Builder gatewayEui(String var1);

        public Builder rfRegion(String var1);

        public Builder joinEuiFilters(Collection<? extends Collection<String>> var1);

        public Builder joinEuiFilters(Collection<String> ... var1);

        public Builder netIdFilters(Collection<String> var1);

        public Builder netIdFilters(String ... var1);

        public Builder subBands(Collection<Integer> var1);

        public Builder subBands(Integer ... var1);
    }
}

