/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for LoRaWAN join resource type event configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANJoinResourceTypeEventConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANJoinResourceTypeEventConfiguration.Builder, LoRaWANJoinResourceTypeEventConfiguration> {
    private static final SdkField<String> WIRELESS_DEVICE_EVENT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceEventTopic")
            .getter(getter(LoRaWANJoinResourceTypeEventConfiguration::wirelessDeviceEventTopicAsString))
            .setter(setter(Builder::wirelessDeviceEventTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceEventTopic").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WIRELESS_DEVICE_EVENT_TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String wirelessDeviceEventTopic;

    private LoRaWANJoinResourceTypeEventConfiguration(BuilderImpl builder) {
        this.wirelessDeviceEventTopic = builder.wirelessDeviceEventTopic;
    }

    /**
     * <p>
     * Enum to denote whether the wireless device join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessDeviceEventTopicAsString}.
     * </p>
     * 
     * @return Enum to denote whether the wireless device join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final EventNotificationTopicStatus wirelessDeviceEventTopic() {
        return EventNotificationTopicStatus.fromValue(wirelessDeviceEventTopic);
    }

    /**
     * <p>
     * Enum to denote whether the wireless device join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessDeviceEventTopicAsString}.
     * </p>
     * 
     * @return Enum to denote whether the wireless device join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final String wirelessDeviceEventTopicAsString() {
        return wirelessDeviceEventTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceEventTopicAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANJoinResourceTypeEventConfiguration)) {
            return false;
        }
        LoRaWANJoinResourceTypeEventConfiguration other = (LoRaWANJoinResourceTypeEventConfiguration) obj;
        return Objects.equals(wirelessDeviceEventTopicAsString(), other.wirelessDeviceEventTopicAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANJoinResourceTypeEventConfiguration")
                .add("WirelessDeviceEventTopic", wirelessDeviceEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessDeviceEventTopic":
            return Optional.ofNullable(clazz.cast(wirelessDeviceEventTopicAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANJoinResourceTypeEventConfiguration, T> g) {
        return obj -> g.apply((LoRaWANJoinResourceTypeEventConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANJoinResourceTypeEventConfiguration> {
        /**
         * <p>
         * Enum to denote whether the wireless device join event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessDeviceEventTopic
         *        Enum to denote whether the wireless device join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessDeviceEventTopic(String wirelessDeviceEventTopic);

        /**
         * <p>
         * Enum to denote whether the wireless device join event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessDeviceEventTopic
         *        Enum to denote whether the wireless device join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessDeviceEventTopic(EventNotificationTopicStatus wirelessDeviceEventTopic);
    }

    static final class BuilderImpl implements Builder {
        private String wirelessDeviceEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANJoinResourceTypeEventConfiguration model) {
            wirelessDeviceEventTopic(model.wirelessDeviceEventTopic);
        }

        public final String getWirelessDeviceEventTopic() {
            return wirelessDeviceEventTopic;
        }

        public final void setWirelessDeviceEventTopic(String wirelessDeviceEventTopic) {
            this.wirelessDeviceEventTopic = wirelessDeviceEventTopic;
        }

        @Override
        public final Builder wirelessDeviceEventTopic(String wirelessDeviceEventTopic) {
            this.wirelessDeviceEventTopic = wirelessDeviceEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessDeviceEventTopic(EventNotificationTopicStatus wirelessDeviceEventTopic) {
            this.wirelessDeviceEventTopic(wirelessDeviceEventTopic == null ? null : wirelessDeviceEventTopic.toString());
            return this;
        }

        @Override
        public LoRaWANJoinResourceTypeEventConfiguration build() {
            return new LoRaWANJoinResourceTypeEventConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
