/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sidewalk object used by list functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkListDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkListDevice.Builder, SidewalkListDevice> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonId").getter(getter(SidewalkListDevice::amazonId)).setter(setter(Builder::amazonId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()).build();

    private static final SdkField<String> SIDEWALK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkId").getter(getter(SidewalkListDevice::sidewalkId)).setter(setter(Builder::sidewalkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkId").build()).build();

    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkManufacturingSn").getter(getter(SidewalkListDevice::sidewalkManufacturingSn))
            .setter(setter(Builder::sidewalkManufacturingSn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build())
            .build();

    private static final SdkField<List<CertificateList>> DEVICE_CERTIFICATES_FIELD = SdkField
            .<List<CertificateList>> builder(MarshallingType.LIST)
            .memberName("DeviceCertificates")
            .getter(getter(SidewalkListDevice::deviceCertificates))
            .setter(setter(Builder::deviceCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateList> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD,
            SIDEWALK_ID_FIELD, SIDEWALK_MANUFACTURING_SN_FIELD, DEVICE_CERTIFICATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amazonId;

    private final String sidewalkId;

    private final String sidewalkManufacturingSn;

    private final List<CertificateList> deviceCertificates;

    private SidewalkListDevice(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.sidewalkId = builder.sidewalkId;
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.deviceCertificates = builder.deviceCertificates;
    }

    /**
     * <p>
     * The Sidewalk Amazon ID.
     * </p>
     * 
     * @return The Sidewalk Amazon ID.
     */
    public final String amazonId() {
        return amazonId;
    }

    /**
     * <p>
     * The sidewalk device identification.
     * </p>
     * 
     * @return The sidewalk device identification.
     */
    public final String sidewalkId() {
        return sidewalkId;
    }

    /**
     * <p>
     * The Sidewalk manufacturing series number.
     * </p>
     * 
     * @return The Sidewalk manufacturing series number.
     */
    public final String sidewalkManufacturingSn() {
        return sidewalkManufacturingSn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceCertificates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceCertificates() {
        return deviceCertificates != null && !(deviceCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sidewalk device certificates for Ed25519 and P256r1.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceCertificates} method.
     * </p>
     * 
     * @return The sidewalk device certificates for Ed25519 and P256r1.
     */
    public final List<CertificateList> deviceCertificates() {
        return deviceCertificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkId());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceCertificates() ? deviceCertificates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkListDevice)) {
            return false;
        }
        SidewalkListDevice other = (SidewalkListDevice) obj;
        return Objects.equals(amazonId(), other.amazonId()) && Objects.equals(sidewalkId(), other.sidewalkId())
                && Objects.equals(sidewalkManufacturingSn(), other.sidewalkManufacturingSn())
                && hasDeviceCertificates() == other.hasDeviceCertificates()
                && Objects.equals(deviceCertificates(), other.deviceCertificates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkListDevice").add("AmazonId", amazonId()).add("SidewalkId", sidewalkId())
                .add("SidewalkManufacturingSn", sidewalkManufacturingSn())
                .add("DeviceCertificates", hasDeviceCertificates() ? deviceCertificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonId":
            return Optional.ofNullable(clazz.cast(amazonId()));
        case "SidewalkId":
            return Optional.ofNullable(clazz.cast(sidewalkId()));
        case "SidewalkManufacturingSn":
            return Optional.ofNullable(clazz.cast(sidewalkManufacturingSn()));
        case "DeviceCertificates":
            return Optional.ofNullable(clazz.cast(deviceCertificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkListDevice, T> g) {
        return obj -> g.apply((SidewalkListDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkListDevice> {
        /**
         * <p>
         * The Sidewalk Amazon ID.
         * </p>
         * 
         * @param amazonId
         *        The Sidewalk Amazon ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonId(String amazonId);

        /**
         * <p>
         * The sidewalk device identification.
         * </p>
         * 
         * @param sidewalkId
         *        The sidewalk device identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkId(String sidewalkId);

        /**
         * <p>
         * The Sidewalk manufacturing series number.
         * </p>
         * 
         * @param sidewalkManufacturingSn
         *        The Sidewalk manufacturing series number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkManufacturingSn(String sidewalkManufacturingSn);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * 
         * @param deviceCertificates
         *        The sidewalk device certificates for Ed25519 and P256r1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificates(Collection<CertificateList> deviceCertificates);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * 
         * @param deviceCertificates
         *        The sidewalk device certificates for Ed25519 and P256r1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificates(CertificateList... deviceCertificates);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CertificateList>.Builder} avoiding
         * the need to create one manually via {@link List<CertificateList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CertificateList>.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceCertificates(List<CertificateList>)}.
         * 
         * @param deviceCertificates
         *        a consumer that will call methods on {@link List<CertificateList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceCertificates(List<CertificateList>)
         */
        Builder deviceCertificates(Consumer<CertificateList.Builder>... deviceCertificates);
    }

    static final class BuilderImpl implements Builder {
        private String amazonId;

        private String sidewalkId;

        private String sidewalkManufacturingSn;

        private List<CertificateList> deviceCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkListDevice model) {
            amazonId(model.amazonId);
            sidewalkId(model.sidewalkId);
            sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            deviceCertificates(model.deviceCertificates);
        }

        public final String getAmazonId() {
            return amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getSidewalkId() {
            return sidewalkId;
        }

        public final void setSidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
        }

        @Override
        public final Builder sidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
            return this;
        }

        public final String getSidewalkManufacturingSn() {
            return sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final List<CertificateList.Builder> getDeviceCertificates() {
            List<CertificateList.Builder> result = DeviceCertificateListCopier.copyToBuilder(this.deviceCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCertificates(Collection<CertificateList.BuilderImpl> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copyFromBuilder(deviceCertificates);
        }

        @Override
        public final Builder deviceCertificates(Collection<CertificateList> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copy(deviceCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(CertificateList... deviceCertificates) {
            deviceCertificates(Arrays.asList(deviceCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(Consumer<CertificateList.Builder>... deviceCertificates) {
            deviceCertificates(Stream.of(deviceCertificates).map(c -> CertificateList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SidewalkListDevice build() {
            return new SidewalkListDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
