/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateWirelessGatewayTaskEntry object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWirelessGatewayTaskEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateWirelessGatewayTaskEntry.Builder, UpdateWirelessGatewayTaskEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateWirelessGatewayTaskEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<LoRaWANUpdateGatewayTaskEntry> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANUpdateGatewayTaskEntry> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(UpdateWirelessGatewayTaskEntry::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANUpdateGatewayTaskEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateWirelessGatewayTaskEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LO_RA_WAN_FIELD,
            ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final LoRaWANUpdateGatewayTaskEntry loRaWAN;

    private final String arn;

    private UpdateWirelessGatewayTaskEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.loRaWAN = builder.loRaWAN;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the new wireless gateway task entry.
     * </p>
     * 
     * @return The ID of the new wireless gateway task entry.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The properties that relate to the LoRaWAN wireless gateway.
     * </p>
     * 
     * @return The properties that relate to the LoRaWAN wireless gateway.
     */
    public final LoRaWANUpdateGatewayTaskEntry loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessGatewayTaskEntry)) {
            return false;
        }
        UpdateWirelessGatewayTaskEntry other = (UpdateWirelessGatewayTaskEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWirelessGatewayTaskEntry").add("Id", id()).add("LoRaWAN", loRaWAN()).add("Arn", arn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessGatewayTaskEntry, T> g) {
        return obj -> g.apply((UpdateWirelessGatewayTaskEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateWirelessGatewayTaskEntry> {
        /**
         * <p>
         * The ID of the new wireless gateway task entry.
         * </p>
         * 
         * @param id
         *        The ID of the new wireless gateway task entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The properties that relate to the LoRaWAN wireless gateway.
         * </p>
         * 
         * @param loRaWAN
         *        The properties that relate to the LoRaWAN wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANUpdateGatewayTaskEntry loRaWAN);

        /**
         * <p>
         * The properties that relate to the LoRaWAN wireless gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANUpdateGatewayTaskEntry.Builder}
         * avoiding the need to create one manually via {@link LoRaWANUpdateGatewayTaskEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANUpdateGatewayTaskEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #loRaWAN(LoRaWANUpdateGatewayTaskEntry)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANUpdateGatewayTaskEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANUpdateGatewayTaskEntry)
         */
        default Builder loRaWAN(Consumer<LoRaWANUpdateGatewayTaskEntry.Builder> loRaWAN) {
            return loRaWAN(LoRaWANUpdateGatewayTaskEntry.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private LoRaWANUpdateGatewayTaskEntry loRaWAN;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessGatewayTaskEntry model) {
            id(model.id);
            loRaWAN(model.loRaWAN);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final LoRaWANUpdateGatewayTaskEntry.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANUpdateGatewayTaskEntry.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANUpdateGatewayTaskEntry loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public UpdateWirelessGatewayTaskEntry build() {
            return new UpdateWirelessGatewayTaskEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
