/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * WirelessMetadata object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessMetadata.Builder, WirelessMetadata> {
    private static final SdkField<LoRaWANSendDataToDevice> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANSendDataToDevice> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(WirelessMetadata::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANSendDataToDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<SidewalkSendDataToDevice> SIDEWALK_FIELD = SdkField
            .<SidewalkSendDataToDevice> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(WirelessMetadata::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkSendDataToDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD,
            SIDEWALK_FIELD));

    private static final long serialVersionUID = 1L;

    private final LoRaWANSendDataToDevice loRaWAN;

    private final SidewalkSendDataToDevice sidewalk;

    private WirelessMetadata(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
    }

    /**
     * <p>
     * LoRaWAN device info.
     * </p>
     * 
     * @return LoRaWAN device info.
     */
    public final LoRaWANSendDataToDevice loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * The Sidewalk account credentials.
     * </p>
     * 
     * @return The Sidewalk account credentials.
     */
    public final SidewalkSendDataToDevice sidewalk() {
        return sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessMetadata)) {
            return false;
        }
        WirelessMetadata other = (WirelessMetadata) obj;
        return Objects.equals(loRaWAN(), other.loRaWAN()) && Objects.equals(sidewalk(), other.sidewalk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessMetadata").add("LoRaWAN", loRaWAN()).add("Sidewalk", sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WirelessMetadata, T> g) {
        return obj -> g.apply((WirelessMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessMetadata> {
        /**
         * <p>
         * LoRaWAN device info.
         * </p>
         * 
         * @param loRaWAN
         *        LoRaWAN device info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANSendDataToDevice loRaWAN);

        /**
         * <p>
         * LoRaWAN device info.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANSendDataToDevice.Builder} avoiding
         * the need to create one manually via {@link LoRaWANSendDataToDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANSendDataToDevice.Builder#build()} is called immediately
         * and its result is passed to {@link #loRaWAN(LoRaWANSendDataToDevice)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANSendDataToDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANSendDataToDevice)
         */
        default Builder loRaWAN(Consumer<LoRaWANSendDataToDevice.Builder> loRaWAN) {
            return loRaWAN(LoRaWANSendDataToDevice.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk account credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkSendDataToDevice sidewalk);

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkSendDataToDevice.Builder}
         * avoiding the need to create one manually via {@link SidewalkSendDataToDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link SidewalkSendDataToDevice.Builder#build()} is called immediately
         * and its result is passed to {@link #sidewalk(SidewalkSendDataToDevice)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkSendDataToDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkSendDataToDevice)
         */
        default Builder sidewalk(Consumer<SidewalkSendDataToDevice.Builder> sidewalk) {
            return sidewalk(SidewalkSendDataToDevice.builder().applyMutation(sidewalk).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LoRaWANSendDataToDevice loRaWAN;

        private SidewalkSendDataToDevice sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessMetadata model) {
            loRaWAN(model.loRaWAN);
            sidewalk(model.sidewalk);
        }

        public final LoRaWANSendDataToDevice.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANSendDataToDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANSendDataToDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkSendDataToDevice.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkSendDataToDevice.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkSendDataToDevice sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public WirelessMetadata build() {
            return new WirelessMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
