/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMulticastGroupsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListMulticastGroupsResponse.Builder, ListMulticastGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMulticastGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MulticastGroup>> MULTICAST_GROUP_LIST_FIELD = SdkField
            .<List<MulticastGroup>> builder(MarshallingType.LIST)
            .memberName("MulticastGroupList")
            .getter(getter(ListMulticastGroupsResponse::multicastGroupList))
            .setter(setter(Builder::multicastGroupList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroupList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MulticastGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MulticastGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MULTICAST_GROUP_LIST_FIELD));

    private final String nextToken;

    private final List<MulticastGroup> multicastGroupList;

    private ListMulticastGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multicastGroupList = builder.multicastGroupList;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MulticastGroupList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMulticastGroupList() {
        return multicastGroupList != null && !(multicastGroupList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the MulticastGroupList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMulticastGroupList} method.
     * </p>
     * 
     * @return The value of the MulticastGroupList property for this object.
     */
    public final List<MulticastGroup> multicastGroupList() {
        return multicastGroupList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMulticastGroupList() ? multicastGroupList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMulticastGroupsResponse)) {
            return false;
        }
        ListMulticastGroupsResponse other = (ListMulticastGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMulticastGroupList() == other.hasMulticastGroupList()
                && Objects.equals(multicastGroupList(), other.multicastGroupList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMulticastGroupsResponse").add("NextToken", nextToken())
                .add("MulticastGroupList", hasMulticastGroupList() ? multicastGroupList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MulticastGroupList":
            return Optional.ofNullable(clazz.cast(multicastGroupList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMulticastGroupsResponse, T> g) {
        return obj -> g.apply((ListMulticastGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMulticastGroupsResponse> {
        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MulticastGroupList property for this object.
         *
         * @param multicastGroupList
         *        The new value for the MulticastGroupList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroupList(Collection<MulticastGroup> multicastGroupList);

        /**
         * Sets the value of the MulticastGroupList property for this object.
         *
         * @param multicastGroupList
         *        The new value for the MulticastGroupList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroupList(MulticastGroup... multicastGroupList);

        /**
         * Sets the value of the MulticastGroupList property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<MulticastGroup>.Builder} avoiding
         * the need to create one manually via {@link List<MulticastGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MulticastGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #multicastGroupList(List<MulticastGroup>)}.
         * 
         * @param multicastGroupList
         *        a consumer that will call methods on {@link List<MulticastGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multicastGroupList(List<MulticastGroup>)
         */
        Builder multicastGroupList(Consumer<MulticastGroup.Builder>... multicastGroupList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MulticastGroup> multicastGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMulticastGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            multicastGroupList(model.multicastGroupList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MulticastGroup.Builder> getMulticastGroupList() {
            List<MulticastGroup.Builder> result = MulticastGroupListCopier.copyToBuilder(this.multicastGroupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMulticastGroupList(Collection<MulticastGroup.BuilderImpl> multicastGroupList) {
            this.multicastGroupList = MulticastGroupListCopier.copyFromBuilder(multicastGroupList);
        }

        @Override
        public final Builder multicastGroupList(Collection<MulticastGroup> multicastGroupList) {
            this.multicastGroupList = MulticastGroupListCopier.copy(multicastGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupList(MulticastGroup... multicastGroupList) {
            multicastGroupList(Arrays.asList(multicastGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupList(Consumer<MulticastGroup.Builder>... multicastGroupList) {
            multicastGroupList(Stream.of(multicastGroupList).map(c -> MulticastGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMulticastGroupsResponse build() {
            return new ListMulticastGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
