/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPositionConfigurationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetPositionConfigurationResponse.Builder, GetPositionConfigurationResponse> {
    private static final SdkField<PositionSolverDetails> SOLVERS_FIELD = SdkField
            .<PositionSolverDetails> builder(MarshallingType.SDK_POJO).memberName("Solvers")
            .getter(getter(GetPositionConfigurationResponse::solvers)).setter(setter(Builder::solvers))
            .constructor(PositionSolverDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solvers").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(GetPositionConfigurationResponse::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLVERS_FIELD,
            DESTINATION_FIELD));

    private final PositionSolverDetails solvers;

    private final String destination;

    private GetPositionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.solvers = builder.solvers;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The wrapper for the solver configuration details object.
     * </p>
     * 
     * @return The wrapper for the solver configuration details object.
     */
    public final PositionSolverDetails solvers() {
        return solvers;
    }

    /**
     * <p>
     * The position data destination that describes the AWS IoT rule that processes the device's position data for use
     * by AWS IoT Core for LoRaWAN.
     * </p>
     * 
     * @return The position data destination that describes the AWS IoT rule that processes the device's position data
     *         for use by AWS IoT Core for LoRaWAN.
     */
    public final String destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solvers());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionConfigurationResponse)) {
            return false;
        }
        GetPositionConfigurationResponse other = (GetPositionConfigurationResponse) obj;
        return Objects.equals(solvers(), other.solvers()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPositionConfigurationResponse").add("Solvers", solvers()).add("Destination", destination())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Solvers":
            return Optional.ofNullable(clazz.cast(solvers()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPositionConfigurationResponse, T> g) {
        return obj -> g.apply((GetPositionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPositionConfigurationResponse> {
        /**
         * <p>
         * The wrapper for the solver configuration details object.
         * </p>
         * 
         * @param solvers
         *        The wrapper for the solver configuration details object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solvers(PositionSolverDetails solvers);

        /**
         * <p>
         * The wrapper for the solver configuration details object.
         * </p>
         * This is a convenience method that creates an instance of the {@link PositionSolverDetails.Builder} avoiding
         * the need to create one manually via {@link PositionSolverDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PositionSolverDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #solvers(PositionSolverDetails)}.
         * 
         * @param solvers
         *        a consumer that will call methods on {@link PositionSolverDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solvers(PositionSolverDetails)
         */
        default Builder solvers(Consumer<PositionSolverDetails.Builder> solvers) {
            return solvers(PositionSolverDetails.builder().applyMutation(solvers).build());
        }

        /**
         * <p>
         * The position data destination that describes the AWS IoT rule that processes the device's position data for
         * use by AWS IoT Core for LoRaWAN.
         * </p>
         * 
         * @param destination
         *        The position data destination that describes the AWS IoT rule that processes the device's position
         *        data for use by AWS IoT Core for LoRaWAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private PositionSolverDetails solvers;

        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionConfigurationResponse model) {
            super(model);
            solvers(model.solvers);
            destination(model.destination);
        }

        public final PositionSolverDetails.Builder getSolvers() {
            return solvers != null ? solvers.toBuilder() : null;
        }

        public final void setSolvers(PositionSolverDetails.BuilderImpl solvers) {
            this.solvers = solvers != null ? solvers.build() : null;
        }

        @Override
        public final Builder solvers(PositionSolverDetails solvers) {
            this.solvers = solvers;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public GetPositionConfigurationResponse build() {
            return new GetPositionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
