/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Sidewalk account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkAccountInfoWithFingerprint implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkAccountInfoWithFingerprint.Builder, SidewalkAccountInfoWithFingerprint> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonId").getter(getter(SidewalkAccountInfoWithFingerprint::amazonId))
            .setter(setter(Builder::amazonId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()).build();

    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Fingerprint").getter(getter(SidewalkAccountInfoWithFingerprint::fingerprint))
            .setter(setter(Builder::fingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(SidewalkAccountInfoWithFingerprint::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD,
            FINGERPRINT_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amazonId;

    private final String fingerprint;

    private final String arn;

    private SidewalkAccountInfoWithFingerprint(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.fingerprint = builder.fingerprint;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The Sidewalk Amazon ID.
     * </p>
     * 
     * @return The Sidewalk Amazon ID.
     */
    public final String amazonId() {
        return amazonId;
    }

    /**
     * <p>
     * The fingerprint of the Sidewalk application server private key.
     * </p>
     * 
     * @return The fingerprint of the Sidewalk application server private key.
     */
    public final String fingerprint() {
        return fingerprint;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkAccountInfoWithFingerprint)) {
            return false;
        }
        SidewalkAccountInfoWithFingerprint other = (SidewalkAccountInfoWithFingerprint) obj;
        return Objects.equals(amazonId(), other.amazonId()) && Objects.equals(fingerprint(), other.fingerprint())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkAccountInfoWithFingerprint").add("AmazonId", amazonId())
                .add("Fingerprint", fingerprint() == null ? null : "*** Sensitive Data Redacted ***").add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonId":
            return Optional.ofNullable(clazz.cast(amazonId()));
        case "Fingerprint":
            return Optional.ofNullable(clazz.cast(fingerprint()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkAccountInfoWithFingerprint, T> g) {
        return obj -> g.apply((SidewalkAccountInfoWithFingerprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkAccountInfoWithFingerprint> {
        /**
         * <p>
         * The Sidewalk Amazon ID.
         * </p>
         * 
         * @param amazonId
         *        The Sidewalk Amazon ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonId(String amazonId);

        /**
         * <p>
         * The fingerprint of the Sidewalk application server private key.
         * </p>
         * 
         * @param fingerprint
         *        The fingerprint of the Sidewalk application server private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fingerprint(String fingerprint);

        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String amazonId;

        private String fingerprint;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkAccountInfoWithFingerprint model) {
            amazonId(model.amazonId);
            fingerprint(model.fingerprint);
            arn(model.arn);
        }

        public final String getAmazonId() {
            return amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        @Transient
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getFingerprint() {
            return fingerprint;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        @Transient
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public SidewalkAccountInfoWithFingerprint build() {
            return new SidewalkAccountInfoWithFingerprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
