/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotwireless.model.AccessDeniedException;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.ConflictException;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.InternalServerException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.ThrottlingException;
import software.amazon.awssdk.services.iotwireless.model.TooManyTagsException;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.ValidationException;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher;
import software.amazon.awssdk.services.iotwireless.transform.AssociateAwsAccountWithPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessDeviceWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateAwsAccountFromPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessDeviceFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetLogLevelsByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceEndpointRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayFirmwareInformationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDeviceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListPartnerAccountsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListServiceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessDevicesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewayTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewaysRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.PutResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ResetAllResourceLogLevelsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ResetResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.SendDataToWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TestWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateLogLevelsByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdatePartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IotWirelessAsyncClient}.
 *
 * @see IotWirelessAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotWirelessAsyncClient implements IotWirelessAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIotWirelessAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotWirelessAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateAwsAccountWithPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAwsAccountWithPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAwsAccountWithPartnerAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateAwsAccountWithPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse>()
                            .withOperationName("AssociateAwsAccountWithPartnerAccount")
                            .withMarshaller(new AssociateAwsAccountWithPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateAwsAccountWithPartnerAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateAwsAccountWithPartnerAccountRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessDeviceWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessDeviceWithThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessDeviceWithThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessDeviceWithThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessDeviceWithThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse>()
                            .withOperationName("AssociateWirelessDeviceWithThing")
                            .withMarshaller(new AssociateWirelessDeviceWithThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateWirelessDeviceWithThingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateWirelessDeviceWithThingRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociateWirelessDeviceWithThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessGatewayWithCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessGatewayWithCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse>()
                            .withOperationName("AssociateWirelessGatewayWithCertificate")
                            .withMarshaller(new AssociateWirelessGatewayWithCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessGatewayWithCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateWirelessGatewayWithCertificateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessGatewayWithThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessGatewayWithThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessGatewayWithThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse>()
                            .withOperationName("AssociateWirelessGatewayWithThing")
                            .withMarshaller(new AssociateWirelessGatewayWithThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateWirelessGatewayWithThingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateWirelessGatewayWithThingRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociateWirelessGatewayWithThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDestinationRequest, CreateDestinationResponse>()
                            .withOperationName("CreateDestination")
                            .withMarshaller(new CreateDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDestinationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDestinationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            CreateDeviceProfileRequest createDeviceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceProfileRequest, CreateDeviceProfileResponse>()
                            .withOperationName("CreateDeviceProfile")
                            .withMarshaller(new CreateDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeviceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDeviceProfileRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            CreateServiceProfileRequest createServiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateServiceProfileRequest, CreateServiceProfileResponse>()
                            .withOperationName("CreateServiceProfile")
                            .withMarshaller(new CreateServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createServiceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createServiceProfileRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            CreateWirelessDeviceRequest createWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse>()
                            .withOperationName("CreateWirelessDevice")
                            .withMarshaller(new CreateWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createWirelessDeviceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            CreateWirelessGatewayRequest createWirelessGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse>()
                            .withOperationName("CreateWirelessGateway")
                            .withMarshaller(new CreateWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWirelessGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createWirelessGatewayRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse>()
                            .withOperationName("CreateWirelessGatewayTask")
                            .withMarshaller(new CreateWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWirelessGatewayTaskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createWirelessGatewayTaskRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("CreateWirelessGatewayTaskDefinition")
                            .withMarshaller(new CreateWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWirelessGatewayTaskDefinitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createWirelessGatewayTaskDefinitionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDestinationRequest, DeleteDestinationResponse>()
                            .withOperationName("DeleteDestination")
                            .withMarshaller(new DeleteDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDestinationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDestinationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            DeleteDeviceProfileRequest deleteDeviceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse>()
                            .withOperationName("DeleteDeviceProfile")
                            .withMarshaller(new DeleteDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDeviceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDeviceProfileRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            DeleteServiceProfileRequest deleteServiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceProfileRequest, DeleteServiceProfileResponse>()
                            .withOperationName("DeleteServiceProfile")
                            .withMarshaller(new DeleteServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteServiceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteServiceProfileRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            DeleteWirelessDeviceRequest deleteWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse>()
                            .withOperationName("DeleteWirelessDevice")
                            .withMarshaller(new DeleteWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteWirelessDeviceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            DeleteWirelessGatewayRequest deleteWirelessGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse>()
                            .withOperationName("DeleteWirelessGateway")
                            .withMarshaller(new DeleteWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWirelessGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteWirelessGatewayRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse>()
                            .withOperationName("DeleteWirelessGatewayTask")
                            .withMarshaller(new DeleteWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWirelessGatewayTaskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteWirelessGatewayTaskRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("DeleteWirelessGatewayTaskDefinition")
                            .withMarshaller(new DeleteWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWirelessGatewayTaskDefinitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteWirelessGatewayTaskDefinitionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAwsAccountFromPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAwsAccountFromPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAwsAccountFromPartnerAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateAwsAccountFromPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse>()
                            .withOperationName("DisassociateAwsAccountFromPartnerAccount")
                            .withMarshaller(new DisassociateAwsAccountFromPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateAwsAccountFromPartnerAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateAwsAccountFromPartnerAccountRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessDeviceFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessDeviceFromThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessDeviceFromThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessDeviceFromThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessDeviceFromThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse>()
                            .withOperationName("DisassociateWirelessDeviceFromThing")
                            .withMarshaller(new DisassociateWirelessDeviceFromThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateWirelessDeviceFromThingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateWirelessDeviceFromThingRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateWirelessDeviceFromThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessGatewayFromCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromCertificate")
                            .withMarshaller(new DisassociateWirelessGatewayFromCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessGatewayFromCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateWirelessGatewayFromCertificateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessGatewayFromThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessGatewayFromThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromThing")
                            .withMarshaller(new DisassociateWirelessGatewayFromThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateWirelessGatewayFromThingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateWirelessGatewayFromThingRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateWirelessGatewayFromThingResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDestinationRequest, GetDestinationResponse>()
                            .withOperationName("GetDestination")
                            .withMarshaller(new GetDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDestinationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDestinationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceProfileRequest, GetDeviceProfileResponse>()
                            .withOperationName("GetDeviceProfile")
                            .withMarshaller(new GetDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDeviceProfileRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the GetLogLevelsByResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLogLevelsByResourceTypesResponse> getLogLevelsByResourceTypes(
            GetLogLevelsByResourceTypesRequest getLogLevelsByResourceTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogLevelsByResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogLevelsByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLogLevelsByResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLogLevelsByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLogLevelsByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLogLevelsByResourceTypesRequest, GetLogLevelsByResourceTypesResponse>()
                            .withOperationName("GetLogLevelsByResourceTypes")
                            .withMarshaller(new GetLogLevelsByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLogLevelsByResourceTypesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLogLevelsByResourceTypesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetLogLevelsByResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPartnerAccountRequest, GetPartnerAccountResponse>()
                            .withOperationName("GetPartnerAccount")
                            .withMarshaller(new GetPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPartnerAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPartnerAccountRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetPartnerAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     *
     * @param getResourceLogLevelRequest
     * @return A Java Future containing the result of the GetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceLogLevelResponse> getResourceLogLevel(
            GetResourceLogLevelRequest getResourceLogLevelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceLogLevelRequest, GetResourceLogLevelResponse>()
                            .withOperationName("GetResourceLogLevel")
                            .withMarshaller(new GetResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceLogLevelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getResourceLogLevelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceEndpointRequest, GetServiceEndpointResponse>()
                            .withOperationName("GetServiceEndpoint")
                            .withMarshaller(new GetServiceEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getServiceEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getServiceEndpointRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetServiceEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceProfileResponse> getServiceProfile(GetServiceProfileRequest getServiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceProfileRequest, GetServiceProfileResponse>()
                            .withOperationName("GetServiceProfile")
                            .withMarshaller(new GetServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getServiceProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getServiceProfileRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceRequest, GetWirelessDeviceResponse>()
                            .withOperationName("GetWirelessDevice")
                            .withMarshaller(new GetWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessDeviceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDeviceStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessDeviceStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessDeviceStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessDeviceStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse>()
                            .withOperationName("GetWirelessDeviceStatistics")
                            .withMarshaller(new GetWirelessDeviceStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessDeviceStatisticsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessDeviceStatisticsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetWirelessDeviceStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayRequest, GetWirelessGatewayResponse>()
                            .withOperationName("GetWirelessGateway")
                            .withMarshaller(new GetWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse>()
                            .withOperationName("GetWirelessGatewayCertificate")
                            .withMarshaller(new GetWirelessGatewayCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayCertificateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetWirelessGatewayCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayFirmwareInformationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayFirmwareInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayFirmwareInformationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetWirelessGatewayFirmwareInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse>()
                            .withOperationName("GetWirelessGatewayFirmwareInformation")
                            .withMarshaller(new GetWirelessGatewayFirmwareInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayFirmwareInformationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayFirmwareInformationRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse>()
                            .withOperationName("GetWirelessGatewayStatistics")
                            .withMarshaller(new GetWirelessGatewayStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayStatisticsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayStatisticsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetWirelessGatewayStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse>()
                            .withOperationName("GetWirelessGatewayTask")
                            .withMarshaller(new GetWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayTaskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayTaskRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("GetWirelessGatewayTaskDefinition")
                            .withMarshaller(new GetWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getWirelessGatewayTaskDefinitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWirelessGatewayTaskDefinitionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDestinationsRequest, ListDestinationsResponse>()
                            .withOperationName("ListDestinations")
                            .withMarshaller(new ListDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDestinationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDestinationsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListDestinationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    public ListDestinationsPublisher listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest) {
        return new ListDestinationsPublisher(this, applyPaginatorUserAgent(listDestinationsRequest));
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceProfilesRequest, ListDeviceProfilesResponse>()
                            .withOperationName("ListDeviceProfiles")
                            .withMarshaller(new ListDeviceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDeviceProfilesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDeviceProfilesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListDeviceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDeviceProfilesPublisher listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        return new ListDeviceProfilesPublisher(this, applyPaginatorUserAgent(listDeviceProfilesRequest));
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            ListPartnerAccountsRequest listPartnerAccountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPartnerAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPartnerAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPartnerAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPartnerAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPartnerAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPartnerAccountsRequest, ListPartnerAccountsResponse>()
                            .withOperationName("ListPartnerAccounts")
                            .withMarshaller(new ListPartnerAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPartnerAccountsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPartnerAccountsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListPartnerAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            ListServiceProfilesRequest listServiceProfilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServiceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListServiceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListServiceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListServiceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServiceProfilesRequest, ListServiceProfilesResponse>()
                            .withOperationName("ListServiceProfiles")
                            .withMarshaller(new ListServiceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listServiceProfilesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServiceProfilesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListServiceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    public ListServiceProfilesPublisher listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest) {
        return new ListServiceProfilesPublisher(this, applyPaginatorUserAgent(listServiceProfilesRequest));
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            ListWirelessDevicesRequest listWirelessDevicesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWirelessDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessDevicesRequest, ListWirelessDevicesResponse>()
                            .withOperationName("ListWirelessDevices")
                            .withMarshaller(new ListWirelessDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listWirelessDevicesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listWirelessDevicesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListWirelessDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    public ListWirelessDevicesPublisher listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest) {
        return new ListWirelessDevicesPublisher(this, applyPaginatorUserAgent(listWirelessDevicesRequest));
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listWirelessGatewayTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGatewayTaskDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessGatewayTaskDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListWirelessGatewayTaskDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse>()
                            .withOperationName("ListWirelessGatewayTaskDefinitions")
                            .withMarshaller(new ListWirelessGatewayTaskDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listWirelessGatewayTaskDefinitionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listWirelessGatewayTaskDefinitionsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWirelessGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse>()
                            .withOperationName("ListWirelessGateways")
                            .withMarshaller(new ListWirelessGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listWirelessGatewaysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listWirelessGatewaysRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListWirelessGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    public ListWirelessGatewaysPublisher listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        return new ListWirelessGatewaysPublisher(this, applyPaginatorUserAgent(listWirelessGatewaysRequest));
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     *
     * @param putResourceLogLevelRequest
     * @return A Java Future containing the result of the PutResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourceLogLevelResponse> putResourceLogLevel(
            PutResourceLogLevelRequest putResourceLogLevelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourceLogLevelRequest, PutResourceLogLevelResponse>()
                            .withOperationName("PutResourceLogLevel")
                            .withMarshaller(new PutResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putResourceLogLevelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putResourceLogLevelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     * @return A Java Future containing the result of the ResetAllResourceLogLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetAllResourceLogLevelsResponse> resetAllResourceLogLevels(
            ResetAllResourceLogLevelsRequest resetAllResourceLogLevelsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetAllResourceLogLevelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetAllResourceLogLevels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetAllResourceLogLevelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetAllResourceLogLevelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetAllResourceLogLevelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetAllResourceLogLevelsRequest, ResetAllResourceLogLevelsResponse>()
                            .withOperationName("ResetAllResourceLogLevels")
                            .withMarshaller(new ResetAllResourceLogLevelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetAllResourceLogLevelsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetAllResourceLogLevelsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ResetAllResourceLogLevelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     *
     * @param resetResourceLogLevelRequest
     * @return A Java Future containing the result of the ResetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetResourceLogLevelResponse> resetResourceLogLevel(
            ResetResourceLogLevelRequest resetResourceLogLevelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetResourceLogLevelRequest, ResetResourceLogLevelResponse>()
                            .withOperationName("ResetResourceLogLevel")
                            .withMarshaller(new ResetResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetResourceLogLevelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetResourceLogLevelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ResetResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendDataToWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendDataToWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendDataToWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendDataToWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendDataToWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse>()
                            .withOperationName("SendDataToWirelessDevice")
                            .withMarshaller(new SendDataToWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendDataToWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = sendDataToWirelessDeviceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<SendDataToWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestWirelessDeviceRequest, TestWirelessDeviceResponse>()
                            .withOperationName("TestWirelessDevice")
                            .withMarshaller(new TestWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(testWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testWirelessDeviceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<TestWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDestinationRequest, UpdateDestinationResponse>()
                            .withOperationName("UpdateDestination")
                            .withMarshaller(new UpdateDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDestinationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDestinationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the UpdateLogLevelsByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLogLevelsByResourceTypesResponse> updateLogLevelsByResourceTypes(
            UpdateLogLevelsByResourceTypesRequest updateLogLevelsByResourceTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateLogLevelsByResourceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLogLevelsByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLogLevelsByResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLogLevelsByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLogLevelsByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLogLevelsByResourceTypesRequest, UpdateLogLevelsByResourceTypesResponse>()
                            .withOperationName("UpdateLogLevelsByResourceTypes")
                            .withMarshaller(new UpdateLogLevelsByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLogLevelsByResourceTypesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateLogLevelsByResourceTypesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateLogLevelsByResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            UpdatePartnerAccountRequest updatePartnerAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse>()
                            .withOperationName("UpdatePartnerAccount")
                            .withMarshaller(new UpdatePartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePartnerAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePartnerAccountRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdatePartnerAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            UpdateWirelessDeviceRequest updateWirelessDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse>()
                            .withOperationName("UpdateWirelessDevice")
                            .withMarshaller(new UpdateWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateWirelessDeviceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateWirelessDeviceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            UpdateWirelessGatewayRequest updateWirelessGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse>()
                            .withOperationName("UpdateWirelessGateway")
                            .withMarshaller(new UpdateWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateWirelessGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateWirelessGatewayRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IotWirelessException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends IotWirelessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
