/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWirelessDevicesResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListWirelessDevicesResponse.Builder, ListWirelessDevicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWirelessDevicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<WirelessDeviceStatistics>> WIRELESS_DEVICE_LIST_FIELD = SdkField
            .<List<WirelessDeviceStatistics>> builder(MarshallingType.LIST)
            .memberName("WirelessDeviceList")
            .getter(getter(ListWirelessDevicesResponse::wirelessDeviceList))
            .setter(setter(Builder::wirelessDeviceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WirelessDeviceStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(WirelessDeviceStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WIRELESS_DEVICE_LIST_FIELD));

    private final String nextToken;

    private final List<WirelessDeviceStatistics> wirelessDeviceList;

    private ListWirelessDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.wirelessDeviceList = builder.wirelessDeviceList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDeviceList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessDeviceList() {
        return wirelessDeviceList != null && !(wirelessDeviceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the wireless device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDeviceList} method.
     * </p>
     * 
     * @return The ID of the wireless device.
     */
    public final List<WirelessDeviceStatistics> wirelessDeviceList() {
        return wirelessDeviceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDeviceList() ? wirelessDeviceList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDevicesResponse)) {
            return false;
        }
        ListWirelessDevicesResponse other = (ListWirelessDevicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWirelessDeviceList() == other.hasWirelessDeviceList()
                && Objects.equals(wirelessDeviceList(), other.wirelessDeviceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWirelessDevicesResponse").add("NextToken", nextToken())
                .add("WirelessDeviceList", hasWirelessDeviceList() ? wirelessDeviceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WirelessDeviceList":
            return Optional.ofNullable(clazz.cast(wirelessDeviceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDevicesResponse, T> g) {
        return obj -> g.apply((ListWirelessDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWirelessDevicesResponse> {
        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the wireless device.
         * </p>
         * 
         * @param wirelessDeviceList
         *        The ID of the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceList(Collection<WirelessDeviceStatistics> wirelessDeviceList);

        /**
         * <p>
         * The ID of the wireless device.
         * </p>
         * 
         * @param wirelessDeviceList
         *        The ID of the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceList(WirelessDeviceStatistics... wirelessDeviceList);

        /**
         * <p>
         * The ID of the wireless device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WirelessDeviceStatistics>.Builder} avoiding
         * the need to create one manually via {@link List<WirelessDeviceStatistics>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WirelessDeviceStatistics>.Builder#build()} is called
         * immediately and its result is passed to {@link #wirelessDeviceList(List<WirelessDeviceStatistics>)}.
         * 
         * @param wirelessDeviceList
         *        a consumer that will call methods on {@link List<WirelessDeviceStatistics>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessDeviceList(List<WirelessDeviceStatistics>)
         */
        Builder wirelessDeviceList(Consumer<WirelessDeviceStatistics.Builder>... wirelessDeviceList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WirelessDeviceStatistics> wirelessDeviceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDevicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            wirelessDeviceList(model.wirelessDeviceList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WirelessDeviceStatistics.Builder> getWirelessDeviceList() {
            List<WirelessDeviceStatistics.Builder> result = WirelessDeviceStatisticsListCopier
                    .copyToBuilder(this.wirelessDeviceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceList(Collection<WirelessDeviceStatistics.BuilderImpl> wirelessDeviceList) {
            this.wirelessDeviceList = WirelessDeviceStatisticsListCopier.copyFromBuilder(wirelessDeviceList);
        }

        @Override
        @Transient
        public final Builder wirelessDeviceList(Collection<WirelessDeviceStatistics> wirelessDeviceList) {
            this.wirelessDeviceList = WirelessDeviceStatisticsListCopier.copy(wirelessDeviceList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder wirelessDeviceList(WirelessDeviceStatistics... wirelessDeviceList) {
            wirelessDeviceList(Arrays.asList(wirelessDeviceList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder wirelessDeviceList(Consumer<WirelessDeviceStatistics.Builder>... wirelessDeviceList) {
            wirelessDeviceList(Stream.of(wirelessDeviceList)
                    .map(c -> WirelessDeviceStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWirelessDevicesResponse build() {
            return new ListWirelessDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
