/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANDeviceProfile object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANDeviceProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANDeviceProfile.Builder, LoRaWANDeviceProfile> {
    private static final SdkField<Boolean> SUPPORTS_CLASSB_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsClassB").getter(getter(LoRaWANDeviceProfile::supportsClassB))
            .setter(setter(Builder::supportsClassB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsClassB").build()).build();

    private static final SdkField<Integer> CLASS_B_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClassBTimeout").getter(getter(LoRaWANDeviceProfile::classBTimeout))
            .setter(setter(Builder::classBTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassBTimeout").build()).build();

    private static final SdkField<Integer> PING_SLOT_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PingSlotPeriod").getter(getter(LoRaWANDeviceProfile::pingSlotPeriod))
            .setter(setter(Builder::pingSlotPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotPeriod").build()).build();

    private static final SdkField<Integer> PING_SLOT_DR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PingSlotDr").getter(getter(LoRaWANDeviceProfile::pingSlotDr)).setter(setter(Builder::pingSlotDr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotDr").build()).build();

    private static final SdkField<Integer> PING_SLOT_FREQ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PingSlotFreq").getter(getter(LoRaWANDeviceProfile::pingSlotFreq)).setter(setter(Builder::pingSlotFreq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotFreq").build()).build();

    private static final SdkField<Boolean> SUPPORTS_CLASSC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsClassC").getter(getter(LoRaWANDeviceProfile::supportsClassC))
            .setter(setter(Builder::supportsClassC))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsClassC").build()).build();

    private static final SdkField<Integer> CLASS_C_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClassCTimeout").getter(getter(LoRaWANDeviceProfile::classCTimeout))
            .setter(setter(Builder::classCTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassCTimeout").build()).build();

    private static final SdkField<String> MAC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacVersion").getter(getter(LoRaWANDeviceProfile::macVersion)).setter(setter(Builder::macVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacVersion").build()).build();

    private static final SdkField<String> REG_PARAMS_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegParamsRevision").getter(getter(LoRaWANDeviceProfile::regParamsRevision))
            .setter(setter(Builder::regParamsRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegParamsRevision").build()).build();

    private static final SdkField<Integer> RX_DELAY1_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxDelay1").getter(getter(LoRaWANDeviceProfile::rxDelay1)).setter(setter(Builder::rxDelay1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDelay1").build()).build();

    private static final SdkField<Integer> RX_DR_OFFSET1_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxDrOffset1").getter(getter(LoRaWANDeviceProfile::rxDrOffset1)).setter(setter(Builder::rxDrOffset1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDrOffset1").build()).build();

    private static final SdkField<Integer> RX_DATA_RATE2_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxDataRate2").getter(getter(LoRaWANDeviceProfile::rxDataRate2)).setter(setter(Builder::rxDataRate2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDataRate2").build()).build();

    private static final SdkField<Integer> RX_FREQ2_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxFreq2").getter(getter(LoRaWANDeviceProfile::rxFreq2)).setter(setter(Builder::rxFreq2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxFreq2").build()).build();

    private static final SdkField<List<Integer>> FACTORY_PRESET_FREQS_LIST_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("FactoryPresetFreqsList")
            .getter(getter(LoRaWANDeviceProfile::factoryPresetFreqsList))
            .setter(setter(Builder::factoryPresetFreqsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FactoryPresetFreqsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_EIRP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxEirp").getter(getter(LoRaWANDeviceProfile::maxEirp)).setter(setter(Builder::maxEirp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEirp").build()).build();

    private static final SdkField<Integer> MAX_DUTY_CYCLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDutyCycle").getter(getter(LoRaWANDeviceProfile::maxDutyCycle)).setter(setter(Builder::maxDutyCycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDutyCycle").build()).build();

    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANDeviceProfile::rfRegion)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final SdkField<Boolean> SUPPORTS_JOIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsJoin").getter(getter(LoRaWANDeviceProfile::supportsJoin)).setter(setter(Builder::supportsJoin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsJoin").build()).build();

    private static final SdkField<Boolean> SUPPORTS32_BIT_F_CNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Supports32BitFCnt").getter(getter(LoRaWANDeviceProfile::supports32BitFCnt))
            .setter(setter(Builder::supports32BitFCnt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Supports32BitFCnt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTS_CLASSB_FIELD,
            CLASS_B_TIMEOUT_FIELD, PING_SLOT_PERIOD_FIELD, PING_SLOT_DR_FIELD, PING_SLOT_FREQ_FIELD, SUPPORTS_CLASSC_FIELD,
            CLASS_C_TIMEOUT_FIELD, MAC_VERSION_FIELD, REG_PARAMS_REVISION_FIELD, RX_DELAY1_FIELD, RX_DR_OFFSET1_FIELD,
            RX_DATA_RATE2_FIELD, RX_FREQ2_FIELD, FACTORY_PRESET_FREQS_LIST_FIELD, MAX_EIRP_FIELD, MAX_DUTY_CYCLE_FIELD,
            RF_REGION_FIELD, SUPPORTS_JOIN_FIELD, SUPPORTS32_BIT_F_CNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean supportsClassB;

    private final Integer classBTimeout;

    private final Integer pingSlotPeriod;

    private final Integer pingSlotDr;

    private final Integer pingSlotFreq;

    private final Boolean supportsClassC;

    private final Integer classCTimeout;

    private final String macVersion;

    private final String regParamsRevision;

    private final Integer rxDelay1;

    private final Integer rxDrOffset1;

    private final Integer rxDataRate2;

    private final Integer rxFreq2;

    private final List<Integer> factoryPresetFreqsList;

    private final Integer maxEirp;

    private final Integer maxDutyCycle;

    private final String rfRegion;

    private final Boolean supportsJoin;

    private final Boolean supports32BitFCnt;

    private LoRaWANDeviceProfile(BuilderImpl builder) {
        this.supportsClassB = builder.supportsClassB;
        this.classBTimeout = builder.classBTimeout;
        this.pingSlotPeriod = builder.pingSlotPeriod;
        this.pingSlotDr = builder.pingSlotDr;
        this.pingSlotFreq = builder.pingSlotFreq;
        this.supportsClassC = builder.supportsClassC;
        this.classCTimeout = builder.classCTimeout;
        this.macVersion = builder.macVersion;
        this.regParamsRevision = builder.regParamsRevision;
        this.rxDelay1 = builder.rxDelay1;
        this.rxDrOffset1 = builder.rxDrOffset1;
        this.rxDataRate2 = builder.rxDataRate2;
        this.rxFreq2 = builder.rxFreq2;
        this.factoryPresetFreqsList = builder.factoryPresetFreqsList;
        this.maxEirp = builder.maxEirp;
        this.maxDutyCycle = builder.maxDutyCycle;
        this.rfRegion = builder.rfRegion;
        this.supportsJoin = builder.supportsJoin;
        this.supports32BitFCnt = builder.supports32BitFCnt;
    }

    /**
     * <p>
     * The SupportsClassB value.
     * </p>
     * 
     * @return The SupportsClassB value.
     */
    public final Boolean supportsClassB() {
        return supportsClassB;
    }

    /**
     * <p>
     * The ClassBTimeout value.
     * </p>
     * 
     * @return The ClassBTimeout value.
     */
    public final Integer classBTimeout() {
        return classBTimeout;
    }

    /**
     * <p>
     * The PingSlotPeriod value.
     * </p>
     * 
     * @return The PingSlotPeriod value.
     */
    public final Integer pingSlotPeriod() {
        return pingSlotPeriod;
    }

    /**
     * <p>
     * The PingSlotDR value.
     * </p>
     * 
     * @return The PingSlotDR value.
     */
    public final Integer pingSlotDr() {
        return pingSlotDr;
    }

    /**
     * <p>
     * The PingSlotFreq value.
     * </p>
     * 
     * @return The PingSlotFreq value.
     */
    public final Integer pingSlotFreq() {
        return pingSlotFreq;
    }

    /**
     * <p>
     * The SupportsClassC value.
     * </p>
     * 
     * @return The SupportsClassC value.
     */
    public final Boolean supportsClassC() {
        return supportsClassC;
    }

    /**
     * <p>
     * The ClassCTimeout value.
     * </p>
     * 
     * @return The ClassCTimeout value.
     */
    public final Integer classCTimeout() {
        return classCTimeout;
    }

    /**
     * <p>
     * The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
     * </p>
     * 
     * @return The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
     */
    public final String macVersion() {
        return macVersion;
    }

    /**
     * <p>
     * The version of regional parameters.
     * </p>
     * 
     * @return The version of regional parameters.
     */
    public final String regParamsRevision() {
        return regParamsRevision;
    }

    /**
     * <p>
     * The RXDelay1 value.
     * </p>
     * 
     * @return The RXDelay1 value.
     */
    public final Integer rxDelay1() {
        return rxDelay1;
    }

    /**
     * <p>
     * The RXDROffset1 value.
     * </p>
     * 
     * @return The RXDROffset1 value.
     */
    public final Integer rxDrOffset1() {
        return rxDrOffset1;
    }

    /**
     * <p>
     * The RXDataRate2 value.
     * </p>
     * 
     * @return The RXDataRate2 value.
     */
    public final Integer rxDataRate2() {
        return rxDataRate2;
    }

    /**
     * <p>
     * The RXFreq2 value.
     * </p>
     * 
     * @return The RXFreq2 value.
     */
    public final Integer rxFreq2() {
        return rxFreq2;
    }

    /**
     * For responses, this returns true if the service returned a value for the FactoryPresetFreqsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFactoryPresetFreqsList() {
        return factoryPresetFreqsList != null && !(factoryPresetFreqsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values that make up the FactoryPresetFreqs value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFactoryPresetFreqsList} method.
     * </p>
     * 
     * @return The list of values that make up the FactoryPresetFreqs value.
     */
    public final List<Integer> factoryPresetFreqsList() {
        return factoryPresetFreqsList;
    }

    /**
     * <p>
     * The MaxEIRP value.
     * </p>
     * 
     * @return The MaxEIRP value.
     */
    public final Integer maxEirp() {
        return maxEirp;
    }

    /**
     * <p>
     * The MaxDutyCycle value.
     * </p>
     * 
     * @return The MaxDutyCycle value.
     */
    public final Integer maxDutyCycle() {
        return maxDutyCycle;
    }

    /**
     * <p>
     * The frequency band (RFRegion) value.
     * </p>
     * 
     * @return The frequency band (RFRegion) value.
     */
    public final String rfRegion() {
        return rfRegion;
    }

    /**
     * <p>
     * The SupportsJoin value.
     * </p>
     * 
     * @return The SupportsJoin value.
     */
    public final Boolean supportsJoin() {
        return supportsJoin;
    }

    /**
     * <p>
     * The Supports32BitFCnt value.
     * </p>
     * 
     * @return The Supports32BitFCnt value.
     */
    public final Boolean supports32BitFCnt() {
        return supports32BitFCnt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(supportsClassB());
        hashCode = 31 * hashCode + Objects.hashCode(classBTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(pingSlotPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(pingSlotDr());
        hashCode = 31 * hashCode + Objects.hashCode(pingSlotFreq());
        hashCode = 31 * hashCode + Objects.hashCode(supportsClassC());
        hashCode = 31 * hashCode + Objects.hashCode(classCTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(macVersion());
        hashCode = 31 * hashCode + Objects.hashCode(regParamsRevision());
        hashCode = 31 * hashCode + Objects.hashCode(rxDelay1());
        hashCode = 31 * hashCode + Objects.hashCode(rxDrOffset1());
        hashCode = 31 * hashCode + Objects.hashCode(rxDataRate2());
        hashCode = 31 * hashCode + Objects.hashCode(rxFreq2());
        hashCode = 31 * hashCode + Objects.hashCode(hasFactoryPresetFreqsList() ? factoryPresetFreqsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxEirp());
        hashCode = 31 * hashCode + Objects.hashCode(maxDutyCycle());
        hashCode = 31 * hashCode + Objects.hashCode(rfRegion());
        hashCode = 31 * hashCode + Objects.hashCode(supportsJoin());
        hashCode = 31 * hashCode + Objects.hashCode(supports32BitFCnt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDeviceProfile)) {
            return false;
        }
        LoRaWANDeviceProfile other = (LoRaWANDeviceProfile) obj;
        return Objects.equals(supportsClassB(), other.supportsClassB()) && Objects.equals(classBTimeout(), other.classBTimeout())
                && Objects.equals(pingSlotPeriod(), other.pingSlotPeriod()) && Objects.equals(pingSlotDr(), other.pingSlotDr())
                && Objects.equals(pingSlotFreq(), other.pingSlotFreq())
                && Objects.equals(supportsClassC(), other.supportsClassC())
                && Objects.equals(classCTimeout(), other.classCTimeout()) && Objects.equals(macVersion(), other.macVersion())
                && Objects.equals(regParamsRevision(), other.regParamsRevision()) && Objects.equals(rxDelay1(), other.rxDelay1())
                && Objects.equals(rxDrOffset1(), other.rxDrOffset1()) && Objects.equals(rxDataRate2(), other.rxDataRate2())
                && Objects.equals(rxFreq2(), other.rxFreq2()) && hasFactoryPresetFreqsList() == other.hasFactoryPresetFreqsList()
                && Objects.equals(factoryPresetFreqsList(), other.factoryPresetFreqsList())
                && Objects.equals(maxEirp(), other.maxEirp()) && Objects.equals(maxDutyCycle(), other.maxDutyCycle())
                && Objects.equals(rfRegion(), other.rfRegion()) && Objects.equals(supportsJoin(), other.supportsJoin())
                && Objects.equals(supports32BitFCnt(), other.supports32BitFCnt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANDeviceProfile").add("SupportsClassB", supportsClassB())
                .add("ClassBTimeout", classBTimeout()).add("PingSlotPeriod", pingSlotPeriod()).add("PingSlotDr", pingSlotDr())
                .add("PingSlotFreq", pingSlotFreq()).add("SupportsClassC", supportsClassC())
                .add("ClassCTimeout", classCTimeout()).add("MacVersion", macVersion())
                .add("RegParamsRevision", regParamsRevision()).add("RxDelay1", rxDelay1()).add("RxDrOffset1", rxDrOffset1())
                .add("RxDataRate2", rxDataRate2()).add("RxFreq2", rxFreq2())
                .add("FactoryPresetFreqsList", hasFactoryPresetFreqsList() ? factoryPresetFreqsList() : null)
                .add("MaxEirp", maxEirp()).add("MaxDutyCycle", maxDutyCycle()).add("RfRegion", rfRegion())
                .add("SupportsJoin", supportsJoin()).add("Supports32BitFCnt", supports32BitFCnt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportsClassB":
            return Optional.ofNullable(clazz.cast(supportsClassB()));
        case "ClassBTimeout":
            return Optional.ofNullable(clazz.cast(classBTimeout()));
        case "PingSlotPeriod":
            return Optional.ofNullable(clazz.cast(pingSlotPeriod()));
        case "PingSlotDr":
            return Optional.ofNullable(clazz.cast(pingSlotDr()));
        case "PingSlotFreq":
            return Optional.ofNullable(clazz.cast(pingSlotFreq()));
        case "SupportsClassC":
            return Optional.ofNullable(clazz.cast(supportsClassC()));
        case "ClassCTimeout":
            return Optional.ofNullable(clazz.cast(classCTimeout()));
        case "MacVersion":
            return Optional.ofNullable(clazz.cast(macVersion()));
        case "RegParamsRevision":
            return Optional.ofNullable(clazz.cast(regParamsRevision()));
        case "RxDelay1":
            return Optional.ofNullable(clazz.cast(rxDelay1()));
        case "RxDrOffset1":
            return Optional.ofNullable(clazz.cast(rxDrOffset1()));
        case "RxDataRate2":
            return Optional.ofNullable(clazz.cast(rxDataRate2()));
        case "RxFreq2":
            return Optional.ofNullable(clazz.cast(rxFreq2()));
        case "FactoryPresetFreqsList":
            return Optional.ofNullable(clazz.cast(factoryPresetFreqsList()));
        case "MaxEirp":
            return Optional.ofNullable(clazz.cast(maxEirp()));
        case "MaxDutyCycle":
            return Optional.ofNullable(clazz.cast(maxDutyCycle()));
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegion()));
        case "SupportsJoin":
            return Optional.ofNullable(clazz.cast(supportsJoin()));
        case "Supports32BitFCnt":
            return Optional.ofNullable(clazz.cast(supports32BitFCnt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDeviceProfile, T> g) {
        return obj -> g.apply((LoRaWANDeviceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANDeviceProfile> {
        /**
         * <p>
         * The SupportsClassB value.
         * </p>
         * 
         * @param supportsClassB
         *        The SupportsClassB value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsClassB(Boolean supportsClassB);

        /**
         * <p>
         * The ClassBTimeout value.
         * </p>
         * 
         * @param classBTimeout
         *        The ClassBTimeout value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classBTimeout(Integer classBTimeout);

        /**
         * <p>
         * The PingSlotPeriod value.
         * </p>
         * 
         * @param pingSlotPeriod
         *        The PingSlotPeriod value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pingSlotPeriod(Integer pingSlotPeriod);

        /**
         * <p>
         * The PingSlotDR value.
         * </p>
         * 
         * @param pingSlotDr
         *        The PingSlotDR value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pingSlotDr(Integer pingSlotDr);

        /**
         * <p>
         * The PingSlotFreq value.
         * </p>
         * 
         * @param pingSlotFreq
         *        The PingSlotFreq value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pingSlotFreq(Integer pingSlotFreq);

        /**
         * <p>
         * The SupportsClassC value.
         * </p>
         * 
         * @param supportsClassC
         *        The SupportsClassC value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsClassC(Boolean supportsClassC);

        /**
         * <p>
         * The ClassCTimeout value.
         * </p>
         * 
         * @param classCTimeout
         *        The ClassCTimeout value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classCTimeout(Integer classCTimeout);

        /**
         * <p>
         * The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
         * </p>
         * 
         * @param macVersion
         *        The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macVersion(String macVersion);

        /**
         * <p>
         * The version of regional parameters.
         * </p>
         * 
         * @param regParamsRevision
         *        The version of regional parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regParamsRevision(String regParamsRevision);

        /**
         * <p>
         * The RXDelay1 value.
         * </p>
         * 
         * @param rxDelay1
         *        The RXDelay1 value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxDelay1(Integer rxDelay1);

        /**
         * <p>
         * The RXDROffset1 value.
         * </p>
         * 
         * @param rxDrOffset1
         *        The RXDROffset1 value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxDrOffset1(Integer rxDrOffset1);

        /**
         * <p>
         * The RXDataRate2 value.
         * </p>
         * 
         * @param rxDataRate2
         *        The RXDataRate2 value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxDataRate2(Integer rxDataRate2);

        /**
         * <p>
         * The RXFreq2 value.
         * </p>
         * 
         * @param rxFreq2
         *        The RXFreq2 value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxFreq2(Integer rxFreq2);

        /**
         * <p>
         * The list of values that make up the FactoryPresetFreqs value.
         * </p>
         * 
         * @param factoryPresetFreqsList
         *        The list of values that make up the FactoryPresetFreqs value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factoryPresetFreqsList(Collection<Integer> factoryPresetFreqsList);

        /**
         * <p>
         * The list of values that make up the FactoryPresetFreqs value.
         * </p>
         * 
         * @param factoryPresetFreqsList
         *        The list of values that make up the FactoryPresetFreqs value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factoryPresetFreqsList(Integer... factoryPresetFreqsList);

        /**
         * <p>
         * The MaxEIRP value.
         * </p>
         * 
         * @param maxEirp
         *        The MaxEIRP value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEirp(Integer maxEirp);

        /**
         * <p>
         * The MaxDutyCycle value.
         * </p>
         * 
         * @param maxDutyCycle
         *        The MaxDutyCycle value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDutyCycle(Integer maxDutyCycle);

        /**
         * <p>
         * The frequency band (RFRegion) value.
         * </p>
         * 
         * @param rfRegion
         *        The frequency band (RFRegion) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfRegion(String rfRegion);

        /**
         * <p>
         * The SupportsJoin value.
         * </p>
         * 
         * @param supportsJoin
         *        The SupportsJoin value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsJoin(Boolean supportsJoin);

        /**
         * <p>
         * The Supports32BitFCnt value.
         * </p>
         * 
         * @param supports32BitFCnt
         *        The Supports32BitFCnt value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supports32BitFCnt(Boolean supports32BitFCnt);
    }

    static final class BuilderImpl implements Builder {
        private Boolean supportsClassB;

        private Integer classBTimeout;

        private Integer pingSlotPeriod;

        private Integer pingSlotDr;

        private Integer pingSlotFreq;

        private Boolean supportsClassC;

        private Integer classCTimeout;

        private String macVersion;

        private String regParamsRevision;

        private Integer rxDelay1;

        private Integer rxDrOffset1;

        private Integer rxDataRate2;

        private Integer rxFreq2;

        private List<Integer> factoryPresetFreqsList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxEirp;

        private Integer maxDutyCycle;

        private String rfRegion;

        private Boolean supportsJoin;

        private Boolean supports32BitFCnt;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDeviceProfile model) {
            supportsClassB(model.supportsClassB);
            classBTimeout(model.classBTimeout);
            pingSlotPeriod(model.pingSlotPeriod);
            pingSlotDr(model.pingSlotDr);
            pingSlotFreq(model.pingSlotFreq);
            supportsClassC(model.supportsClassC);
            classCTimeout(model.classCTimeout);
            macVersion(model.macVersion);
            regParamsRevision(model.regParamsRevision);
            rxDelay1(model.rxDelay1);
            rxDrOffset1(model.rxDrOffset1);
            rxDataRate2(model.rxDataRate2);
            rxFreq2(model.rxFreq2);
            factoryPresetFreqsList(model.factoryPresetFreqsList);
            maxEirp(model.maxEirp);
            maxDutyCycle(model.maxDutyCycle);
            rfRegion(model.rfRegion);
            supportsJoin(model.supportsJoin);
            supports32BitFCnt(model.supports32BitFCnt);
        }

        public final Boolean getSupportsClassB() {
            return supportsClassB;
        }

        public final void setSupportsClassB(Boolean supportsClassB) {
            this.supportsClassB = supportsClassB;
        }

        @Override
        @Transient
        public final Builder supportsClassB(Boolean supportsClassB) {
            this.supportsClassB = supportsClassB;
            return this;
        }

        public final Integer getClassBTimeout() {
            return classBTimeout;
        }

        public final void setClassBTimeout(Integer classBTimeout) {
            this.classBTimeout = classBTimeout;
        }

        @Override
        @Transient
        public final Builder classBTimeout(Integer classBTimeout) {
            this.classBTimeout = classBTimeout;
            return this;
        }

        public final Integer getPingSlotPeriod() {
            return pingSlotPeriod;
        }

        public final void setPingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
        }

        @Override
        @Transient
        public final Builder pingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
            return this;
        }

        public final Integer getPingSlotDr() {
            return pingSlotDr;
        }

        public final void setPingSlotDr(Integer pingSlotDr) {
            this.pingSlotDr = pingSlotDr;
        }

        @Override
        @Transient
        public final Builder pingSlotDr(Integer pingSlotDr) {
            this.pingSlotDr = pingSlotDr;
            return this;
        }

        public final Integer getPingSlotFreq() {
            return pingSlotFreq;
        }

        public final void setPingSlotFreq(Integer pingSlotFreq) {
            this.pingSlotFreq = pingSlotFreq;
        }

        @Override
        @Transient
        public final Builder pingSlotFreq(Integer pingSlotFreq) {
            this.pingSlotFreq = pingSlotFreq;
            return this;
        }

        public final Boolean getSupportsClassC() {
            return supportsClassC;
        }

        public final void setSupportsClassC(Boolean supportsClassC) {
            this.supportsClassC = supportsClassC;
        }

        @Override
        @Transient
        public final Builder supportsClassC(Boolean supportsClassC) {
            this.supportsClassC = supportsClassC;
            return this;
        }

        public final Integer getClassCTimeout() {
            return classCTimeout;
        }

        public final void setClassCTimeout(Integer classCTimeout) {
            this.classCTimeout = classCTimeout;
        }

        @Override
        @Transient
        public final Builder classCTimeout(Integer classCTimeout) {
            this.classCTimeout = classCTimeout;
            return this;
        }

        public final String getMacVersion() {
            return macVersion;
        }

        public final void setMacVersion(String macVersion) {
            this.macVersion = macVersion;
        }

        @Override
        @Transient
        public final Builder macVersion(String macVersion) {
            this.macVersion = macVersion;
            return this;
        }

        public final String getRegParamsRevision() {
            return regParamsRevision;
        }

        public final void setRegParamsRevision(String regParamsRevision) {
            this.regParamsRevision = regParamsRevision;
        }

        @Override
        @Transient
        public final Builder regParamsRevision(String regParamsRevision) {
            this.regParamsRevision = regParamsRevision;
            return this;
        }

        public final Integer getRxDelay1() {
            return rxDelay1;
        }

        public final void setRxDelay1(Integer rxDelay1) {
            this.rxDelay1 = rxDelay1;
        }

        @Override
        @Transient
        public final Builder rxDelay1(Integer rxDelay1) {
            this.rxDelay1 = rxDelay1;
            return this;
        }

        public final Integer getRxDrOffset1() {
            return rxDrOffset1;
        }

        public final void setRxDrOffset1(Integer rxDrOffset1) {
            this.rxDrOffset1 = rxDrOffset1;
        }

        @Override
        @Transient
        public final Builder rxDrOffset1(Integer rxDrOffset1) {
            this.rxDrOffset1 = rxDrOffset1;
            return this;
        }

        public final Integer getRxDataRate2() {
            return rxDataRate2;
        }

        public final void setRxDataRate2(Integer rxDataRate2) {
            this.rxDataRate2 = rxDataRate2;
        }

        @Override
        @Transient
        public final Builder rxDataRate2(Integer rxDataRate2) {
            this.rxDataRate2 = rxDataRate2;
            return this;
        }

        public final Integer getRxFreq2() {
            return rxFreq2;
        }

        public final void setRxFreq2(Integer rxFreq2) {
            this.rxFreq2 = rxFreq2;
        }

        @Override
        @Transient
        public final Builder rxFreq2(Integer rxFreq2) {
            this.rxFreq2 = rxFreq2;
            return this;
        }

        public final Collection<Integer> getFactoryPresetFreqsList() {
            if (factoryPresetFreqsList instanceof SdkAutoConstructList) {
                return null;
            }
            return factoryPresetFreqsList;
        }

        public final void setFactoryPresetFreqsList(Collection<Integer> factoryPresetFreqsList) {
            this.factoryPresetFreqsList = FactoryPresetFreqsListCopier.copy(factoryPresetFreqsList);
        }

        @Override
        @Transient
        public final Builder factoryPresetFreqsList(Collection<Integer> factoryPresetFreqsList) {
            this.factoryPresetFreqsList = FactoryPresetFreqsListCopier.copy(factoryPresetFreqsList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder factoryPresetFreqsList(Integer... factoryPresetFreqsList) {
            factoryPresetFreqsList(Arrays.asList(factoryPresetFreqsList));
            return this;
        }

        public final Integer getMaxEirp() {
            return maxEirp;
        }

        public final void setMaxEirp(Integer maxEirp) {
            this.maxEirp = maxEirp;
        }

        @Override
        @Transient
        public final Builder maxEirp(Integer maxEirp) {
            this.maxEirp = maxEirp;
            return this;
        }

        public final Integer getMaxDutyCycle() {
            return maxDutyCycle;
        }

        public final void setMaxDutyCycle(Integer maxDutyCycle) {
            this.maxDutyCycle = maxDutyCycle;
        }

        @Override
        @Transient
        public final Builder maxDutyCycle(Integer maxDutyCycle) {
            this.maxDutyCycle = maxDutyCycle;
            return this;
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        @Transient
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final Boolean getSupportsJoin() {
            return supportsJoin;
        }

        public final void setSupportsJoin(Boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
        }

        @Override
        @Transient
        public final Builder supportsJoin(Boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
            return this;
        }

        public final Boolean getSupports32BitFCnt() {
            return supports32BitFCnt;
        }

        public final void setSupports32BitFCnt(Boolean supports32BitFCnt) {
            this.supports32BitFCnt = supports32BitFCnt;
        }

        @Override
        @Transient
        public final Builder supports32BitFCnt(Boolean supports32BitFCnt) {
            this.supports32BitFCnt = supports32BitFCnt;
            return this;
        }

        @Override
        public LoRaWANDeviceProfile build() {
            return new LoRaWANDeviceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
