/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessGatewayResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessGatewayResponse.Builder, GetWirelessGatewayResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetWirelessGatewayResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetWirelessGatewayResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetWirelessGatewayResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoRaWANGateway> LO_RA_WAN_FIELD = SdkField.<LoRaWANGateway> builder(MarshallingType.SDK_POJO)
            .memberName("LoRaWAN").getter(getter(GetWirelessGatewayResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetWirelessGatewayResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingName").getter(getter(GetWirelessGatewayResponse::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingArn").getter(getter(GetWirelessGatewayResponse::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, LO_RA_WAN_FIELD, ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD));

    private final String name;

    private final String id;

    private final String description;

    private final LoRaWANGateway loRaWAN;

    private final String arn;

    private final String thingName;

    private final String thingArn;

    private GetWirelessGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.arn = builder.arn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the wireless gateway.
     * </p>
     * 
     * @return The ID of the wireless gateway.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description of the resource.
     * </p>
     * 
     * @return The description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the wireless gateway.
     * </p>
     * 
     * @return Information about the wireless gateway.
     */
    public final LoRaWANGateway loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the thing associated with the wireless gateway. The value is empty if a thing isn't associated with
     * the gateway.
     * </p>
     * 
     * @return The name of the thing associated with the wireless gateway. The value is empty if a thing isn't
     *         associated with the gateway.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the thing associated with the wireless gateway.
     * </p>
     * 
     * @return The ARN of the thing associated with the wireless gateway.
     */
    public final String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayResponse)) {
            return false;
        }
        GetWirelessGatewayResponse other = (GetWirelessGatewayResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(arn(), other.arn()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(thingArn(), other.thingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessGatewayResponse").add("Name", name()).add("Id", id())
                .add("Description", description()).add("LoRaWAN", loRaWAN()).add("Arn", arn()).add("ThingName", thingName())
                .add("ThingArn", thingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ThingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "ThingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWirelessGatewayResponse> {
        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * 
         * @param id
         *        The ID of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description of the resource.
         * </p>
         * 
         * @param description
         *        The description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the wireless gateway.
         * </p>
         * 
         * @param loRaWAN
         *        Information about the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANGateway loRaWAN);

        /**
         * <p>
         * Information about the wireless gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link LoRaWANGateway.Builder} avoiding the need to
         * create one manually via {@link LoRaWANGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANGateway)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANGateway)
         */
        default Builder loRaWAN(Consumer<LoRaWANGateway.Builder> loRaWAN) {
            return loRaWAN(LoRaWANGateway.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the thing associated with the wireless gateway. The value is empty if a thing isn't associated
         * with the gateway.
         * </p>
         * 
         * @param thingName
         *        The name of the thing associated with the wireless gateway. The value is empty if a thing isn't
         *        associated with the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the thing associated with the wireless gateway.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing associated with the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String name;

        private String id;

        private String description;

        private LoRaWANGateway loRaWAN;

        private String arn;

        private String thingName;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayResponse model) {
            super(model);
            name(model.name);
            id(model.id);
            description(model.description);
            loRaWAN(model.loRaWAN);
            arn(model.arn);
            thingName(model.thingName);
            thingArn(model.thingArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANGateway.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANGateway.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANGateway loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        @Override
        public GetWirelessGatewayResponse build() {
            return new GetWirelessGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
