/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * MetaData for Sidewalk device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkDeviceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkDeviceMetadata.Builder, SidewalkDeviceMetadata> {
    private static final SdkField<Integer> RSSI_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rssi")
            .getter(getter(SidewalkDeviceMetadata::rssi)).setter(setter(Builder::rssi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rssi").build()).build();

    private static final SdkField<String> BATTERY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatteryLevel").getter(getter(SidewalkDeviceMetadata::batteryLevelAsString))
            .setter(setter(Builder::batteryLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatteryLevel").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Event")
            .getter(getter(SidewalkDeviceMetadata::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceState").getter(getter(SidewalkDeviceMetadata::deviceStateAsString))
            .setter(setter(Builder::deviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RSSI_FIELD,
            BATTERY_LEVEL_FIELD, EVENT_FIELD, DEVICE_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer rssi;

    private final String batteryLevel;

    private final String event;

    private final String deviceState;

    private SidewalkDeviceMetadata(BuilderImpl builder) {
        this.rssi = builder.rssi;
        this.batteryLevel = builder.batteryLevel;
        this.event = builder.event;
        this.deviceState = builder.deviceState;
    }

    /**
     * <p>
     * The RSSI value.
     * </p>
     * 
     * @return The RSSI value.
     */
    public final Integer rssi() {
        return rssi;
    }

    /**
     * <p>
     * Sidewalk device battery level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batteryLevel} will
     * return {@link BatteryLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batteryLevelAsString}.
     * </p>
     * 
     * @return Sidewalk device battery level.
     * @see BatteryLevel
     */
    public final BatteryLevel batteryLevel() {
        return BatteryLevel.fromValue(batteryLevel);
    }

    /**
     * <p>
     * Sidewalk device battery level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batteryLevel} will
     * return {@link BatteryLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batteryLevelAsString}.
     * </p>
     * 
     * @return Sidewalk device battery level.
     * @see BatteryLevel
     */
    public final String batteryLevelAsString() {
        return batteryLevel;
    }

    /**
     * <p>
     * Sidewalk device status notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Sidewalk device status notification.
     * @see Event
     */
    public final Event event() {
        return Event.fromValue(event);
    }

    /**
     * <p>
     * Sidewalk device status notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Sidewalk device status notification.
     * @see Event
     */
    public final String eventAsString() {
        return event;
    }

    /**
     * <p>
     * Device state defines the device status of sidewalk device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link DeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return Device state defines the device status of sidewalk device.
     * @see DeviceState
     */
    public final DeviceState deviceState() {
        return DeviceState.fromValue(deviceState);
    }

    /**
     * <p>
     * Device state defines the device status of sidewalk device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link DeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return Device state defines the device status of sidewalk device.
     * @see DeviceState
     */
    public final String deviceStateAsString() {
        return deviceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rssi());
        hashCode = 31 * hashCode + Objects.hashCode(batteryLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkDeviceMetadata)) {
            return false;
        }
        SidewalkDeviceMetadata other = (SidewalkDeviceMetadata) obj;
        return Objects.equals(rssi(), other.rssi()) && Objects.equals(batteryLevelAsString(), other.batteryLevelAsString())
                && Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(deviceStateAsString(), other.deviceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkDeviceMetadata").add("Rssi", rssi()).add("BatteryLevel", batteryLevelAsString())
                .add("Event", eventAsString()).add("DeviceState", deviceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rssi":
            return Optional.ofNullable(clazz.cast(rssi()));
        case "BatteryLevel":
            return Optional.ofNullable(clazz.cast(batteryLevelAsString()));
        case "Event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "DeviceState":
            return Optional.ofNullable(clazz.cast(deviceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkDeviceMetadata, T> g) {
        return obj -> g.apply((SidewalkDeviceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkDeviceMetadata> {
        /**
         * <p>
         * The RSSI value.
         * </p>
         * 
         * @param rssi
         *        The RSSI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rssi(Integer rssi);

        /**
         * <p>
         * Sidewalk device battery level.
         * </p>
         * 
         * @param batteryLevel
         *        Sidewalk device battery level.
         * @see BatteryLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatteryLevel
         */
        Builder batteryLevel(String batteryLevel);

        /**
         * <p>
         * Sidewalk device battery level.
         * </p>
         * 
         * @param batteryLevel
         *        Sidewalk device battery level.
         * @see BatteryLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatteryLevel
         */
        Builder batteryLevel(BatteryLevel batteryLevel);

        /**
         * <p>
         * Sidewalk device status notification.
         * </p>
         * 
         * @param event
         *        Sidewalk device status notification.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * <p>
         * Sidewalk device status notification.
         * </p>
         * 
         * @param event
         *        Sidewalk device status notification.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * <p>
         * Device state defines the device status of sidewalk device.
         * </p>
         * 
         * @param deviceState
         *        Device state defines the device status of sidewalk device.
         * @see DeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceState
         */
        Builder deviceState(String deviceState);

        /**
         * <p>
         * Device state defines the device status of sidewalk device.
         * </p>
         * 
         * @param deviceState
         *        Device state defines the device status of sidewalk device.
         * @see DeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceState
         */
        Builder deviceState(DeviceState deviceState);
    }

    static final class BuilderImpl implements Builder {
        private Integer rssi;

        private String batteryLevel;

        private String event;

        private String deviceState;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkDeviceMetadata model) {
            rssi(model.rssi);
            batteryLevel(model.batteryLevel);
            event(model.event);
            deviceState(model.deviceState);
        }

        public final Integer getRssi() {
            return rssi;
        }

        public final void setRssi(Integer rssi) {
            this.rssi = rssi;
        }

        @Override
        @Transient
        public final Builder rssi(Integer rssi) {
            this.rssi = rssi;
            return this;
        }

        public final String getBatteryLevel() {
            return batteryLevel;
        }

        public final void setBatteryLevel(String batteryLevel) {
            this.batteryLevel = batteryLevel;
        }

        @Override
        @Transient
        public final Builder batteryLevel(String batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder batteryLevel(BatteryLevel batteryLevel) {
            this.batteryLevel(batteryLevel == null ? null : batteryLevel.toString());
            return this;
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @Transient
        public final Builder event(Event event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getDeviceState() {
            return deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        @Transient
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceState(DeviceState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        @Override
        public SidewalkDeviceMetadata build() {
            return new SidewalkDeviceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
