/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceEventConfigurationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetResourceEventConfigurationResponse.Builder, GetResourceEventConfigurationResponse> {
    private static final SdkField<DeviceRegistrationStateEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField
            .<DeviceRegistrationStateEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeviceRegistrationState")
            .getter(getter(GetResourceEventConfigurationResponse::deviceRegistrationState))
            .setter(setter(Builder::deviceRegistrationState)).constructor(DeviceRegistrationStateEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build())
            .build();

    private static final SdkField<ProximityEventConfiguration> PROXIMITY_FIELD = SdkField
            .<ProximityEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("Proximity")
            .getter(getter(GetResourceEventConfigurationResponse::proximity)).setter(setter(Builder::proximity))
            .constructor(ProximityEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD));

    private final DeviceRegistrationStateEventConfiguration deviceRegistrationState;

    private final ProximityEventConfiguration proximity;

    private GetResourceEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
    }

    /**
     * <p>
     * Event configuration for the device registration state event
     * </p>
     * 
     * @return Event configuration for the device registration state event
     */
    public final DeviceRegistrationStateEventConfiguration deviceRegistrationState() {
        return deviceRegistrationState;
    }

    /**
     * <p>
     * Event configuration for the Proximity event
     * </p>
     * 
     * @return Event configuration for the Proximity event
     */
    public final ProximityEventConfiguration proximity() {
        return proximity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(proximity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEventConfigurationResponse)) {
            return false;
        }
        GetResourceEventConfigurationResponse other = (GetResourceEventConfigurationResponse) obj;
        return Objects.equals(deviceRegistrationState(), other.deviceRegistrationState())
                && Objects.equals(proximity(), other.proximity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceEventConfigurationResponse")
                .add("DeviceRegistrationState", deviceRegistrationState()).add("Proximity", proximity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceRegistrationState":
            return Optional.ofNullable(clazz.cast(deviceRegistrationState()));
        case "Proximity":
            return Optional.ofNullable(clazz.cast(proximity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEventConfigurationResponse, T> g) {
        return obj -> g.apply((GetResourceEventConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceEventConfigurationResponse> {
        /**
         * <p>
         * Event configuration for the device registration state event
         * </p>
         * 
         * @param deviceRegistrationState
         *        Event configuration for the device registration state event
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState);

        /**
         * <p>
         * Event configuration for the device registration state event
         * </p>
         * This is a convenience that creates an instance of the
         * {@link DeviceRegistrationStateEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link DeviceRegistrationStateEventConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceRegistrationStateEventConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deviceRegistrationState(DeviceRegistrationStateEventConfiguration)}.
         * 
         * @param deviceRegistrationState
         *        a consumer that will call methods on {@link DeviceRegistrationStateEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceRegistrationState(DeviceRegistrationStateEventConfiguration)
         */
        default Builder deviceRegistrationState(
                Consumer<DeviceRegistrationStateEventConfiguration.Builder> deviceRegistrationState) {
            return deviceRegistrationState(DeviceRegistrationStateEventConfiguration.builder()
                    .applyMutation(deviceRegistrationState).build());
        }

        /**
         * <p>
         * Event configuration for the Proximity event
         * </p>
         * 
         * @param proximity
         *        Event configuration for the Proximity event
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proximity(ProximityEventConfiguration proximity);

        /**
         * <p>
         * Event configuration for the Proximity event
         * </p>
         * This is a convenience that creates an instance of the {@link ProximityEventConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProximityEventConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProximityEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #proximity(ProximityEventConfiguration)}.
         * 
         * @param proximity
         *        a consumer that will call methods on {@link ProximityEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proximity(ProximityEventConfiguration)
         */
        default Builder proximity(Consumer<ProximityEventConfiguration.Builder> proximity) {
            return proximity(ProximityEventConfiguration.builder().applyMutation(proximity).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private DeviceRegistrationStateEventConfiguration deviceRegistrationState;

        private ProximityEventConfiguration proximity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEventConfigurationResponse model) {
            super(model);
            deviceRegistrationState(model.deviceRegistrationState);
            proximity(model.proximity);
        }

        public final DeviceRegistrationStateEventConfiguration.Builder getDeviceRegistrationState() {
            return deviceRegistrationState != null ? deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(DeviceRegistrationStateEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityEventConfiguration.Builder getProximity() {
            return proximity != null ? proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        @Transient
        public final Builder proximity(ProximityEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        @Override
        public GetResourceEventConfigurationResponse build() {
            return new GetResourceEventConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
