/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessGatewayFirmwareInformationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessGatewayFirmwareInformationResponse.Builder, GetWirelessGatewayFirmwareInformationResponse> {
    private static final SdkField<LoRaWANGatewayCurrentVersion> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANGatewayCurrentVersion> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(GetWirelessGatewayFirmwareInformationResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANGatewayCurrentVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD));

    private final LoRaWANGatewayCurrentVersion loRaWAN;

    private GetWirelessGatewayFirmwareInformationResponse(BuilderImpl builder) {
        super(builder);
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * <p>
     * Information about the wireless gateway's firmware.
     * </p>
     * 
     * @return Information about the wireless gateway's firmware.
     */
    public final LoRaWANGatewayCurrentVersion loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayFirmwareInformationResponse)) {
            return false;
        }
        GetWirelessGatewayFirmwareInformationResponse other = (GetWirelessGatewayFirmwareInformationResponse) obj;
        return Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessGatewayFirmwareInformationResponse").add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayFirmwareInformationResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayFirmwareInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWirelessGatewayFirmwareInformationResponse> {
        /**
         * <p>
         * Information about the wireless gateway's firmware.
         * </p>
         * 
         * @param loRaWAN
         *        Information about the wireless gateway's firmware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANGatewayCurrentVersion loRaWAN);

        /**
         * <p>
         * Information about the wireless gateway's firmware.
         * </p>
         * This is a convenience that creates an instance of the {@link LoRaWANGatewayCurrentVersion.Builder} avoiding
         * the need to create one manually via {@link LoRaWANGatewayCurrentVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANGatewayCurrentVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #loRaWAN(LoRaWANGatewayCurrentVersion)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANGatewayCurrentVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANGatewayCurrentVersion)
         */
        default Builder loRaWAN(Consumer<LoRaWANGatewayCurrentVersion.Builder> loRaWAN) {
            return loRaWAN(LoRaWANGatewayCurrentVersion.builder().applyMutation(loRaWAN).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private LoRaWANGatewayCurrentVersion loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayFirmwareInformationResponse model) {
            super(model);
            loRaWAN(model.loRaWAN);
        }

        public final LoRaWANGatewayCurrentVersion.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANGatewayCurrentVersion.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANGatewayCurrentVersion loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        @Override
        public GetWirelessGatewayFirmwareInformationResponse build() {
            return new GetWirelessGatewayFirmwareInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
