/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata information of the LoRaWAN multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANMulticastMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANMulticastMetadata.Builder, LoRaWANMulticastMetadata> {
    private static final SdkField<Integer> F_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("FPort")
            .getter(getter(LoRaWANMulticastMetadata::fPort)).setter(setter(Builder::fPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fPort;

    private LoRaWANMulticastMetadata(BuilderImpl builder) {
        this.fPort = builder.fPort;
    }

    /**
     * Returns the value of the FPort property for this object.
     * 
     * @return The value of the FPort property for this object.
     */
    public final Integer fPort() {
        return fPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticastMetadata)) {
            return false;
        }
        LoRaWANMulticastMetadata other = (LoRaWANMulticastMetadata) obj;
        return Objects.equals(fPort(), other.fPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANMulticastMetadata").add("FPort", fPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FPort":
            return Optional.ofNullable(clazz.cast(fPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticastMetadata, T> g) {
        return obj -> g.apply((LoRaWANMulticastMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANMulticastMetadata> {
        /**
         * Sets the value of the FPort property for this object.
         *
         * @param fPort
         *        The new value for the FPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPort(Integer fPort);
    }

    static final class BuilderImpl implements Builder {
        private Integer fPort;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticastMetadata model) {
            fPort(model.fPort);
        }

        public final Integer getFPort() {
            return fPort;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        @Override
        @Transient
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        @Override
        public LoRaWANMulticastMetadata build() {
            return new LoRaWANMulticastMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
