/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWirelessDeviceRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateWirelessDeviceRequest.Builder, UpdateWirelessDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateWirelessDeviceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(UpdateWirelessDeviceRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateWirelessDeviceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWirelessDeviceRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoRaWANUpdateDevice> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANUpdateDevice> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(UpdateWirelessDeviceRequest::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANUpdateDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DESTINATION_NAME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LO_RA_WAN_FIELD));

    private final String id;

    private final String destinationName;

    private final String name;

    private final String description;

    private final LoRaWANUpdateDevice loRaWAN;

    private UpdateWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.destinationName = builder.destinationName;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * <p>
     * The ID of the resource to update.
     * </p>
     * 
     * @return The ID of the resource to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the new destination for the device.
     * </p>
     * 
     * @return The name of the new destination for the device.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The new name of the resource.
     * </p>
     * 
     * @return The new name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new description of the resource.
     * </p>
     * 
     * @return A new description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated wireless device's configuration.
     * </p>
     * 
     * @return The updated wireless device's configuration.
     */
    public final LoRaWANUpdateDevice loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessDeviceRequest)) {
            return false;
        }
        UpdateWirelessDeviceRequest other = (UpdateWirelessDeviceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWirelessDeviceRequest").add("Id", id()).add("DestinationName", destinationName())
                .add("Name", name()).add("Description", description()).add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessDeviceRequest, T> g) {
        return obj -> g.apply((UpdateWirelessDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWirelessDeviceRequest> {
        /**
         * <p>
         * The ID of the resource to update.
         * </p>
         * 
         * @param id
         *        The ID of the resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the new destination for the device.
         * </p>
         * 
         * @param destinationName
         *        The name of the new destination for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The new name of the resource.
         * </p>
         * 
         * @param name
         *        The new name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new description of the resource.
         * </p>
         * 
         * @param description
         *        A new description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated wireless device's configuration.
         * </p>
         * 
         * @param loRaWAN
         *        The updated wireless device's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANUpdateDevice loRaWAN);

        /**
         * <p>
         * The updated wireless device's configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link LoRaWANUpdateDevice.Builder} avoiding the need
         * to create one manually via {@link LoRaWANUpdateDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANUpdateDevice.Builder#build()} is called immediately and
         * its result is passed to {@link #loRaWAN(LoRaWANUpdateDevice)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANUpdateDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANUpdateDevice)
         */
        default Builder loRaWAN(Consumer<LoRaWANUpdateDevice.Builder> loRaWAN) {
            return loRaWAN(LoRaWANUpdateDevice.builder().applyMutation(loRaWAN).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String destinationName;

        private String name;

        private String description;

        private LoRaWANUpdateDevice loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessDeviceRequest model) {
            super(model);
            id(model.id);
            destinationName(model.destinationName);
            name(model.name);
            description(model.description);
            loRaWAN(model.loRaWAN);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        @Transient
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANUpdateDevice.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANUpdateDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANUpdateDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWirelessDeviceRequest build() {
            return new UpdateWirelessDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
