/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANServiceProfile object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANServiceProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANServiceProfile.Builder, LoRaWANServiceProfile> {
    private static final SdkField<Boolean> ADD_GW_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddGwMetadata").getter(getter(LoRaWANServiceProfile::addGwMetadata))
            .setter(setter(Builder::addGwMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddGwMetadata").build()).build();

    private static final SdkField<Integer> DR_MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("DrMin")
            .getter(getter(LoRaWANServiceProfile::drMin)).setter(setter(Builder::drMin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrMin").build()).build();

    private static final SdkField<Integer> DR_MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("DrMax")
            .getter(getter(LoRaWANServiceProfile::drMax)).setter(setter(Builder::drMax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrMax").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_GW_METADATA_FIELD,
            DR_MIN_FIELD, DR_MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean addGwMetadata;

    private final Integer drMin;

    private final Integer drMax;

    private LoRaWANServiceProfile(BuilderImpl builder) {
        this.addGwMetadata = builder.addGwMetadata;
        this.drMin = builder.drMin;
        this.drMax = builder.drMax;
    }

    /**
     * <p>
     * The AddGWMetaData value.
     * </p>
     * 
     * @return The AddGWMetaData value.
     */
    public final Boolean addGwMetadata() {
        return addGwMetadata;
    }

    /**
     * <p>
     * The DrMin value.
     * </p>
     * 
     * @return The DrMin value.
     */
    public final Integer drMin() {
        return drMin;
    }

    /**
     * <p>
     * The DrMax value.
     * </p>
     * 
     * @return The DrMax value.
     */
    public final Integer drMax() {
        return drMax;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addGwMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(drMin());
        hashCode = 31 * hashCode + Objects.hashCode(drMax());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANServiceProfile)) {
            return false;
        }
        LoRaWANServiceProfile other = (LoRaWANServiceProfile) obj;
        return Objects.equals(addGwMetadata(), other.addGwMetadata()) && Objects.equals(drMin(), other.drMin())
                && Objects.equals(drMax(), other.drMax());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANServiceProfile").add("AddGwMetadata", addGwMetadata()).add("DrMin", drMin())
                .add("DrMax", drMax()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddGwMetadata":
            return Optional.ofNullable(clazz.cast(addGwMetadata()));
        case "DrMin":
            return Optional.ofNullable(clazz.cast(drMin()));
        case "DrMax":
            return Optional.ofNullable(clazz.cast(drMax()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANServiceProfile, T> g) {
        return obj -> g.apply((LoRaWANServiceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANServiceProfile> {
        /**
         * <p>
         * The AddGWMetaData value.
         * </p>
         * 
         * @param addGwMetadata
         *        The AddGWMetaData value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGwMetadata(Boolean addGwMetadata);

        /**
         * <p>
         * The DrMin value.
         * </p>
         * 
         * @param drMin
         *        The DrMin value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drMin(Integer drMin);

        /**
         * <p>
         * The DrMax value.
         * </p>
         * 
         * @param drMax
         *        The DrMax value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drMax(Integer drMax);
    }

    static final class BuilderImpl implements Builder {
        private Boolean addGwMetadata;

        private Integer drMin;

        private Integer drMax;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANServiceProfile model) {
            addGwMetadata(model.addGwMetadata);
            drMin(model.drMin);
            drMax(model.drMax);
        }

        public final Boolean getAddGwMetadata() {
            return addGwMetadata;
        }

        public final void setAddGwMetadata(Boolean addGwMetadata) {
            this.addGwMetadata = addGwMetadata;
        }

        @Override
        public final Builder addGwMetadata(Boolean addGwMetadata) {
            this.addGwMetadata = addGwMetadata;
            return this;
        }

        public final Integer getDrMin() {
            return drMin;
        }

        public final void setDrMin(Integer drMin) {
            this.drMin = drMin;
        }

        @Override
        public final Builder drMin(Integer drMin) {
            this.drMin = drMin;
            return this;
        }

        public final Integer getDrMax() {
            return drMax;
        }

        public final void setDrMax(Integer drMax) {
            this.drMax = drMax;
        }

        @Override
        public final Builder drMax(Integer drMax) {
            this.drMax = drMax;
            return this;
        }

        @Override
        public LoRaWANServiceProfile build() {
            return new LoRaWANServiceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
