/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CDMA (Code-division multiple access) object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdmaObj implements SdkPojo, Serializable, ToCopyableBuilder<CdmaObj.Builder, CdmaObj> {
    private static final SdkField<Integer> SYSTEM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SystemId").getter(getter(CdmaObj::systemId)).setter(setter(Builder::systemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemId").build()).build();

    private static final SdkField<Integer> NETWORK_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkId").getter(getter(CdmaObj::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()).build();

    private static final SdkField<Integer> BASE_STATION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BaseStationId").getter(getter(CdmaObj::baseStationId)).setter(setter(Builder::baseStationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseStationId").build()).build();

    private static final SdkField<Integer> REGISTRATION_ZONE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RegistrationZone").getter(getter(CdmaObj::registrationZone)).setter(setter(Builder::registrationZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationZone").build()).build();

    private static final SdkField<CdmaLocalId> CDMA_LOCAL_ID_FIELD = SdkField.<CdmaLocalId> builder(MarshallingType.SDK_POJO)
            .memberName("CdmaLocalId").getter(getter(CdmaObj::cdmaLocalId)).setter(setter(Builder::cdmaLocalId))
            .constructor(CdmaLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaLocalId").build()).build();

    private static final SdkField<Integer> PILOT_POWER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PilotPower").getter(getter(CdmaObj::pilotPower)).setter(setter(Builder::pilotPower))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PilotPower").build()).build();

    private static final SdkField<Float> BASE_LAT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("BaseLat")
            .getter(getter(CdmaObj::baseLat)).setter(setter(Builder::baseLat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLat").build()).build();

    private static final SdkField<Float> BASE_LNG_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("BaseLng")
            .getter(getter(CdmaObj::baseLng)).setter(setter(Builder::baseLng))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLng").build()).build();

    private static final SdkField<List<CdmaNmrObj>> CDMA_NMR_FIELD = SdkField
            .<List<CdmaNmrObj>> builder(MarshallingType.LIST)
            .memberName("CdmaNmr")
            .getter(getter(CdmaObj::cdmaNmr))
            .setter(setter(Builder::cdmaNmr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaNmr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CdmaNmrObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(CdmaNmrObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ID_FIELD,
            NETWORK_ID_FIELD, BASE_STATION_ID_FIELD, REGISTRATION_ZONE_FIELD, CDMA_LOCAL_ID_FIELD, PILOT_POWER_FIELD,
            BASE_LAT_FIELD, BASE_LNG_FIELD, CDMA_NMR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer systemId;

    private final Integer networkId;

    private final Integer baseStationId;

    private final Integer registrationZone;

    private final CdmaLocalId cdmaLocalId;

    private final Integer pilotPower;

    private final Float baseLat;

    private final Float baseLng;

    private final List<CdmaNmrObj> cdmaNmr;

    private CdmaObj(BuilderImpl builder) {
        this.systemId = builder.systemId;
        this.networkId = builder.networkId;
        this.baseStationId = builder.baseStationId;
        this.registrationZone = builder.registrationZone;
        this.cdmaLocalId = builder.cdmaLocalId;
        this.pilotPower = builder.pilotPower;
        this.baseLat = builder.baseLat;
        this.baseLng = builder.baseLng;
        this.cdmaNmr = builder.cdmaNmr;
    }

    /**
     * <p>
     * CDMA system ID (SID).
     * </p>
     * 
     * @return CDMA system ID (SID).
     */
    public final Integer systemId() {
        return systemId;
    }

    /**
     * <p>
     * CDMA network ID (NID).
     * </p>
     * 
     * @return CDMA network ID (NID).
     */
    public final Integer networkId() {
        return networkId;
    }

    /**
     * <p>
     * CDMA base station ID (BSID).
     * </p>
     * 
     * @return CDMA base station ID (BSID).
     */
    public final Integer baseStationId() {
        return baseStationId;
    }

    /**
     * <p>
     * CDMA registration zone (RZ).
     * </p>
     * 
     * @return CDMA registration zone (RZ).
     */
    public final Integer registrationZone() {
        return registrationZone;
    }

    /**
     * <p>
     * CDMA local identification (local ID) parameters.
     * </p>
     * 
     * @return CDMA local identification (local ID) parameters.
     */
    public final CdmaLocalId cdmaLocalId() {
        return cdmaLocalId;
    }

    /**
     * <p>
     * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     */
    public final Integer pilotPower() {
        return pilotPower;
    }

    /**
     * <p>
     * CDMA base station latitude in degrees.
     * </p>
     * 
     * @return CDMA base station latitude in degrees.
     */
    public final Float baseLat() {
        return baseLat;
    }

    /**
     * <p>
     * CDMA base station longtitude in degrees.
     * </p>
     * 
     * @return CDMA base station longtitude in degrees.
     */
    public final Float baseLng() {
        return baseLng;
    }

    /**
     * For responses, this returns true if the service returned a value for the CdmaNmr property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCdmaNmr() {
        return cdmaNmr != null && !(cdmaNmr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * CDMA network measurement reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCdmaNmr} method.
     * </p>
     * 
     * @return CDMA network measurement reports.
     */
    public final List<CdmaNmrObj> cdmaNmr() {
        return cdmaNmr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemId());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(baseStationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationZone());
        hashCode = 31 * hashCode + Objects.hashCode(cdmaLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(pilotPower());
        hashCode = 31 * hashCode + Objects.hashCode(baseLat());
        hashCode = 31 * hashCode + Objects.hashCode(baseLng());
        hashCode = 31 * hashCode + Objects.hashCode(hasCdmaNmr() ? cdmaNmr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdmaObj)) {
            return false;
        }
        CdmaObj other = (CdmaObj) obj;
        return Objects.equals(systemId(), other.systemId()) && Objects.equals(networkId(), other.networkId())
                && Objects.equals(baseStationId(), other.baseStationId())
                && Objects.equals(registrationZone(), other.registrationZone())
                && Objects.equals(cdmaLocalId(), other.cdmaLocalId()) && Objects.equals(pilotPower(), other.pilotPower())
                && Objects.equals(baseLat(), other.baseLat()) && Objects.equals(baseLng(), other.baseLng())
                && hasCdmaNmr() == other.hasCdmaNmr() && Objects.equals(cdmaNmr(), other.cdmaNmr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdmaObj").add("SystemId", systemId()).add("NetworkId", networkId())
                .add("BaseStationId", baseStationId()).add("RegistrationZone", registrationZone())
                .add("CdmaLocalId", cdmaLocalId()).add("PilotPower", pilotPower()).add("BaseLat", baseLat())
                .add("BaseLng", baseLng()).add("CdmaNmr", hasCdmaNmr() ? cdmaNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SystemId":
            return Optional.ofNullable(clazz.cast(systemId()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "BaseStationId":
            return Optional.ofNullable(clazz.cast(baseStationId()));
        case "RegistrationZone":
            return Optional.ofNullable(clazz.cast(registrationZone()));
        case "CdmaLocalId":
            return Optional.ofNullable(clazz.cast(cdmaLocalId()));
        case "PilotPower":
            return Optional.ofNullable(clazz.cast(pilotPower()));
        case "BaseLat":
            return Optional.ofNullable(clazz.cast(baseLat()));
        case "BaseLng":
            return Optional.ofNullable(clazz.cast(baseLng()));
        case "CdmaNmr":
            return Optional.ofNullable(clazz.cast(cdmaNmr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CdmaObj, T> g) {
        return obj -> g.apply((CdmaObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdmaObj> {
        /**
         * <p>
         * CDMA system ID (SID).
         * </p>
         * 
         * @param systemId
         *        CDMA system ID (SID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemId(Integer systemId);

        /**
         * <p>
         * CDMA network ID (NID).
         * </p>
         * 
         * @param networkId
         *        CDMA network ID (NID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(Integer networkId);

        /**
         * <p>
         * CDMA base station ID (BSID).
         * </p>
         * 
         * @param baseStationId
         *        CDMA base station ID (BSID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseStationId(Integer baseStationId);

        /**
         * <p>
         * CDMA registration zone (RZ).
         * </p>
         * 
         * @param registrationZone
         *        CDMA registration zone (RZ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationZone(Integer registrationZone);

        /**
         * <p>
         * CDMA local identification (local ID) parameters.
         * </p>
         * 
         * @param cdmaLocalId
         *        CDMA local identification (local ID) parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdmaLocalId(CdmaLocalId cdmaLocalId);

        /**
         * <p>
         * CDMA local identification (local ID) parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link CdmaLocalId.Builder} avoiding the need to
         * create one manually via {@link CdmaLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CdmaLocalId.Builder#build()} is called immediately and its result
         * is passed to {@link #cdmaLocalId(CdmaLocalId)}.
         * 
         * @param cdmaLocalId
         *        a consumer that will call methods on {@link CdmaLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdmaLocalId(CdmaLocalId)
         */
        default Builder cdmaLocalId(Consumer<CdmaLocalId.Builder> cdmaLocalId) {
            return cdmaLocalId(CdmaLocalId.builder().applyMutation(cdmaLocalId).build());
        }

        /**
         * <p>
         * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param pilotPower
         *        Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pilotPower(Integer pilotPower);

        /**
         * <p>
         * CDMA base station latitude in degrees.
         * </p>
         * 
         * @param baseLat
         *        CDMA base station latitude in degrees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseLat(Float baseLat);

        /**
         * <p>
         * CDMA base station longtitude in degrees.
         * </p>
         * 
         * @param baseLng
         *        CDMA base station longtitude in degrees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseLng(Float baseLng);

        /**
         * <p>
         * CDMA network measurement reports.
         * </p>
         * 
         * @param cdmaNmr
         *        CDMA network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdmaNmr(Collection<CdmaNmrObj> cdmaNmr);

        /**
         * <p>
         * CDMA network measurement reports.
         * </p>
         * 
         * @param cdmaNmr
         *        CDMA network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdmaNmr(CdmaNmrObj... cdmaNmr);

        /**
         * <p>
         * CDMA network measurement reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj.Builder#build()} is called immediately
         * and its result is passed to {@link #cdmaNmr(List<CdmaNmrObj>)}.
         * 
         * @param cdmaNmr
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdmaNmr(java.util.Collection<CdmaNmrObj>)
         */
        Builder cdmaNmr(Consumer<CdmaNmrObj.Builder>... cdmaNmr);
    }

    static final class BuilderImpl implements Builder {
        private Integer systemId;

        private Integer networkId;

        private Integer baseStationId;

        private Integer registrationZone;

        private CdmaLocalId cdmaLocalId;

        private Integer pilotPower;

        private Float baseLat;

        private Float baseLng;

        private List<CdmaNmrObj> cdmaNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CdmaObj model) {
            systemId(model.systemId);
            networkId(model.networkId);
            baseStationId(model.baseStationId);
            registrationZone(model.registrationZone);
            cdmaLocalId(model.cdmaLocalId);
            pilotPower(model.pilotPower);
            baseLat(model.baseLat);
            baseLng(model.baseLng);
            cdmaNmr(model.cdmaNmr);
        }

        public final Integer getSystemId() {
            return systemId;
        }

        public final void setSystemId(Integer systemId) {
            this.systemId = systemId;
        }

        @Override
        public final Builder systemId(Integer systemId) {
            this.systemId = systemId;
            return this;
        }

        public final Integer getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final Integer getBaseStationId() {
            return baseStationId;
        }

        public final void setBaseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
        }

        @Override
        public final Builder baseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
            return this;
        }

        public final Integer getRegistrationZone() {
            return registrationZone;
        }

        public final void setRegistrationZone(Integer registrationZone) {
            this.registrationZone = registrationZone;
        }

        @Override
        public final Builder registrationZone(Integer registrationZone) {
            this.registrationZone = registrationZone;
            return this;
        }

        public final CdmaLocalId.Builder getCdmaLocalId() {
            return cdmaLocalId != null ? cdmaLocalId.toBuilder() : null;
        }

        public final void setCdmaLocalId(CdmaLocalId.BuilderImpl cdmaLocalId) {
            this.cdmaLocalId = cdmaLocalId != null ? cdmaLocalId.build() : null;
        }

        @Override
        public final Builder cdmaLocalId(CdmaLocalId cdmaLocalId) {
            this.cdmaLocalId = cdmaLocalId;
            return this;
        }

        public final Integer getPilotPower() {
            return pilotPower;
        }

        public final void setPilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
        }

        @Override
        public final Builder pilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
            return this;
        }

        public final Float getBaseLat() {
            return baseLat;
        }

        public final void setBaseLat(Float baseLat) {
            this.baseLat = baseLat;
        }

        @Override
        public final Builder baseLat(Float baseLat) {
            this.baseLat = baseLat;
            return this;
        }

        public final Float getBaseLng() {
            return baseLng;
        }

        public final void setBaseLng(Float baseLng) {
            this.baseLng = baseLng;
        }

        @Override
        public final Builder baseLng(Float baseLng) {
            this.baseLng = baseLng;
            return this;
        }

        public final List<CdmaNmrObj.Builder> getCdmaNmr() {
            List<CdmaNmrObj.Builder> result = CdmaNmrListCopier.copyToBuilder(this.cdmaNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCdmaNmr(Collection<CdmaNmrObj.BuilderImpl> cdmaNmr) {
            this.cdmaNmr = CdmaNmrListCopier.copyFromBuilder(cdmaNmr);
        }

        @Override
        public final Builder cdmaNmr(Collection<CdmaNmrObj> cdmaNmr) {
            this.cdmaNmr = CdmaNmrListCopier.copy(cdmaNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdmaNmr(CdmaNmrObj... cdmaNmr) {
            cdmaNmr(Arrays.asList(cdmaNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdmaNmr(Consumer<CdmaNmrObj.Builder>... cdmaNmr) {
            cdmaNmr(Stream.of(cdmaNmr).map(c -> CdmaNmrObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CdmaObj build() {
            return new CdmaObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
