/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * GSM local ID information, which corresponds to the local identification parameters of a GSM cell.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GsmLocalId implements SdkPojo, Serializable, ToCopyableBuilder<GsmLocalId.Builder, GsmLocalId> {
    private static final SdkField<Integer> BSIC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Bsic")
            .getter(getter(GsmLocalId::bsic)).setter(setter(Builder::bsic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bsic").build()).build();

    private static final SdkField<Integer> BCCH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Bcch")
            .getter(getter(GsmLocalId::bcch)).setter(setter(Builder::bcch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bcch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BSIC_FIELD, BCCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bsic;

    private final Integer bcch;

    private GsmLocalId(BuilderImpl builder) {
        this.bsic = builder.bsic;
        this.bcch = builder.bcch;
    }

    /**
     * <p>
     * GSM base station identity code (BSIC).
     * </p>
     * 
     * @return GSM base station identity code (BSIC).
     */
    public final Integer bsic() {
        return bsic;
    }

    /**
     * <p>
     * GSM broadcast control channel.
     * </p>
     * 
     * @return GSM broadcast control channel.
     */
    public final Integer bcch() {
        return bcch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bsic());
        hashCode = 31 * hashCode + Objects.hashCode(bcch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GsmLocalId)) {
            return false;
        }
        GsmLocalId other = (GsmLocalId) obj;
        return Objects.equals(bsic(), other.bsic()) && Objects.equals(bcch(), other.bcch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GsmLocalId").add("Bsic", bsic()).add("Bcch", bcch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bsic":
            return Optional.ofNullable(clazz.cast(bsic()));
        case "Bcch":
            return Optional.ofNullable(clazz.cast(bcch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GsmLocalId, T> g) {
        return obj -> g.apply((GsmLocalId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GsmLocalId> {
        /**
         * <p>
         * GSM base station identity code (BSIC).
         * </p>
         * 
         * @param bsic
         *        GSM base station identity code (BSIC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bsic(Integer bsic);

        /**
         * <p>
         * GSM broadcast control channel.
         * </p>
         * 
         * @param bcch
         *        GSM broadcast control channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bcch(Integer bcch);
    }

    static final class BuilderImpl implements Builder {
        private Integer bsic;

        private Integer bcch;

        private BuilderImpl() {
        }

        private BuilderImpl(GsmLocalId model) {
            bsic(model.bsic);
            bcch(model.bcch);
        }

        public final Integer getBsic() {
            return bsic;
        }

        public final void setBsic(Integer bsic) {
            this.bsic = bsic;
        }

        @Override
        public final Builder bsic(Integer bsic) {
            this.bsic = bsic;
            return this;
        }

        public final Integer getBcch() {
            return bcch;
        }

        public final void setBcch(Integer bcch) {
            this.bcch = bcch;
        }

        @Override
        public final Builder bcch(Integer bcch) {
            this.bcch = bcch;
            return this;
        }

        @Override
        public GsmLocalId build() {
            return new GsmLocalId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
