/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesForWirelessDeviceImportTaskResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListDevicesForWirelessDeviceImportTaskResponse.Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDevicesForWirelessDeviceImportTaskResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(ListDevicesForWirelessDeviceImportTaskResponse::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<List<ImportedWirelessDevice>> IMPORTED_WIRELESS_DEVICE_LIST_FIELD = SdkField
            .<List<ImportedWirelessDevice>> builder(MarshallingType.LIST)
            .memberName("ImportedWirelessDeviceList")
            .getter(getter(ListDevicesForWirelessDeviceImportTaskResponse::importedWirelessDeviceList))
            .setter(setter(Builder::importedWirelessDeviceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedWirelessDeviceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportedWirelessDevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportedWirelessDevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            DESTINATION_NAME_FIELD, IMPORTED_WIRELESS_DEVICE_LIST_FIELD));

    private final String nextToken;

    private final String destinationName;

    private final List<ImportedWirelessDevice> importedWirelessDeviceList;

    private ListDevicesForWirelessDeviceImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.destinationName = builder.destinationName;
        this.importedWirelessDeviceList = builder.importedWirelessDeviceList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <code>null</code> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the Sidewalk destination that describes the IoT rule to route messages received from devices in an
     * import task that are onboarded to AWS IoT Wireless.
     * </p>
     * 
     * @return The name of the Sidewalk destination that describes the IoT rule to route messages received from devices
     *         in an import task that are onboarded to AWS IoT Wireless.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportedWirelessDeviceList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImportedWirelessDeviceList() {
        return importedWirelessDeviceList != null && !(importedWirelessDeviceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of wireless devices in an import task and their onboarding status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportedWirelessDeviceList} method.
     * </p>
     * 
     * @return List of wireless devices in an import task and their onboarding status.
     */
    public final List<ImportedWirelessDevice> importedWirelessDeviceList() {
        return importedWirelessDeviceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasImportedWirelessDeviceList() ? importedWirelessDeviceList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesForWirelessDeviceImportTaskResponse)) {
            return false;
        }
        ListDevicesForWirelessDeviceImportTaskResponse other = (ListDevicesForWirelessDeviceImportTaskResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(destinationName(), other.destinationName())
                && hasImportedWirelessDeviceList() == other.hasImportedWirelessDeviceList()
                && Objects.equals(importedWirelessDeviceList(), other.importedWirelessDeviceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDevicesForWirelessDeviceImportTaskResponse").add("NextToken", nextToken())
                .add("DestinationName", destinationName())
                .add("ImportedWirelessDeviceList", hasImportedWirelessDeviceList() ? importedWirelessDeviceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "ImportedWirelessDeviceList":
            return Optional.ofNullable(clazz.cast(importedWirelessDeviceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesForWirelessDeviceImportTaskResponse, T> g) {
        return obj -> g.apply((ListDevicesForWirelessDeviceImportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
        /**
         * <p>
         * The token to use to get the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <code>null</code> if there are no additional
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the Sidewalk destination that describes the IoT rule to route messages received from devices in
         * an import task that are onboarded to AWS IoT Wireless.
         * </p>
         * 
         * @param destinationName
         *        The name of the Sidewalk destination that describes the IoT rule to route messages received from
         *        devices in an import task that are onboarded to AWS IoT Wireless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * List of wireless devices in an import task and their onboarding status.
         * </p>
         * 
         * @param importedWirelessDeviceList
         *        List of wireless devices in an import task and their onboarding status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> importedWirelessDeviceList);

        /**
         * <p>
         * List of wireless devices in an import task and their onboarding status.
         * </p>
         * 
         * @param importedWirelessDeviceList
         *        List of wireless devices in an import task and their onboarding status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedWirelessDeviceList(ImportedWirelessDevice... importedWirelessDeviceList);

        /**
         * <p>
         * List of wireless devices in an import task and their onboarding status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice.Builder#build()} is called
         * immediately and its result is passed to {@link #importedWirelessDeviceList(List<ImportedWirelessDevice>)}.
         * 
         * @param importedWirelessDeviceList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importedWirelessDeviceList(java.util.Collection<ImportedWirelessDevice>)
         */
        Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder>... importedWirelessDeviceList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String destinationName;

        private List<ImportedWirelessDevice> importedWirelessDeviceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesForWirelessDeviceImportTaskResponse model) {
            super(model);
            nextToken(model.nextToken);
            destinationName(model.destinationName);
            importedWirelessDeviceList(model.importedWirelessDeviceList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final List<ImportedWirelessDevice.Builder> getImportedWirelessDeviceList() {
            List<ImportedWirelessDevice.Builder> result = ImportedWirelessDeviceListCopier
                    .copyToBuilder(this.importedWirelessDeviceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportedWirelessDeviceList(Collection<ImportedWirelessDevice.BuilderImpl> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copyFromBuilder(importedWirelessDeviceList);
        }

        @Override
        public final Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copy(importedWirelessDeviceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(ImportedWirelessDevice... importedWirelessDeviceList) {
            importedWirelessDeviceList(Arrays.asList(importedWirelessDeviceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder>... importedWirelessDeviceList) {
            importedWirelessDeviceList(Stream.of(importedWirelessDeviceList)
                    .map(c -> ImportedWirelessDevice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDevicesForWirelessDeviceImportTaskResponse build() {
            return new ListDevicesForWirelessDeviceImportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
