/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN object for update functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANUpdateDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANUpdateDevice.Builder, LoRaWANUpdateDevice> {
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(LoRaWANUpdateDevice::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()).build();

    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProfileId").getter(getter(LoRaWANUpdateDevice::serviceProfileId))
            .setter(setter(Builder::serviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()).build();

    private static final SdkField<UpdateAbpV1_1> ABP_V1_1_FIELD = SdkField.<UpdateAbpV1_1> builder(MarshallingType.SDK_POJO)
            .memberName("AbpV1_1").getter(getter(LoRaWANUpdateDevice::abpV1_1)).setter(setter(Builder::abpV1_1))
            .constructor(UpdateAbpV1_1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_1").build()).build();

    private static final SdkField<UpdateAbpV1_0_x> ABP_V1_0_X_FIELD = SdkField
            .<UpdateAbpV1_0_x> builder(MarshallingType.SDK_POJO).memberName("AbpV1_0_x")
            .getter(getter(LoRaWANUpdateDevice::abpV1_0_x)).setter(setter(Builder::abpV1_0_x))
            .constructor(UpdateAbpV1_0_x::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_0_x").build()).build();

    private static final SdkField<UpdateFPorts> F_PORTS_FIELD = SdkField.<UpdateFPorts> builder(MarshallingType.SDK_POJO)
            .memberName("FPorts").getter(getter(LoRaWANUpdateDevice::fPorts)).setter(setter(Builder::fPorts))
            .constructor(UpdateFPorts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPorts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_PROFILE_ID_FIELD,
            SERVICE_PROFILE_ID_FIELD, ABP_V1_1_FIELD, ABP_V1_0_X_FIELD, F_PORTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceProfileId;

    private final String serviceProfileId;

    private final UpdateAbpV1_1 abpV1_1;

    private final UpdateAbpV1_0_x abpV1_0_x;

    private final UpdateFPorts fPorts;

    private LoRaWANUpdateDevice(BuilderImpl builder) {
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.abpV1_1 = builder.abpV1_1;
        this.abpV1_0_x = builder.abpV1_0_x;
        this.fPorts = builder.fPorts;
    }

    /**
     * <p>
     * The ID of the device profile for the wireless device.
     * </p>
     * 
     * @return The ID of the device profile for the wireless device.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * The ID of the service profile.
     * </p>
     * 
     * @return The ID of the service profile.
     */
    public final String serviceProfileId() {
        return serviceProfileId;
    }

    /**
     * <p>
     * ABP device object for update APIs for v1.1
     * </p>
     * 
     * @return ABP device object for update APIs for v1.1
     */
    public final UpdateAbpV1_1 abpV1_1() {
        return abpV1_1;
    }

    /**
     * <p>
     * ABP device object for update APIs for v1.0.x
     * </p>
     * 
     * @return ABP device object for update APIs for v1.0.x
     */
    public final UpdateAbpV1_0_x abpV1_0_x() {
        return abpV1_0_x;
    }

    /**
     * <p>
     * FPorts object for the positioning information of the device.
     * </p>
     * 
     * @return FPorts object for the positioning information of the device.
     */
    public final UpdateFPorts fPorts() {
        return fPorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(abpV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(abpV1_0_x());
        hashCode = 31 * hashCode + Objects.hashCode(fPorts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANUpdateDevice)) {
            return false;
        }
        LoRaWANUpdateDevice other = (LoRaWANUpdateDevice) obj;
        return Objects.equals(deviceProfileId(), other.deviceProfileId())
                && Objects.equals(serviceProfileId(), other.serviceProfileId()) && Objects.equals(abpV1_1(), other.abpV1_1())
                && Objects.equals(abpV1_0_x(), other.abpV1_0_x()) && Objects.equals(fPorts(), other.fPorts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANUpdateDevice").add("DeviceProfileId", deviceProfileId())
                .add("ServiceProfileId", serviceProfileId()).add("AbpV1_1", abpV1_1()).add("AbpV1_0_x", abpV1_0_x())
                .add("FPorts", fPorts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "ServiceProfileId":
            return Optional.ofNullable(clazz.cast(serviceProfileId()));
        case "AbpV1_1":
            return Optional.ofNullable(clazz.cast(abpV1_1()));
        case "AbpV1_0_x":
            return Optional.ofNullable(clazz.cast(abpV1_0_x()));
        case "FPorts":
            return Optional.ofNullable(clazz.cast(fPorts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANUpdateDevice, T> g) {
        return obj -> g.apply((LoRaWANUpdateDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANUpdateDevice> {
        /**
         * <p>
         * The ID of the device profile for the wireless device.
         * </p>
         * 
         * @param deviceProfileId
         *        The ID of the device profile for the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * The ID of the service profile.
         * </p>
         * 
         * @param serviceProfileId
         *        The ID of the service profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProfileId(String serviceProfileId);

        /**
         * <p>
         * ABP device object for update APIs for v1.1
         * </p>
         * 
         * @param abpV1_1
         *        ABP device object for update APIs for v1.1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abpV1_1(UpdateAbpV1_1 abpV1_1);

        /**
         * <p>
         * ABP device object for update APIs for v1.1
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateAbpV1_1.Builder} avoiding the need
         * to create one manually via {@link UpdateAbpV1_1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateAbpV1_1.Builder#build()} is called immediately and its
         * result is passed to {@link #abpV1_1(UpdateAbpV1_1)}.
         * 
         * @param abpV1_1
         *        a consumer that will call methods on {@link UpdateAbpV1_1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abpV1_1(UpdateAbpV1_1)
         */
        default Builder abpV1_1(Consumer<UpdateAbpV1_1.Builder> abpV1_1) {
            return abpV1_1(UpdateAbpV1_1.builder().applyMutation(abpV1_1).build());
        }

        /**
         * <p>
         * ABP device object for update APIs for v1.0.x
         * </p>
         * 
         * @param abpV1_0_x
         *        ABP device object for update APIs for v1.0.x
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abpV1_0_x(UpdateAbpV1_0_x abpV1_0_x);

        /**
         * <p>
         * ABP device object for update APIs for v1.0.x
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateAbpV1_0_x.Builder} avoiding the
         * need to create one manually via {@link UpdateAbpV1_0_x#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateAbpV1_0_x.Builder#build()} is called immediately and its
         * result is passed to {@link #abpV1_0_x(UpdateAbpV1_0_x)}.
         * 
         * @param abpV1_0_x
         *        a consumer that will call methods on {@link UpdateAbpV1_0_x.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abpV1_0_x(UpdateAbpV1_0_x)
         */
        default Builder abpV1_0_x(Consumer<UpdateAbpV1_0_x.Builder> abpV1_0_x) {
            return abpV1_0_x(UpdateAbpV1_0_x.builder().applyMutation(abpV1_0_x).build());
        }

        /**
         * <p>
         * FPorts object for the positioning information of the device.
         * </p>
         * 
         * @param fPorts
         *        FPorts object for the positioning information of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPorts(UpdateFPorts fPorts);

        /**
         * <p>
         * FPorts object for the positioning information of the device.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateFPorts.Builder} avoiding the need
         * to create one manually via {@link UpdateFPorts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFPorts.Builder#build()} is called immediately and its
         * result is passed to {@link #fPorts(UpdateFPorts)}.
         * 
         * @param fPorts
         *        a consumer that will call methods on {@link UpdateFPorts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fPorts(UpdateFPorts)
         */
        default Builder fPorts(Consumer<UpdateFPorts.Builder> fPorts) {
            return fPorts(UpdateFPorts.builder().applyMutation(fPorts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceProfileId;

        private String serviceProfileId;

        private UpdateAbpV1_1 abpV1_1;

        private UpdateAbpV1_0_x abpV1_0_x;

        private UpdateFPorts fPorts;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANUpdateDevice model) {
            deviceProfileId(model.deviceProfileId);
            serviceProfileId(model.serviceProfileId);
            abpV1_1(model.abpV1_1);
            abpV1_0_x(model.abpV1_0_x);
            fPorts(model.fPorts);
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final UpdateAbpV1_1.Builder getAbpV1_1() {
            return abpV1_1 != null ? abpV1_1.toBuilder() : null;
        }

        public final void setAbpV1_1(UpdateAbpV1_1.BuilderImpl abpV1_1) {
            this.abpV1_1 = abpV1_1 != null ? abpV1_1.build() : null;
        }

        @Override
        public final Builder abpV1_1(UpdateAbpV1_1 abpV1_1) {
            this.abpV1_1 = abpV1_1;
            return this;
        }

        public final UpdateAbpV1_0_x.Builder getAbpV1_0_x() {
            return abpV1_0_x != null ? abpV1_0_x.toBuilder() : null;
        }

        public final void setAbpV1_0_x(UpdateAbpV1_0_x.BuilderImpl abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x != null ? abpV1_0_x.build() : null;
        }

        @Override
        public final Builder abpV1_0_x(UpdateAbpV1_0_x abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x;
            return this;
        }

        public final UpdateFPorts.Builder getFPorts() {
            return fPorts != null ? fPorts.toBuilder() : null;
        }

        public final void setFPorts(UpdateFPorts.BuilderImpl fPorts) {
            this.fPorts = fPorts != null ? fPorts.build() : null;
        }

        @Override
        public final Builder fPorts(UpdateFPorts fPorts) {
            this.fPorts = fPorts;
            return this;
        }

        @Override
        public LoRaWANUpdateDevice build() {
            return new LoRaWANUpdateDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
