/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify the list of gateways to which you want to send downlink data traffic when the wireless device is running in
 * class B or class C mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipatingGateways implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipatingGateways.Builder, ParticipatingGateways> {
    private static final SdkField<String> DOWNLINK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DownlinkMode").getter(getter(ParticipatingGateways::downlinkModeAsString))
            .setter(setter(Builder::downlinkMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownlinkMode").build()).build();

    private static final SdkField<List<GatewayListItem>> GATEWAY_LIST_FIELD = SdkField
            .<List<GatewayListItem>> builder(MarshallingType.LIST)
            .memberName("GatewayList")
            .getter(getter(ParticipatingGateways::gatewayList))
            .setter(setter(Builder::gatewayList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TRANSMISSION_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransmissionInterval").getter(getter(ParticipatingGateways::transmissionInterval))
            .setter(setter(Builder::transmissionInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmissionInterval").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLINK_MODE_FIELD,
            GATEWAY_LIST_FIELD, TRANSMISSION_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String downlinkMode;

    private final List<GatewayListItem> gatewayList;

    private final Integer transmissionInterval;

    private ParticipatingGateways(BuilderImpl builder) {
        this.downlinkMode = builder.downlinkMode;
        this.gatewayList = builder.gatewayList;
        this.transmissionInterval = builder.transmissionInterval;
    }

    /**
     * <p>
     * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the chosen
     * gateways from the previous uplink message transmission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downlinkMode} will
     * return {@link DownlinkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downlinkModeAsString}.
     * </p>
     * 
     * @return Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the
     *         chosen gateways from the previous uplink message transmission.
     * @see DownlinkMode
     */
    public final DownlinkMode downlinkMode() {
        return DownlinkMode.fromValue(downlinkMode);
    }

    /**
     * <p>
     * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the chosen
     * gateways from the previous uplink message transmission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downlinkMode} will
     * return {@link DownlinkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downlinkModeAsString}.
     * </p>
     * 
     * @return Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the
     *         chosen gateways from the previous uplink message transmission.
     * @see DownlinkMode
     */
    public final String downlinkModeAsString() {
        return downlinkMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatewayList() {
        return gatewayList != null && !(gatewayList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of gateways that you want to use for sending the downlink data traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayList} method.
     * </p>
     * 
     * @return The list of gateways that you want to use for sending the downlink data traffic.
     */
    public final List<GatewayListItem> gatewayList() {
        return gatewayList;
    }

    /**
     * <p>
     * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the next
     * gateway.
     * </p>
     * 
     * @return The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the
     *         next gateway.
     */
    public final Integer transmissionInterval() {
        return transmissionInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(downlinkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayList() ? gatewayList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transmissionInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingGateways)) {
            return false;
        }
        ParticipatingGateways other = (ParticipatingGateways) obj;
        return Objects.equals(downlinkModeAsString(), other.downlinkModeAsString()) && hasGatewayList() == other.hasGatewayList()
                && Objects.equals(gatewayList(), other.gatewayList())
                && Objects.equals(transmissionInterval(), other.transmissionInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipatingGateways").add("DownlinkMode", downlinkModeAsString())
                .add("GatewayList", hasGatewayList() ? gatewayList() : null).add("TransmissionInterval", transmissionInterval())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DownlinkMode":
            return Optional.ofNullable(clazz.cast(downlinkModeAsString()));
        case "GatewayList":
            return Optional.ofNullable(clazz.cast(gatewayList()));
        case "TransmissionInterval":
            return Optional.ofNullable(clazz.cast(transmissionInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingGateways, T> g) {
        return obj -> g.apply((ParticipatingGateways) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipatingGateways> {
        /**
         * <p>
         * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the
         * chosen gateways from the previous uplink message transmission.
         * </p>
         * 
         * @param downlinkMode
         *        Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only
         *        the chosen gateways from the previous uplink message transmission.
         * @see DownlinkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DownlinkMode
         */
        Builder downlinkMode(String downlinkMode);

        /**
         * <p>
         * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the
         * chosen gateways from the previous uplink message transmission.
         * </p>
         * 
         * @param downlinkMode
         *        Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only
         *        the chosen gateways from the previous uplink message transmission.
         * @see DownlinkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DownlinkMode
         */
        Builder downlinkMode(DownlinkMode downlinkMode);

        /**
         * <p>
         * The list of gateways that you want to use for sending the downlink data traffic.
         * </p>
         * 
         * @param gatewayList
         *        The list of gateways that you want to use for sending the downlink data traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayList(Collection<GatewayListItem> gatewayList);

        /**
         * <p>
         * The list of gateways that you want to use for sending the downlink data traffic.
         * </p>
         * 
         * @param gatewayList
         *        The list of gateways that you want to use for sending the downlink data traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayList(GatewayListItem... gatewayList);

        /**
         * <p>
         * The list of gateways that you want to use for sending the downlink data traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.GatewayListItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.GatewayListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.GatewayListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #gatewayList(List<GatewayListItem>)}.
         * 
         * @param gatewayList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.GatewayListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayList(java.util.Collection<GatewayListItem>)
         */
        Builder gatewayList(Consumer<GatewayListItem.Builder>... gatewayList);

        /**
         * <p>
         * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the next
         * gateway.
         * </p>
         * 
         * @param transmissionInterval
         *        The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to
         *        the next gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transmissionInterval(Integer transmissionInterval);
    }

    static final class BuilderImpl implements Builder {
        private String downlinkMode;

        private List<GatewayListItem> gatewayList = DefaultSdkAutoConstructList.getInstance();

        private Integer transmissionInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingGateways model) {
            downlinkMode(model.downlinkMode);
            gatewayList(model.gatewayList);
            transmissionInterval(model.transmissionInterval);
        }

        public final String getDownlinkMode() {
            return downlinkMode;
        }

        public final void setDownlinkMode(String downlinkMode) {
            this.downlinkMode = downlinkMode;
        }

        @Override
        public final Builder downlinkMode(String downlinkMode) {
            this.downlinkMode = downlinkMode;
            return this;
        }

        @Override
        public final Builder downlinkMode(DownlinkMode downlinkMode) {
            this.downlinkMode(downlinkMode == null ? null : downlinkMode.toString());
            return this;
        }

        public final List<GatewayListItem.Builder> getGatewayList() {
            List<GatewayListItem.Builder> result = GatewayListCopier.copyToBuilder(this.gatewayList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayList(Collection<GatewayListItem.BuilderImpl> gatewayList) {
            this.gatewayList = GatewayListCopier.copyFromBuilder(gatewayList);
        }

        @Override
        public final Builder gatewayList(Collection<GatewayListItem> gatewayList) {
            this.gatewayList = GatewayListCopier.copy(gatewayList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(GatewayListItem... gatewayList) {
            gatewayList(Arrays.asList(gatewayList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(Consumer<GatewayListItem.Builder>... gatewayList) {
            gatewayList(Stream.of(gatewayList).map(c -> GatewayListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTransmissionInterval() {
            return transmissionInterval;
        }

        public final void setTransmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
        }

        @Override
        public final Builder transmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
            return this;
        }

        @Override
        public ParticipatingGateways build() {
            return new ParticipatingGateways(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
