/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPositionEstimateRequest extends IotWirelessRequest implements
        ToCopyableBuilder<GetPositionEstimateRequest.Builder, GetPositionEstimateRequest> {
    private static final SdkField<List<WiFiAccessPoint>> WI_FI_ACCESS_POINTS_FIELD = SdkField
            .<List<WiFiAccessPoint>> builder(MarshallingType.LIST)
            .memberName("WiFiAccessPoints")
            .getter(getter(GetPositionEstimateRequest::wiFiAccessPoints))
            .setter(setter(Builder::wiFiAccessPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WiFiAccessPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WiFiAccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(WiFiAccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CellTowers> CELL_TOWERS_FIELD = SdkField.<CellTowers> builder(MarshallingType.SDK_POJO)
            .memberName("CellTowers").getter(getter(GetPositionEstimateRequest::cellTowers)).setter(setter(Builder::cellTowers))
            .constructor(CellTowers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellTowers").build()).build();

    private static final SdkField<Ip> IP_FIELD = SdkField.<Ip> builder(MarshallingType.SDK_POJO).memberName("Ip")
            .getter(getter(GetPositionEstimateRequest::ip)).setter(setter(Builder::ip)).constructor(Ip::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<Gnss> GNSS_FIELD = SdkField.<Gnss> builder(MarshallingType.SDK_POJO).memberName("Gnss")
            .getter(getter(GetPositionEstimateRequest::gnss)).setter(setter(Builder::gnss)).constructor(Gnss::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gnss").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(GetPositionEstimateRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WI_FI_ACCESS_POINTS_FIELD,
            CELL_TOWERS_FIELD, IP_FIELD, GNSS_FIELD, TIMESTAMP_FIELD));

    private final List<WiFiAccessPoint> wiFiAccessPoints;

    private final CellTowers cellTowers;

    private final Ip ip;

    private final Gnss gnss;

    private final Instant timestamp;

    private GetPositionEstimateRequest(BuilderImpl builder) {
        super(builder);
        this.wiFiAccessPoints = builder.wiFiAccessPoints;
        this.cellTowers = builder.cellTowers;
        this.ip = builder.ip;
        this.gnss = builder.gnss;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the WiFiAccessPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWiFiAccessPoints() {
        return wiFiAccessPoints != null && !(wiFiAccessPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using HERE's
     * Wi-Fi based solver.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWiFiAccessPoints} method.
     * </p>
     * 
     * @return Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using
     *         HERE's Wi-Fi based solver.
     */
    public final List<WiFiAccessPoint> wiFiAccessPoints() {
        return wiFiAccessPoints;
    }

    /**
     * <p>
     * Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position is
     * resolved using HERE's cellular-based solver.
     * </p>
     * 
     * @return Retrieves an estimated device position by resolving measurement data from cellular radio towers. The
     *         position is resolved using HERE's cellular-based solver.
     */
    public final CellTowers cellTowers() {
        return cellTowers;
    }

    /**
     * <p>
     * Retrieves an estimated device position by resolving the IP address information from the device. The position is
     * resolved using MaxMind's IP-based solver.
     * </p>
     * 
     * @return Retrieves an estimated device position by resolving the IP address information from the device. The
     *         position is resolved using MaxMind's IP-based solver.
     */
    public final Ip ip() {
        return ip;
    }

    /**
     * <p>
     * Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data. The
     * position is resolved using the GNSS solver powered by LoRa Cloud.
     * </p>
     * 
     * @return Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan
     *         data. The position is resolved using the GNSS solver powered by LoRa Cloud.
     */
    public final Gnss gnss() {
        return gnss;
    }

    /**
     * <p>
     * Optional information that specifies the time when the position information will be resolved. It uses the UNIX
     * timestamp format. If not specified, the time at which the request was received will be used.
     * </p>
     * 
     * @return Optional information that specifies the time when the position information will be resolved. It uses the
     *         UNIX timestamp format. If not specified, the time at which the request was received will be used.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWiFiAccessPoints() ? wiFiAccessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cellTowers());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(gnss());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionEstimateRequest)) {
            return false;
        }
        GetPositionEstimateRequest other = (GetPositionEstimateRequest) obj;
        return hasWiFiAccessPoints() == other.hasWiFiAccessPoints()
                && Objects.equals(wiFiAccessPoints(), other.wiFiAccessPoints())
                && Objects.equals(cellTowers(), other.cellTowers()) && Objects.equals(ip(), other.ip())
                && Objects.equals(gnss(), other.gnss()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPositionEstimateRequest")
                .add("WiFiAccessPoints", hasWiFiAccessPoints() ? wiFiAccessPoints() : null).add("CellTowers", cellTowers())
                .add("Ip", ip()).add("Gnss", gnss()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WiFiAccessPoints":
            return Optional.ofNullable(clazz.cast(wiFiAccessPoints()));
        case "CellTowers":
            return Optional.ofNullable(clazz.cast(cellTowers()));
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Gnss":
            return Optional.ofNullable(clazz.cast(gnss()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPositionEstimateRequest, T> g) {
        return obj -> g.apply((GetPositionEstimateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPositionEstimateRequest> {
        /**
         * <p>
         * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using
         * HERE's Wi-Fi based solver.
         * </p>
         * 
         * @param wiFiAccessPoints
         *        Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved
         *        using HERE's Wi-Fi based solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints);

        /**
         * <p>
         * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using
         * HERE's Wi-Fi based solver.
         * </p>
         * 
         * @param wiFiAccessPoints
         *        Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved
         *        using HERE's Wi-Fi based solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wiFiAccessPoints(WiFiAccessPoint... wiFiAccessPoints);

        /**
         * <p>
         * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using
         * HERE's Wi-Fi based solver.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint.Builder#build()} is called
         * immediately and its result is passed to {@link #wiFiAccessPoints(List<WiFiAccessPoint>)}.
         * 
         * @param wiFiAccessPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wiFiAccessPoints(java.util.Collection<WiFiAccessPoint>)
         */
        Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder>... wiFiAccessPoints);

        /**
         * <p>
         * Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position
         * is resolved using HERE's cellular-based solver.
         * </p>
         * 
         * @param cellTowers
         *        Retrieves an estimated device position by resolving measurement data from cellular radio towers. The
         *        position is resolved using HERE's cellular-based solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellTowers(CellTowers cellTowers);

        /**
         * <p>
         * Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position
         * is resolved using HERE's cellular-based solver.
         * </p>
         * This is a convenience method that creates an instance of the {@link CellTowers.Builder} avoiding the need to
         * create one manually via {@link CellTowers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CellTowers.Builder#build()} is called immediately and its result
         * is passed to {@link #cellTowers(CellTowers)}.
         * 
         * @param cellTowers
         *        a consumer that will call methods on {@link CellTowers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellTowers(CellTowers)
         */
        default Builder cellTowers(Consumer<CellTowers.Builder> cellTowers) {
            return cellTowers(CellTowers.builder().applyMutation(cellTowers).build());
        }

        /**
         * <p>
         * Retrieves an estimated device position by resolving the IP address information from the device. The position
         * is resolved using MaxMind's IP-based solver.
         * </p>
         * 
         * @param ip
         *        Retrieves an estimated device position by resolving the IP address information from the device. The
         *        position is resolved using MaxMind's IP-based solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(Ip ip);

        /**
         * <p>
         * Retrieves an estimated device position by resolving the IP address information from the device. The position
         * is resolved using MaxMind's IP-based solver.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ip.Builder} avoiding the need to create
         * one manually via {@link Ip#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ip.Builder#build()} is called immediately and its result is
         * passed to {@link #ip(Ip)}.
         * 
         * @param ip
         *        a consumer that will call methods on {@link Ip.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ip(Ip)
         */
        default Builder ip(Consumer<Ip.Builder> ip) {
            return ip(Ip.builder().applyMutation(ip).build());
        }

        /**
         * <p>
         * Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data.
         * The position is resolved using the GNSS solver powered by LoRa Cloud.
         * </p>
         * 
         * @param gnss
         *        Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan
         *        data. The position is resolved using the GNSS solver powered by LoRa Cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gnss(Gnss gnss);

        /**
         * <p>
         * Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data.
         * The position is resolved using the GNSS solver powered by LoRa Cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link Gnss.Builder} avoiding the need to create
         * one manually via {@link Gnss#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Gnss.Builder#build()} is called immediately and its result is
         * passed to {@link #gnss(Gnss)}.
         * 
         * @param gnss
         *        a consumer that will call methods on {@link Gnss.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gnss(Gnss)
         */
        default Builder gnss(Consumer<Gnss.Builder> gnss) {
            return gnss(Gnss.builder().applyMutation(gnss).build());
        }

        /**
         * <p>
         * Optional information that specifies the time when the position information will be resolved. It uses the UNIX
         * timestamp format. If not specified, the time at which the request was received will be used.
         * </p>
         * 
         * @param timestamp
         *        Optional information that specifies the time when the position information will be resolved. It uses
         *        the UNIX timestamp format. If not specified, the time at which the request was received will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private List<WiFiAccessPoint> wiFiAccessPoints = DefaultSdkAutoConstructList.getInstance();

        private CellTowers cellTowers;

        private Ip ip;

        private Gnss gnss;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionEstimateRequest model) {
            super(model);
            wiFiAccessPoints(model.wiFiAccessPoints);
            cellTowers(model.cellTowers);
            ip(model.ip);
            gnss(model.gnss);
            timestamp(model.timestamp);
        }

        public final List<WiFiAccessPoint.Builder> getWiFiAccessPoints() {
            List<WiFiAccessPoint.Builder> result = WiFiAccessPointsCopier.copyToBuilder(this.wiFiAccessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWiFiAccessPoints(Collection<WiFiAccessPoint.BuilderImpl> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointsCopier.copyFromBuilder(wiFiAccessPoints);
        }

        @Override
        public final Builder wiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointsCopier.copy(wiFiAccessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(WiFiAccessPoint... wiFiAccessPoints) {
            wiFiAccessPoints(Arrays.asList(wiFiAccessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder>... wiFiAccessPoints) {
            wiFiAccessPoints(Stream.of(wiFiAccessPoints).map(c -> WiFiAccessPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CellTowers.Builder getCellTowers() {
            return cellTowers != null ? cellTowers.toBuilder() : null;
        }

        public final void setCellTowers(CellTowers.BuilderImpl cellTowers) {
            this.cellTowers = cellTowers != null ? cellTowers.build() : null;
        }

        @Override
        public final Builder cellTowers(CellTowers cellTowers) {
            this.cellTowers = cellTowers;
            return this;
        }

        public final Ip.Builder getIp() {
            return ip != null ? ip.toBuilder() : null;
        }

        public final void setIp(Ip.BuilderImpl ip) {
            this.ip = ip != null ? ip.build() : null;
        }

        @Override
        public final Builder ip(Ip ip) {
            this.ip = ip;
            return this;
        }

        public final Gnss.Builder getGnss() {
            return gnss != null ? gnss.toBuilder() : null;
        }

        public final void setGnss(Gnss.BuilderImpl gnss) {
            this.gnss = gnss != null ? gnss.build() : null;
        }

        @Override
        public final Builder gnss(Gnss gnss) {
            this.gnss = gnss;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPositionEstimateRequest build() {
            return new GetPositionEstimateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
