/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The wrapper for position solver details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PositionSolverDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PositionSolverDetails.Builder, PositionSolverDetails> {
    private static final SdkField<SemtechGnssDetail> SEMTECH_GNSS_FIELD = SdkField
            .<SemtechGnssDetail> builder(MarshallingType.SDK_POJO).memberName("SemtechGnss")
            .getter(getter(PositionSolverDetails::semtechGnss)).setter(setter(Builder::semtechGnss))
            .constructor(SemtechGnssDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemtechGnss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMTECH_GNSS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SemtechGnssDetail semtechGnss;

    private PositionSolverDetails(BuilderImpl builder) {
        this.semtechGnss = builder.semtechGnss;
    }

    /**
     * <p>
     * The Semtech GNSS solver object details.
     * </p>
     * 
     * @return The Semtech GNSS solver object details.
     */
    public final SemtechGnssDetail semtechGnss() {
        return semtechGnss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semtechGnss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PositionSolverDetails)) {
            return false;
        }
        PositionSolverDetails other = (PositionSolverDetails) obj;
        return Objects.equals(semtechGnss(), other.semtechGnss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PositionSolverDetails").add("SemtechGnss", semtechGnss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SemtechGnss":
            return Optional.ofNullable(clazz.cast(semtechGnss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PositionSolverDetails, T> g) {
        return obj -> g.apply((PositionSolverDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PositionSolverDetails> {
        /**
         * <p>
         * The Semtech GNSS solver object details.
         * </p>
         * 
         * @param semtechGnss
         *        The Semtech GNSS solver object details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semtechGnss(SemtechGnssDetail semtechGnss);

        /**
         * <p>
         * The Semtech GNSS solver object details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemtechGnssDetail.Builder} avoiding the
         * need to create one manually via {@link SemtechGnssDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemtechGnssDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #semtechGnss(SemtechGnssDetail)}.
         * 
         * @param semtechGnss
         *        a consumer that will call methods on {@link SemtechGnssDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semtechGnss(SemtechGnssDetail)
         */
        default Builder semtechGnss(Consumer<SemtechGnssDetail.Builder> semtechGnss) {
            return semtechGnss(SemtechGnssDetail.builder().applyMutation(semtechGnss).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemtechGnssDetail semtechGnss;

        private BuilderImpl() {
        }

        private BuilderImpl(PositionSolverDetails model) {
            semtechGnss(model.semtechGnss);
        }

        public final SemtechGnssDetail.Builder getSemtechGnss() {
            return semtechGnss != null ? semtechGnss.toBuilder() : null;
        }

        public final void setSemtechGnss(SemtechGnssDetail.BuilderImpl semtechGnss) {
            this.semtechGnss = semtechGnss != null ? semtechGnss.build() : null;
        }

        @Override
        public final Builder semtechGnss(SemtechGnssDetail semtechGnss) {
            this.semtechGnss = semtechGnss;
            return this;
        }

        @Override
        public PositionSolverDetails build() {
            return new PositionSolverDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
