/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotwireless.model.AccessDeniedException;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.ConflictException;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.InternalServerException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessException;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.ThrottlingException;
import software.amazon.awssdk.services.iotwireless.model.TooManyTagsException;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.ValidationException;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable;

/**
 * Service client for accessing AWS IoT Wireless. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS IoT Wireless provides bi-directional communication between internet-connected wireless devices and the AWS Cloud.
 * To onboard both LoRaWAN and Sidewalk devices to AWS IoT, use the IoT Wireless API. These wireless devices use the Low
 * Power Wide Area Networking (LPWAN) communication protocol to communicate with AWS IoT.
 * </p>
 * <p>
 * Using the API, you can perform create, read, update, and delete operations for your wireless devices, gateways,
 * destinations, and profiles. After onboarding your devices, you can use the API operations to set log levels and
 * monitor your devices with CloudWatch.
 * </p>
 * <p>
 * You can also use the API operations to create multicast groups and schedule a multicast session for sending a
 * downlink message to devices in the group. By using Firmware Updates Over-The-Air (FUOTA) API operations, you can
 * create a FUOTA task and schedule a session to update the firmware of individual devices or an entire group of devices
 * in a multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotWirelessClient extends AwsClient {
    String SERVICE_NAME = "iotwireless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotwireless";

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return Result of the AssociateAwsAccountWithPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAwsAccountWithPartnerAccountResponse associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAwsAccountWithPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAwsAccountWithPartnerAccountRequest#builder()}
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAwsAccountWithPartnerAccountRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateAwsAccountWithPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAwsAccountWithPartnerAccountResponse associateAwsAccountWithPartnerAccount(
            Consumer<AssociateAwsAccountWithPartnerAccountRequest.Builder> associateAwsAccountWithPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.builder()
                .applyMutation(associateAwsAccountWithPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Associate a multicast group with a FUOTA task.
     * </p>
     *
     * @param associateMulticastGroupWithFuotaTaskRequest
     * @return Result of the AssociateMulticastGroupWithFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateMulticastGroupWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateMulticastGroupWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMulticastGroupWithFuotaTaskResponse associateMulticastGroupWithFuotaTask(
            AssociateMulticastGroupWithFuotaTaskRequest associateMulticastGroupWithFuotaTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a multicast group with a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateMulticastGroupWithFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateMulticastGroupWithFuotaTaskRequest#builder()}
     * </p>
     *
     * @param associateMulticastGroupWithFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link AssociateMulticastGroupWithFuotaTaskRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateMulticastGroupWithFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateMulticastGroupWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateMulticastGroupWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMulticastGroupWithFuotaTaskResponse associateMulticastGroupWithFuotaTask(
            Consumer<AssociateMulticastGroupWithFuotaTaskRequest.Builder> associateMulticastGroupWithFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateMulticastGroupWithFuotaTask(AssociateMulticastGroupWithFuotaTaskRequest.builder()
                .applyMutation(associateMulticastGroupWithFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Associate a wireless device with a FUOTA task.
     * </p>
     *
     * @param associateWirelessDeviceWithFuotaTaskRequest
     * @return Result of the AssociateWirelessDeviceWithFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithFuotaTaskResponse associateWirelessDeviceWithFuotaTask(
            AssociateWirelessDeviceWithFuotaTaskRequest associateWirelessDeviceWithFuotaTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a wireless device with a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessDeviceWithFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessDeviceWithFuotaTaskRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithFuotaTaskRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateWirelessDeviceWithFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithFuotaTaskResponse associateWirelessDeviceWithFuotaTask(
            Consumer<AssociateWirelessDeviceWithFuotaTaskRequest.Builder> associateWirelessDeviceWithFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessDeviceWithFuotaTask(AssociateWirelessDeviceWithFuotaTaskRequest.builder()
                .applyMutation(associateWirelessDeviceWithFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a multicast group.
     * </p>
     *
     * @param associateWirelessDeviceWithMulticastGroupRequest
     * @return Result of the AssociateWirelessDeviceWithMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithMulticastGroupResponse associateWirelessDeviceWithMulticastGroup(
            AssociateWirelessDeviceWithMulticastGroupRequest associateWirelessDeviceWithMulticastGroupRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessDeviceWithMulticastGroupRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessDeviceWithMulticastGroupRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessDeviceWithMulticastGroupRequest.Builder} to create a request.
     * @return Result of the AssociateWirelessDeviceWithMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithMulticastGroupResponse associateWirelessDeviceWithMulticastGroup(
            Consumer<AssociateWirelessDeviceWithMulticastGroupRequest.Builder> associateWirelessDeviceWithMulticastGroupRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessDeviceWithMulticastGroup(AssociateWirelessDeviceWithMulticastGroupRequest.builder()
                .applyMutation(associateWirelessDeviceWithMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return Result of the AssociateWirelessDeviceWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithThingResponse associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessDeviceWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessDeviceWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithThingRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateWirelessDeviceWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithThingResponse associateWirelessDeviceWithThing(
            Consumer<AssociateWirelessDeviceWithThingRequest.Builder> associateWirelessDeviceWithThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.builder()
                .applyMutation(associateWirelessDeviceWithThingRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return Result of the AssociateWirelessGatewayWithCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithCertificateResponse associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessGatewayWithCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessGatewayWithCertificateRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessGatewayWithCertificateRequest.Builder} to create a request.
     * @return Result of the AssociateWirelessGatewayWithCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithCertificateResponse associateWirelessGatewayWithCertificate(
            Consumer<AssociateWirelessGatewayWithCertificateRequest.Builder> associateWirelessGatewayWithCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.builder()
                .applyMutation(associateWirelessGatewayWithCertificateRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return Result of the AssociateWirelessGatewayWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithThingResponse associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessGatewayWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessGatewayWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessGatewayWithThingRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateWirelessGatewayWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithThingResponse associateWirelessGatewayWithThing(
            Consumer<AssociateWirelessGatewayWithThingRequest.Builder> associateWirelessGatewayWithThingRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.builder()
                .applyMutation(associateWirelessGatewayWithThingRequest).build());
    }

    /**
     * <p>
     * Cancels an existing multicast group session.
     * </p>
     *
     * @param cancelMulticastGroupSessionRequest
     * @return Result of the CancelMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CancelMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CancelMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMulticastGroupSessionResponse cancelMulticastGroupSession(
            CancelMulticastGroupSessionRequest cancelMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an existing multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMulticastGroupSessionRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param cancelMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link CancelMulticastGroupSessionRequest.Builder} to create
     *        a request.
     * @return Result of the CancelMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CancelMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CancelMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMulticastGroupSessionResponse cancelMulticastGroupSession(
            Consumer<CancelMulticastGroupSessionRequest.Builder> cancelMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return cancelMulticastGroupSession(CancelMulticastGroupSessionRequest.builder()
                .applyMutation(cancelMulticastGroupSessionRequest).build());
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return Result of the CreateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDestinationResponse createDestination(CreateDestinationRequest createDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDestinationRequest.Builder} to create a request.
     * @return Result of the CreateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDestinationResponse createDestination(Consumer<CreateDestinationRequest.Builder> createDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return Result of the CreateDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceProfileResponse createDeviceProfile(CreateDeviceProfileRequest createDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceProfileRequest#builder()}
     * </p>
     *
     * @param createDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceProfileResponse createDeviceProfile(
            Consumer<CreateDeviceProfileRequest.Builder> createDeviceProfileRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createDeviceProfile(CreateDeviceProfileRequest.builder().applyMutation(createDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a FUOTA task.
     * </p>
     *
     * @param createFuotaTaskRequest
     * @return Result of the CreateFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFuotaTaskResponse createFuotaTask(CreateFuotaTaskRequest createFuotaTaskRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFuotaTaskRequest#builder()}
     * </p>
     *
     * @param createFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateFuotaTaskRequest.Builder} to create a request.
     * @return Result of the CreateFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFuotaTaskResponse createFuotaTask(Consumer<CreateFuotaTaskRequest.Builder> createFuotaTaskRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createFuotaTask(CreateFuotaTaskRequest.builder().applyMutation(createFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Creates a multicast group.
     * </p>
     *
     * @param createMulticastGroupRequest
     * @return Result of the CreateMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMulticastGroupResponse createMulticastGroup(CreateMulticastGroupRequest createMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMulticastGroupRequest#builder()}
     * </p>
     *
     * @param createMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateMulticastGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMulticastGroupResponse createMulticastGroup(
            Consumer<CreateMulticastGroupRequest.Builder> createMulticastGroupRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return createMulticastGroup(CreateMulticastGroupRequest.builder().applyMutation(createMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new network analyzer configuration.
     * </p>
     *
     * @param createNetworkAnalyzerConfigurationRequest
     * @return Result of the CreateNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkAnalyzerConfigurationResponse createNetworkAnalyzerConfiguration(
            CreateNetworkAnalyzerConfigurationRequest createNetworkAnalyzerConfigurationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param createNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkAnalyzerConfigurationResponse createNetworkAnalyzerConfiguration(
            Consumer<CreateNetworkAnalyzerConfigurationRequest.Builder> createNetworkAnalyzerConfigurationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createNetworkAnalyzerConfiguration(CreateNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(createNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return Result of the CreateServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceProfileResponse createServiceProfile(CreateServiceProfileRequest createServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceProfileRequest#builder()}
     * </p>
     *
     * @param createServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceProfileResponse createServiceProfile(
            Consumer<CreateServiceProfileRequest.Builder> createServiceProfileRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createServiceProfile(CreateServiceProfileRequest.builder().applyMutation(createServiceProfileRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return Result of the CreateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessDeviceResponse createWirelessDevice(CreateWirelessDeviceRequest createWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param createWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessDeviceResponse createWirelessDevice(
            Consumer<CreateWirelessDeviceRequest.Builder> createWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessDevice(CreateWirelessDeviceRequest.builder().applyMutation(createWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return Result of the CreateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayResponse createWirelessGateway(CreateWirelessGatewayRequest createWirelessGatewayRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayResponse createWirelessGateway(
            Consumer<CreateWirelessGatewayRequest.Builder> createWirelessGatewayRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createWirelessGateway(CreateWirelessGatewayRequest.builder().applyMutation(createWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return Result of the CreateWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskResponse createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskResponse createWirelessGatewayTask(
            Consumer<CreateWirelessGatewayTaskRequest.Builder> createWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.builder()
                .applyMutation(createWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return Result of the CreateWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskDefinitionResponse createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskDefinitionResponse createWirelessGatewayTaskDefinition(
            Consumer<CreateWirelessGatewayTaskDefinitionRequest.Builder> createWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(createWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDestinationRequest.Builder} to create a request.
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return Result of the DeleteDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceProfileResponse deleteDeviceProfile(DeleteDeviceProfileRequest deleteDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceProfileRequest#builder()}
     * </p>
     *
     * @param deleteDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceProfileResponse deleteDeviceProfile(
            Consumer<DeleteDeviceProfileRequest.Builder> deleteDeviceProfileRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return deleteDeviceProfile(DeleteDeviceProfileRequest.builder().applyMutation(deleteDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a FUOTA task.
     * </p>
     *
     * @param deleteFuotaTaskRequest
     * @return Result of the DeleteFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFuotaTaskResponse deleteFuotaTask(DeleteFuotaTaskRequest deleteFuotaTaskRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFuotaTaskRequest#builder()}
     * </p>
     *
     * @param deleteFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFuotaTaskRequest.Builder} to create a request.
     * @return Result of the DeleteFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFuotaTaskResponse deleteFuotaTask(Consumer<DeleteFuotaTaskRequest.Builder> deleteFuotaTaskRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteFuotaTask(DeleteFuotaTaskRequest.builder().applyMutation(deleteFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a multicast group if it is not in use by a fuota task.
     * </p>
     *
     * @param deleteMulticastGroupRequest
     * @return Result of the DeleteMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMulticastGroupResponse deleteMulticastGroup(DeleteMulticastGroupRequest deleteMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a multicast group if it is not in use by a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMulticastGroupRequest#builder()}
     * </p>
     *
     * @param deleteMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMulticastGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMulticastGroupResponse deleteMulticastGroup(
            Consumer<DeleteMulticastGroupRequest.Builder> deleteMulticastGroupRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return deleteMulticastGroup(DeleteMulticastGroupRequest.builder().applyMutation(deleteMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a network analyzer configuration.
     * </p>
     *
     * @param deleteNetworkAnalyzerConfigurationRequest
     * @return Result of the DeleteNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkAnalyzerConfigurationResponse deleteNetworkAnalyzerConfiguration(
            DeleteNetworkAnalyzerConfigurationRequest deleteNetworkAnalyzerConfigurationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkAnalyzerConfigurationResponse deleteNetworkAnalyzerConfiguration(
            Consumer<DeleteNetworkAnalyzerConfigurationRequest.Builder> deleteNetworkAnalyzerConfigurationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteNetworkAnalyzerConfiguration(DeleteNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(deleteNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Remove queued messages from the downlink queue.
     * </p>
     *
     * @param deleteQueuedMessagesRequest
     * @return Result of the DeleteQueuedMessages operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueuedMessagesResponse deleteQueuedMessages(DeleteQueuedMessagesRequest deleteQueuedMessagesRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove queued messages from the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param deleteQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQueuedMessages operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueuedMessagesResponse deleteQueuedMessages(
            Consumer<DeleteQueuedMessagesRequest.Builder> deleteQueuedMessagesRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteQueuedMessages(DeleteQueuedMessagesRequest.builder().applyMutation(deleteQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return Result of the DeleteServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceProfileResponse deleteServiceProfile(DeleteServiceProfileRequest deleteServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceProfileRequest#builder()}
     * </p>
     *
     * @param deleteServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceProfileResponse deleteServiceProfile(
            Consumer<DeleteServiceProfileRequest.Builder> deleteServiceProfileRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return deleteServiceProfile(DeleteServiceProfileRequest.builder().applyMutation(deleteServiceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return Result of the DeleteWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceResponse deleteWirelessDevice(DeleteWirelessDeviceRequest deleteWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceResponse deleteWirelessDevice(
            Consumer<DeleteWirelessDeviceRequest.Builder> deleteWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessDevice(DeleteWirelessDeviceRequest.builder().applyMutation(deleteWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Delete an import task.
     * </p>
     *
     * @param deleteWirelessDeviceImportTaskRequest
     * @return Result of the DeleteWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceImportTaskResponse deleteWirelessDeviceImportTask(
            DeleteWirelessDeviceImportTaskRequest deleteWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceImportTaskResponse deleteWirelessDeviceImportTask(
            Consumer<DeleteWirelessDeviceImportTaskRequest.Builder> deleteWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteWirelessDeviceImportTask(DeleteWirelessDeviceImportTaskRequest.builder()
                .applyMutation(deleteWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return Result of the DeleteWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayResponse deleteWirelessGateway(DeleteWirelessGatewayRequest deleteWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayResponse deleteWirelessGateway(
            Consumer<DeleteWirelessGatewayRequest.Builder> deleteWirelessGatewayRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessGateway(DeleteWirelessGatewayRequest.builder().applyMutation(deleteWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return Result of the DeleteWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskResponse deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskResponse deleteWirelessGatewayTask(
            Consumer<DeleteWirelessGatewayTaskRequest.Builder> deleteWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return Result of the DeleteWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskDefinitionResponse deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskDefinitionResponse deleteWirelessGatewayTaskDefinition(
            Consumer<DeleteWirelessGatewayTaskDefinitionRequest.Builder> deleteWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deregister a wireless device from AWS IoT Wireless.
     * </p>
     *
     * @param deregisterWirelessDeviceRequest
     * @return Result of the DeregisterWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeregisterWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeregisterWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWirelessDeviceResponse deregisterWirelessDevice(
            DeregisterWirelessDeviceRequest deregisterWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregister a wireless device from AWS IoT Wireless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deregisterWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeregisterWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeregisterWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWirelessDeviceResponse deregisterWirelessDevice(
            Consumer<DeregisterWirelessDeviceRequest.Builder> deregisterWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return deregisterWirelessDevice(DeregisterWirelessDeviceRequest.builder().applyMutation(deregisterWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return Result of the DisassociateAwsAccountFromPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAwsAccountFromPartnerAccountResponse disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAwsAccountFromPartnerAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} to create a request.
     * @return Result of the DisassociateAwsAccountFromPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAwsAccountFromPartnerAccountResponse disassociateAwsAccountFromPartnerAccount(
            Consumer<DisassociateAwsAccountFromPartnerAccountRequest.Builder> disassociateAwsAccountFromPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.builder()
                .applyMutation(disassociateAwsAccountFromPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a multicast group from a fuota task.
     * </p>
     *
     * @param disassociateMulticastGroupFromFuotaTaskRequest
     * @return Result of the DisassociateMulticastGroupFromFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateMulticastGroupFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateMulticastGroupFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMulticastGroupFromFuotaTaskResponse disassociateMulticastGroupFromFuotaTask(
            DisassociateMulticastGroupFromFuotaTaskRequest disassociateMulticastGroupFromFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a multicast group from a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateMulticastGroupFromFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateMulticastGroupFromFuotaTaskRequest#builder()}
     * </p>
     *
     * @param disassociateMulticastGroupFromFuotaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateMulticastGroupFromFuotaTaskRequest.Builder} to create a request.
     * @return Result of the DisassociateMulticastGroupFromFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateMulticastGroupFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateMulticastGroupFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMulticastGroupFromFuotaTaskResponse disassociateMulticastGroupFromFuotaTask(
            Consumer<DisassociateMulticastGroupFromFuotaTaskRequest.Builder> disassociateMulticastGroupFromFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateMulticastGroupFromFuotaTask(DisassociateMulticastGroupFromFuotaTaskRequest.builder()
                .applyMutation(disassociateMulticastGroupFromFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from a FUOTA task.
     * </p>
     *
     * @param disassociateWirelessDeviceFromFuotaTaskRequest
     * @return Result of the DisassociateWirelessDeviceFromFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromFuotaTaskResponse disassociateWirelessDeviceFromFuotaTask(
            DisassociateWirelessDeviceFromFuotaTaskRequest disassociateWirelessDeviceFromFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessDeviceFromFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessDeviceFromFuotaTaskRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromFuotaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessDeviceFromFuotaTaskRequest.Builder} to create a request.
     * @return Result of the DisassociateWirelessDeviceFromFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromFuotaTaskResponse disassociateWirelessDeviceFromFuotaTask(
            Consumer<DisassociateWirelessDeviceFromFuotaTaskRequest.Builder> disassociateWirelessDeviceFromFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessDeviceFromFuotaTask(DisassociateWirelessDeviceFromFuotaTaskRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from a multicast group.
     * </p>
     *
     * @param disassociateWirelessDeviceFromMulticastGroupRequest
     * @return Result of the DisassociateWirelessDeviceFromMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromMulticastGroupResponse disassociateWirelessDeviceFromMulticastGroup(
            DisassociateWirelessDeviceFromMulticastGroupRequest disassociateWirelessDeviceFromMulticastGroupRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessDeviceFromMulticastGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessDeviceFromMulticastGroupRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessDeviceFromMulticastGroupRequest.Builder} to create a request.
     * @return Result of the DisassociateWirelessDeviceFromMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromMulticastGroupResponse disassociateWirelessDeviceFromMulticastGroup(
            Consumer<DisassociateWirelessDeviceFromMulticastGroupRequest.Builder> disassociateWirelessDeviceFromMulticastGroupRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessDeviceFromMulticastGroup(DisassociateWirelessDeviceFromMulticastGroupRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return Result of the DisassociateWirelessDeviceFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromThingResponse disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWirelessDeviceFromThingRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWirelessDeviceFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessDeviceFromThingRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateWirelessDeviceFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromThingResponse disassociateWirelessDeviceFromThing(
            Consumer<DisassociateWirelessDeviceFromThingRequest.Builder> disassociateWirelessDeviceFromThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromThingRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return Result of the DisassociateWirelessGatewayFromCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromCertificateResponse disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} to create a request.
     * @return Result of the DisassociateWirelessGatewayFromCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromCertificateResponse disassociateWirelessGatewayFromCertificate(
            Consumer<DisassociateWirelessGatewayFromCertificateRequest.Builder> disassociateWirelessGatewayFromCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromCertificateRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return Result of the DisassociateWirelessGatewayFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromThingResponse disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromThingRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessGatewayFromThingRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateWirelessGatewayFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromThingResponse disassociateWirelessGatewayFromThing(
            Consumer<DisassociateWirelessGatewayFromThingRequest.Builder> disassociateWirelessGatewayFromThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromThingRequest).build());
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return Result of the GetDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDestinationResponse getDestination(GetDestinationRequest getDestinationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on {@link GetDestinationRequest.Builder} to create a request.
     * @return Result of the GetDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDestinationResponse getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return Result of the GetDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceProfileResponse getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceProfileRequest#builder()}
     * </p>
     *
     * @param getDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceProfileRequest.Builder} to create a request.
     * @return Result of the GetDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceProfileResponse getDeviceProfile(Consumer<GetDeviceProfileRequest.Builder> getDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getDeviceProfile(GetDeviceProfileRequest.builder().applyMutation(getDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Get the event configuration based on resource types.
     * </p>
     *
     * @param getEventConfigurationByResourceTypesRequest
     * @return Result of the GetEventConfigurationByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventConfigurationByResourceTypesResponse getEventConfigurationByResourceTypes(
            GetEventConfigurationByResourceTypesRequest getEventConfigurationByResourceTypesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the event configuration based on resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEventConfigurationByResourceTypesRequest.Builder} avoiding the need to create one manually via
     * {@link GetEventConfigurationByResourceTypesRequest#builder()}
     * </p>
     *
     * @param getEventConfigurationByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventConfigurationByResourceTypesRequest.Builder}
     *        to create a request.
     * @return Result of the GetEventConfigurationByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventConfigurationByResourceTypesResponse getEventConfigurationByResourceTypes(
            Consumer<GetEventConfigurationByResourceTypesRequest.Builder> getEventConfigurationByResourceTypesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return getEventConfigurationByResourceTypes(GetEventConfigurationByResourceTypesRequest.builder()
                .applyMutation(getEventConfigurationByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about a FUOTA task.
     * </p>
     *
     * @param getFuotaTaskRequest
     * @return Result of the GetFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetFuotaTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFuotaTaskResponse getFuotaTask(GetFuotaTaskRequest getFuotaTaskRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFuotaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetFuotaTaskRequest#builder()}
     * </p>
     *
     * @param getFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetFuotaTaskRequest.Builder} to create a request.
     * @return Result of the GetFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetFuotaTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFuotaTaskResponse getFuotaTask(Consumer<GetFuotaTaskRequest.Builder> getFuotaTaskRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getFuotaTask(GetFuotaTaskRequest.builder().applyMutation(getFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     * @return Result of the GetLogLevelsByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLogLevelsByResourceTypesResponse getLogLevelsByResourceTypes(
            GetLogLevelsByResourceTypesRequest getLogLevelsByResourceTypesRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogLevelsByResourceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link GetLogLevelsByResourceTypesRequest#builder()}
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetLogLevelsByResourceTypesRequest.Builder} to create
     *        a request.
     * @return Result of the GetLogLevelsByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLogLevelsByResourceTypesResponse getLogLevelsByResourceTypes(
            Consumer<GetLogLevelsByResourceTypesRequest.Builder> getLogLevelsByResourceTypesRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IotWirelessException {
        return getLogLevelsByResourceTypes(GetLogLevelsByResourceTypesRequest.builder()
                .applyMutation(getLogLevelsByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about a multicast group.
     * </p>
     *
     * @param getMulticastGroupRequest
     * @return Result of the GetMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMulticastGroupResponse getMulticastGroup(GetMulticastGroupRequest getMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMulticastGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetMulticastGroupRequest#builder()}
     * </p>
     *
     * @param getMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetMulticastGroupRequest.Builder} to create a request.
     * @return Result of the GetMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMulticastGroupResponse getMulticastGroup(Consumer<GetMulticastGroupRequest.Builder> getMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getMulticastGroup(GetMulticastGroupRequest.builder().applyMutation(getMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about a multicast group session.
     * </p>
     *
     * @param getMulticastGroupSessionRequest
     * @return Result of the GetMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMulticastGroupSessionResponse getMulticastGroupSession(
            GetMulticastGroupSessionRequest getMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMulticastGroupSessionRequest.Builder} avoiding
     * the need to create one manually via {@link GetMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param getMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link GetMulticastGroupSessionRequest.Builder} to create a
     *        request.
     * @return Result of the GetMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMulticastGroupSessionResponse getMulticastGroupSession(
            Consumer<GetMulticastGroupSessionRequest.Builder> getMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getMulticastGroupSession(GetMulticastGroupSessionRequest.builder().applyMutation(getMulticastGroupSessionRequest)
                .build());
    }

    /**
     * <p>
     * Get network analyzer configuration.
     * </p>
     *
     * @param getNetworkAnalyzerConfigurationRequest
     * @return Result of the GetNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkAnalyzerConfigurationResponse getNetworkAnalyzerConfiguration(
            GetNetworkAnalyzerConfigurationRequest getNetworkAnalyzerConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param getNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkAnalyzerConfigurationResponse getNetworkAnalyzerConfiguration(
            Consumer<GetNetworkAnalyzerConfigurationRequest.Builder> getNetworkAnalyzerConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getNetworkAnalyzerConfiguration(GetNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(getNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return Result of the GetPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPartnerAccountResponse getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnerAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetPartnerAccountRequest#builder()}
     * </p>
     *
     * @param getPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetPartnerAccountRequest.Builder} to create a request.
     * @return Result of the GetPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPartnerAccountResponse getPartnerAccount(Consumer<GetPartnerAccountRequest.Builder> getPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return getPartnerAccount(GetPartnerAccountRequest.builder().applyMutation(getPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Get the position information for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionRequest
     * @return Result of the GetPosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPosition" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default GetPositionResponse getPosition(GetPositionRequest getPositionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the position information for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPositionRequest#builder()}
     * </p>
     *
     * @param getPositionRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionRequest.Builder} to create a request.
     * @return Result of the GetPosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPosition" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default GetPositionResponse getPosition(Consumer<GetPositionRequest.Builder> getPositionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getPosition(GetPositionRequest.builder().applyMutation(getPositionRequest).build());
    }

    /**
     * <p>
     * Get position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionConfigurationRequest
     * @return Result of the GetPositionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default GetPositionConfigurationResponse getPositionConfiguration(
            GetPositionConfigurationRequest getPositionConfigurationRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetPositionConfigurationRequest#builder()}
     * </p>
     *
     * @param getPositionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetPositionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default GetPositionConfigurationResponse getPositionConfiguration(
            Consumer<GetPositionConfigurationRequest.Builder> getPositionConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getPositionConfiguration(GetPositionConfigurationRequest.builder().applyMutation(getPositionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using
     * solvers that are provided by third-party vendors.
     * </p>
     *
     * @param getPositionEstimateRequest
     * @return Result of the GetPositionEstimate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPositionEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPositionEstimateResponse getPositionEstimate(GetPositionEstimateRequest getPositionEstimateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using
     * solvers that are provided by third-party vendors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link GetPositionEstimateRequest#builder()}
     * </p>
     *
     * @param getPositionEstimateRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionEstimateRequest.Builder} to create a
     *        request.
     * @return Result of the GetPositionEstimate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPositionEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPositionEstimateResponse getPositionEstimate(
            Consumer<GetPositionEstimateRequest.Builder> getPositionEstimateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getPositionEstimate(GetPositionEstimateRequest.builder().applyMutation(getPositionEstimateRequest).build());
    }

    /**
     * <p>
     * Get the event configuration for a particular resource identifier.
     * </p>
     *
     * @param getResourceEventConfigurationRequest
     * @return Result of the GetResourceEventConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceEventConfigurationResponse getResourceEventConfiguration(
            GetResourceEventConfigurationRequest getResourceEventConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the event configuration for a particular resource identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceEventConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceEventConfigurationRequest#builder()}
     * </p>
     *
     * @param getResourceEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceEventConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourceEventConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceEventConfigurationResponse getResourceEventConfiguration(
            Consumer<GetResourceEventConfigurationRequest.Builder> getResourceEventConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return getResourceEventConfiguration(GetResourceEventConfigurationRequest.builder()
                .applyMutation(getResourceEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     *
     * @param getResourceLogLevelRequest
     * @return Result of the GetResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceLogLevelResponse getResourceLogLevel(GetResourceLogLevelRequest getResourceLogLevelRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param getResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceLogLevelResponse getResourceLogLevel(
            Consumer<GetResourceLogLevelRequest.Builder> getResourceLogLevelRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getResourceLogLevel(GetResourceLogLevelRequest.builder().applyMutation(getResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Get the position information for a given wireless device or a wireless gateway resource. The position information
     * uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.
     * </p>
     *
     * @param getResourcePositionRequest
     * @return Result of the GetResourcePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePositionResponse getResourcePosition(GetResourcePositionRequest getResourcePositionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the position information for a given wireless device or a wireless gateway resource. The position information
     * uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePositionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePositionRequest#builder()}
     * </p>
     *
     * @param getResourcePositionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePositionRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePositionResponse getResourcePosition(
            Consumer<GetResourcePositionRequest.Builder> getResourcePositionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getResourcePosition(GetResourcePositionRequest.builder().applyMutation(getResourcePositionRequest).build());
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return Result of the GetServiceEndpoint operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceEndpointResponse getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceEndpointRequest#builder()}
     * </p>
     *
     * @param getServiceEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceEndpoint operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceEndpointResponse getServiceEndpoint(Consumer<GetServiceEndpointRequest.Builder> getServiceEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getServiceEndpoint(GetServiceEndpointRequest.builder().applyMutation(getServiceEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return Result of the GetServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceProfileResponse getServiceProfile(GetServiceProfileRequest getServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceProfileRequest#builder()}
     * </p>
     *
     * @param getServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceProfileRequest.Builder} to create a request.
     * @return Result of the GetServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceProfileResponse getServiceProfile(Consumer<GetServiceProfileRequest.Builder> getServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getServiceProfile(GetServiceProfileRequest.builder().applyMutation(getServiceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return Result of the GetWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessDeviceResponse getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceRequest.Builder} to create a request.
     * @return Result of the GetWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessDeviceResponse getWirelessDevice(Consumer<GetWirelessDeviceRequest.Builder> getWirelessDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessDevice(GetWirelessDeviceRequest.builder().applyMutation(getWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Get information about an import task and count of device onboarding summary information for the import task.
     * </p>
     *
     * @param getWirelessDeviceImportTaskRequest
     * @return Result of the GetWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceImportTaskResponse getWirelessDeviceImportTask(
            GetWirelessDeviceImportTaskRequest getWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an import task and count of device onboarding summary information for the import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceImportTaskRequest.Builder} to create
     *        a request.
     * @return Result of the GetWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceImportTaskResponse getWirelessDeviceImportTask(
            Consumer<GetWirelessDeviceImportTaskRequest.Builder> getWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessDeviceImportTask(GetWirelessDeviceImportTaskRequest.builder()
                .applyMutation(getWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return Result of the GetWirelessDeviceStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceStatisticsResponse getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the GetWirelessDeviceStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceStatisticsResponse getWirelessDeviceStatistics(
            Consumer<GetWirelessDeviceStatisticsRequest.Builder> getWirelessDeviceStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.builder()
                .applyMutation(getWirelessDeviceStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return Result of the GetWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayResponse getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the GetWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayResponse getWirelessGateway(Consumer<GetWirelessGatewayRequest.Builder> getWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGateway(GetWirelessGatewayRequest.builder().applyMutation(getWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return Result of the GetWirelessGatewayCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayCertificateResponse getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayCertificateRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the GetWirelessGatewayCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayCertificateResponse getWirelessGatewayCertificate(
            Consumer<GetWirelessGatewayCertificateRequest.Builder> getWirelessGatewayCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.builder()
                .applyMutation(getWirelessGatewayCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return Result of the GetWirelessGatewayFirmwareInformation operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayFirmwareInformationResponse getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetWirelessGatewayFirmwareInformationRequest.Builder} avoiding the need to create one manually via
     * {@link GetWirelessGatewayFirmwareInformationRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayFirmwareInformationRequest.Builder}
     *        to create a request.
     * @return Result of the GetWirelessGatewayFirmwareInformation operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayFirmwareInformationResponse getWirelessGatewayFirmwareInformation(
            Consumer<GetWirelessGatewayFirmwareInformationRequest.Builder> getWirelessGatewayFirmwareInformationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.builder()
                .applyMutation(getWirelessGatewayFirmwareInformationRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return Result of the GetWirelessGatewayStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayStatisticsResponse getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the GetWirelessGatewayStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayStatisticsResponse getWirelessGatewayStatistics(
            Consumer<GetWirelessGatewayStatisticsRequest.Builder> getWirelessGatewayStatisticsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.builder()
                .applyMutation(getWirelessGatewayStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return Result of the GetWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskResponse getWirelessGatewayTask(GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskResponse getWirelessGatewayTask(
            Consumer<GetWirelessGatewayTaskRequest.Builder> getWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getWirelessGatewayTask(GetWirelessGatewayTaskRequest.builder().applyMutation(getWirelessGatewayTaskRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return Result of the GetWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskDefinitionResponse getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskDefinitionResponse getWirelessGatewayTaskDefinition(
            Consumer<GetWirelessGatewayTaskDefinitionRequest.Builder> getWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(getWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return Result of the ListDestinations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(ListDestinationsRequest listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return Result of the ListDestinations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return Result of the ListDeviceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesResponse listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesResponse listDeviceProfiles(Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDeviceProfiles(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client
     *             .listDeviceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesIterable listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client
     *             .listDeviceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesIterable listDeviceProfilesPaginator(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listDeviceProfilesPaginator(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * List the Sidewalk devices in an import task and their onboarding status.
     * </p>
     *
     * @param listDevicesForWirelessDeviceImportTaskRequest
     * @return Result of the ListDevicesForWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDevicesForWirelessDeviceImportTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDevicesForWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesForWirelessDeviceImportTaskResponse listDevicesForWirelessDeviceImportTask(
            ListDevicesForWirelessDeviceImportTaskRequest listDevicesForWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Sidewalk devices in an import task and their onboarding status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDevicesForWirelessDeviceImportTaskRequest.Builder} avoiding the need to create one manually via
     * {@link ListDevicesForWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param listDevicesForWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesForWirelessDeviceImportTaskRequest.Builder}
     *        to create a request.
     * @return Result of the ListDevicesForWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDevicesForWirelessDeviceImportTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDevicesForWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesForWirelessDeviceImportTaskResponse listDevicesForWirelessDeviceImportTask(
            Consumer<ListDevicesForWirelessDeviceImportTaskRequest.Builder> listDevicesForWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return listDevicesForWirelessDeviceImportTask(ListDevicesForWirelessDeviceImportTaskRequest.builder()
                .applyMutation(listDevicesForWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * List event configurations where at least one event topic has been enabled.
     * </p>
     *
     * @param listEventConfigurationsRequest
     * @return Result of the ListEventConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListEventConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListEventConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventConfigurationsResponse listEventConfigurations(ListEventConfigurationsRequest listEventConfigurationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List event configurations where at least one event topic has been enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListEventConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListEventConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventConfigurationsResponse listEventConfigurations(
            Consumer<ListEventConfigurationsRequest.Builder> listEventConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listEventConfigurations(ListEventConfigurationsRequest.builder().applyMutation(listEventConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     *
     * @param listFuotaTasksRequest
     * @return Result of the ListFuotaTasks operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksResponse listFuotaTasks(ListFuotaTasksRequest listFuotaTasksRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFuotaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFuotaTasksRequest#builder()}
     * </p>
     *
     * @param listFuotaTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListFuotaTasksRequest.Builder} to create a request.
     * @return Result of the ListFuotaTasks operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksResponse listFuotaTasks(Consumer<ListFuotaTasksRequest.Builder> listFuotaTasksRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listFuotaTasks(ListFuotaTasksRequest.builder().applyMutation(listFuotaTasksRequest).build());
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client.listFuotaTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client
     *             .listFuotaTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client.listFuotaTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation.</b>
     * </p>
     *
     * @param listFuotaTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksIterable listFuotaTasksPaginator(ListFuotaTasksRequest listFuotaTasksRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client.listFuotaTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client
     *             .listFuotaTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksIterable responses = client.listFuotaTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFuotaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFuotaTasksRequest#builder()}
     * </p>
     *
     * @param listFuotaTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListFuotaTasksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksIterable listFuotaTasksPaginator(Consumer<ListFuotaTasksRequest.Builder> listFuotaTasksRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listFuotaTasksPaginator(ListFuotaTasksRequest.builder().applyMutation(listFuotaTasksRequest).build());
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     *
     * @param listMulticastGroupsRequest
     * @return Result of the ListMulticastGroups operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsResponse listMulticastGroups(ListMulticastGroupsRequest listMulticastGroupsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMulticastGroupsRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMulticastGroups operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsResponse listMulticastGroups(
            Consumer<ListMulticastGroupsRequest.Builder> listMulticastGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listMulticastGroups(ListMulticastGroupsRequest.builder().applyMutation(listMulticastGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client.listMulticastGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client
     *             .listMulticastGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client.listMulticastGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMulticastGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsIterable listMulticastGroupsPaginator(ListMulticastGroupsRequest listMulticastGroupsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client.listMulticastGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client
     *             .listMulticastGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsIterable responses = client.listMulticastGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMulticastGroupsRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsIterable listMulticastGroupsPaginator(
            Consumer<ListMulticastGroupsRequest.Builder> listMulticastGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listMulticastGroupsPaginator(ListMulticastGroupsRequest.builder().applyMutation(listMulticastGroupsRequest)
                .build());
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     * @return Result of the ListMulticastGroupsByFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskResponse listMulticastGroupsByFuotaTask(
            ListMulticastGroupsByFuotaTaskRequest listMulticastGroupsByFuotaTaskRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsByFuotaTaskRequest.Builder}
     * avoiding the need to create one manually via {@link ListMulticastGroupsByFuotaTaskRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsByFuotaTaskRequest.Builder} to
     *        create a request.
     * @return Result of the ListMulticastGroupsByFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskResponse listMulticastGroupsByFuotaTask(
            Consumer<ListMulticastGroupsByFuotaTaskRequest.Builder> listMulticastGroupsByFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return listMulticastGroupsByFuotaTask(ListMulticastGroupsByFuotaTaskRequest.builder()
                .applyMutation(listMulticastGroupsByFuotaTaskRequest).build());
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client
     *             .listMulticastGroupsByFuotaTaskPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskIterable listMulticastGroupsByFuotaTaskPaginator(
            ListMulticastGroupsByFuotaTaskRequest listMulticastGroupsByFuotaTaskRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client
     *             .listMulticastGroupsByFuotaTaskPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskIterable responses = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsByFuotaTaskRequest.Builder}
     * avoiding the need to create one manually via {@link ListMulticastGroupsByFuotaTaskRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsByFuotaTaskRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskIterable listMulticastGroupsByFuotaTaskPaginator(
            Consumer<ListMulticastGroupsByFuotaTaskRequest.Builder> listMulticastGroupsByFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return listMulticastGroupsByFuotaTaskPaginator(ListMulticastGroupsByFuotaTaskRequest.builder()
                .applyMutation(listMulticastGroupsByFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     * @return Result of the ListNetworkAnalyzerConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsResponse listNetworkAnalyzerConfigurations(
            ListNetworkAnalyzerConfigurationsRequest listNetworkAnalyzerConfigurationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkAnalyzerConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNetworkAnalyzerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkAnalyzerConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListNetworkAnalyzerConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsResponse listNetworkAnalyzerConfigurations(
            Consumer<ListNetworkAnalyzerConfigurationsRequest.Builder> listNetworkAnalyzerConfigurationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsRequest.builder()
                .applyMutation(listNetworkAnalyzerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client
     *             .listNetworkAnalyzerConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsIterable listNetworkAnalyzerConfigurationsPaginator(
            ListNetworkAnalyzerConfigurationsRequest listNetworkAnalyzerConfigurationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client
     *             .listNetworkAnalyzerConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsIterable responses = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkAnalyzerConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNetworkAnalyzerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkAnalyzerConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsIterable listNetworkAnalyzerConfigurationsPaginator(
            Consumer<ListNetworkAnalyzerConfigurationsRequest.Builder> listNetworkAnalyzerConfigurationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listNetworkAnalyzerConfigurationsPaginator(ListNetworkAnalyzerConfigurationsRequest.builder()
                .applyMutation(listNetworkAnalyzerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return Result of the ListPartnerAccounts operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerAccountsResponse listPartnerAccounts(ListPartnerAccountsRequest listPartnerAccountsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPartnerAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerAccountsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPartnerAccounts operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerAccountsResponse listPartnerAccounts(
            Consumer<ListPartnerAccountsRequest.Builder> listPartnerAccountsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listPartnerAccounts(ListPartnerAccountsRequest.builder().applyMutation(listPartnerAccountsRequest).build());
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param listPositionConfigurationsRequest
     * @return Result of the ListPositionConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsResponse listPositionConfigurations(
            ListPositionConfigurationsRequest listPositionConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPositionConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPositionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPositionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPositionConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPositionConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsResponse listPositionConfigurations(
            Consumer<ListPositionConfigurationsRequest.Builder> listPositionConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listPositionConfigurations(ListPositionConfigurationsRequest.builder()
                .applyMutation(listPositionConfigurationsRequest).build());
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client.listPositionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client
     *             .listPositionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client.listPositionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPositionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsIterable listPositionConfigurationsPaginator(
            ListPositionConfigurationsRequest listPositionConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client.listPositionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client
     *             .listPositionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsIterable responses = client.listPositionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPositionConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPositionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPositionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPositionConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsIterable listPositionConfigurationsPaginator(
            Consumer<ListPositionConfigurationsRequest.Builder> listPositionConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listPositionConfigurationsPaginator(ListPositionConfigurationsRequest.builder()
                .applyMutation(listPositionConfigurationsRequest).build());
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     *
     * @param listQueuedMessagesRequest
     * @return Result of the ListQueuedMessages operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesResponse listQueuedMessages(ListQueuedMessagesRequest listQueuedMessagesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param listQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return Result of the ListQueuedMessages operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesResponse listQueuedMessages(Consumer<ListQueuedMessagesRequest.Builder> listQueuedMessagesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        return listQueuedMessages(ListQueuedMessagesRequest.builder().applyMutation(listQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client.listQueuedMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client
     *             .listQueuedMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client.listQueuedMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueuedMessagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesIterable listQueuedMessagesPaginator(ListQueuedMessagesRequest listQueuedMessagesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client.listQueuedMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client
     *             .listQueuedMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesIterable responses = client.listQueuedMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param listQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesIterable listQueuedMessagesPaginator(
            Consumer<ListQueuedMessagesRequest.Builder> listQueuedMessagesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listQueuedMessagesPaginator(ListQueuedMessagesRequest.builder().applyMutation(listQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return Result of the ListServiceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesResponse listServiceProfiles(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListServiceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesResponse listServiceProfiles(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listServiceProfiles(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client
     *             .listServiceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesIterable listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client
     *             .listServiceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesIterable listServiceProfilesPaginator(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listServiceProfilesPaginator(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List wireless devices that have been added to an import task.
     * </p>
     *
     * @param listWirelessDeviceImportTasksRequest
     * @return Result of the ListWirelessDeviceImportTasks operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDeviceImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDeviceImportTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDeviceImportTasksResponse listWirelessDeviceImportTasks(
            ListWirelessDeviceImportTasksRequest listWirelessDeviceImportTasksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List wireless devices that have been added to an import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDeviceImportTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessDeviceImportTasksRequest#builder()}
     * </p>
     *
     * @param listWirelessDeviceImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDeviceImportTasksRequest.Builder} to
     *        create a request.
     * @return Result of the ListWirelessDeviceImportTasks operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDeviceImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDeviceImportTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDeviceImportTasksResponse listWirelessDeviceImportTasks(
            Consumer<ListWirelessDeviceImportTasksRequest.Builder> listWirelessDeviceImportTasksRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return listWirelessDeviceImportTasks(ListWirelessDeviceImportTasksRequest.builder()
                .applyMutation(listWirelessDeviceImportTasksRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return Result of the ListWirelessDevices operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesResponse listWirelessDevices(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListWirelessDevices operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesResponse listWirelessDevices(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessDevices(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client
     *             .listWirelessDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesIterable listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client
     *             .listWirelessDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesIterable listWirelessDevicesPaginator(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessDevicesPaginator(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return Result of the ListWirelessGatewayTaskDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewayTaskDefinitionsResponse listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewayTaskDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessGatewayTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewayTaskDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListWirelessGatewayTaskDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewayTaskDefinitionsResponse listWirelessGatewayTaskDefinitions(
            Consumer<ListWirelessGatewayTaskDefinitionsRequest.Builder> listWirelessGatewayTaskDefinitionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.builder()
                .applyMutation(listWirelessGatewayTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return Result of the ListWirelessGateways operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysResponse listWirelessGateways(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListWirelessGateways operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysResponse listWirelessGateways(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessGateways(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client
     *             .listWirelessGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysIterable listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client
     *             .listWirelessGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysIterable listWirelessGatewaysPaginator(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessGatewaysPaginator(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Put position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param putPositionConfigurationRequest
     * @return Result of the PutPositionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.PutPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default PutPositionConfigurationResponse putPositionConfiguration(
            PutPositionConfigurationRequest putPositionConfigurationRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPositionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutPositionConfigurationRequest#builder()}
     * </p>
     *
     * @param putPositionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutPositionConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutPositionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.PutPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default PutPositionConfigurationResponse putPositionConfiguration(
            Consumer<PutPositionConfigurationRequest.Builder> putPositionConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return putPositionConfiguration(PutPositionConfigurationRequest.builder().applyMutation(putPositionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     *
     * @param putResourceLogLevelRequest
     * @return Result of the PutResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourceLogLevelResponse putResourceLogLevel(PutResourceLogLevelRequest putResourceLogLevelRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link PutResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param putResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link PutResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourceLogLevelResponse putResourceLogLevel(
            Consumer<PutResourceLogLevelRequest.Builder> putResourceLogLevelRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return putResourceLogLevel(PutResourceLogLevelRequest.builder().applyMutation(putResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     * @return Result of the ResetAllResourceLogLevels operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetAllResourceLogLevelsResponse resetAllResourceLogLevels(
            ResetAllResourceLogLevelsRequest resetAllResourceLogLevelsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetAllResourceLogLevelsRequest.Builder} avoiding
     * the need to create one manually via {@link ResetAllResourceLogLevelsRequest#builder()}
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     *        A {@link Consumer} that will call methods on {@link ResetAllResourceLogLevelsRequest.Builder} to create a
     *        request.
     * @return Result of the ResetAllResourceLogLevels operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetAllResourceLogLevelsResponse resetAllResourceLogLevels(
            Consumer<ResetAllResourceLogLevelsRequest.Builder> resetAllResourceLogLevelsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return resetAllResourceLogLevels(ResetAllResourceLogLevelsRequest.builder()
                .applyMutation(resetAllResourceLogLevelsRequest).build());
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     *
     * @param resetResourceLogLevelRequest
     * @return Result of the ResetResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetResourceLogLevelResponse resetResourceLogLevel(ResetResourceLogLevelRequest resetResourceLogLevelRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link ResetResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param resetResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link ResetResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return Result of the ResetResourceLogLevel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetResourceLogLevelResponse resetResourceLogLevel(
            Consumer<ResetResourceLogLevelRequest.Builder> resetResourceLogLevelRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return resetResourceLogLevel(ResetResourceLogLevelRequest.builder().applyMutation(resetResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Sends the specified data to a multicast group.
     * </p>
     *
     * @param sendDataToMulticastGroupRequest
     * @return Result of the SendDataToMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToMulticastGroupResponse sendDataToMulticastGroup(
            SendDataToMulticastGroupRequest sendDataToMulticastGroupRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends the specified data to a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToMulticastGroupRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToMulticastGroupRequest#builder()}
     * </p>
     *
     * @param sendDataToMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToMulticastGroupRequest.Builder} to create a
     *        request.
     * @return Result of the SendDataToMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToMulticastGroupResponse sendDataToMulticastGroup(
            Consumer<SendDataToMulticastGroupRequest.Builder> sendDataToMulticastGroupRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return sendDataToMulticastGroup(SendDataToMulticastGroupRequest.builder().applyMutation(sendDataToMulticastGroupRequest)
                .build());
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return Result of the SendDataToWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToWirelessDeviceResponse sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the SendDataToWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToWirelessDeviceResponse sendDataToWirelessDevice(
            Consumer<SendDataToWirelessDeviceRequest.Builder> sendDataToWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.builder().applyMutation(sendDataToWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     * </p>
     *
     * @param startBulkAssociateWirelessDeviceWithMulticastGroupRequest
     * @return Result of the StartBulkAssociateWirelessDeviceWithMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartBulkAssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkAssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkAssociateWirelessDeviceWithMulticastGroupResponse startBulkAssociateWirelessDeviceWithMulticastGroup(
            StartBulkAssociateWirelessDeviceWithMulticastGroupRequest startBulkAssociateWirelessDeviceWithMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder} avoiding the need to create one
     * manually via {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest#builder()}
     * </p>
     *
     * @param startBulkAssociateWirelessDeviceWithMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder} to create a request.
     * @return Result of the StartBulkAssociateWirelessDeviceWithMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartBulkAssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkAssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkAssociateWirelessDeviceWithMulticastGroupResponse startBulkAssociateWirelessDeviceWithMulticastGroup(
            Consumer<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder> startBulkAssociateWirelessDeviceWithMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return startBulkAssociateWirelessDeviceWithMulticastGroup(StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
                .builder().applyMutation(startBulkAssociateWirelessDeviceWithMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     * </p>
     *
     * @param startBulkDisassociateWirelessDeviceFromMulticastGroupRequest
     * @return Result of the StartBulkDisassociateWirelessDeviceFromMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartBulkDisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkDisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse startBulkDisassociateWirelessDeviceFromMulticastGroup(
            StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest startBulkDisassociateWirelessDeviceFromMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder} avoiding the need to create one
     * manually via {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest#builder()}
     * </p>
     *
     * @param startBulkDisassociateWirelessDeviceFromMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder} to create a request.
     * @return Result of the StartBulkDisassociateWirelessDeviceFromMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartBulkDisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkDisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse startBulkDisassociateWirelessDeviceFromMulticastGroup(
            Consumer<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder> startBulkDisassociateWirelessDeviceFromMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return startBulkDisassociateWirelessDeviceFromMulticastGroup(StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
                .builder().applyMutation(startBulkDisassociateWirelessDeviceFromMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Starts a FUOTA task.
     * </p>
     *
     * @param startFuotaTaskRequest
     * @return Result of the StartFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFuotaTaskResponse startFuotaTask(StartFuotaTaskRequest startFuotaTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFuotaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link StartFuotaTaskRequest#builder()}
     * </p>
     *
     * @param startFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartFuotaTaskRequest.Builder} to create a request.
     * @return Result of the StartFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFuotaTaskResponse startFuotaTask(Consumer<StartFuotaTaskRequest.Builder> startFuotaTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return startFuotaTask(StartFuotaTaskRequest.builder().applyMutation(startFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Starts a multicast group session.
     * </p>
     *
     * @param startMulticastGroupSessionRequest
     * @return Result of the StartMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMulticastGroupSessionResponse startMulticastGroupSession(
            StartMulticastGroupSessionRequest startMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMulticastGroupSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StartMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param startMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link StartMulticastGroupSessionRequest.Builder} to create a
     *        request.
     * @return Result of the StartMulticastGroupSession operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMulticastGroupSessionResponse startMulticastGroupSession(
            Consumer<StartMulticastGroupSessionRequest.Builder> startMulticastGroupSessionRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return startMulticastGroupSession(StartMulticastGroupSessionRequest.builder()
                .applyMutation(startMulticastGroupSessionRequest).build());
    }

    /**
     * <p>
     * Start import task for a single wireless device.
     * </p>
     *
     * @param startSingleWirelessDeviceImportTaskRequest
     * @return Result of the StartSingleWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartSingleWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartSingleWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSingleWirelessDeviceImportTaskResponse startSingleWirelessDeviceImportTask(
            StartSingleWirelessDeviceImportTaskRequest startSingleWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import task for a single wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSingleWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartSingleWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param startSingleWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartSingleWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return Result of the StartSingleWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartSingleWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartSingleWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSingleWirelessDeviceImportTaskResponse startSingleWirelessDeviceImportTask(
            Consumer<StartSingleWirelessDeviceImportTaskRequest.Builder> startSingleWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return startSingleWirelessDeviceImportTask(StartSingleWirelessDeviceImportTaskRequest.builder()
                .applyMutation(startSingleWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     * </p>
     *
     * @param startWirelessDeviceImportTaskRequest
     * @return Result of the StartWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWirelessDeviceImportTaskResponse startWirelessDeviceImportTask(
            StartWirelessDeviceImportTaskRequest startWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param startWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return Result of the StartWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.StartWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWirelessDeviceImportTaskResponse startWirelessDeviceImportTask(
            Consumer<StartWirelessDeviceImportTaskRequest.Builder> startWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return startWirelessDeviceImportTask(StartWirelessDeviceImportTaskRequest.builder()
                .applyMutation(startWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws TooManyTagsException
     *         The request was denied because the resource can't have any more tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, TooManyTagsException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws TooManyTagsException
     *         The request was denied because the resource can't have any more tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, TooManyTagsException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return Result of the TestWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default TestWirelessDeviceResponse testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TestWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param testWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link TestWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the TestWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default TestWirelessDeviceResponse testWirelessDevice(Consumer<TestWirelessDeviceRequest.Builder> testWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return testWirelessDevice(TestWirelessDeviceRequest.builder().applyMutation(testWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDestinationRequest.Builder} to create a request.
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Update the event configuration based on resource types.
     * </p>
     *
     * @param updateEventConfigurationByResourceTypesRequest
     * @return Result of the UpdateEventConfigurationByResourceTypes operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventConfigurationByResourceTypesResponse updateEventConfigurationByResourceTypes(
            UpdateEventConfigurationByResourceTypesRequest updateEventConfigurationByResourceTypesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the event configuration based on resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateEventConfigurationByResourceTypesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateEventConfigurationByResourceTypesRequest#builder()}
     * </p>
     *
     * @param updateEventConfigurationByResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateEventConfigurationByResourceTypesRequest.Builder} to create a request.
     * @return Result of the UpdateEventConfigurationByResourceTypes operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventConfigurationByResourceTypesResponse updateEventConfigurationByResourceTypes(
            Consumer<UpdateEventConfigurationByResourceTypesRequest.Builder> updateEventConfigurationByResourceTypesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateEventConfigurationByResourceTypes(UpdateEventConfigurationByResourceTypesRequest.builder()
                .applyMutation(updateEventConfigurationByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Updates properties of a FUOTA task.
     * </p>
     *
     * @param updateFuotaTaskRequest
     * @return Result of the UpdateFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFuotaTaskResponse updateFuotaTask(UpdateFuotaTaskRequest updateFuotaTaskRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFuotaTaskRequest#builder()}
     * </p>
     *
     * @param updateFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFuotaTaskRequest.Builder} to create a request.
     * @return Result of the UpdateFuotaTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFuotaTaskResponse updateFuotaTask(Consumer<UpdateFuotaTaskRequest.Builder> updateFuotaTaskRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateFuotaTask(UpdateFuotaTaskRequest.builder().applyMutation(updateFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     * @return Result of the UpdateLogLevelsByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLogLevelsByResourceTypesResponse updateLogLevelsByResourceTypes(
            UpdateLogLevelsByResourceTypesRequest updateLogLevelsByResourceTypesRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLogLevelsByResourceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLogLevelsByResourceTypesRequest#builder()}
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLogLevelsByResourceTypesRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLogLevelsByResourceTypes operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLogLevelsByResourceTypesResponse updateLogLevelsByResourceTypes(
            Consumer<UpdateLogLevelsByResourceTypesRequest.Builder> updateLogLevelsByResourceTypesRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateLogLevelsByResourceTypes(UpdateLogLevelsByResourceTypesRequest.builder()
                .applyMutation(updateLogLevelsByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Updates properties of a multicast group session.
     * </p>
     *
     * @param updateMulticastGroupRequest
     * @return Result of the UpdateMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMulticastGroupResponse updateMulticastGroup(UpdateMulticastGroupRequest updateMulticastGroupRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMulticastGroupRequest#builder()}
     * </p>
     *
     * @param updateMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMulticastGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMulticastGroup operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMulticastGroupResponse updateMulticastGroup(
            Consumer<UpdateMulticastGroupRequest.Builder> updateMulticastGroupRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return updateMulticastGroup(UpdateMulticastGroupRequest.builder().applyMutation(updateMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Update network analyzer configuration.
     * </p>
     *
     * @param updateNetworkAnalyzerConfigurationRequest
     * @return Result of the UpdateNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkAnalyzerConfigurationResponse updateNetworkAnalyzerConfiguration(
            UpdateNetworkAnalyzerConfigurationRequest updateNetworkAnalyzerConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateNetworkAnalyzerConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkAnalyzerConfigurationResponse updateNetworkAnalyzerConfiguration(
            Consumer<UpdateNetworkAnalyzerConfigurationRequest.Builder> updateNetworkAnalyzerConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateNetworkAnalyzerConfiguration(UpdateNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(updateNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return Result of the UpdatePartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePartnerAccountResponse updatePartnerAccount(UpdatePartnerAccountRequest updatePartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnerAccountRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePartnerAccountRequest#builder()}
     * </p>
     *
     * @param updatePartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePartnerAccountRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePartnerAccountResponse updatePartnerAccount(
            Consumer<UpdatePartnerAccountRequest.Builder> updatePartnerAccountRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return updatePartnerAccount(UpdatePartnerAccountRequest.builder().applyMutation(updatePartnerAccountRequest).build());
    }

    /**
     * <p>
     * Update the position information of a resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param updatePositionRequest
     * @return Result of the UpdatePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePosition" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default UpdatePositionResponse updatePosition(UpdatePositionRequest updatePositionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the position information of a resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePositionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePositionRequest#builder()}
     * </p>
     *
     * @param updatePositionRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePositionRequest.Builder} to create a request.
     * @return Result of the UpdatePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePosition" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default UpdatePositionResponse updatePosition(Consumer<UpdatePositionRequest.Builder> updatePositionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return updatePosition(UpdatePositionRequest.builder().applyMutation(updatePositionRequest).build());
    }

    /**
     * <p>
     * Update the event configuration for a particular resource identifier.
     * </p>
     *
     * @param updateResourceEventConfigurationRequest
     * @return Result of the UpdateResourceEventConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceEventConfigurationResponse updateResourceEventConfiguration(
            UpdateResourceEventConfigurationRequest updateResourceEventConfigurationRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the event configuration for a particular resource identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceEventConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateResourceEventConfigurationRequest#builder()}
     * </p>
     *
     * @param updateResourceEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceEventConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateResourceEventConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceEventConfigurationResponse updateResourceEventConfiguration(
            Consumer<UpdateResourceEventConfigurationRequest.Builder> updateResourceEventConfigurationRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateResourceEventConfiguration(UpdateResourceEventConfigurationRequest.builder()
                .applyMutation(updateResourceEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Update the position information of a given wireless device or a wireless gateway resource. The position
     * coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic
     * System (WGS84)</a>.
     * </p>
     *
     * @param updateResourcePositionRequest
     * @return Result of the UpdateResourcePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourcePositionResponse updateResourcePosition(UpdateResourcePositionRequest updateResourcePositionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the position information of a given wireless device or a wireless gateway resource. The position
     * coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic
     * System (WGS84)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourcePositionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourcePositionRequest#builder()}
     * </p>
     *
     * @param updateResourcePositionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourcePositionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourcePosition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourcePositionResponse updateResourcePosition(
            Consumer<UpdateResourcePositionRequest.Builder> updateResourcePositionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateResourcePosition(UpdateResourcePositionRequest.builder().applyMutation(updateResourcePositionRequest)
                .build());
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return Result of the UpdateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceResponse updateWirelessDevice(UpdateWirelessDeviceRequest updateWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceResponse updateWirelessDevice(
            Consumer<UpdateWirelessDeviceRequest.Builder> updateWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateWirelessDevice(UpdateWirelessDeviceRequest.builder().applyMutation(updateWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Update an import task to add more devices to the task.
     * </p>
     *
     * @param updateWirelessDeviceImportTaskRequest
     * @return Result of the UpdateWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceImportTaskResponse updateWirelessDeviceImportTask(
            UpdateWirelessDeviceImportTaskRequest updateWirelessDeviceImportTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an import task to add more devices to the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateWirelessDeviceImportTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceImportTaskResponse updateWirelessDeviceImportTask(
            Consumer<UpdateWirelessDeviceImportTaskRequest.Builder> updateWirelessDeviceImportTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateWirelessDeviceImportTask(UpdateWirelessDeviceImportTaskRequest.builder()
                .applyMutation(updateWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return Result of the UpdateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessGatewayResponse updateWirelessGateway(UpdateWirelessGatewayRequest updateWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param updateWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessGatewayResponse updateWirelessGateway(
            Consumer<UpdateWirelessGatewayRequest.Builder> updateWirelessGatewayRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateWirelessGateway(UpdateWirelessGatewayRequest.builder().applyMutation(updateWirelessGatewayRequest).build());
    }

    /**
     * Create a {@link IotWirelessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotWirelessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotWirelessClient}.
     */
    static IotWirelessClientBuilder builder() {
        return new DefaultIotWirelessClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IotWirelessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
