/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher;

/**
 * Service client for accessing AWS IoT Wireless asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS IoT Wireless provides bi-directional communication between internet-connected wireless devices and the AWS Cloud.
 * To onboard both LoRaWAN and Sidewalk devices to AWS IoT, use the IoT Wireless API. These wireless devices use the Low
 * Power Wide Area Networking (LPWAN) communication protocol to communicate with AWS IoT.
 * </p>
 * <p>
 * Using the API, you can perform create, read, update, and delete operations for your wireless devices, gateways,
 * destinations, and profiles. After onboarding your devices, you can use the API operations to set log levels and
 * monitor your devices with CloudWatch.
 * </p>
 * <p>
 * You can also use the API operations to create multicast groups and schedule a multicast session for sending a
 * downlink message to devices in the group. By using Firmware Updates Over-The-Air (FUOTA) API operations, you can
 * create a FUOTA task and schedule a session to update the firmware of individual devices or an entire group of devices
 * in a multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotWirelessAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotwireless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotwireless";

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAwsAccountWithPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAwsAccountWithPartnerAccountRequest#builder()}
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAwsAccountWithPartnerAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            Consumer<AssociateAwsAccountWithPartnerAccountRequest.Builder> associateAwsAccountWithPartnerAccountRequest) {
        return associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.builder()
                .applyMutation(associateAwsAccountWithPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Associate a multicast group with a FUOTA task.
     * </p>
     *
     * @param associateMulticastGroupWithFuotaTaskRequest
     * @return A Java Future containing the result of the AssociateMulticastGroupWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateMulticastGroupWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateMulticastGroupWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMulticastGroupWithFuotaTaskResponse> associateMulticastGroupWithFuotaTask(
            AssociateMulticastGroupWithFuotaTaskRequest associateMulticastGroupWithFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a multicast group with a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateMulticastGroupWithFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateMulticastGroupWithFuotaTaskRequest#builder()}
     * </p>
     *
     * @param associateMulticastGroupWithFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link AssociateMulticastGroupWithFuotaTaskRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateMulticastGroupWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateMulticastGroupWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateMulticastGroupWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMulticastGroupWithFuotaTaskResponse> associateMulticastGroupWithFuotaTask(
            Consumer<AssociateMulticastGroupWithFuotaTaskRequest.Builder> associateMulticastGroupWithFuotaTaskRequest) {
        return associateMulticastGroupWithFuotaTask(AssociateMulticastGroupWithFuotaTaskRequest.builder()
                .applyMutation(associateMulticastGroupWithFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Associate a wireless device with a FUOTA task.
     * </p>
     *
     * @param associateWirelessDeviceWithFuotaTaskRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithFuotaTaskResponse> associateWirelessDeviceWithFuotaTask(
            AssociateWirelessDeviceWithFuotaTaskRequest associateWirelessDeviceWithFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a wireless device with a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessDeviceWithFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessDeviceWithFuotaTaskRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithFuotaTaskRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithFuotaTaskResponse> associateWirelessDeviceWithFuotaTask(
            Consumer<AssociateWirelessDeviceWithFuotaTaskRequest.Builder> associateWirelessDeviceWithFuotaTaskRequest) {
        return associateWirelessDeviceWithFuotaTask(AssociateWirelessDeviceWithFuotaTaskRequest.builder()
                .applyMutation(associateWirelessDeviceWithFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a multicast group.
     * </p>
     *
     * @param associateWirelessDeviceWithMulticastGroupRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithMulticastGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithMulticastGroupResponse> associateWirelessDeviceWithMulticastGroup(
            AssociateWirelessDeviceWithMulticastGroupRequest associateWirelessDeviceWithMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessDeviceWithMulticastGroupRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessDeviceWithMulticastGroupRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessDeviceWithMulticastGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithMulticastGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithMulticastGroupResponse> associateWirelessDeviceWithMulticastGroup(
            Consumer<AssociateWirelessDeviceWithMulticastGroupRequest.Builder> associateWirelessDeviceWithMulticastGroupRequest) {
        return associateWirelessDeviceWithMulticastGroup(AssociateWirelessDeviceWithMulticastGroupRequest.builder()
                .applyMutation(associateWirelessDeviceWithMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessDeviceWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessDeviceWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            Consumer<AssociateWirelessDeviceWithThingRequest.Builder> associateWirelessDeviceWithThingRequest) {
        return associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.builder()
                .applyMutation(associateWirelessDeviceWithThingRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessGatewayWithCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessGatewayWithCertificateRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessGatewayWithCertificateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            Consumer<AssociateWirelessGatewayWithCertificateRequest.Builder> associateWirelessGatewayWithCertificateRequest) {
        return associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.builder()
                .applyMutation(associateWirelessGatewayWithCertificateRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessGatewayWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessGatewayWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessGatewayWithThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            Consumer<AssociateWirelessGatewayWithThingRequest.Builder> associateWirelessGatewayWithThingRequest) {
        return associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.builder()
                .applyMutation(associateWirelessGatewayWithThingRequest).build());
    }

    /**
     * <p>
     * Cancels an existing multicast group session.
     * </p>
     *
     * @param cancelMulticastGroupSessionRequest
     * @return A Java Future containing the result of the CancelMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CancelMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CancelMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMulticastGroupSessionResponse> cancelMulticastGroupSession(
            CancelMulticastGroupSessionRequest cancelMulticastGroupSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an existing multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMulticastGroupSessionRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param cancelMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link CancelMulticastGroupSessionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CancelMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CancelMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CancelMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMulticastGroupSessionResponse> cancelMulticastGroupSession(
            Consumer<CancelMulticastGroupSessionRequest.Builder> cancelMulticastGroupSessionRequest) {
        return cancelMulticastGroupSession(CancelMulticastGroupSessionRequest.builder()
                .applyMutation(cancelMulticastGroupSessionRequest).build());
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(
            Consumer<CreateDestinationRequest.Builder> createDestinationRequest) {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            CreateDeviceProfileRequest createDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceProfileRequest#builder()}
     * </p>
     *
     * @param createDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            Consumer<CreateDeviceProfileRequest.Builder> createDeviceProfileRequest) {
        return createDeviceProfile(CreateDeviceProfileRequest.builder().applyMutation(createDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a FUOTA task.
     * </p>
     *
     * @param createFuotaTaskRequest
     * @return A Java Future containing the result of the CreateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFuotaTaskResponse> createFuotaTask(CreateFuotaTaskRequest createFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFuotaTaskRequest#builder()}
     * </p>
     *
     * @param createFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFuotaTaskResponse> createFuotaTask(
            Consumer<CreateFuotaTaskRequest.Builder> createFuotaTaskRequest) {
        return createFuotaTask(CreateFuotaTaskRequest.builder().applyMutation(createFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Creates a multicast group.
     * </p>
     *
     * @param createMulticastGroupRequest
     * @return A Java Future containing the result of the CreateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMulticastGroupResponse> createMulticastGroup(
            CreateMulticastGroupRequest createMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMulticastGroupRequest#builder()}
     * </p>
     *
     * @param createMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateMulticastGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMulticastGroupResponse> createMulticastGroup(
            Consumer<CreateMulticastGroupRequest.Builder> createMulticastGroupRequest) {
        return createMulticastGroup(CreateMulticastGroupRequest.builder().applyMutation(createMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new network analyzer configuration.
     * </p>
     *
     * @param createNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the CreateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkAnalyzerConfigurationResponse> createNetworkAnalyzerConfiguration(
            CreateNetworkAnalyzerConfigurationRequest createNetworkAnalyzerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param createNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkAnalyzerConfigurationResponse> createNetworkAnalyzerConfiguration(
            Consumer<CreateNetworkAnalyzerConfigurationRequest.Builder> createNetworkAnalyzerConfigurationRequest) {
        return createNetworkAnalyzerConfiguration(CreateNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(createNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            CreateServiceProfileRequest createServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceProfileRequest#builder()}
     * </p>
     *
     * @param createServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            Consumer<CreateServiceProfileRequest.Builder> createServiceProfileRequest) {
        return createServiceProfile(CreateServiceProfileRequest.builder().applyMutation(createServiceProfileRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            CreateWirelessDeviceRequest createWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param createWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            Consumer<CreateWirelessDeviceRequest.Builder> createWirelessDeviceRequest) {
        return createWirelessDevice(CreateWirelessDeviceRequest.builder().applyMutation(createWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            CreateWirelessGatewayRequest createWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            Consumer<CreateWirelessGatewayRequest.Builder> createWirelessGatewayRequest) {
        return createWirelessGateway(CreateWirelessGatewayRequest.builder().applyMutation(createWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            Consumer<CreateWirelessGatewayTaskRequest.Builder> createWirelessGatewayTaskRequest) {
        return createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.builder()
                .applyMutation(createWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            Consumer<CreateWirelessGatewayTaskDefinitionRequest.Builder> createWirelessGatewayTaskDefinitionRequest) {
        return createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(createWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(
            Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest) {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            DeleteDeviceProfileRequest deleteDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceProfileRequest#builder()}
     * </p>
     *
     * @param deleteDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            Consumer<DeleteDeviceProfileRequest.Builder> deleteDeviceProfileRequest) {
        return deleteDeviceProfile(DeleteDeviceProfileRequest.builder().applyMutation(deleteDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a FUOTA task.
     * </p>
     *
     * @param deleteFuotaTaskRequest
     * @return A Java Future containing the result of the DeleteFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFuotaTaskResponse> deleteFuotaTask(DeleteFuotaTaskRequest deleteFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFuotaTaskRequest#builder()}
     * </p>
     *
     * @param deleteFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFuotaTaskResponse> deleteFuotaTask(
            Consumer<DeleteFuotaTaskRequest.Builder> deleteFuotaTaskRequest) {
        return deleteFuotaTask(DeleteFuotaTaskRequest.builder().applyMutation(deleteFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a multicast group if it is not in use by a fuota task.
     * </p>
     *
     * @param deleteMulticastGroupRequest
     * @return A Java Future containing the result of the DeleteMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMulticastGroupResponse> deleteMulticastGroup(
            DeleteMulticastGroupRequest deleteMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a multicast group if it is not in use by a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMulticastGroupRequest#builder()}
     * </p>
     *
     * @param deleteMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMulticastGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMulticastGroupResponse> deleteMulticastGroup(
            Consumer<DeleteMulticastGroupRequest.Builder> deleteMulticastGroupRequest) {
        return deleteMulticastGroup(DeleteMulticastGroupRequest.builder().applyMutation(deleteMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a network analyzer configuration.
     * </p>
     *
     * @param deleteNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the DeleteNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAnalyzerConfigurationResponse> deleteNetworkAnalyzerConfiguration(
            DeleteNetworkAnalyzerConfigurationRequest deleteNetworkAnalyzerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAnalyzerConfigurationResponse> deleteNetworkAnalyzerConfiguration(
            Consumer<DeleteNetworkAnalyzerConfigurationRequest.Builder> deleteNetworkAnalyzerConfigurationRequest) {
        return deleteNetworkAnalyzerConfiguration(DeleteNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(deleteNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Remove queued messages from the downlink queue.
     * </p>
     *
     * @param deleteQueuedMessagesRequest
     * @return A Java Future containing the result of the DeleteQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueuedMessagesResponse> deleteQueuedMessages(
            DeleteQueuedMessagesRequest deleteQueuedMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove queued messages from the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param deleteQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueuedMessagesResponse> deleteQueuedMessages(
            Consumer<DeleteQueuedMessagesRequest.Builder> deleteQueuedMessagesRequest) {
        return deleteQueuedMessages(DeleteQueuedMessagesRequest.builder().applyMutation(deleteQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            DeleteServiceProfileRequest deleteServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceProfileRequest#builder()}
     * </p>
     *
     * @param deleteServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            Consumer<DeleteServiceProfileRequest.Builder> deleteServiceProfileRequest) {
        return deleteServiceProfile(DeleteServiceProfileRequest.builder().applyMutation(deleteServiceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            DeleteWirelessDeviceRequest deleteWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            Consumer<DeleteWirelessDeviceRequest.Builder> deleteWirelessDeviceRequest) {
        return deleteWirelessDevice(DeleteWirelessDeviceRequest.builder().applyMutation(deleteWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Delete an import task.
     * </p>
     *
     * @param deleteWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceImportTaskResponse> deleteWirelessDeviceImportTask(
            DeleteWirelessDeviceImportTaskRequest deleteWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceImportTaskResponse> deleteWirelessDeviceImportTask(
            Consumer<DeleteWirelessDeviceImportTaskRequest.Builder> deleteWirelessDeviceImportTaskRequest) {
        return deleteWirelessDeviceImportTask(DeleteWirelessDeviceImportTaskRequest.builder()
                .applyMutation(deleteWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            DeleteWirelessGatewayRequest deleteWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            Consumer<DeleteWirelessGatewayRequest.Builder> deleteWirelessGatewayRequest) {
        return deleteWirelessGateway(DeleteWirelessGatewayRequest.builder().applyMutation(deleteWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            Consumer<DeleteWirelessGatewayTaskRequest.Builder> deleteWirelessGatewayTaskRequest) {
        return deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            Consumer<DeleteWirelessGatewayTaskDefinitionRequest.Builder> deleteWirelessGatewayTaskDefinitionRequest) {
        return deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deregister a wireless device from AWS IoT Wireless.
     * </p>
     *
     * @param deregisterWirelessDeviceRequest
     * @return A Java Future containing the result of the DeregisterWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeregisterWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeregisterWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWirelessDeviceResponse> deregisterWirelessDevice(
            DeregisterWirelessDeviceRequest deregisterWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregister a wireless device from AWS IoT Wireless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deregisterWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeregisterWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeregisterWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWirelessDeviceResponse> deregisterWirelessDevice(
            Consumer<DeregisterWirelessDeviceRequest.Builder> deregisterWirelessDeviceRequest) {
        return deregisterWirelessDevice(DeregisterWirelessDeviceRequest.builder().applyMutation(deregisterWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAwsAccountFromPartnerAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            Consumer<DisassociateAwsAccountFromPartnerAccountRequest.Builder> disassociateAwsAccountFromPartnerAccountRequest) {
        return disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.builder()
                .applyMutation(disassociateAwsAccountFromPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a multicast group from a fuota task.
     * </p>
     *
     * @param disassociateMulticastGroupFromFuotaTaskRequest
     * @return A Java Future containing the result of the DisassociateMulticastGroupFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateMulticastGroupFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateMulticastGroupFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMulticastGroupFromFuotaTaskResponse> disassociateMulticastGroupFromFuotaTask(
            DisassociateMulticastGroupFromFuotaTaskRequest disassociateMulticastGroupFromFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a multicast group from a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateMulticastGroupFromFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateMulticastGroupFromFuotaTaskRequest#builder()}
     * </p>
     *
     * @param disassociateMulticastGroupFromFuotaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateMulticastGroupFromFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateMulticastGroupFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateMulticastGroupFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateMulticastGroupFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMulticastGroupFromFuotaTaskResponse> disassociateMulticastGroupFromFuotaTask(
            Consumer<DisassociateMulticastGroupFromFuotaTaskRequest.Builder> disassociateMulticastGroupFromFuotaTaskRequest) {
        return disassociateMulticastGroupFromFuotaTask(DisassociateMulticastGroupFromFuotaTaskRequest.builder()
                .applyMutation(disassociateMulticastGroupFromFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from a FUOTA task.
     * </p>
     *
     * @param disassociateWirelessDeviceFromFuotaTaskRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromFuotaTaskResponse> disassociateWirelessDeviceFromFuotaTask(
            DisassociateWirelessDeviceFromFuotaTaskRequest disassociateWirelessDeviceFromFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessDeviceFromFuotaTaskRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessDeviceFromFuotaTaskRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromFuotaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessDeviceFromFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromFuotaTaskResponse> disassociateWirelessDeviceFromFuotaTask(
            Consumer<DisassociateWirelessDeviceFromFuotaTaskRequest.Builder> disassociateWirelessDeviceFromFuotaTaskRequest) {
        return disassociateWirelessDeviceFromFuotaTask(DisassociateWirelessDeviceFromFuotaTaskRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from a multicast group.
     * </p>
     *
     * @param disassociateWirelessDeviceFromMulticastGroupRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromMulticastGroupResponse> disassociateWirelessDeviceFromMulticastGroup(
            DisassociateWirelessDeviceFromMulticastGroupRequest disassociateWirelessDeviceFromMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessDeviceFromMulticastGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessDeviceFromMulticastGroupRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessDeviceFromMulticastGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromMulticastGroupResponse> disassociateWirelessDeviceFromMulticastGroup(
            Consumer<DisassociateWirelessDeviceFromMulticastGroupRequest.Builder> disassociateWirelessDeviceFromMulticastGroupRequest) {
        return disassociateWirelessDeviceFromMulticastGroup(DisassociateWirelessDeviceFromMulticastGroupRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWirelessDeviceFromThingRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWirelessDeviceFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessDeviceFromThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            Consumer<DisassociateWirelessDeviceFromThingRequest.Builder> disassociateWirelessDeviceFromThingRequest) {
        return disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromThingRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            Consumer<DisassociateWirelessGatewayFromCertificateRequest.Builder> disassociateWirelessGatewayFromCertificateRequest) {
        return disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromCertificateRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromThingRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessGatewayFromThingRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            Consumer<DisassociateWirelessGatewayFromThingRequest.Builder> disassociateWirelessGatewayFromThingRequest) {
        return disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromThingRequest).build());
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on {@link GetDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest) {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceProfileRequest#builder()}
     * </p>
     *
     * @param getDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(
            Consumer<GetDeviceProfileRequest.Builder> getDeviceProfileRequest) {
        return getDeviceProfile(GetDeviceProfileRequest.builder().applyMutation(getDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Get the event configuration based on resource types.
     * </p>
     *
     * @param getEventConfigurationByResourceTypesRequest
     * @return A Java Future containing the result of the GetEventConfigurationByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventConfigurationByResourceTypesResponse> getEventConfigurationByResourceTypes(
            GetEventConfigurationByResourceTypesRequest getEventConfigurationByResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the event configuration based on resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEventConfigurationByResourceTypesRequest.Builder} avoiding the need to create one manually via
     * {@link GetEventConfigurationByResourceTypesRequest#builder()}
     * </p>
     *
     * @param getEventConfigurationByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventConfigurationByResourceTypesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEventConfigurationByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventConfigurationByResourceTypesResponse> getEventConfigurationByResourceTypes(
            Consumer<GetEventConfigurationByResourceTypesRequest.Builder> getEventConfigurationByResourceTypesRequest) {
        return getEventConfigurationByResourceTypes(GetEventConfigurationByResourceTypesRequest.builder()
                .applyMutation(getEventConfigurationByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about a FUOTA task.
     * </p>
     *
     * @param getFuotaTaskRequest
     * @return A Java Future containing the result of the GetFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetFuotaTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFuotaTaskResponse> getFuotaTask(GetFuotaTaskRequest getFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFuotaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetFuotaTaskRequest#builder()}
     * </p>
     *
     * @param getFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetFuotaTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFuotaTaskResponse> getFuotaTask(Consumer<GetFuotaTaskRequest.Builder> getFuotaTaskRequest) {
        return getFuotaTask(GetFuotaTaskRequest.builder().applyMutation(getFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the GetLogLevelsByResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLogLevelsByResourceTypesResponse> getLogLevelsByResourceTypes(
            GetLogLevelsByResourceTypesRequest getLogLevelsByResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogLevelsByResourceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link GetLogLevelsByResourceTypesRequest#builder()}
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetLogLevelsByResourceTypesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetLogLevelsByResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLogLevelsByResourceTypesResponse> getLogLevelsByResourceTypes(
            Consumer<GetLogLevelsByResourceTypesRequest.Builder> getLogLevelsByResourceTypesRequest) {
        return getLogLevelsByResourceTypes(GetLogLevelsByResourceTypesRequest.builder()
                .applyMutation(getLogLevelsByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about a multicast group.
     * </p>
     *
     * @param getMulticastGroupRequest
     * @return A Java Future containing the result of the GetMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMulticastGroupResponse> getMulticastGroup(GetMulticastGroupRequest getMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMulticastGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetMulticastGroupRequest#builder()}
     * </p>
     *
     * @param getMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetMulticastGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMulticastGroupResponse> getMulticastGroup(
            Consumer<GetMulticastGroupRequest.Builder> getMulticastGroupRequest) {
        return getMulticastGroup(GetMulticastGroupRequest.builder().applyMutation(getMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about a multicast group session.
     * </p>
     *
     * @param getMulticastGroupSessionRequest
     * @return A Java Future containing the result of the GetMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMulticastGroupSessionResponse> getMulticastGroupSession(
            GetMulticastGroupSessionRequest getMulticastGroupSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMulticastGroupSessionRequest.Builder} avoiding
     * the need to create one manually via {@link GetMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param getMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link GetMulticastGroupSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMulticastGroupSessionResponse> getMulticastGroupSession(
            Consumer<GetMulticastGroupSessionRequest.Builder> getMulticastGroupSessionRequest) {
        return getMulticastGroupSession(GetMulticastGroupSessionRequest.builder().applyMutation(getMulticastGroupSessionRequest)
                .build());
    }

    /**
     * <p>
     * Get network analyzer configuration.
     * </p>
     *
     * @param getNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the GetNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkAnalyzerConfigurationResponse> getNetworkAnalyzerConfiguration(
            GetNetworkAnalyzerConfigurationRequest getNetworkAnalyzerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param getNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkAnalyzerConfigurationResponse> getNetworkAnalyzerConfiguration(
            Consumer<GetNetworkAnalyzerConfigurationRequest.Builder> getNetworkAnalyzerConfigurationRequest) {
        return getNetworkAnalyzerConfiguration(GetNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(getNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnerAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetPartnerAccountRequest#builder()}
     * </p>
     *
     * @param getPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetPartnerAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(
            Consumer<GetPartnerAccountRequest.Builder> getPartnerAccountRequest) {
        return getPartnerAccount(GetPartnerAccountRequest.builder().applyMutation(getPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Get the position information for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionRequest
     * @return A Java Future containing the result of the GetPosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPosition" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<GetPositionResponse> getPosition(GetPositionRequest getPositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the position information for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPositionRequest#builder()}
     * </p>
     *
     * @param getPositionRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPosition" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<GetPositionResponse> getPosition(Consumer<GetPositionRequest.Builder> getPositionRequest) {
        return getPosition(GetPositionRequest.builder().applyMutation(getPositionRequest).build());
    }

    /**
     * <p>
     * Get position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionConfigurationRequest
     * @return A Java Future containing the result of the GetPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<GetPositionConfigurationResponse> getPositionConfiguration(
            GetPositionConfigurationRequest getPositionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetPositionConfigurationRequest#builder()}
     * </p>
     *
     * @param getPositionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<GetPositionConfigurationResponse> getPositionConfiguration(
            Consumer<GetPositionConfigurationRequest.Builder> getPositionConfigurationRequest) {
        return getPositionConfiguration(GetPositionConfigurationRequest.builder().applyMutation(getPositionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using
     * solvers that are provided by third-party vendors.
     * </p>
     *
     * @param getPositionEstimateRequest
     * @return A Java Future containing the result of the GetPositionEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPositionEstimateResponse> getPositionEstimate(
            GetPositionEstimateRequest getPositionEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using
     * solvers that are provided by third-party vendors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPositionEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link GetPositionEstimateRequest#builder()}
     * </p>
     *
     * @param getPositionEstimateRequest
     *        A {@link Consumer} that will call methods on {@link GetPositionEstimateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPositionEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPositionEstimateResponse> getPositionEstimate(
            Consumer<GetPositionEstimateRequest.Builder> getPositionEstimateRequest) {
        return getPositionEstimate(GetPositionEstimateRequest.builder().applyMutation(getPositionEstimateRequest).build());
    }

    /**
     * <p>
     * Get the event configuration for a particular resource identifier.
     * </p>
     *
     * @param getResourceEventConfigurationRequest
     * @return A Java Future containing the result of the GetResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceEventConfigurationResponse> getResourceEventConfiguration(
            GetResourceEventConfigurationRequest getResourceEventConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the event configuration for a particular resource identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceEventConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceEventConfigurationRequest#builder()}
     * </p>
     *
     * @param getResourceEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceEventConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceEventConfigurationResponse> getResourceEventConfiguration(
            Consumer<GetResourceEventConfigurationRequest.Builder> getResourceEventConfigurationRequest) {
        return getResourceEventConfiguration(GetResourceEventConfigurationRequest.builder()
                .applyMutation(getResourceEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     *
     * @param getResourceLogLevelRequest
     * @return A Java Future containing the result of the GetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceLogLevelResponse> getResourceLogLevel(
            GetResourceLogLevelRequest getResourceLogLevelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param getResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceLogLevelResponse> getResourceLogLevel(
            Consumer<GetResourceLogLevelRequest.Builder> getResourceLogLevelRequest) {
        return getResourceLogLevel(GetResourceLogLevelRequest.builder().applyMutation(getResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Get the position information for a given wireless device or a wireless gateway resource. The position information
     * uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.
     * </p>
     *
     * @param getResourcePositionRequest
     * @return A Java Future containing the result of the GetResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePositionResponse> getResourcePosition(
            GetResourcePositionRequest getResourcePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the position information for a given wireless device or a wireless gateway resource. The position information
     * uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePositionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePositionRequest#builder()}
     * </p>
     *
     * @param getResourcePositionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePositionResponse> getResourcePosition(
            Consumer<GetResourcePositionRequest.Builder> getResourcePositionRequest) {
        return getResourcePosition(GetResourcePositionRequest.builder().applyMutation(getResourcePositionRequest).build());
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceEndpointRequest#builder()}
     * </p>
     *
     * @param getServiceEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(
            Consumer<GetServiceEndpointRequest.Builder> getServiceEndpointRequest) {
        return getServiceEndpoint(GetServiceEndpointRequest.builder().applyMutation(getServiceEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceProfileResponse> getServiceProfile(GetServiceProfileRequest getServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceProfileRequest#builder()}
     * </p>
     *
     * @param getServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceProfileResponse> getServiceProfile(
            Consumer<GetServiceProfileRequest.Builder> getServiceProfileRequest) {
        return getServiceProfile(GetServiceProfileRequest.builder().applyMutation(getServiceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(
            Consumer<GetWirelessDeviceRequest.Builder> getWirelessDeviceRequest) {
        return getWirelessDevice(GetWirelessDeviceRequest.builder().applyMutation(getWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Get information about an import task and count of device onboarding summary information for the import task.
     * </p>
     *
     * @param getWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the GetWirelessDeviceImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceImportTaskResponse> getWirelessDeviceImportTask(
            GetWirelessDeviceImportTaskRequest getWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an import task and count of device onboarding summary information for the import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceImportTaskRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetWirelessDeviceImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceImportTaskResponse> getWirelessDeviceImportTask(
            Consumer<GetWirelessDeviceImportTaskRequest.Builder> getWirelessDeviceImportTaskRequest) {
        return getWirelessDeviceImportTask(GetWirelessDeviceImportTaskRequest.builder()
                .applyMutation(getWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            Consumer<GetWirelessDeviceStatisticsRequest.Builder> getWirelessDeviceStatisticsRequest) {
        return getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.builder()
                .applyMutation(getWirelessDeviceStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(
            Consumer<GetWirelessGatewayRequest.Builder> getWirelessGatewayRequest) {
        return getWirelessGateway(GetWirelessGatewayRequest.builder().applyMutation(getWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayCertificateRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            Consumer<GetWirelessGatewayCertificateRequest.Builder> getWirelessGatewayCertificateRequest) {
        return getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.builder()
                .applyMutation(getWirelessGatewayCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetWirelessGatewayFirmwareInformationRequest.Builder} avoiding the need to create one manually via
     * {@link GetWirelessGatewayFirmwareInformationRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayFirmwareInformationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            Consumer<GetWirelessGatewayFirmwareInformationRequest.Builder> getWirelessGatewayFirmwareInformationRequest) {
        return getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.builder()
                .applyMutation(getWirelessGatewayFirmwareInformationRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            Consumer<GetWirelessGatewayStatisticsRequest.Builder> getWirelessGatewayStatisticsRequest) {
        return getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.builder()
                .applyMutation(getWirelessGatewayStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            Consumer<GetWirelessGatewayTaskRequest.Builder> getWirelessGatewayTaskRequest) {
        return getWirelessGatewayTask(GetWirelessGatewayTaskRequest.builder().applyMutation(getWirelessGatewayTaskRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            Consumer<GetWirelessGatewayTaskDefinitionRequest.Builder> getWirelessGatewayTaskDefinitionRequest) {
        return getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(getWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(
            Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) {
        return listDeviceProfiles(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesPublisher listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesPublisher listDeviceProfilesPaginator(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) {
        return listDeviceProfilesPaginator(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * List the Sidewalk devices in an import task and their onboarding status.
     * </p>
     *
     * @param listDevicesForWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the ListDevicesForWirelessDeviceImportTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDevicesForWirelessDeviceImportTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDevicesForWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevicesForWirelessDeviceImportTaskResponse> listDevicesForWirelessDeviceImportTask(
            ListDevicesForWirelessDeviceImportTaskRequest listDevicesForWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Sidewalk devices in an import task and their onboarding status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDevicesForWirelessDeviceImportTaskRequest.Builder} avoiding the need to create one manually via
     * {@link ListDevicesForWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param listDevicesForWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesForWirelessDeviceImportTaskRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDevicesForWirelessDeviceImportTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDevicesForWirelessDeviceImportTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDevicesForWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevicesForWirelessDeviceImportTaskResponse> listDevicesForWirelessDeviceImportTask(
            Consumer<ListDevicesForWirelessDeviceImportTaskRequest.Builder> listDevicesForWirelessDeviceImportTaskRequest) {
        return listDevicesForWirelessDeviceImportTask(ListDevicesForWirelessDeviceImportTaskRequest.builder()
                .applyMutation(listDevicesForWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * List event configurations where at least one event topic has been enabled.
     * </p>
     *
     * @param listEventConfigurationsRequest
     * @return A Java Future containing the result of the ListEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListEventConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListEventConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventConfigurationsResponse> listEventConfigurations(
            ListEventConfigurationsRequest listEventConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List event configurations where at least one event topic has been enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListEventConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListEventConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventConfigurationsResponse> listEventConfigurations(
            Consumer<ListEventConfigurationsRequest.Builder> listEventConfigurationsRequest) {
        return listEventConfigurations(ListEventConfigurationsRequest.builder().applyMutation(listEventConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     *
     * @param listFuotaTasksRequest
     * @return A Java Future containing the result of the ListFuotaTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFuotaTasksResponse> listFuotaTasks(ListFuotaTasksRequest listFuotaTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFuotaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFuotaTasksRequest#builder()}
     * </p>
     *
     * @param listFuotaTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListFuotaTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFuotaTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFuotaTasksResponse> listFuotaTasks(Consumer<ListFuotaTasksRequest.Builder> listFuotaTasksRequest) {
        return listFuotaTasks(ListFuotaTasksRequest.builder().applyMutation(listFuotaTasksRequest).build());
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksPublisher publisher = client.listFuotaTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksPublisher publisher = client.listFuotaTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation.</b>
     * </p>
     *
     * @param listFuotaTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksPublisher listFuotaTasksPaginator(ListFuotaTasksRequest listFuotaTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksPublisher publisher = client.listFuotaTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListFuotaTasksPublisher publisher = client.listFuotaTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFuotaTasks(software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFuotaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFuotaTasksRequest#builder()}
     * </p>
     *
     * @param listFuotaTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListFuotaTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFuotaTasksPublisher listFuotaTasksPaginator(Consumer<ListFuotaTasksRequest.Builder> listFuotaTasksRequest) {
        return listFuotaTasksPaginator(ListFuotaTasksRequest.builder().applyMutation(listFuotaTasksRequest).build());
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     *
     * @param listMulticastGroupsRequest
     * @return A Java Future containing the result of the ListMulticastGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMulticastGroupsResponse> listMulticastGroups(
            ListMulticastGroupsRequest listMulticastGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMulticastGroupsRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMulticastGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMulticastGroupsResponse> listMulticastGroups(
            Consumer<ListMulticastGroupsRequest.Builder> listMulticastGroupsRequest) {
        return listMulticastGroups(ListMulticastGroupsRequest.builder().applyMutation(listMulticastGroupsRequest).build());
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     * @return A Java Future containing the result of the ListMulticastGroupsByFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMulticastGroupsByFuotaTaskResponse> listMulticastGroupsByFuotaTask(
            ListMulticastGroupsByFuotaTaskRequest listMulticastGroupsByFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsByFuotaTaskRequest.Builder}
     * avoiding the need to create one manually via {@link ListMulticastGroupsByFuotaTaskRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsByFuotaTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMulticastGroupsByFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMulticastGroupsByFuotaTaskResponse> listMulticastGroupsByFuotaTask(
            Consumer<ListMulticastGroupsByFuotaTaskRequest.Builder> listMulticastGroupsByFuotaTaskRequest) {
        return listMulticastGroupsByFuotaTask(ListMulticastGroupsByFuotaTaskRequest.builder()
                .applyMutation(listMulticastGroupsByFuotaTaskRequest).build());
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskPublisher publisher = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskPublisher publisher = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskPublisher listMulticastGroupsByFuotaTaskPaginator(
            ListMulticastGroupsByFuotaTaskRequest listMulticastGroupsByFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskPublisher publisher = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsByFuotaTaskPublisher publisher = client.listMulticastGroupsByFuotaTaskPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroupsByFuotaTask(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsByFuotaTaskRequest.Builder}
     * avoiding the need to create one manually via {@link ListMulticastGroupsByFuotaTaskRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsByFuotaTaskRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsByFuotaTaskPublisher listMulticastGroupsByFuotaTaskPaginator(
            Consumer<ListMulticastGroupsByFuotaTaskRequest.Builder> listMulticastGroupsByFuotaTaskRequest) {
        return listMulticastGroupsByFuotaTaskPaginator(ListMulticastGroupsByFuotaTaskRequest.builder()
                .applyMutation(listMulticastGroupsByFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsPublisher publisher = client.listMulticastGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsPublisher publisher = client.listMulticastGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMulticastGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsPublisher listMulticastGroupsPaginator(ListMulticastGroupsRequest listMulticastGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsPublisher publisher = client.listMulticastGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListMulticastGroupsPublisher publisher = client.listMulticastGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMulticastGroups(software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMulticastGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMulticastGroupsRequest#builder()}
     * </p>
     *
     * @param listMulticastGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListMulticastGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMulticastGroupsPublisher listMulticastGroupsPaginator(
            Consumer<ListMulticastGroupsRequest.Builder> listMulticastGroupsRequest) {
        return listMulticastGroupsPaginator(ListMulticastGroupsRequest.builder().applyMutation(listMulticastGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     * @return A Java Future containing the result of the ListNetworkAnalyzerConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> listNetworkAnalyzerConfigurations(
            ListNetworkAnalyzerConfigurationsRequest listNetworkAnalyzerConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkAnalyzerConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNetworkAnalyzerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkAnalyzerConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListNetworkAnalyzerConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> listNetworkAnalyzerConfigurations(
            Consumer<ListNetworkAnalyzerConfigurationsRequest.Builder> listNetworkAnalyzerConfigurationsRequest) {
        return listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsRequest.builder()
                .applyMutation(listNetworkAnalyzerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsPublisher publisher = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsPublisher publisher = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsPublisher listNetworkAnalyzerConfigurationsPaginator(
            ListNetworkAnalyzerConfigurationsRequest listNetworkAnalyzerConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsPublisher publisher = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListNetworkAnalyzerConfigurationsPublisher publisher = client.listNetworkAnalyzerConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkAnalyzerConfigurations(software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkAnalyzerConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNetworkAnalyzerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkAnalyzerConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkAnalyzerConfigurationsPublisher listNetworkAnalyzerConfigurationsPaginator(
            Consumer<ListNetworkAnalyzerConfigurationsRequest.Builder> listNetworkAnalyzerConfigurationsRequest) {
        return listNetworkAnalyzerConfigurationsPaginator(ListNetworkAnalyzerConfigurationsRequest.builder()
                .applyMutation(listNetworkAnalyzerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            ListPartnerAccountsRequest listPartnerAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPartnerAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerAccountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            Consumer<ListPartnerAccountsRequest.Builder> listPartnerAccountsRequest) {
        return listPartnerAccounts(ListPartnerAccountsRequest.builder().applyMutation(listPartnerAccountsRequest).build());
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param listPositionConfigurationsRequest
     * @return A Java Future containing the result of the ListPositionConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<ListPositionConfigurationsResponse> listPositionConfigurations(
            ListPositionConfigurationsRequest listPositionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPositionConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPositionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPositionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPositionConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPositionConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<ListPositionConfigurationsResponse> listPositionConfigurations(
            Consumer<ListPositionConfigurationsRequest.Builder> listPositionConfigurationsRequest) {
        return listPositionConfigurations(ListPositionConfigurationsRequest.builder()
                .applyMutation(listPositionConfigurationsRequest).build());
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsPublisher publisher = client.listPositionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsPublisher publisher = client.listPositionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPositionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsPublisher listPositionConfigurationsPaginator(
            ListPositionConfigurationsRequest listPositionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsPublisher publisher = client.listPositionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListPositionConfigurationsPublisher publisher = client.listPositionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPositionConfigurations(software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPositionConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPositionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPositionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPositionConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default ListPositionConfigurationsPublisher listPositionConfigurationsPaginator(
            Consumer<ListPositionConfigurationsRequest.Builder> listPositionConfigurationsRequest) {
        return listPositionConfigurationsPaginator(ListPositionConfigurationsRequest.builder()
                .applyMutation(listPositionConfigurationsRequest).build());
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     *
     * @param listQueuedMessagesRequest
     * @return A Java Future containing the result of the ListQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueuedMessagesResponse> listQueuedMessages(ListQueuedMessagesRequest listQueuedMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param listQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueuedMessagesResponse> listQueuedMessages(
            Consumer<ListQueuedMessagesRequest.Builder> listQueuedMessagesRequest) {
        return listQueuedMessages(ListQueuedMessagesRequest.builder().applyMutation(listQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesPublisher publisher = client.listQueuedMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesPublisher publisher = client.listQueuedMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueuedMessagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesPublisher listQueuedMessagesPaginator(ListQueuedMessagesRequest listQueuedMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesPublisher publisher = client.listQueuedMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListQueuedMessagesPublisher publisher = client.listQueuedMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueuedMessages(software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuedMessagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueuedMessagesRequest#builder()}
     * </p>
     *
     * @param listQueuedMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuedMessagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueuedMessagesPublisher listQueuedMessagesPaginator(
            Consumer<ListQueuedMessagesRequest.Builder> listQueuedMessagesRequest) {
        return listQueuedMessagesPaginator(ListQueuedMessagesRequest.builder().applyMutation(listQueuedMessagesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            ListServiceProfilesRequest listServiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) {
        return listServiceProfiles(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesPublisher listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesPublisher listServiceProfilesPaginator(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) {
        return listServiceProfilesPaginator(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List wireless devices that have been added to an import task.
     * </p>
     *
     * @param listWirelessDeviceImportTasksRequest
     * @return A Java Future containing the result of the ListWirelessDeviceImportTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDeviceImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDeviceImportTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDeviceImportTasksResponse> listWirelessDeviceImportTasks(
            ListWirelessDeviceImportTasksRequest listWirelessDeviceImportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List wireless devices that have been added to an import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDeviceImportTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessDeviceImportTasksRequest#builder()}
     * </p>
     *
     * @param listWirelessDeviceImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDeviceImportTasksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWirelessDeviceImportTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDeviceImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDeviceImportTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDeviceImportTasksResponse> listWirelessDeviceImportTasks(
            Consumer<ListWirelessDeviceImportTasksRequest.Builder> listWirelessDeviceImportTasksRequest) {
        return listWirelessDeviceImportTasks(ListWirelessDeviceImportTasksRequest.builder()
                .applyMutation(listWirelessDeviceImportTasksRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            ListWirelessDevicesRequest listWirelessDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) {
        return listWirelessDevices(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesPublisher listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesPublisher listWirelessDevicesPaginator(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) {
        return listWirelessDevicesPaginator(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewayTaskDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessGatewayTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewayTaskDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            Consumer<ListWirelessGatewayTaskDefinitionsRequest.Builder> listWirelessGatewayTaskDefinitionsRequest) {
        return listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.builder()
                .applyMutation(listWirelessGatewayTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) {
        return listWirelessGateways(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysPublisher listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysPublisher listWirelessGatewaysPaginator(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) {
        return listWirelessGatewaysPaginator(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Put position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param putPositionConfigurationRequest
     * @return A Java Future containing the result of the PutPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<PutPositionConfigurationResponse> putPositionConfiguration(
            PutPositionConfigurationRequest putPositionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPositionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutPositionConfigurationRequest#builder()}
     * </p>
     *
     * @param putPositionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutPositionConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<PutPositionConfigurationResponse> putPositionConfiguration(
            Consumer<PutPositionConfigurationRequest.Builder> putPositionConfigurationRequest) {
        return putPositionConfiguration(PutPositionConfigurationRequest.builder().applyMutation(putPositionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     *
     * @param putResourceLogLevelRequest
     * @return A Java Future containing the result of the PutResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourceLogLevelResponse> putResourceLogLevel(
            PutResourceLogLevelRequest putResourceLogLevelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link PutResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param putResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link PutResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourceLogLevelResponse> putResourceLogLevel(
            Consumer<PutResourceLogLevelRequest.Builder> putResourceLogLevelRequest) {
        return putResourceLogLevel(PutResourceLogLevelRequest.builder().applyMutation(putResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     * @return A Java Future containing the result of the ResetAllResourceLogLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetAllResourceLogLevelsResponse> resetAllResourceLogLevels(
            ResetAllResourceLogLevelsRequest resetAllResourceLogLevelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetAllResourceLogLevelsRequest.Builder} avoiding
     * the need to create one manually via {@link ResetAllResourceLogLevelsRequest#builder()}
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     *        A {@link Consumer} that will call methods on {@link ResetAllResourceLogLevelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetAllResourceLogLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetAllResourceLogLevelsResponse> resetAllResourceLogLevels(
            Consumer<ResetAllResourceLogLevelsRequest.Builder> resetAllResourceLogLevelsRequest) {
        return resetAllResourceLogLevels(ResetAllResourceLogLevelsRequest.builder()
                .applyMutation(resetAllResourceLogLevelsRequest).build());
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     *
     * @param resetResourceLogLevelRequest
     * @return A Java Future containing the result of the ResetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetResourceLogLevelResponse> resetResourceLogLevel(
            ResetResourceLogLevelRequest resetResourceLogLevelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetResourceLogLevelRequest.Builder} avoiding the
     * need to create one manually via {@link ResetResourceLogLevelRequest#builder()}
     * </p>
     *
     * @param resetResourceLogLevelRequest
     *        A {@link Consumer} that will call methods on {@link ResetResourceLogLevelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetResourceLogLevelResponse> resetResourceLogLevel(
            Consumer<ResetResourceLogLevelRequest.Builder> resetResourceLogLevelRequest) {
        return resetResourceLogLevel(ResetResourceLogLevelRequest.builder().applyMutation(resetResourceLogLevelRequest).build());
    }

    /**
     * <p>
     * Sends the specified data to a multicast group.
     * </p>
     *
     * @param sendDataToMulticastGroupRequest
     * @return A Java Future containing the result of the SendDataToMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToMulticastGroupResponse> sendDataToMulticastGroup(
            SendDataToMulticastGroupRequest sendDataToMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends the specified data to a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToMulticastGroupRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToMulticastGroupRequest#builder()}
     * </p>
     *
     * @param sendDataToMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToMulticastGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendDataToMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToMulticastGroupResponse> sendDataToMulticastGroup(
            Consumer<SendDataToMulticastGroupRequest.Builder> sendDataToMulticastGroupRequest) {
        return sendDataToMulticastGroup(SendDataToMulticastGroupRequest.builder().applyMutation(sendDataToMulticastGroupRequest)
                .build());
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            Consumer<SendDataToWirelessDeviceRequest.Builder> sendDataToWirelessDeviceRequest) {
        return sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.builder().applyMutation(sendDataToWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     * </p>
     *
     * @param startBulkAssociateWirelessDeviceWithMulticastGroupRequest
     * @return A Java Future containing the result of the StartBulkAssociateWirelessDeviceWithMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkAssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkAssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> startBulkAssociateWirelessDeviceWithMulticastGroup(
            StartBulkAssociateWirelessDeviceWithMulticastGroupRequest startBulkAssociateWirelessDeviceWithMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder} avoiding the need to create one
     * manually via {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest#builder()}
     * </p>
     *
     * @param startBulkAssociateWirelessDeviceWithMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartBulkAssociateWirelessDeviceWithMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkAssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkAssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> startBulkAssociateWirelessDeviceWithMulticastGroup(
            Consumer<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder> startBulkAssociateWirelessDeviceWithMulticastGroupRequest) {
        return startBulkAssociateWirelessDeviceWithMulticastGroup(StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
                .builder().applyMutation(startBulkAssociateWirelessDeviceWithMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     * </p>
     *
     * @param startBulkDisassociateWirelessDeviceFromMulticastGroupRequest
     * @return A Java Future containing the result of the StartBulkDisassociateWirelessDeviceFromMulticastGroup
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkDisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkDisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> startBulkDisassociateWirelessDeviceFromMulticastGroup(
            StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest startBulkDisassociateWirelessDeviceFromMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder} avoiding the need to create one
     * manually via {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest#builder()}
     * </p>
     *
     * @param startBulkDisassociateWirelessDeviceFromMulticastGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartBulkDisassociateWirelessDeviceFromMulticastGroup
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkDisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkDisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> startBulkDisassociateWirelessDeviceFromMulticastGroup(
            Consumer<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder> startBulkDisassociateWirelessDeviceFromMulticastGroupRequest) {
        return startBulkDisassociateWirelessDeviceFromMulticastGroup(StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
                .builder().applyMutation(startBulkDisassociateWirelessDeviceFromMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Starts a FUOTA task.
     * </p>
     *
     * @param startFuotaTaskRequest
     * @return A Java Future containing the result of the StartFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFuotaTaskResponse> startFuotaTask(StartFuotaTaskRequest startFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFuotaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link StartFuotaTaskRequest#builder()}
     * </p>
     *
     * @param startFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFuotaTaskResponse> startFuotaTask(Consumer<StartFuotaTaskRequest.Builder> startFuotaTaskRequest) {
        return startFuotaTask(StartFuotaTaskRequest.builder().applyMutation(startFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Starts a multicast group session.
     * </p>
     *
     * @param startMulticastGroupSessionRequest
     * @return A Java Future containing the result of the StartMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMulticastGroupSessionResponse> startMulticastGroupSession(
            StartMulticastGroupSessionRequest startMulticastGroupSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMulticastGroupSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StartMulticastGroupSessionRequest#builder()}
     * </p>
     *
     * @param startMulticastGroupSessionRequest
     *        A {@link Consumer} that will call methods on {@link StartMulticastGroupSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMulticastGroupSessionResponse> startMulticastGroupSession(
            Consumer<StartMulticastGroupSessionRequest.Builder> startMulticastGroupSessionRequest) {
        return startMulticastGroupSession(StartMulticastGroupSessionRequest.builder()
                .applyMutation(startMulticastGroupSessionRequest).build());
    }

    /**
     * <p>
     * Start import task for a single wireless device.
     * </p>
     *
     * @param startSingleWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the StartSingleWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartSingleWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartSingleWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSingleWirelessDeviceImportTaskResponse> startSingleWirelessDeviceImportTask(
            StartSingleWirelessDeviceImportTaskRequest startSingleWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import task for a single wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSingleWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartSingleWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param startSingleWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartSingleWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartSingleWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartSingleWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartSingleWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSingleWirelessDeviceImportTaskResponse> startSingleWirelessDeviceImportTask(
            Consumer<StartSingleWirelessDeviceImportTaskRequest.Builder> startSingleWirelessDeviceImportTaskRequest) {
        return startSingleWirelessDeviceImportTask(StartSingleWirelessDeviceImportTaskRequest.builder()
                .applyMutation(startSingleWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     * </p>
     *
     * @param startWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the StartWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartWirelessDeviceImportTaskResponse> startWirelessDeviceImportTask(
            StartWirelessDeviceImportTaskRequest startWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param startWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartWirelessDeviceImportTaskResponse> startWirelessDeviceImportTask(
            Consumer<StartWirelessDeviceImportTaskRequest.Builder> startWirelessDeviceImportTaskRequest) {
        return startWirelessDeviceImportTask(StartWirelessDeviceImportTaskRequest.builder()
                .applyMutation(startWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TestWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param testWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link TestWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(
            Consumer<TestWirelessDeviceRequest.Builder> testWirelessDeviceRequest) {
        return testWirelessDevice(TestWirelessDeviceRequest.builder().applyMutation(testWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(
            Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Update the event configuration based on resource types.
     * </p>
     *
     * @param updateEventConfigurationByResourceTypesRequest
     * @return A Java Future containing the result of the UpdateEventConfigurationByResourceTypes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventConfigurationByResourceTypesResponse> updateEventConfigurationByResourceTypes(
            UpdateEventConfigurationByResourceTypesRequest updateEventConfigurationByResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the event configuration based on resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateEventConfigurationByResourceTypesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateEventConfigurationByResourceTypesRequest#builder()}
     * </p>
     *
     * @param updateEventConfigurationByResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateEventConfigurationByResourceTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEventConfigurationByResourceTypes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventConfigurationByResourceTypesResponse> updateEventConfigurationByResourceTypes(
            Consumer<UpdateEventConfigurationByResourceTypesRequest.Builder> updateEventConfigurationByResourceTypesRequest) {
        return updateEventConfigurationByResourceTypes(UpdateEventConfigurationByResourceTypesRequest.builder()
                .applyMutation(updateEventConfigurationByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Updates properties of a FUOTA task.
     * </p>
     *
     * @param updateFuotaTaskRequest
     * @return A Java Future containing the result of the UpdateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFuotaTaskResponse> updateFuotaTask(UpdateFuotaTaskRequest updateFuotaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a FUOTA task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFuotaTaskRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFuotaTaskRequest#builder()}
     * </p>
     *
     * @param updateFuotaTaskRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFuotaTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFuotaTaskResponse> updateFuotaTask(
            Consumer<UpdateFuotaTaskRequest.Builder> updateFuotaTaskRequest) {
        return updateFuotaTask(UpdateFuotaTaskRequest.builder().applyMutation(updateFuotaTaskRequest).build());
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the UpdateLogLevelsByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLogLevelsByResourceTypesResponse> updateLogLevelsByResourceTypes(
            UpdateLogLevelsByResourceTypesRequest updateLogLevelsByResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLogLevelsByResourceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLogLevelsByResourceTypesRequest#builder()}
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLogLevelsByResourceTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLogLevelsByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLogLevelsByResourceTypesResponse> updateLogLevelsByResourceTypes(
            Consumer<UpdateLogLevelsByResourceTypesRequest.Builder> updateLogLevelsByResourceTypesRequest) {
        return updateLogLevelsByResourceTypes(UpdateLogLevelsByResourceTypesRequest.builder()
                .applyMutation(updateLogLevelsByResourceTypesRequest).build());
    }

    /**
     * <p>
     * Updates properties of a multicast group session.
     * </p>
     *
     * @param updateMulticastGroupRequest
     * @return A Java Future containing the result of the UpdateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMulticastGroupResponse> updateMulticastGroup(
            UpdateMulticastGroupRequest updateMulticastGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a multicast group session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMulticastGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMulticastGroupRequest#builder()}
     * </p>
     *
     * @param updateMulticastGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMulticastGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMulticastGroupResponse> updateMulticastGroup(
            Consumer<UpdateMulticastGroupRequest.Builder> updateMulticastGroupRequest) {
        return updateMulticastGroup(UpdateMulticastGroupRequest.builder().applyMutation(updateMulticastGroupRequest).build());
    }

    /**
     * <p>
     * Update network analyzer configuration.
     * </p>
     *
     * @param updateNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the UpdateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkAnalyzerConfigurationResponse> updateNetworkAnalyzerConfiguration(
            UpdateNetworkAnalyzerConfigurationRequest updateNetworkAnalyzerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update network analyzer configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkAnalyzerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNetworkAnalyzerConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNetworkAnalyzerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkAnalyzerConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkAnalyzerConfigurationResponse> updateNetworkAnalyzerConfiguration(
            Consumer<UpdateNetworkAnalyzerConfigurationRequest.Builder> updateNetworkAnalyzerConfigurationRequest) {
        return updateNetworkAnalyzerConfiguration(UpdateNetworkAnalyzerConfigurationRequest.builder()
                .applyMutation(updateNetworkAnalyzerConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            UpdatePartnerAccountRequest updatePartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnerAccountRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePartnerAccountRequest#builder()}
     * </p>
     *
     * @param updatePartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePartnerAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            Consumer<UpdatePartnerAccountRequest.Builder> updatePartnerAccountRequest) {
        return updatePartnerAccount(UpdatePartnerAccountRequest.builder().applyMutation(updatePartnerAccountRequest).build());
    }

    /**
     * <p>
     * Update the position information of a resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param updatePositionRequest
     * @return A Java Future containing the result of the UpdatePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePosition" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<UpdatePositionResponse> updatePosition(UpdatePositionRequest updatePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the position information of a resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePositionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePositionRequest#builder()}
     * </p>
     *
     * @param updatePositionRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePositionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePosition" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is no longer supported.
     */
    @Deprecated
    default CompletableFuture<UpdatePositionResponse> updatePosition(Consumer<UpdatePositionRequest.Builder> updatePositionRequest) {
        return updatePosition(UpdatePositionRequest.builder().applyMutation(updatePositionRequest).build());
    }

    /**
     * <p>
     * Update the event configuration for a particular resource identifier.
     * </p>
     *
     * @param updateResourceEventConfigurationRequest
     * @return A Java Future containing the result of the UpdateResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceEventConfigurationResponse> updateResourceEventConfiguration(
            UpdateResourceEventConfigurationRequest updateResourceEventConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the event configuration for a particular resource identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceEventConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateResourceEventConfigurationRequest#builder()}
     * </p>
     *
     * @param updateResourceEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceEventConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceEventConfigurationResponse> updateResourceEventConfiguration(
            Consumer<UpdateResourceEventConfigurationRequest.Builder> updateResourceEventConfigurationRequest) {
        return updateResourceEventConfiguration(UpdateResourceEventConfigurationRequest.builder()
                .applyMutation(updateResourceEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Update the position information of a given wireless device or a wireless gateway resource. The position
     * coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic
     * System (WGS84)</a>.
     * </p>
     *
     * @param updateResourcePositionRequest
     * @return A Java Future containing the result of the UpdateResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourcePositionResponse> updateResourcePosition(
            UpdateResourcePositionRequest updateResourcePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the position information of a given wireless device or a wireless gateway resource. The position
     * coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic
     * System (WGS84)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourcePositionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourcePositionRequest#builder()}
     * </p>
     *
     * @param updateResourcePositionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourcePositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourcePositionResponse> updateResourcePosition(
            Consumer<UpdateResourcePositionRequest.Builder> updateResourcePositionRequest) {
        return updateResourcePosition(UpdateResourcePositionRequest.builder().applyMutation(updateResourcePositionRequest)
                .build());
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            UpdateWirelessDeviceRequest updateWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            Consumer<UpdateWirelessDeviceRequest.Builder> updateWirelessDeviceRequest) {
        return updateWirelessDevice(UpdateWirelessDeviceRequest.builder().applyMutation(updateWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Update an import task to add more devices to the task.
     * </p>
     *
     * @param updateWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the UpdateWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceImportTaskResponse> updateWirelessDeviceImportTask(
            UpdateWirelessDeviceImportTaskRequest updateWirelessDeviceImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an import task to add more devices to the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceImportTaskRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWirelessDeviceImportTaskRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceImportTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceImportTaskResponse> updateWirelessDeviceImportTask(
            Consumer<UpdateWirelessDeviceImportTaskRequest.Builder> updateWirelessDeviceImportTaskRequest) {
        return updateWirelessDeviceImportTask(UpdateWirelessDeviceImportTaskRequest.builder()
                .applyMutation(updateWirelessDeviceImportTaskRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            UpdateWirelessGatewayRequest updateWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param updateWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            Consumer<UpdateWirelessGatewayRequest.Builder> updateWirelessGatewayRequest) {
        return updateWirelessGateway(UpdateWirelessGatewayRequest.builder().applyMutation(updateWirelessGatewayRequest).build());
    }

    @Override
    default IotWirelessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotWirelessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotWirelessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotWirelessAsyncClient}.
     */
    static IotWirelessAsyncClientBuilder builder() {
        return new DefaultIotWirelessAsyncClientBuilder();
    }
}
