/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LTE object for network measurement reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LteNmrObj implements SdkPojo, Serializable, ToCopyableBuilder<LteNmrObj.Builder, LteNmrObj> {
    private static final SdkField<Integer> PCI_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pci")
            .getter(getter(LteNmrObj::pci)).setter(setter(Builder::pci))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pci").build()).build();

    private static final SdkField<Integer> EARFCN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Earfcn").getter(getter(LteNmrObj::earfcn)).setter(setter(Builder::earfcn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Earfcn").build()).build();

    private static final SdkField<Integer> EUTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EutranCid").getter(getter(LteNmrObj::eutranCid)).setter(setter(Builder::eutranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EutranCid").build()).build();

    private static final SdkField<Integer> RSRP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rsrp")
            .getter(getter(LteNmrObj::rsrp)).setter(setter(Builder::rsrp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()).build();

    private static final SdkField<Float> RSRQ_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Rsrq")
            .getter(getter(LteNmrObj::rsrq)).setter(setter(Builder::rsrq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PCI_FIELD, EARFCN_FIELD,
            EUTRAN_CID_FIELD, RSRP_FIELD, RSRQ_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer pci;

    private final Integer earfcn;

    private final Integer eutranCid;

    private final Integer rsrp;

    private final Float rsrq;

    private LteNmrObj(BuilderImpl builder) {
        this.pci = builder.pci;
        this.earfcn = builder.earfcn;
        this.eutranCid = builder.eutranCid;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
    }

    /**
     * <p>
     * Physical cell ID.
     * </p>
     * 
     * @return Physical cell ID.
     */
    public final Integer pci() {
        return pci;
    }

    /**
     * <p>
     * E-UTRA (Evolved universal terrestrial Radio Access) absolute radio frequency channel Number (EARFCN).
     * </p>
     * 
     * @return E-UTRA (Evolved universal terrestrial Radio Access) absolute radio frequency channel Number (EARFCN).
     */
    public final Integer earfcn() {
        return earfcn;
    }

    /**
     * <p>
     * E-UTRAN (Evolved Universal Terrestrial Radio Access Network) cell global identifier (EUTRANCID).
     * </p>
     * 
     * @return E-UTRAN (Evolved Universal Terrestrial Radio Access Network) cell global identifier (EUTRANCID).
     */
    public final Integer eutranCid() {
        return eutranCid;
    }

    /**
     * <p>
     * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     */
    public final Integer rsrp() {
        return rsrp;
    }

    /**
     * <p>
     * Signal quality of the reference Signal received, measured in decibels (dB).
     * </p>
     * 
     * @return Signal quality of the reference Signal received, measured in decibels (dB).
     */
    public final Float rsrq() {
        return rsrq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pci());
        hashCode = 31 * hashCode + Objects.hashCode(earfcn());
        hashCode = 31 * hashCode + Objects.hashCode(eutranCid());
        hashCode = 31 * hashCode + Objects.hashCode(rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(rsrq());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteNmrObj)) {
            return false;
        }
        LteNmrObj other = (LteNmrObj) obj;
        return Objects.equals(pci(), other.pci()) && Objects.equals(earfcn(), other.earfcn())
                && Objects.equals(eutranCid(), other.eutranCid()) && Objects.equals(rsrp(), other.rsrp())
                && Objects.equals(rsrq(), other.rsrq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LteNmrObj").add("Pci", pci()).add("Earfcn", earfcn()).add("EutranCid", eutranCid())
                .add("Rsrp", rsrp()).add("Rsrq", rsrq()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pci":
            return Optional.ofNullable(clazz.cast(pci()));
        case "Earfcn":
            return Optional.ofNullable(clazz.cast(earfcn()));
        case "EutranCid":
            return Optional.ofNullable(clazz.cast(eutranCid()));
        case "Rsrp":
            return Optional.ofNullable(clazz.cast(rsrp()));
        case "Rsrq":
            return Optional.ofNullable(clazz.cast(rsrq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LteNmrObj, T> g) {
        return obj -> g.apply((LteNmrObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LteNmrObj> {
        /**
         * <p>
         * Physical cell ID.
         * </p>
         * 
         * @param pci
         *        Physical cell ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pci(Integer pci);

        /**
         * <p>
         * E-UTRA (Evolved universal terrestrial Radio Access) absolute radio frequency channel Number (EARFCN).
         * </p>
         * 
         * @param earfcn
         *        E-UTRA (Evolved universal terrestrial Radio Access) absolute radio frequency channel Number (EARFCN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earfcn(Integer earfcn);

        /**
         * <p>
         * E-UTRAN (Evolved Universal Terrestrial Radio Access Network) cell global identifier (EUTRANCID).
         * </p>
         * 
         * @param eutranCid
         *        E-UTRAN (Evolved Universal Terrestrial Radio Access Network) cell global identifier (EUTRANCID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eutranCid(Integer eutranCid);

        /**
         * <p>
         * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param rsrp
         *        Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrp(Integer rsrp);

        /**
         * <p>
         * Signal quality of the reference Signal received, measured in decibels (dB).
         * </p>
         * 
         * @param rsrq
         *        Signal quality of the reference Signal received, measured in decibels (dB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrq(Float rsrq);
    }

    static final class BuilderImpl implements Builder {
        private Integer pci;

        private Integer earfcn;

        private Integer eutranCid;

        private Integer rsrp;

        private Float rsrq;

        private BuilderImpl() {
        }

        private BuilderImpl(LteNmrObj model) {
            pci(model.pci);
            earfcn(model.earfcn);
            eutranCid(model.eutranCid);
            rsrp(model.rsrp);
            rsrq(model.rsrq);
        }

        public final Integer getPci() {
            return pci;
        }

        public final void setPci(Integer pci) {
            this.pci = pci;
        }

        @Override
        public final Builder pci(Integer pci) {
            this.pci = pci;
            return this;
        }

        public final Integer getEarfcn() {
            return earfcn;
        }

        public final void setEarfcn(Integer earfcn) {
            this.earfcn = earfcn;
        }

        @Override
        public final Builder earfcn(Integer earfcn) {
            this.earfcn = earfcn;
            return this;
        }

        public final Integer getEutranCid() {
            return eutranCid;
        }

        public final void setEutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
        }

        @Override
        public final Builder eutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
            return this;
        }

        public final Integer getRsrp() {
            return rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        @Override
        public LteNmrObj build() {
            return new LteNmrObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
