/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotwireless.internal.IotWirelessServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotwireless.model.AccessDeniedException;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.ConflictException;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.InternalServerException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessException;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetAllResourceLogLevelsResponse;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest;
import software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelResponse;
import software.amazon.awssdk.services.iotwireless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest;
import software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionResponse;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.ThrottlingException;
import software.amazon.awssdk.services.iotwireless.model.TooManyTagsException;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.ValidationException;
import software.amazon.awssdk.services.iotwireless.transform.AssociateAwsAccountWithPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateMulticastGroupWithFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessDeviceWithFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessDeviceWithMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessDeviceWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.AssociateWirelessGatewayWithThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CancelMulticastGroupSessionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateNetworkAnalyzerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.CreateWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteNetworkAnalyzerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteQueuedMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeleteWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DeregisterWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateAwsAccountFromPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateMulticastGroupFromFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessDeviceFromFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessDeviceFromMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessDeviceFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.DisassociateWirelessGatewayFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetDeviceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetEventConfigurationByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetLogLevelsByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetMulticastGroupSessionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetNetworkAnalyzerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPositionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPositionEstimateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetPositionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetResourceEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetResourcePositionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceEndpointRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetServiceProfileRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessDeviceStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayCertificateRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayFirmwareInformationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.GetWirelessGatewayTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDeviceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListDevicesForWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListFuotaTasksRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListMulticastGroupsByFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListMulticastGroupsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListNetworkAnalyzerConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListPartnerAccountsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListPositionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListQueuedMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListServiceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessDeviceImportTasksRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessDevicesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewayTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ListWirelessGatewaysRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.PutPositionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.PutResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ResetAllResourceLogLevelsRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.ResetResourceLogLevelRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.SendDataToMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.SendDataToWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartBulkAssociateWirelessDeviceWithMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartMulticastGroupSessionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartSingleWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.StartWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.TestWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateEventConfigurationByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateFuotaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateLogLevelsByResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateMulticastGroupRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateNetworkAnalyzerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdatePartnerAccountRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdatePositionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateResourceEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateResourcePositionRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessDeviceImportTaskRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessDeviceRequestMarshaller;
import software.amazon.awssdk.services.iotwireless.transform.UpdateWirelessGatewayRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IotWirelessAsyncClient}.
 *
 * @see IotWirelessAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotWirelessAsyncClient implements IotWirelessAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIotWirelessAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final IotWirelessServiceClientConfiguration serviceClientConfiguration;

    protected DefaultIotWirelessAsyncClient(IotWirelessServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAwsAccountWithPartnerAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateAwsAccountWithPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAwsAccountWithPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAwsAccountWithPartnerAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateAwsAccountWithPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse>()
                            .withOperationName("AssociateAwsAccountWithPartnerAccount")
                            .withMarshaller(new AssociateAwsAccountWithPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateAwsAccountWithPartnerAccountRequest));
            CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate a multicast group with a FUOTA task.
     * </p>
     *
     * @param associateMulticastGroupWithFuotaTaskRequest
     * @return A Java Future containing the result of the AssociateMulticastGroupWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateMulticastGroupWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateMulticastGroupWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMulticastGroupWithFuotaTaskResponse> associateMulticastGroupWithFuotaTask(
            AssociateMulticastGroupWithFuotaTaskRequest associateMulticastGroupWithFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMulticastGroupWithFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateMulticastGroupWithFuotaTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMulticastGroupWithFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMulticastGroupWithFuotaTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateMulticastGroupWithFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateMulticastGroupWithFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMulticastGroupWithFuotaTaskRequest, AssociateMulticastGroupWithFuotaTaskResponse>()
                            .withOperationName("AssociateMulticastGroupWithFuotaTask")
                            .withMarshaller(new AssociateMulticastGroupWithFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateMulticastGroupWithFuotaTaskRequest));
            CompletableFuture<AssociateMulticastGroupWithFuotaTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate a wireless device with a FUOTA task.
     * </p>
     *
     * @param associateWirelessDeviceWithFuotaTaskRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessDeviceWithFuotaTaskResponse> associateWirelessDeviceWithFuotaTask(
            AssociateWirelessDeviceWithFuotaTaskRequest associateWirelessDeviceWithFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWirelessDeviceWithFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessDeviceWithFuotaTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessDeviceWithFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessDeviceWithFuotaTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessDeviceWithFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessDeviceWithFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessDeviceWithFuotaTaskRequest, AssociateWirelessDeviceWithFuotaTaskResponse>()
                            .withOperationName("AssociateWirelessDeviceWithFuotaTask")
                            .withMarshaller(new AssociateWirelessDeviceWithFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessDeviceWithFuotaTaskRequest));
            CompletableFuture<AssociateWirelessDeviceWithFuotaTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless device with a multicast group.
     * </p>
     *
     * @param associateWirelessDeviceWithMulticastGroupRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithMulticastGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessDeviceWithMulticastGroupResponse> associateWirelessDeviceWithMulticastGroup(
            AssociateWirelessDeviceWithMulticastGroupRequest associateWirelessDeviceWithMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                associateWirelessDeviceWithMulticastGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessDeviceWithMulticastGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessDeviceWithMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessDeviceWithMulticastGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessDeviceWithMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessDeviceWithMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessDeviceWithMulticastGroupRequest, AssociateWirelessDeviceWithMulticastGroupResponse>()
                            .withOperationName("AssociateWirelessDeviceWithMulticastGroup")
                            .withMarshaller(new AssociateWirelessDeviceWithMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessDeviceWithMulticastGroupRequest));
            CompletableFuture<AssociateWirelessDeviceWithMulticastGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWirelessDeviceWithThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessDeviceWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessDeviceWithThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessDeviceWithThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessDeviceWithThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessDeviceWithThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse>()
                            .withOperationName("AssociateWirelessDeviceWithThing")
                            .withMarshaller(new AssociateWirelessDeviceWithThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessDeviceWithThingRequest));
            CompletableFuture<AssociateWirelessDeviceWithThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWirelessGatewayWithCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessGatewayWithCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessGatewayWithCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse>()
                            .withOperationName("AssociateWirelessGatewayWithCertificate")
                            .withMarshaller(new AssociateWirelessGatewayWithCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessGatewayWithCertificateRequest));
            CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWirelessGatewayWithThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWirelessGatewayWithThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWirelessGatewayWithThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateWirelessGatewayWithThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateWirelessGatewayWithThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateWirelessGatewayWithThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse>()
                            .withOperationName("AssociateWirelessGatewayWithThing")
                            .withMarshaller(new AssociateWirelessGatewayWithThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateWirelessGatewayWithThingRequest));
            CompletableFuture<AssociateWirelessGatewayWithThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an existing multicast group session.
     * </p>
     *
     * @param cancelMulticastGroupSessionRequest
     * @return A Java Future containing the result of the CancelMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CancelMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CancelMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMulticastGroupSessionResponse> cancelMulticastGroupSession(
            CancelMulticastGroupSessionRequest cancelMulticastGroupSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMulticastGroupSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMulticastGroupSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMulticastGroupSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMulticastGroupSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMulticastGroupSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMulticastGroupSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMulticastGroupSessionRequest, CancelMulticastGroupSessionResponse>()
                            .withOperationName("CancelMulticastGroupSession")
                            .withMarshaller(new CancelMulticastGroupSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMulticastGroupSessionRequest));
            CompletableFuture<CancelMulticastGroupSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDestinationRequest, CreateDestinationResponse>()
                            .withOperationName("CreateDestination")
                            .withMarshaller(new CreateDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDestinationRequest));
            CompletableFuture<CreateDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            CreateDeviceProfileRequest createDeviceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeviceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceProfileRequest, CreateDeviceProfileResponse>()
                            .withOperationName("CreateDeviceProfile")
                            .withMarshaller(new CreateDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeviceProfileRequest));
            CompletableFuture<CreateDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a FUOTA task.
     * </p>
     *
     * @param createFuotaTaskRequest
     * @return A Java Future containing the result of the CreateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFuotaTaskResponse> createFuotaTask(CreateFuotaTaskRequest createFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFuotaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFuotaTaskRequest, CreateFuotaTaskResponse>()
                            .withOperationName("CreateFuotaTask")
                            .withMarshaller(new CreateFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFuotaTaskRequest));
            CompletableFuture<CreateFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a multicast group.
     * </p>
     *
     * @param createMulticastGroupRequest
     * @return A Java Future containing the result of the CreateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMulticastGroupResponse> createMulticastGroup(
            CreateMulticastGroupRequest createMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMulticastGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMulticastGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMulticastGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMulticastGroupRequest, CreateMulticastGroupResponse>()
                            .withOperationName("CreateMulticastGroup")
                            .withMarshaller(new CreateMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMulticastGroupRequest));
            CompletableFuture<CreateMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new network analyzer configuration.
     * </p>
     *
     * @param createNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the CreateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAnalyzerConfigurationResponse> createNetworkAnalyzerConfiguration(
            CreateNetworkAnalyzerConfigurationRequest createNetworkAnalyzerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkAnalyzerConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNetworkAnalyzerConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkAnalyzerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNetworkAnalyzerConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateNetworkAnalyzerConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNetworkAnalyzerConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkAnalyzerConfigurationRequest, CreateNetworkAnalyzerConfigurationResponse>()
                            .withOperationName("CreateNetworkAnalyzerConfiguration")
                            .withMarshaller(new CreateNetworkAnalyzerConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkAnalyzerConfigurationRequest));
            CompletableFuture<CreateNetworkAnalyzerConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            CreateServiceProfileRequest createServiceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createServiceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateServiceProfileRequest, CreateServiceProfileResponse>()
                            .withOperationName("CreateServiceProfile")
                            .withMarshaller(new CreateServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createServiceProfileRequest));
            CompletableFuture<CreateServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            CreateWirelessDeviceRequest createWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse>()
                            .withOperationName("CreateWirelessDevice")
                            .withMarshaller(new CreateWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWirelessDeviceRequest));
            CompletableFuture<CreateWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            CreateWirelessGatewayRequest createWirelessGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWirelessGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse>()
                            .withOperationName("CreateWirelessGateway")
                            .withMarshaller(new CreateWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWirelessGatewayRequest));
            CompletableFuture<CreateWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWirelessGatewayTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse>()
                            .withOperationName("CreateWirelessGatewayTask")
                            .withMarshaller(new CreateWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWirelessGatewayTaskRequest));
            CompletableFuture<CreateWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWirelessGatewayTaskDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("CreateWirelessGatewayTaskDefinition")
                            .withMarshaller(new CreateWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWirelessGatewayTaskDefinitionRequest));
            CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDestinationRequest, DeleteDestinationResponse>()
                            .withOperationName("DeleteDestination")
                            .withMarshaller(new DeleteDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDestinationRequest));
            CompletableFuture<DeleteDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            DeleteDeviceProfileRequest deleteDeviceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeviceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse>()
                            .withOperationName("DeleteDeviceProfile")
                            .withMarshaller(new DeleteDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeviceProfileRequest));
            CompletableFuture<DeleteDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a FUOTA task.
     * </p>
     *
     * @param deleteFuotaTaskRequest
     * @return A Java Future containing the result of the DeleteFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFuotaTaskResponse> deleteFuotaTask(DeleteFuotaTaskRequest deleteFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFuotaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFuotaTaskRequest, DeleteFuotaTaskResponse>()
                            .withOperationName("DeleteFuotaTask")
                            .withMarshaller(new DeleteFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFuotaTaskRequest));
            CompletableFuture<DeleteFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a multicast group if it is not in use by a fuota task.
     * </p>
     *
     * @param deleteMulticastGroupRequest
     * @return A Java Future containing the result of the DeleteMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMulticastGroupResponse> deleteMulticastGroup(
            DeleteMulticastGroupRequest deleteMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMulticastGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMulticastGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMulticastGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMulticastGroupRequest, DeleteMulticastGroupResponse>()
                            .withOperationName("DeleteMulticastGroup")
                            .withMarshaller(new DeleteMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMulticastGroupRequest));
            CompletableFuture<DeleteMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a network analyzer configuration.
     * </p>
     *
     * @param deleteNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the DeleteNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAnalyzerConfigurationResponse> deleteNetworkAnalyzerConfiguration(
            DeleteNetworkAnalyzerConfigurationRequest deleteNetworkAnalyzerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkAnalyzerConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkAnalyzerConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkAnalyzerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNetworkAnalyzerConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteNetworkAnalyzerConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNetworkAnalyzerConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkAnalyzerConfigurationRequest, DeleteNetworkAnalyzerConfigurationResponse>()
                            .withOperationName("DeleteNetworkAnalyzerConfiguration")
                            .withMarshaller(new DeleteNetworkAnalyzerConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkAnalyzerConfigurationRequest));
            CompletableFuture<DeleteNetworkAnalyzerConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove queued messages from the downlink queue.
     * </p>
     *
     * @param deleteQueuedMessagesRequest
     * @return A Java Future containing the result of the DeleteQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueuedMessagesResponse> deleteQueuedMessages(
            DeleteQueuedMessagesRequest deleteQueuedMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueuedMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueuedMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueuedMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQueuedMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteQueuedMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteQueuedMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueuedMessagesRequest, DeleteQueuedMessagesResponse>()
                            .withOperationName("DeleteQueuedMessages")
                            .withMarshaller(new DeleteQueuedMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteQueuedMessagesRequest));
            CompletableFuture<DeleteQueuedMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            DeleteServiceProfileRequest deleteServiceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServiceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceProfileRequest, DeleteServiceProfileResponse>()
                            .withOperationName("DeleteServiceProfile")
                            .withMarshaller(new DeleteServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteServiceProfileRequest));
            CompletableFuture<DeleteServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            DeleteWirelessDeviceRequest deleteWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse>()
                            .withOperationName("DeleteWirelessDevice")
                            .withMarshaller(new DeleteWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWirelessDeviceRequest));
            CompletableFuture<DeleteWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an import task.
     * </p>
     *
     * @param deleteWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessDeviceImportTaskResponse> deleteWirelessDeviceImportTask(
            DeleteWirelessDeviceImportTaskRequest deleteWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteWirelessDeviceImportTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessDeviceImportTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessDeviceImportTaskRequest, DeleteWirelessDeviceImportTaskResponse>()
                            .withOperationName("DeleteWirelessDeviceImportTask")
                            .withMarshaller(new DeleteWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWirelessDeviceImportTaskRequest));
            CompletableFuture<DeleteWirelessDeviceImportTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            DeleteWirelessGatewayRequest deleteWirelessGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWirelessGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse>()
                            .withOperationName("DeleteWirelessGateway")
                            .withMarshaller(new DeleteWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWirelessGatewayRequest));
            CompletableFuture<DeleteWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWirelessGatewayTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse>()
                            .withOperationName("DeleteWirelessGatewayTask")
                            .withMarshaller(new DeleteWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWirelessGatewayTaskRequest));
            CompletableFuture<DeleteWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWirelessGatewayTaskDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("DeleteWirelessGatewayTaskDefinition")
                            .withMarshaller(new DeleteWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWirelessGatewayTaskDefinitionRequest));
            CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregister a wireless device from AWS IoT Wireless.
     * </p>
     *
     * @param deregisterWirelessDeviceRequest
     * @return A Java Future containing the result of the DeregisterWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeregisterWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeregisterWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterWirelessDeviceResponse> deregisterWirelessDevice(
            DeregisterWirelessDeviceRequest deregisterWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterWirelessDeviceRequest, DeregisterWirelessDeviceResponse>()
                            .withOperationName("DeregisterWirelessDevice")
                            .withMarshaller(new DeregisterWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterWirelessDeviceRequest));
            CompletableFuture<DeregisterWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                disassociateAwsAccountFromPartnerAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAwsAccountFromPartnerAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAwsAccountFromPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAwsAccountFromPartnerAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateAwsAccountFromPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse>()
                            .withOperationName("DisassociateAwsAccountFromPartnerAccount")
                            .withMarshaller(new DisassociateAwsAccountFromPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateAwsAccountFromPartnerAccountRequest));
            CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a multicast group from a fuota task.
     * </p>
     *
     * @param disassociateMulticastGroupFromFuotaTaskRequest
     * @return A Java Future containing the result of the DisassociateMulticastGroupFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateMulticastGroupFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateMulticastGroupFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMulticastGroupFromFuotaTaskResponse> disassociateMulticastGroupFromFuotaTask(
            DisassociateMulticastGroupFromFuotaTaskRequest disassociateMulticastGroupFromFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMulticastGroupFromFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateMulticastGroupFromFuotaTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMulticastGroupFromFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMulticastGroupFromFuotaTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateMulticastGroupFromFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMulticastGroupFromFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMulticastGroupFromFuotaTaskRequest, DisassociateMulticastGroupFromFuotaTaskResponse>()
                            .withOperationName("DisassociateMulticastGroupFromFuotaTask")
                            .withMarshaller(new DisassociateMulticastGroupFromFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateMulticastGroupFromFuotaTaskRequest));
            CompletableFuture<DisassociateMulticastGroupFromFuotaTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless device from a FUOTA task.
     * </p>
     *
     * @param disassociateWirelessDeviceFromFuotaTaskRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromFuotaTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromFuotaTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessDeviceFromFuotaTaskResponse> disassociateWirelessDeviceFromFuotaTask(
            DisassociateWirelessDeviceFromFuotaTaskRequest disassociateWirelessDeviceFromFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateWirelessDeviceFromFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessDeviceFromFuotaTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessDeviceFromFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessDeviceFromFuotaTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessDeviceFromFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessDeviceFromFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessDeviceFromFuotaTaskRequest, DisassociateWirelessDeviceFromFuotaTaskResponse>()
                            .withOperationName("DisassociateWirelessDeviceFromFuotaTask")
                            .withMarshaller(new DisassociateWirelessDeviceFromFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessDeviceFromFuotaTaskRequest));
            CompletableFuture<DisassociateWirelessDeviceFromFuotaTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless device from a multicast group.
     * </p>
     *
     * @param disassociateWirelessDeviceFromMulticastGroupRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessDeviceFromMulticastGroupResponse> disassociateWirelessDeviceFromMulticastGroup(
            DisassociateWirelessDeviceFromMulticastGroupRequest disassociateWirelessDeviceFromMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                disassociateWirelessDeviceFromMulticastGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessDeviceFromMulticastGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessDeviceFromMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessDeviceFromMulticastGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessDeviceFromMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessDeviceFromMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessDeviceFromMulticastGroupRequest, DisassociateWirelessDeviceFromMulticastGroupResponse>()
                            .withOperationName("DisassociateWirelessDeviceFromMulticastGroup")
                            .withMarshaller(new DisassociateWirelessDeviceFromMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessDeviceFromMulticastGroupRequest));
            CompletableFuture<DisassociateWirelessDeviceFromMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateWirelessDeviceFromThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessDeviceFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessDeviceFromThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessDeviceFromThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessDeviceFromThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessDeviceFromThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse>()
                            .withOperationName("DisassociateWirelessDeviceFromThing")
                            .withMarshaller(new DisassociateWirelessDeviceFromThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessDeviceFromThingRequest));
            CompletableFuture<DisassociateWirelessDeviceFromThingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                disassociateWirelessGatewayFromCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessGatewayFromCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromCertificate")
                            .withMarshaller(new DisassociateWirelessGatewayFromCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessGatewayFromCertificateRequest));
            CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateWirelessGatewayFromThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWirelessGatewayFromThingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWirelessGatewayFromThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateWirelessGatewayFromThingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateWirelessGatewayFromThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateWirelessGatewayFromThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse>()
                            .withOperationName("DisassociateWirelessGatewayFromThing")
                            .withMarshaller(new DisassociateWirelessGatewayFromThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateWirelessGatewayFromThingRequest));
            CompletableFuture<DisassociateWirelessGatewayFromThingResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDestinationRequest, GetDestinationResponse>()
                            .withOperationName("GetDestination")
                            .withMarshaller(new GetDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDestinationRequest));
            CompletableFuture<GetDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeviceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceProfileRequest, GetDeviceProfileResponse>()
                            .withOperationName("GetDeviceProfile")
                            .withMarshaller(new GetDeviceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeviceProfileRequest));
            CompletableFuture<GetDeviceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the event configuration based on resource types.
     * </p>
     *
     * @param getEventConfigurationByResourceTypesRequest
     * @return A Java Future containing the result of the GetEventConfigurationByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventConfigurationByResourceTypesResponse> getEventConfigurationByResourceTypes(
            GetEventConfigurationByResourceTypesRequest getEventConfigurationByResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventConfigurationByResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEventConfigurationByResourceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventConfigurationByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventConfigurationByResourceTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetEventConfigurationByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventConfigurationByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventConfigurationByResourceTypesRequest, GetEventConfigurationByResourceTypesResponse>()
                            .withOperationName("GetEventConfigurationByResourceTypes")
                            .withMarshaller(new GetEventConfigurationByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventConfigurationByResourceTypesRequest));
            CompletableFuture<GetEventConfigurationByResourceTypesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a FUOTA task.
     * </p>
     *
     * @param getFuotaTaskRequest
     * @return A Java Future containing the result of the GetFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetFuotaTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFuotaTaskResponse> getFuotaTask(GetFuotaTaskRequest getFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFuotaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFuotaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFuotaTaskRequest, GetFuotaTaskResponse>()
                            .withOperationName("GetFuotaTask").withMarshaller(new GetFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFuotaTaskRequest));
            CompletableFuture<GetFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
     * for wireless device log options or wireless gateway log options.
     * </p>
     *
     * @param getLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the GetLogLevelsByResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLogLevelsByResourceTypesResponse> getLogLevelsByResourceTypes(
            GetLogLevelsByResourceTypesRequest getLogLevelsByResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogLevelsByResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogLevelsByResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogLevelsByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLogLevelsByResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLogLevelsByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLogLevelsByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLogLevelsByResourceTypesRequest, GetLogLevelsByResourceTypesResponse>()
                            .withOperationName("GetLogLevelsByResourceTypes")
                            .withMarshaller(new GetLogLevelsByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLogLevelsByResourceTypesRequest));
            CompletableFuture<GetLogLevelsByResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a multicast group.
     * </p>
     *
     * @param getMulticastGroupRequest
     * @return A Java Future containing the result of the GetMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMulticastGroupResponse> getMulticastGroup(GetMulticastGroupRequest getMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMulticastGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMulticastGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMulticastGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMulticastGroupRequest, GetMulticastGroupResponse>()
                            .withOperationName("GetMulticastGroup")
                            .withMarshaller(new GetMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMulticastGroupRequest));
            CompletableFuture<GetMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a multicast group session.
     * </p>
     *
     * @param getMulticastGroupSessionRequest
     * @return A Java Future containing the result of the GetMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMulticastGroupSessionResponse> getMulticastGroupSession(
            GetMulticastGroupSessionRequest getMulticastGroupSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMulticastGroupSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMulticastGroupSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMulticastGroupSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMulticastGroupSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMulticastGroupSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMulticastGroupSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMulticastGroupSessionRequest, GetMulticastGroupSessionResponse>()
                            .withOperationName("GetMulticastGroupSession")
                            .withMarshaller(new GetMulticastGroupSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMulticastGroupSessionRequest));
            CompletableFuture<GetMulticastGroupSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get network analyzer configuration.
     * </p>
     *
     * @param getNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the GetNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNetworkAnalyzerConfigurationResponse> getNetworkAnalyzerConfiguration(
            GetNetworkAnalyzerConfigurationRequest getNetworkAnalyzerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNetworkAnalyzerConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getNetworkAnalyzerConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNetworkAnalyzerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNetworkAnalyzerConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetNetworkAnalyzerConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNetworkAnalyzerConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNetworkAnalyzerConfigurationRequest, GetNetworkAnalyzerConfigurationResponse>()
                            .withOperationName("GetNetworkAnalyzerConfiguration")
                            .withMarshaller(new GetNetworkAnalyzerConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getNetworkAnalyzerConfigurationRequest));
            CompletableFuture<GetNetworkAnalyzerConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPartnerAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPartnerAccountRequest, GetPartnerAccountResponse>()
                            .withOperationName("GetPartnerAccount")
                            .withMarshaller(new GetPartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPartnerAccountRequest));
            CompletableFuture<GetPartnerAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the position information for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionRequest
     * @return A Java Future containing the result of the GetPosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPosition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPositionResponse> getPosition(GetPositionRequest getPositionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPositionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPositionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPosition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPositionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPositionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPositionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPositionRequest, GetPositionResponse>()
                            .withOperationName("GetPosition").withMarshaller(new GetPositionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPositionRequest));
            CompletableFuture<GetPositionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param getPositionConfigurationRequest
     * @return A Java Future containing the result of the GetPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPositionConfigurationResponse> getPositionConfiguration(
            GetPositionConfigurationRequest getPositionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPositionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPositionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPositionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPositionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPositionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPositionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPositionConfigurationRequest, GetPositionConfigurationResponse>()
                            .withOperationName("GetPositionConfiguration")
                            .withMarshaller(new GetPositionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPositionConfigurationRequest));
            CompletableFuture<GetPositionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using
     * solvers that are provided by third-party vendors.
     * </p>
     *
     * @param getPositionEstimateRequest
     * @return A Java Future containing the result of the GetPositionEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPositionEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPositionEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPositionEstimateResponse> getPositionEstimate(
            GetPositionEstimateRequest getPositionEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPositionEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPositionEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPositionEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetPositionEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPositionEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPositionEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPositionEstimateRequest, GetPositionEstimateResponse>()
                            .withOperationName("GetPositionEstimate")
                            .withMarshaller(new GetPositionEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPositionEstimateRequest));
            CompletableFuture<GetPositionEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the event configuration for a particular resource identifier.
     * </p>
     *
     * @param getResourceEventConfigurationRequest
     * @return A Java Future containing the result of the GetResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceEventConfigurationResponse> getResourceEventConfiguration(
            GetResourceEventConfigurationRequest getResourceEventConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceEventConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getResourceEventConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceEventConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceEventConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceEventConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceEventConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceEventConfigurationRequest, GetResourceEventConfigurationResponse>()
                            .withOperationName("GetResourceEventConfiguration")
                            .withMarshaller(new GetResourceEventConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourceEventConfigurationRequest));
            CompletableFuture<GetResourceEventConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless
     * device or a wireless gateway.
     * </p>
     *
     * @param getResourceLogLevelRequest
     * @return A Java Future containing the result of the GetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceLogLevelResponse> getResourceLogLevel(
            GetResourceLogLevelRequest getResourceLogLevelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceLogLevelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceLogLevelRequest, GetResourceLogLevelResponse>()
                            .withOperationName("GetResourceLogLevel")
                            .withMarshaller(new GetResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourceLogLevelRequest));
            CompletableFuture<GetResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the position information for a given wireless device or a wireless gateway resource. The position information
     * uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.
     * </p>
     *
     * @param getResourcePositionRequest
     * @return A Java Future containing the result of the GetResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePositionResponse> getResourcePosition(
            GetResourcePositionRequest getResourcePositionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePositionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePositionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePosition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetResourcePositionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourcePositionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourcePositionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePositionRequest, GetResourcePositionResponse>()
                            .withOperationName("GetResourcePosition")
                            .withMarshaller(new GetResourcePositionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePositionRequest));
            CompletableFuture<GetResourcePositionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServiceEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceEndpointRequest, GetServiceEndpointResponse>()
                            .withOperationName("GetServiceEndpoint")
                            .withMarshaller(new GetServiceEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServiceEndpointRequest));
            CompletableFuture<GetServiceEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceProfileResponse> getServiceProfile(GetServiceProfileRequest getServiceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServiceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceProfileRequest, GetServiceProfileResponse>()
                            .withOperationName("GetServiceProfile")
                            .withMarshaller(new GetServiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServiceProfileRequest));
            CompletableFuture<GetServiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceRequest, GetWirelessDeviceResponse>()
                            .withOperationName("GetWirelessDevice")
                            .withMarshaller(new GetWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessDeviceRequest));
            CompletableFuture<GetWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about an import task and count of device onboarding summary information for the import task.
     * </p>
     *
     * @param getWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the GetWirelessDeviceImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessDeviceImportTaskResponse> getWirelessDeviceImportTask(
            GetWirelessDeviceImportTaskRequest getWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceImportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessDeviceImportTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceImportTaskRequest, GetWirelessDeviceImportTaskResponse>()
                            .withOperationName("GetWirelessDeviceImportTask")
                            .withMarshaller(new GetWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessDeviceImportTaskRequest));
            CompletableFuture<GetWirelessDeviceImportTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessDeviceStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessDeviceStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessDeviceStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessDeviceStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessDeviceStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessDeviceStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse>()
                            .withOperationName("GetWirelessDeviceStatistics")
                            .withMarshaller(new GetWirelessDeviceStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessDeviceStatisticsRequest));
            CompletableFuture<GetWirelessDeviceStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayRequest, GetWirelessGatewayResponse>()
                            .withOperationName("GetWirelessGateway")
                            .withMarshaller(new GetWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayRequest));
            CompletableFuture<GetWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse>()
                            .withOperationName("GetWirelessGatewayCertificate")
                            .withMarshaller(new GetWirelessGatewayCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayCertificateRequest));
            CompletableFuture<GetWirelessGatewayCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayFirmwareInformationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayFirmwareInformationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayFirmwareInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayFirmwareInformationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetWirelessGatewayFirmwareInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse>()
                            .withOperationName("GetWirelessGatewayFirmwareInformation")
                            .withMarshaller(new GetWirelessGatewayFirmwareInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayFirmwareInformationRequest));
            CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse>()
                            .withOperationName("GetWirelessGatewayStatistics")
                            .withMarshaller(new GetWirelessGatewayStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayStatisticsRequest));
            CompletableFuture<GetWirelessGatewayStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWirelessGatewayTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWirelessGatewayTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse>()
                            .withOperationName("GetWirelessGatewayTask")
                            .withMarshaller(new GetWirelessGatewayTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayTaskRequest));
            CompletableFuture<GetWirelessGatewayTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWirelessGatewayTaskDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getWirelessGatewayTaskDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWirelessGatewayTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWirelessGatewayTaskDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetWirelessGatewayTaskDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse>()
                            .withOperationName("GetWirelessGatewayTaskDefinition")
                            .withMarshaller(new GetWirelessGatewayTaskDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWirelessGatewayTaskDefinitionRequest));
            CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDestinationsRequest, ListDestinationsResponse>()
                            .withOperationName("ListDestinations")
                            .withMarshaller(new ListDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDestinationsRequest));
            CompletableFuture<ListDestinationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeviceProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceProfilesRequest, ListDeviceProfilesResponse>()
                            .withOperationName("ListDeviceProfiles")
                            .withMarshaller(new ListDeviceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeviceProfilesRequest));
            CompletableFuture<ListDeviceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the Sidewalk devices in an import task and their onboarding status.
     * </p>
     *
     * @param listDevicesForWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the ListDevicesForWirelessDeviceImportTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDevicesForWirelessDeviceImportTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDevicesForWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesForWirelessDeviceImportTaskResponse> listDevicesForWirelessDeviceImportTask(
            ListDevicesForWirelessDeviceImportTaskRequest listDevicesForWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDevicesForWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDevicesForWirelessDeviceImportTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevicesForWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDevicesForWirelessDeviceImportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListDevicesForWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDevicesForWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDevicesForWirelessDeviceImportTaskRequest, ListDevicesForWirelessDeviceImportTaskResponse>()
                            .withOperationName("ListDevicesForWirelessDeviceImportTask")
                            .withMarshaller(new ListDevicesForWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDevicesForWirelessDeviceImportTaskRequest));
            CompletableFuture<ListDevicesForWirelessDeviceImportTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List event configurations where at least one event topic has been enabled.
     * </p>
     *
     * @param listEventConfigurationsRequest
     * @return A Java Future containing the result of the ListEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListEventConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListEventConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventConfigurationsResponse> listEventConfigurations(
            ListEventConfigurationsRequest listEventConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventConfigurationsRequest, ListEventConfigurationsResponse>()
                            .withOperationName("ListEventConfigurations")
                            .withMarshaller(new ListEventConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventConfigurationsRequest));
            CompletableFuture<ListEventConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the FUOTA tasks registered to your AWS account.
     * </p>
     *
     * @param listFuotaTasksRequest
     * @return A Java Future containing the result of the ListFuotaTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListFuotaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListFuotaTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFuotaTasksResponse> listFuotaTasks(ListFuotaTasksRequest listFuotaTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFuotaTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFuotaTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFuotaTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFuotaTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFuotaTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFuotaTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFuotaTasksRequest, ListFuotaTasksResponse>()
                            .withOperationName("ListFuotaTasks")
                            .withMarshaller(new ListFuotaTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFuotaTasksRequest));
            CompletableFuture<ListFuotaTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the multicast groups registered to your AWS account.
     * </p>
     *
     * @param listMulticastGroupsRequest
     * @return A Java Future containing the result of the ListMulticastGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMulticastGroupsResponse> listMulticastGroups(
            ListMulticastGroupsRequest listMulticastGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMulticastGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMulticastGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMulticastGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMulticastGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMulticastGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMulticastGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMulticastGroupsRequest, ListMulticastGroupsResponse>()
                            .withOperationName("ListMulticastGroups")
                            .withMarshaller(new ListMulticastGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMulticastGroupsRequest));
            CompletableFuture<ListMulticastGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all multicast groups associated with a fuota task.
     * </p>
     *
     * @param listMulticastGroupsByFuotaTaskRequest
     * @return A Java Future containing the result of the ListMulticastGroupsByFuotaTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListMulticastGroupsByFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListMulticastGroupsByFuotaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMulticastGroupsByFuotaTaskResponse> listMulticastGroupsByFuotaTask(
            ListMulticastGroupsByFuotaTaskRequest listMulticastGroupsByFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMulticastGroupsByFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMulticastGroupsByFuotaTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMulticastGroupsByFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMulticastGroupsByFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMulticastGroupsByFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMulticastGroupsByFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMulticastGroupsByFuotaTaskRequest, ListMulticastGroupsByFuotaTaskResponse>()
                            .withOperationName("ListMulticastGroupsByFuotaTask")
                            .withMarshaller(new ListMulticastGroupsByFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMulticastGroupsByFuotaTaskRequest));
            CompletableFuture<ListMulticastGroupsByFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the network analyzer configurations.
     * </p>
     *
     * @param listNetworkAnalyzerConfigurationsRequest
     * @return A Java Future containing the result of the ListNetworkAnalyzerConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListNetworkAnalyzerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListNetworkAnalyzerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> listNetworkAnalyzerConfigurations(
            ListNetworkAnalyzerConfigurationsRequest listNetworkAnalyzerConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNetworkAnalyzerConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listNetworkAnalyzerConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworkAnalyzerConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNetworkAnalyzerConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListNetworkAnalyzerConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNetworkAnalyzerConfigurationsRequest, ListNetworkAnalyzerConfigurationsResponse>()
                            .withOperationName("ListNetworkAnalyzerConfigurations")
                            .withMarshaller(new ListNetworkAnalyzerConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNetworkAnalyzerConfigurationsRequest));
            CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            ListPartnerAccountsRequest listPartnerAccountsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPartnerAccountsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPartnerAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPartnerAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPartnerAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPartnerAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPartnerAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPartnerAccountsRequest, ListPartnerAccountsResponse>()
                            .withOperationName("ListPartnerAccounts")
                            .withMarshaller(new ListPartnerAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPartnerAccountsRequest));
            CompletableFuture<ListPartnerAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List position configurations for a given resource, such as positioning solvers.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to retrieve position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html"
     * >GetResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param listPositionConfigurationsRequest
     * @return A Java Future containing the result of the ListPositionConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPositionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPositionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPositionConfigurationsResponse> listPositionConfigurations(
            ListPositionConfigurationsRequest listPositionConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPositionConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPositionConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPositionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPositionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPositionConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPositionConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPositionConfigurationsRequest, ListPositionConfigurationsResponse>()
                            .withOperationName("ListPositionConfigurations")
                            .withMarshaller(new ListPositionConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPositionConfigurationsRequest));
            CompletableFuture<ListPositionConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List queued messages in the downlink queue.
     * </p>
     *
     * @param listQueuedMessagesRequest
     * @return A Java Future containing the result of the ListQueuedMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListQueuedMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListQueuedMessages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueuedMessagesResponse> listQueuedMessages(ListQueuedMessagesRequest listQueuedMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueuedMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueuedMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueuedMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueuedMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQueuedMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListQueuedMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueuedMessagesRequest, ListQueuedMessagesResponse>()
                            .withOperationName("ListQueuedMessages")
                            .withMarshaller(new ListQueuedMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listQueuedMessagesRequest));
            CompletableFuture<ListQueuedMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            ListServiceProfilesRequest listServiceProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listServiceProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServiceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListServiceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListServiceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListServiceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServiceProfilesRequest, ListServiceProfilesResponse>()
                            .withOperationName("ListServiceProfiles")
                            .withMarshaller(new ListServiceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listServiceProfilesRequest));
            CompletableFuture<ListServiceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List wireless devices that have been added to an import task.
     * </p>
     *
     * @param listWirelessDeviceImportTasksRequest
     * @return A Java Future containing the result of the ListWirelessDeviceImportTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDeviceImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDeviceImportTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessDeviceImportTasksResponse> listWirelessDeviceImportTasks(
            ListWirelessDeviceImportTasksRequest listWirelessDeviceImportTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWirelessDeviceImportTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listWirelessDeviceImportTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessDeviceImportTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessDeviceImportTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWirelessDeviceImportTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessDeviceImportTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessDeviceImportTasksRequest, ListWirelessDeviceImportTasksResponse>()
                            .withOperationName("ListWirelessDeviceImportTasks")
                            .withMarshaller(new ListWirelessDeviceImportTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWirelessDeviceImportTasksRequest));
            CompletableFuture<ListWirelessDeviceImportTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            ListWirelessDevicesRequest listWirelessDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWirelessDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWirelessDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessDevicesRequest, ListWirelessDevicesResponse>()
                            .withOperationName("ListWirelessDevices")
                            .withMarshaller(new ListWirelessDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWirelessDevicesRequest));
            CompletableFuture<ListWirelessDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWirelessGatewayTaskDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listWirelessGatewayTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGatewayTaskDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessGatewayTaskDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListWirelessGatewayTaskDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse>()
                            .withOperationName("ListWirelessGatewayTaskDefinitions")
                            .withMarshaller(new ListWirelessGatewayTaskDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWirelessGatewayTaskDefinitionsRequest));
            CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWirelessGatewaysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWirelessGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWirelessGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWirelessGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWirelessGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWirelessGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse>()
                            .withOperationName("ListWirelessGateways")
                            .withMarshaller(new ListWirelessGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWirelessGatewaysRequest));
            CompletableFuture<ListWirelessGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Put position configuration for a given resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position configuration should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param putPositionConfigurationRequest
     * @return A Java Future containing the result of the PutPositionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutPositionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutPositionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutPositionConfigurationResponse> putPositionConfiguration(
            PutPositionConfigurationRequest putPositionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putPositionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putPositionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPositionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutPositionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutPositionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutPositionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutPositionConfigurationRequest, PutPositionConfigurationResponse>()
                            .withOperationName("PutPositionConfiguration")
                            .withMarshaller(new PutPositionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putPositionConfigurationRequest));
            CompletableFuture<PutPositionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless
     * gateway or a wireless device. A limit of 200 log level override can be set per account.
     * </p>
     *
     * @param putResourceLogLevelRequest
     * @return A Java Future containing the result of the PutResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.PutResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/PutResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourceLogLevelResponse> putResourceLogLevel(
            PutResourceLogLevelRequest putResourceLogLevelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourceLogLevelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourceLogLevelRequest, PutResourceLogLevelResponse>()
                            .withOperationName("PutResourceLogLevel")
                            .withMarshaller(new PutResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourceLogLevelRequest));
            CompletableFuture<PutResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     * </p>
     *
     * @param resetAllResourceLogLevelsRequest
     * @return A Java Future containing the result of the ResetAllResourceLogLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetAllResourceLogLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetAllResourceLogLevels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetAllResourceLogLevelsResponse> resetAllResourceLogLevels(
            ResetAllResourceLogLevelsRequest resetAllResourceLogLevelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetAllResourceLogLevelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetAllResourceLogLevelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetAllResourceLogLevels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetAllResourceLogLevelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetAllResourceLogLevelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetAllResourceLogLevelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetAllResourceLogLevelsRequest, ResetAllResourceLogLevelsResponse>()
                            .withOperationName("ResetAllResourceLogLevels")
                            .withMarshaller(new ResetAllResourceLogLevelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetAllResourceLogLevelsRequest));
            CompletableFuture<ResetAllResourceLogLevelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a
     * wireless device or a wireless gateway.
     * </p>
     *
     * @param resetResourceLogLevelRequest
     * @return A Java Future containing the result of the ResetResourceLogLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ResetResourceLogLevel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ResetResourceLogLevel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetResourceLogLevelResponse> resetResourceLogLevel(
            ResetResourceLogLevelRequest resetResourceLogLevelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetResourceLogLevelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetResourceLogLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetResourceLogLevel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetResourceLogLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetResourceLogLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetResourceLogLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetResourceLogLevelRequest, ResetResourceLogLevelResponse>()
                            .withOperationName("ResetResourceLogLevel")
                            .withMarshaller(new ResetResourceLogLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetResourceLogLevelRequest));
            CompletableFuture<ResetResourceLogLevelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends the specified data to a multicast group.
     * </p>
     *
     * @param sendDataToMulticastGroupRequest
     * @return A Java Future containing the result of the SendDataToMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendDataToMulticastGroupResponse> sendDataToMulticastGroup(
            SendDataToMulticastGroupRequest sendDataToMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendDataToMulticastGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendDataToMulticastGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendDataToMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendDataToMulticastGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendDataToMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendDataToMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendDataToMulticastGroupRequest, SendDataToMulticastGroupResponse>()
                            .withOperationName("SendDataToMulticastGroup")
                            .withMarshaller(new SendDataToMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendDataToMulticastGroupRequest));
            CompletableFuture<SendDataToMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendDataToWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendDataToWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendDataToWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendDataToWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendDataToWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendDataToWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse>()
                            .withOperationName("SendDataToWirelessDevice")
                            .withMarshaller(new SendDataToWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendDataToWirelessDeviceRequest));
            CompletableFuture<SendDataToWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     * </p>
     *
     * @param startBulkAssociateWirelessDeviceWithMulticastGroupRequest
     * @return A Java Future containing the result of the StartBulkAssociateWirelessDeviceWithMulticastGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkAssociateWirelessDeviceWithMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkAssociateWirelessDeviceWithMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> startBulkAssociateWirelessDeviceWithMulticastGroup(
            StartBulkAssociateWirelessDeviceWithMulticastGroupRequest startBulkAssociateWirelessDeviceWithMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                startBulkAssociateWirelessDeviceWithMulticastGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startBulkAssociateWirelessDeviceWithMulticastGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBulkAssociateWirelessDeviceWithMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartBulkAssociateWirelessDeviceWithMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest, StartBulkAssociateWirelessDeviceWithMulticastGroupResponse>()
                            .withOperationName("StartBulkAssociateWirelessDeviceWithMulticastGroup")
                            .withMarshaller(
                                    new StartBulkAssociateWirelessDeviceWithMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBulkAssociateWirelessDeviceWithMulticastGroupRequest));
            CompletableFuture<StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     * </p>
     *
     * @param startBulkDisassociateWirelessDeviceFromMulticastGroupRequest
     * @return A Java Future containing the result of the StartBulkDisassociateWirelessDeviceFromMulticastGroup
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartBulkDisassociateWirelessDeviceFromMulticastGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartBulkDisassociateWirelessDeviceFromMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> startBulkDisassociateWirelessDeviceFromMulticastGroup(
            StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest startBulkDisassociateWirelessDeviceFromMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                startBulkDisassociateWirelessDeviceFromMulticastGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startBulkDisassociateWirelessDeviceFromMulticastGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "StartBulkDisassociateWirelessDeviceFromMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest, StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse>()
                            .withOperationName("StartBulkDisassociateWirelessDeviceFromMulticastGroup")
                            .withMarshaller(
                                    new StartBulkDisassociateWirelessDeviceFromMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBulkDisassociateWirelessDeviceFromMulticastGroupRequest));
            CompletableFuture<StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a FUOTA task.
     * </p>
     *
     * @param startFuotaTaskRequest
     * @return A Java Future containing the result of the StartFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartFuotaTaskResponse> startFuotaTask(StartFuotaTaskRequest startFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFuotaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFuotaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFuotaTaskRequest, StartFuotaTaskResponse>()
                            .withOperationName("StartFuotaTask")
                            .withMarshaller(new StartFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFuotaTaskRequest));
            CompletableFuture<StartFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a multicast group session.
     * </p>
     *
     * @param startMulticastGroupSessionRequest
     * @return A Java Future containing the result of the StartMulticastGroupSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartMulticastGroupSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartMulticastGroupSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMulticastGroupSessionResponse> startMulticastGroupSession(
            StartMulticastGroupSessionRequest startMulticastGroupSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMulticastGroupSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMulticastGroupSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMulticastGroupSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMulticastGroupSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMulticastGroupSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMulticastGroupSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMulticastGroupSessionRequest, StartMulticastGroupSessionResponse>()
                            .withOperationName("StartMulticastGroupSession")
                            .withMarshaller(new StartMulticastGroupSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMulticastGroupSessionRequest));
            CompletableFuture<StartMulticastGroupSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start import task for a single wireless device.
     * </p>
     *
     * @param startSingleWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the StartSingleWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartSingleWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartSingleWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSingleWirelessDeviceImportTaskResponse> startSingleWirelessDeviceImportTask(
            StartSingleWirelessDeviceImportTaskRequest startSingleWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSingleWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startSingleWirelessDeviceImportTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSingleWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSingleWirelessDeviceImportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartSingleWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSingleWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSingleWirelessDeviceImportTaskRequest, StartSingleWirelessDeviceImportTaskResponse>()
                            .withOperationName("StartSingleWirelessDeviceImportTask")
                            .withMarshaller(new StartSingleWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSingleWirelessDeviceImportTaskRequest));
            CompletableFuture<StartSingleWirelessDeviceImportTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     * </p>
     *
     * @param startWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the StartWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.StartWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/StartWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartWirelessDeviceImportTaskResponse> startWirelessDeviceImportTask(
            StartWirelessDeviceImportTaskRequest startWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startWirelessDeviceImportTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartWirelessDeviceImportTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartWirelessDeviceImportTaskRequest, StartWirelessDeviceImportTaskResponse>()
                            .withOperationName("StartWirelessDeviceImportTask")
                            .withMarshaller(new StartWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startWirelessDeviceImportTaskRequest));
            CompletableFuture<StartWirelessDeviceImportTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestWirelessDeviceRequest, TestWirelessDeviceResponse>()
                            .withOperationName("TestWirelessDevice")
                            .withMarshaller(new TestWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testWirelessDeviceRequest));
            CompletableFuture<TestWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDestinationRequest, UpdateDestinationResponse>()
                            .withOperationName("UpdateDestination")
                            .withMarshaller(new UpdateDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDestinationRequest));
            CompletableFuture<UpdateDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the event configuration based on resource types.
     * </p>
     *
     * @param updateEventConfigurationByResourceTypesRequest
     * @return A Java Future containing the result of the UpdateEventConfigurationByResourceTypes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateEventConfigurationByResourceTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateEventConfigurationByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventConfigurationByResourceTypesResponse> updateEventConfigurationByResourceTypes(
            UpdateEventConfigurationByResourceTypesRequest updateEventConfigurationByResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventConfigurationByResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEventConfigurationByResourceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventConfigurationByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventConfigurationByResourceTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateEventConfigurationByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventConfigurationByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventConfigurationByResourceTypesRequest, UpdateEventConfigurationByResourceTypesResponse>()
                            .withOperationName("UpdateEventConfigurationByResourceTypes")
                            .withMarshaller(new UpdateEventConfigurationByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventConfigurationByResourceTypesRequest));
            CompletableFuture<UpdateEventConfigurationByResourceTypesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a FUOTA task.
     * </p>
     *
     * @param updateFuotaTaskRequest
     * @return A Java Future containing the result of the UpdateFuotaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateFuotaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateFuotaTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFuotaTaskResponse> updateFuotaTask(UpdateFuotaTaskRequest updateFuotaTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFuotaTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFuotaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFuotaTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFuotaTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFuotaTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFuotaTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFuotaTaskRequest, UpdateFuotaTaskResponse>()
                            .withOperationName("UpdateFuotaTask")
                            .withMarshaller(new UpdateFuotaTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFuotaTaskRequest));
            CompletableFuture<UpdateFuotaTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless
     * gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     * </p>
     *
     * @param updateLogLevelsByResourceTypesRequest
     * @return A Java Future containing the result of the UpdateLogLevelsByResourceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateLogLevelsByResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateLogLevelsByResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLogLevelsByResourceTypesResponse> updateLogLevelsByResourceTypes(
            UpdateLogLevelsByResourceTypesRequest updateLogLevelsByResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLogLevelsByResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateLogLevelsByResourceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLogLevelsByResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLogLevelsByResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLogLevelsByResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLogLevelsByResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLogLevelsByResourceTypesRequest, UpdateLogLevelsByResourceTypesResponse>()
                            .withOperationName("UpdateLogLevelsByResourceTypes")
                            .withMarshaller(new UpdateLogLevelsByResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateLogLevelsByResourceTypesRequest));
            CompletableFuture<UpdateLogLevelsByResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a multicast group session.
     * </p>
     *
     * @param updateMulticastGroupRequest
     * @return A Java Future containing the result of the UpdateMulticastGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateMulticastGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateMulticastGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMulticastGroupResponse> updateMulticastGroup(
            UpdateMulticastGroupRequest updateMulticastGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMulticastGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMulticastGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMulticastGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMulticastGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMulticastGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMulticastGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMulticastGroupRequest, UpdateMulticastGroupResponse>()
                            .withOperationName("UpdateMulticastGroup")
                            .withMarshaller(new UpdateMulticastGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMulticastGroupRequest));
            CompletableFuture<UpdateMulticastGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update network analyzer configuration.
     * </p>
     *
     * @param updateNetworkAnalyzerConfigurationRequest
     * @return A Java Future containing the result of the UpdateNetworkAnalyzerConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateNetworkAnalyzerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateNetworkAnalyzerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNetworkAnalyzerConfigurationResponse> updateNetworkAnalyzerConfiguration(
            UpdateNetworkAnalyzerConfigurationRequest updateNetworkAnalyzerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNetworkAnalyzerConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateNetworkAnalyzerConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetworkAnalyzerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNetworkAnalyzerConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateNetworkAnalyzerConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNetworkAnalyzerConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNetworkAnalyzerConfigurationRequest, UpdateNetworkAnalyzerConfigurationResponse>()
                            .withOperationName("UpdateNetworkAnalyzerConfiguration")
                            .withMarshaller(new UpdateNetworkAnalyzerConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNetworkAnalyzerConfigurationRequest));
            CompletableFuture<UpdateNetworkAnalyzerConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            UpdatePartnerAccountRequest updatePartnerAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePartnerAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePartnerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePartnerAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePartnerAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePartnerAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePartnerAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse>()
                            .withOperationName("UpdatePartnerAccount")
                            .withMarshaller(new UpdatePartnerAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePartnerAccountRequest));
            CompletableFuture<UpdatePartnerAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the position information of a resource.
     * </p>
     * <important>
     * <p>
     * This action is no longer supported. Calls to update the position information should use the <a
     * href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html"
     * >UpdateResourcePosition</a> API operation instead.
     * </p>
     * </important>
     *
     * @param updatePositionRequest
     * @return A Java Future containing the result of the UpdatePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePosition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePositionResponse> updatePosition(UpdatePositionRequest updatePositionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePositionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePositionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePosition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePositionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePositionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePositionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePositionRequest, UpdatePositionResponse>()
                            .withOperationName("UpdatePosition")
                            .withMarshaller(new UpdatePositionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePositionRequest));
            CompletableFuture<UpdatePositionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the event configuration for a particular resource identifier.
     * </p>
     *
     * @param updateResourceEventConfigurationRequest
     * @return A Java Future containing the result of the UpdateResourceEventConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourceEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourceEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceEventConfigurationResponse> updateResourceEventConfiguration(
            UpdateResourceEventConfigurationRequest updateResourceEventConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourceEventConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateResourceEventConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceEventConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceEventConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateResourceEventConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceEventConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceEventConfigurationRequest, UpdateResourceEventConfigurationResponse>()
                            .withOperationName("UpdateResourceEventConfiguration")
                            .withMarshaller(new UpdateResourceEventConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResourceEventConfigurationRequest));
            CompletableFuture<UpdateResourceEventConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the position information of a given wireless device or a wireless gateway resource. The position
     * coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic
     * System (WGS84)</a>.
     * </p>
     *
     * @param updateResourcePositionRequest
     * @return A Java Future containing the result of the UpdateResourcePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateResourcePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateResourcePosition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourcePositionResponse> updateResourcePosition(
            UpdateResourcePositionRequest updateResourcePositionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourcePositionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourcePositionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourcePosition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourcePositionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourcePositionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourcePositionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourcePositionRequest, UpdateResourcePositionResponse>()
                            .withOperationName("UpdateResourcePosition")
                            .withMarshaller(new UpdateResourcePositionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResourcePositionRequest));
            CompletableFuture<UpdateResourcePositionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            UpdateWirelessDeviceRequest updateWirelessDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWirelessDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWirelessDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWirelessDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWirelessDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse>()
                            .withOperationName("UpdateWirelessDevice")
                            .withMarshaller(new UpdateWirelessDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWirelessDeviceRequest));
            CompletableFuture<UpdateWirelessDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update an import task to add more devices to the task.
     * </p>
     *
     * @param updateWirelessDeviceImportTaskRequest
     * @return A Java Future containing the result of the UpdateWirelessDeviceImportTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDeviceImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDeviceImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWirelessDeviceImportTaskResponse> updateWirelessDeviceImportTask(
            UpdateWirelessDeviceImportTaskRequest updateWirelessDeviceImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWirelessDeviceImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateWirelessDeviceImportTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessDeviceImportTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWirelessDeviceImportTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWirelessDeviceImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWirelessDeviceImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWirelessDeviceImportTaskRequest, UpdateWirelessDeviceImportTaskResponse>()
                            .withOperationName("UpdateWirelessDeviceImportTask")
                            .withMarshaller(new UpdateWirelessDeviceImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWirelessDeviceImportTaskRequest));
            CompletableFuture<UpdateWirelessDeviceImportTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            UpdateWirelessGatewayRequest updateWirelessGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWirelessGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWirelessGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Wireless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWirelessGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWirelessGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWirelessGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWirelessGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse>()
                            .withOperationName("UpdateWirelessGateway")
                            .withMarshaller(new UpdateWirelessGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWirelessGatewayRequest));
            CompletableFuture<UpdateWirelessGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final IotWirelessServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IotWirelessException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        IotWirelessServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = IotWirelessServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
