/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricConfigurationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetMetricConfigurationResponse.Builder, GetMetricConfigurationResponse> {
    private static final SdkField<SummaryMetricConfiguration> SUMMARY_METRIC_FIELD = SdkField
            .<SummaryMetricConfiguration> builder(MarshallingType.SDK_POJO).memberName("SummaryMetric")
            .getter(getter(GetMetricConfigurationResponse::summaryMetric)).setter(setter(Builder::summaryMetric))
            .constructor(SummaryMetricConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryMetric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_METRIC_FIELD));

    private final SummaryMetricConfiguration summaryMetric;

    private GetMetricConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.summaryMetric = builder.summaryMetric;
    }

    /**
     * <p>
     * The account's configuration status for summary metric aggregation.
     * </p>
     * 
     * @return The account's configuration status for summary metric aggregation.
     */
    public final SummaryMetricConfiguration summaryMetric() {
        return summaryMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summaryMetric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricConfigurationResponse)) {
            return false;
        }
        GetMetricConfigurationResponse other = (GetMetricConfigurationResponse) obj;
        return Objects.equals(summaryMetric(), other.summaryMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricConfigurationResponse").add("SummaryMetric", summaryMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SummaryMetric":
            return Optional.ofNullable(clazz.cast(summaryMetric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricConfigurationResponse, T> g) {
        return obj -> g.apply((GetMetricConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMetricConfigurationResponse> {
        /**
         * <p>
         * The account's configuration status for summary metric aggregation.
         * </p>
         * 
         * @param summaryMetric
         *        The account's configuration status for summary metric aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMetric(SummaryMetricConfiguration summaryMetric);

        /**
         * <p>
         * The account's configuration status for summary metric aggregation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummaryMetricConfiguration.Builder}
         * avoiding the need to create one manually via {@link SummaryMetricConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryMetricConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #summaryMetric(SummaryMetricConfiguration)}.
         * 
         * @param summaryMetric
         *        a consumer that will call methods on {@link SummaryMetricConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryMetric(SummaryMetricConfiguration)
         */
        default Builder summaryMetric(Consumer<SummaryMetricConfiguration.Builder> summaryMetric) {
            return summaryMetric(SummaryMetricConfiguration.builder().applyMutation(summaryMetric).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private SummaryMetricConfiguration summaryMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricConfigurationResponse model) {
            super(model);
            summaryMetric(model.summaryMetric);
        }

        public final SummaryMetricConfiguration.Builder getSummaryMetric() {
            return summaryMetric != null ? summaryMetric.toBuilder() : null;
        }

        public final void setSummaryMetric(SummaryMetricConfiguration.BuilderImpl summaryMetric) {
            this.summaryMetric = summaryMetric != null ? summaryMetric.build() : null;
        }

        @Override
        public final Builder summaryMetric(SummaryMetricConfiguration summaryMetric) {
            this.summaryMetric = summaryMetric;
            return this;
        }

        @Override
        public GetMetricConfigurationResponse build() {
            return new GetMetricConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
