/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum MetricName {
    DEVICE_RSSI("DeviceRSSI"),

    DEVICE_SNR("DeviceSNR"),

    DEVICE_UPLINK_COUNT("DeviceUplinkCount"),

    DEVICE_DOWNLINK_COUNT("DeviceDownlinkCount"),

    DEVICE_UPLINK_LOST_COUNT("DeviceUplinkLostCount"),

    DEVICE_UPLINK_LOST_RATE("DeviceUplinkLostRate"),

    DEVICE_JOIN_REQUEST_COUNT("DeviceJoinRequestCount"),

    DEVICE_JOIN_ACCEPT_COUNT("DeviceJoinAcceptCount"),

    DEVICE_ROAMING_UPLINK_COUNT("DeviceRoamingUplinkCount"),

    DEVICE_ROAMING_DOWNLINK_COUNT("DeviceRoamingDownlinkCount"),

    GATEWAY_UP_TIME("GatewayUpTime"),

    GATEWAY_DOWN_TIME("GatewayDownTime"),

    GATEWAY_RSSI("GatewayRSSI"),

    GATEWAY_SNR("GatewaySNR"),

    GATEWAY_UPLINK_COUNT("GatewayUplinkCount"),

    GATEWAY_DOWNLINK_COUNT("GatewayDownlinkCount"),

    GATEWAY_JOIN_REQUEST_COUNT("GatewayJoinRequestCount"),

    GATEWAY_JOIN_ACCEPT_COUNT("GatewayJoinAcceptCount"),

    AWS_ACCOUNT_UPLINK_COUNT("AwsAccountUplinkCount"),

    AWS_ACCOUNT_DOWNLINK_COUNT("AwsAccountDownlinkCount"),

    AWS_ACCOUNT_UPLINK_LOST_COUNT("AwsAccountUplinkLostCount"),

    AWS_ACCOUNT_UPLINK_LOST_RATE("AwsAccountUplinkLostRate"),

    AWS_ACCOUNT_JOIN_REQUEST_COUNT("AwsAccountJoinRequestCount"),

    AWS_ACCOUNT_JOIN_ACCEPT_COUNT("AwsAccountJoinAcceptCount"),

    AWS_ACCOUNT_ROAMING_UPLINK_COUNT("AwsAccountRoamingUplinkCount"),

    AWS_ACCOUNT_ROAMING_DOWNLINK_COUNT("AwsAccountRoamingDownlinkCount"),

    AWS_ACCOUNT_DEVICE_COUNT("AwsAccountDeviceCount"),

    AWS_ACCOUNT_GATEWAY_COUNT("AwsAccountGatewayCount"),

    AWS_ACCOUNT_ACTIVE_DEVICE_COUNT("AwsAccountActiveDeviceCount"),

    AWS_ACCOUNT_ACTIVE_GATEWAY_COUNT("AwsAccountActiveGatewayCount"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricName> VALUE_MAP = EnumUtils.uniqueIndex(MetricName.class, MetricName::toString);

    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MetricName corresponding to the value
     */
    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MetricName}s
     */
    public static Set<MetricName> knownValues() {
        Set<MetricName> knownValues = EnumSet.allOf(MetricName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
