/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of metrics aggregation operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SummaryMetricQueryResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SummaryMetricQueryResult.Builder, SummaryMetricQueryResult> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(SummaryMetricQueryResult::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(SummaryMetricQueryResult::queryStatusAsString))
            .setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(SummaryMetricQueryResult::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(SummaryMetricQueryResult::metricNameAsString))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(SummaryMetricQueryResult::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationPeriod").getter(getter(SummaryMetricQueryResult::aggregationPeriodAsString))
            .setter(setter(Builder::aggregationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(SummaryMetricQueryResult::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(SummaryMetricQueryResult::endTimestamp))
            .setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("Timestamps")
            .getter(getter(SummaryMetricQueryResult::timestamps))
            .setter(setter(Builder::timestamps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricQueryValue>> VALUES_FIELD = SdkField
            .<List<MetricQueryValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(SummaryMetricQueryResult::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricQueryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricQueryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(SummaryMetricQueryResult::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STATUS_FIELD, ERROR_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, AGGREGATION_PERIOD_FIELD,
            START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, TIMESTAMPS_FIELD, VALUES_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryStatus;

    private final String error;

    private final String metricName;

    private final List<Dimension> dimensions;

    private final String aggregationPeriod;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final List<Instant> timestamps;

    private final List<MetricQueryValue> values;

    private final String unit;

    private SummaryMetricQueryResult(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryStatus = builder.queryStatus;
        this.error = builder.error;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.timestamps = builder.timestamps;
        this.values = builder.values;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The id of the query.
     * </p>
     * 
     * @return The id of the query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The status of the metric query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link MetricQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the metric query.
     * @see MetricQueryStatus
     */
    public final MetricQueryStatus queryStatus() {
        return MetricQueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * The status of the metric query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link MetricQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the metric query.
     * @see MetricQueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    /**
     * <p>
     * The error message for the summary metric query.
     * </p>
     * 
     * @return The error message for the summary metric query.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see MetricName
     */
    public final MetricName metricName() {
        return MetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see MetricName
     */
    public final String metricNameAsString() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions of the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The dimensions of the metric.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The aggregation period of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return The aggregation period of the metric.
     * @see AggregationPeriod
     */
    public final AggregationPeriod aggregationPeriod() {
        return AggregationPeriod.fromValue(aggregationPeriod);
    }

    /**
     * <p>
     * The aggregation period of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return The aggregation period of the metric.
     * @see AggregationPeriod
     */
    public final String aggregationPeriodAsString() {
        return aggregationPeriod;
    }

    /**
     * <p>
     * The start timestamp for summary metric query.
     * </p>
     * 
     * @return The start timestamp for summary metric query.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The end timestamp for summary metric query.
     * </p>
     * 
     * @return The end timestamp for summary metric query.
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timestamps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimestamps() {
        return timestamps != null && !(timestamps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The timestamp of each aggregation result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestamps} method.
     * </p>
     * 
     * @return The timestamp of each aggregation result.
     */
    public final List<Instant> timestamps() {
        return timestamps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregated metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The list of aggregated metrics.
     */
    public final List<MetricQueryValue> values() {
        return values;
    }

    /**
     * <p>
     * The units of measurement to be used for interpreting the aggregation result.
     * </p>
     * 
     * @return The units of measurement to be used for interpreting the aggregation result.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestamps() ? timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummaryMetricQueryResult)) {
            return false;
        }
        SummaryMetricQueryResult other = (SummaryMetricQueryResult) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryStatusAsString(), other.queryStatusAsString())
                && Objects.equals(error(), other.error()) && Objects.equals(metricNameAsString(), other.metricNameAsString())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(aggregationPeriodAsString(), other.aggregationPeriodAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp()) && hasTimestamps() == other.hasTimestamps()
                && Objects.equals(timestamps(), other.timestamps()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SummaryMetricQueryResult").add("QueryId", queryId()).add("QueryStatus", queryStatusAsString())
                .add("Error", error()).add("MetricName", metricNameAsString())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("AggregationPeriod", aggregationPeriodAsString())
                .add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp())
                .add("Timestamps", hasTimestamps() ? timestamps() : null).add("Values", hasValues() ? values() : null)
                .add("Unit", unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "AggregationPeriod":
            return Optional.ofNullable(clazz.cast(aggregationPeriodAsString()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "Timestamps":
            return Optional.ofNullable(clazz.cast(timestamps()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SummaryMetricQueryResult, T> g) {
        return obj -> g.apply((SummaryMetricQueryResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SummaryMetricQueryResult> {
        /**
         * <p>
         * The id of the query.
         * </p>
         * 
         * @param queryId
         *        The id of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The status of the metric query.
         * </p>
         * 
         * @param queryStatus
         *        The status of the metric query.
         * @see MetricQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricQueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * The status of the metric query.
         * </p>
         * 
         * @param queryStatus
         *        The status of the metric query.
         * @see MetricQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricQueryStatus
         */
        Builder queryStatus(MetricQueryStatus queryStatus);

        /**
         * <p>
         * The error message for the summary metric query.
         * </p>
         * 
         * @param error
         *        The error message for the summary metric query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(MetricName metricName);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * 
         * @param dimensions
         *        The dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * 
         * @param dimensions
         *        The dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Dimension.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.Dimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Dimension.Builder#build()} is called immediately and
         * its result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Dimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * The aggregation period of the metric.
         * </p>
         * 
         * @param aggregationPeriod
         *        The aggregation period of the metric.
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(String aggregationPeriod);

        /**
         * <p>
         * The aggregation period of the metric.
         * </p>
         * 
         * @param aggregationPeriod
         *        The aggregation period of the metric.
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(AggregationPeriod aggregationPeriod);

        /**
         * <p>
         * The start timestamp for summary metric query.
         * </p>
         * 
         * @param startTimestamp
         *        The start timestamp for summary metric query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The end timestamp for summary metric query.
         * </p>
         * 
         * @param endTimestamp
         *        The end timestamp for summary metric query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The timestamp of each aggregation result.
         * </p>
         * 
         * @param timestamps
         *        The timestamp of each aggregation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Collection<Instant> timestamps);

        /**
         * <p>
         * The timestamp of each aggregation result.
         * </p>
         * 
         * @param timestamps
         *        The timestamp of each aggregation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Instant... timestamps);

        /**
         * <p>
         * The list of aggregated metrics.
         * </p>
         * 
         * @param values
         *        The list of aggregated metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MetricQueryValue> values);

        /**
         * <p>
         * The list of aggregated metrics.
         * </p>
         * 
         * @param values
         *        The list of aggregated metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MetricQueryValue... values);

        /**
         * <p>
         * The list of aggregated metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.MetricQueryValue.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotwireless.model.MetricQueryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.MetricQueryValue.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<MetricQueryValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.MetricQueryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MetricQueryValue>)
         */
        Builder values(Consumer<MetricQueryValue.Builder>... values);

        /**
         * <p>
         * The units of measurement to be used for interpreting the aggregation result.
         * </p>
         * 
         * @param unit
         *        The units of measurement to be used for interpreting the aggregation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryStatus;

        private String error;

        private String metricName;

        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String aggregationPeriod;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();

        private List<MetricQueryValue> values = DefaultSdkAutoConstructList.getInstance();

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(SummaryMetricQueryResult model) {
            queryId(model.queryId);
            queryStatus(model.queryStatus);
            error(model.error);
            metricName(model.metricName);
            dimensions(model.dimensions);
            aggregationPeriod(model.aggregationPeriod);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            timestamps(model.timestamps);
            values(model.values);
            unit(model.unit);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(MetricQueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public final Builder aggregationPeriod(AggregationPeriod aggregationPeriod) {
            this.aggregationPeriod(aggregationPeriod == null ? null : aggregationPeriod.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = MetricQueryTimestampsCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = MetricQueryTimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant... timestamps) {
            timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final List<MetricQueryValue.Builder> getValues() {
            List<MetricQueryValue.Builder> result = MetricQueryValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MetricQueryValue.BuilderImpl> values) {
            this.values = MetricQueryValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MetricQueryValue> values) {
            this.values = MetricQueryValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MetricQueryValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MetricQueryValue.Builder>... values) {
            values(Stream.of(values).map(c -> MetricQueryValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public SummaryMetricQueryResult build() {
            return new SummaryMetricQueryResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
