/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN application configuration, which can be used to perform geolocation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfig.Builder, ApplicationConfig> {
    private static final SdkField<Integer> F_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("FPort")
            .getter(getter(ApplicationConfig::fPort)).setter(setter(Builder::fPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ApplicationConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(ApplicationConfig::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_PORT_FIELD, TYPE_FIELD,
            DESTINATION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fPort;

    private final String type;

    private final String destinationName;

    private ApplicationConfig(BuilderImpl builder) {
        this.fPort = builder.fPort;
        this.type = builder.type;
        this.destinationName = builder.destinationName;
    }

    /**
     * Returns the value of the FPort property for this object.
     * 
     * @return The value of the FPort property for this object.
     */
    public final Integer fPort() {
        return fPort;
    }

    /**
     * <p>
     * Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
     * @see ApplicationConfigType
     */
    public final ApplicationConfigType type() {
        return ApplicationConfigType.fromValue(type);
    }

    /**
     * <p>
     * Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
     * @see ApplicationConfigType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the position data destination that describes the AWS IoT rule that processes the device's position
     * data for use by AWS IoT Core for LoRaWAN.
     * </p>
     * 
     * @return The name of the position data destination that describes the AWS IoT rule that processes the device's
     *         position data for use by AWS IoT Core for LoRaWAN.
     */
    public final String destinationName() {
        return destinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fPort());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig) obj;
        return Objects.equals(fPort(), other.fPort()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(destinationName(), other.destinationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfig").add("FPort", fPort()).add("Type", typeAsString())
                .add("DestinationName", destinationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FPort":
            return Optional.ofNullable(clazz.cast(fPort()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfig, T> g) {
        return obj -> g.apply((ApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfig> {
        /**
         * Sets the value of the FPort property for this object.
         *
         * @param fPort
         *        The new value for the FPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPort(Integer fPort);

        /**
         * <p>
         * Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
         * </p>
         * 
         * @param type
         *        Application type, which can be specified to obtain real-time position information of your LoRaWAN
         *        device.
         * @see ApplicationConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationConfigType
         */
        Builder type(String type);

        /**
         * <p>
         * Application type, which can be specified to obtain real-time position information of your LoRaWAN device.
         * </p>
         * 
         * @param type
         *        Application type, which can be specified to obtain real-time position information of your LoRaWAN
         *        device.
         * @see ApplicationConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationConfigType
         */
        Builder type(ApplicationConfigType type);

        /**
         * <p>
         * The name of the position data destination that describes the AWS IoT rule that processes the device's
         * position data for use by AWS IoT Core for LoRaWAN.
         * </p>
         * 
         * @param destinationName
         *        The name of the position data destination that describes the AWS IoT rule that processes the device's
         *        position data for use by AWS IoT Core for LoRaWAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);
    }

    static final class BuilderImpl implements Builder {
        private Integer fPort;

        private String type;

        private String destinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfig model) {
            fPort(model.fPort);
            type(model.type);
            destinationName(model.destinationName);
        }

        public final Integer getFPort() {
            return fPort;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        @Override
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApplicationConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public ApplicationConfig build() {
            return new ApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
